/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.customer.account;

import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestBadDebtBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCashPaymentItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCashRefundItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestClosingBalanceBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCounterSaleBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCounterSaleItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCreditAdjustBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCreditBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCreditItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestDebitAdjustBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestEFTPaymentItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestEFTRefundItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestEstimateBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestEstimateItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInitialBalanceBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestOpeningBalanceBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestOtherPaymentItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestOtherRefundItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentProcessorPaymentItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentProcessorRefundItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestRefundBuilder;
import org.openvpms.archetype.test.builder.eft.TestEFTPOSPaymentBuilder;
import org.openvpms.archetype.test.builder.eft.TestEFTPOSRefundBuilder;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.paymentprocessor.TestPaymentProcessorPaymentBuilder;
import org.openvpms.archetype.test.builder.paymentprocessor.TestPaymentProcessorRefundBuilder;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestCustomerAccountFactory {
    private final ArchetypeService service;
    private final CustomerAccountRules rules;
    private final TestCustomerFactory customerFactory;
    private final TestPatientFactory patientFactory;

    public TestCustomerAccountFactory(ArchetypeService service, CustomerAccountRules rules, TestCustomerFactory customerFactory, TestPatientFactory patientFactory) {
        this.service = service;
        this.rules = rules;
        this.customerFactory = customerFactory;
        this.patientFactory = patientFactory;
    }

    public TestInitialBalanceBuilder newInitialBalance() {
        return new TestInitialBalanceBuilder(this.service);
    }

    public TestOpeningBalanceBuilder newOpeningBalance() {
        return new TestOpeningBalanceBuilder(this.service);
    }

    public TestClosingBalanceBuilder newClosingBalance() {
        return new TestClosingBalanceBuilder(this.service);
    }

    public TestBadDebtBuilder newBadDebt() {
        return new TestBadDebtBuilder(this.service);
    }

    public FinancialAct createCounterSale(int amount, String status) {
        return (FinancialAct)this.newCounterSale(amount, status).build();
    }

    public TestCounterSaleBuilder newCounterSale(int amount, String status) {
        Party customer = this.customerFactory.createCustomer();
        return (TestCounterSaleBuilder)((TestCounterSaleBuilder)((TestCounterSaleItemBuilder)((TestCounterSaleItemBuilder)((TestCounterSaleBuilder)this.newCounterSale().customer(customer)).item().medicationProduct()).unitPrice(amount)).add()).status(status);
    }

    public TestCounterSaleBuilder newCounterSale() {
        return new TestCounterSaleBuilder(this.service);
    }

    public TestEstimateBuilder newEstimate() {
        return new TestEstimateBuilder(this.service, this.rules);
    }

    public TestEstimateItemBuilder newEstimateItem() {
        return new TestEstimateItemBuilder(null, this.service, this.rules);
    }

    public FinancialAct createInvoice(int amount, String status) {
        return (FinancialAct)this.newInvoice(amount, status).build();
    }

    public FinancialAct createInvoice(Party customer, int amount, String status) {
        return (FinancialAct)this.newInvoice(customer, amount, status).build();
    }

    public TestInvoiceBuilder newInvoice(int amount, String status) {
        return this.newInvoice(this.customerFactory.createCustomer(), amount, status);
    }

    public TestInvoiceBuilder newInvoice(Party customer, int amount, String status) {
        Party patient = this.patientFactory.createPatient(customer);
        return (TestInvoiceBuilder)((TestInvoiceBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceBuilder)this.newInvoice().customer(customer)).item().patient(patient)).medicationProduct()).unitPrice(amount)).add()).status(status);
    }

    public TestInvoiceBuilder newInvoice() {
        return new TestInvoiceBuilder(this.service);
    }

    public TestInvoiceItemBuilder newInvoiceItem() {
        return new TestInvoiceItemBuilder(null, this.service);
    }

    public TestInvoiceItemBuilder updateInvoiceItem(FinancialAct item) {
        return new TestInvoiceItemBuilder(null, item, this.service);
    }

    public FinancialAct createCredit(int amount, String status) {
        return (FinancialAct)this.newCredit(amount, status).build();
    }

    public TestCreditBuilder newCredit(int amount, String status) {
        Party customer = this.customerFactory.createCustomer();
        Party patient = this.patientFactory.createPatient(customer);
        return (TestCreditBuilder)((TestCreditBuilder)((TestCreditItemBuilder)((TestCreditItemBuilder)((TestCreditItemBuilder)((TestCreditBuilder)this.newCredit().customer(customer)).item().patient(patient)).medicationProduct()).unitPrice(amount)).add()).status(status);
    }

    public TestCreditBuilder newCredit() {
        return new TestCreditBuilder(this.service);
    }

    public TestCreditAdjustBuilder newCreditAdjust() {
        return new TestCreditAdjustBuilder(this.service);
    }

    public TestDebitAdjustBuilder newDebitAdjust() {
        return new TestDebitAdjustBuilder(this.service);
    }

    public TestPaymentBuilder newPayment() {
        return new TestPaymentBuilder(this.service);
    }

    public TestPaymentBuilder updatePayment(FinancialAct payment) {
        return new TestPaymentBuilder(payment, this.service);
    }

    public TestCashPaymentItemBuilder newCashPaymentItem() {
        return new TestCashPaymentItemBuilder(null, this.service);
    }

    public TestEFTPaymentItemBuilder newEFTPaymentItem() {
        return new TestEFTPaymentItemBuilder(null, this.service);
    }

    public TestOtherPaymentItemBuilder newOtherPaymentItem() {
        return new TestOtherPaymentItemBuilder(null, this.service);
    }

    public TestEFTPOSPaymentBuilder newEFTPOSPayment() {
        return new TestEFTPOSPaymentBuilder(this.service);
    }

    public TestEFTPOSRefundBuilder newEFTPOSRefund() {
        return new TestEFTPOSRefundBuilder(this.service);
    }

    public TestPaymentProcessorPaymentItemBuilder newPaymentProcessorPaymentItem() {
        return new TestPaymentProcessorPaymentItemBuilder(null, this.service);
    }

    public TestPaymentProcessorPaymentBuilder newPaymentProcessorPayment() {
        return new TestPaymentProcessorPaymentBuilder(this.service);
    }

    public TestRefundBuilder newRefund() {
        return new TestRefundBuilder(this.service);
    }

    public TestRefundBuilder updateRefund(FinancialAct refund) {
        return new TestRefundBuilder(refund, this.service);
    }

    public TestCashRefundItemBuilder newCashRefundItem() {
        return new TestCashRefundItemBuilder(null, this.service);
    }

    public TestEFTRefundItemBuilder newEFTRefundItem() {
        return new TestEFTRefundItemBuilder(null, this.service);
    }

    public TestPaymentProcessorRefundItemBuilder newPaymentProcessorRefundItem() {
        return new TestPaymentProcessorRefundItemBuilder(null, this.service);
    }

    public TestPaymentProcessorRefundBuilder newPaymentProcessorRefund() {
        return new TestPaymentProcessorRefundBuilder(this.service);
    }

    public TestOtherRefundItemBuilder newOtherRefundItem() {
        return new TestOtherRefundItemBuilder(null, this.service);
    }

    public Lookup createCustomPaymentType(String code) {
        return (Lookup)((TestLookupBuilder)this.newCustomPaymentType().code(code)).build();
    }

    public TestLookupBuilder newCustomPaymentType() {
        return new TestLookupBuilder("lookup.customPaymentType", this.service);
    }
}

