/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.customer.account;

import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.collections4.IterableUtils;
import org.junit.Assert;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.test.builder.act.AbstractTestActVerifier;
import org.openvpms.archetype.test.builder.customer.account.TestChargeVerifier;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.RelatedIMObjects;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestChargeItemVerifier<P extends TestChargeVerifier<P, V>, V extends TestChargeItemVerifier<P, V>>
extends AbstractTestActVerifier<FinancialAct, V> {
    private final P parent;
    private ValueStrategy patient = ValueStrategy.value(null);
    private ValueStrategy product = ValueStrategy.value(null);
    private ValueStrategy clinician = ValueStrategy.value(null);
    private ValueStrategy quantity = ValueStrategy.value(1);
    private ValueStrategy template = ValueStrategy.value(null);
    private ValueStrategy group = ValueStrategy.value(null);
    private ValueStrategy department = ValueStrategy.value(null);
    private ValueStrategy fixedCost = ValueStrategy.value(0);
    private ValueStrategy fixedPrice = ValueStrategy.value(0);
    private ValueStrategy unitCost = ValueStrategy.value(0);
    private ValueStrategy unitPrice = ValueStrategy.value(0);
    private ValueStrategy serviceRatio = ValueStrategy.value(null);
    private ValueStrategy discount = ValueStrategy.value(0);
    private ValueStrategy tax = ValueStrategy.value(0);
    private ValueStrategy total = ValueStrategy.value(0);
    private ValueStrategy print = ValueStrategy.value(true);

    public TestChargeItemVerifier(P parent, ArchetypeService service) {
        super(service);
        this.parent = parent;
    }

    public V patient(Party patient) {
        return this.patient(this.getReference((IMObject)patient));
    }

    public V patient(Reference patient) {
        this.patient = ValueStrategy.value(patient);
        return (V)((TestChargeItemVerifier)this.getThis());
    }

    public Reference getPatient() {
        return (Reference)this.patient.getValue();
    }

    public V product(Product product) {
        return this.product(this.getReference((IMObject)product));
    }

    public V product(Reference product) {
        this.product = ValueStrategy.value(product);
        return (V)((TestChargeItemVerifier)this.getThis());
    }

    public Reference getProduct() {
        return (Reference)this.product.getValue();
    }

    public V clinician(User clinician) {
        return this.clinician(this.getReference((IMObject)clinician));
    }

    public V clinician(Reference clinician) {
        this.clinician = ValueStrategy.value(clinician);
        return (V)((TestChargeItemVerifier)this.getThis());
    }

    public Reference getClinician() {
        return (Reference)this.clinician.getValue();
    }

    public V department(Entity department) {
        return this.department(this.getReference((IMObject)department));
    }

    public V department(Reference department) {
        this.department = ValueStrategy.value(department);
        return (V)((TestChargeItemVerifier)this.getThis());
    }

    public V quantity(int quantity) {
        return this.quantity(BigDecimal.valueOf(quantity));
    }

    public V quantity(BigDecimal quantity) {
        this.quantity = ValueStrategy.value(quantity);
        return (V)((TestChargeItemVerifier)this.getThis());
    }

    public BigDecimal getQuantity() {
        return (BigDecimal)this.quantity.getValue();
    }

    public V fixedCost(int fixedCost) {
        return this.fixedCost(BigDecimal.valueOf(fixedCost));
    }

    public V fixedCost(String fixedCost) {
        return this.fixedCost(new BigDecimal(fixedCost));
    }

    public V fixedCost(BigDecimal fixedCost) {
        this.fixedCost = ValueStrategy.value(fixedCost);
        return (V)((TestChargeItemVerifier)this.getThis());
    }

    public V fixedPrice(int fixedPrice) {
        return this.fixedPrice(BigDecimal.valueOf(fixedPrice));
    }

    public V fixedPrice(String fixedPrice) {
        return this.fixedPrice(new BigDecimal(fixedPrice));
    }

    public V fixedPrice(BigDecimal fixedPrice) {
        this.fixedPrice = ValueStrategy.value(fixedPrice);
        return (V)((TestChargeItemVerifier)this.getThis());
    }

    public V unitCost(int unitCost) {
        return this.unitCost(BigDecimal.valueOf(unitCost));
    }

    public V unitCost(String unitCost) {
        return this.unitCost(new BigDecimal(unitCost));
    }

    public V unitCost(BigDecimal unitCost) {
        this.unitCost = ValueStrategy.value(unitCost);
        return (V)((TestChargeItemVerifier)this.getThis());
    }

    public V unitPrice(int unitPrice) {
        return this.unitPrice(BigDecimal.valueOf(unitPrice));
    }

    public V unitPrice(String unitPrice) {
        return this.unitPrice(new BigDecimal(unitPrice));
    }

    public V unitPrice(BigDecimal unitPrice) {
        this.unitPrice = ValueStrategy.value(unitPrice);
        return (V)((TestChargeItemVerifier)this.getThis());
    }

    public V serviceRatio(int serviceRatio) {
        return this.serviceRatio(BigDecimal.valueOf(serviceRatio));
    }

    public V serviceRatio(BigDecimal serviceRatio) {
        this.serviceRatio = ValueStrategy.value(serviceRatio);
        return (V)((TestChargeItemVerifier)this.getThis());
    }

    public V discount(int discount) {
        return this.discount(BigDecimal.valueOf(discount));
    }

    public V discount(String discount) {
        return this.discount(new BigDecimal(discount));
    }

    public V discount(BigDecimal discount) {
        this.discount = ValueStrategy.value(discount);
        return (V)((TestChargeItemVerifier)this.getThis());
    }

    public V tax(int tax) {
        return this.tax(BigDecimal.valueOf(tax));
    }

    public V tax(String tax) {
        return this.tax(new BigDecimal(tax));
    }

    public V tax(BigDecimal tax) {
        this.tax = ValueStrategy.value(tax);
        return (V)((TestChargeItemVerifier)this.getThis());
    }

    public V total(int total) {
        return this.total(BigDecimal.valueOf(total));
    }

    public V total(String total) {
        return this.total(new BigDecimal(total));
    }

    public V total(BigDecimal total) {
        this.total = ValueStrategy.value(total);
        return (V)((TestChargeItemVerifier)this.getThis());
    }

    public V template(Product template) {
        return this.template(this.getReference((IMObject)template));
    }

    public V template(Reference template) {
        this.template = ValueStrategy.value(template);
        if (template == null) {
            this.group = ValueStrategy.value(null);
        }
        return (V)((TestChargeItemVerifier)this.getThis());
    }

    public V group(Integer group) {
        this.group = ValueStrategy.value(group);
        return (V)((TestChargeItemVerifier)this.getThis());
    }

    public V print(boolean print) {
        this.print = ValueStrategy.value(print);
        return (V)((TestChargeItemVerifier)this.getThis());
    }

    public P add() {
        return (P)((TestChargeVerifier)this.parent).add((TestChargeItemVerifier)((TestChargeItemVerifier)this.getThis()));
    }

    public FinancialAct verify(List<FinancialAct> items) {
        Reference productRef;
        Reference patientRef = (Reference)this.patient.getValue();
        FinancialAct item = FinancialTestHelper.find(items, patientRef, productRef = (Reference)this.product.getValue(), null);
        if (item == null) {
            Assert.fail((String)("Failed to find invoice item for patient=" + this.patient + ", product=" + this.product));
        }
        this.verify(item);
        return item;
    }

    public FinancialAct verify(RelatedIMObjects<FinancialAct, ActRelationship> itemRelationships, int sequence) {
        List items = IterableUtils.toList((Iterable)itemRelationships.getObjects());
        FinancialAct act = this.verify(items);
        ActRelationship relationship = itemRelationships.getRelationships().stream().filter(r -> r.getTarget().equals((Object)act.getObjectReference())).findFirst().orElse(null);
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((long)sequence, (long)relationship.getSequence());
        return act;
    }

    @Override
    protected void verify(FinancialAct object, IMObjectBean bean) {
        super.verify(object, bean);
        this.checkEquals(this.patient, bean.getTargetRef("patient"));
        this.checkEquals(this.product, bean.getTargetRef("product"));
        this.checkEquals(this.template, bean.getTargetRef("template"));
        this.checkEquals(this.department, bean.getTargetRef("department"));
        this.checkEquals(this.quantity, (Object)bean.getBigDecimal("quantity"));
        this.checkEquals(this.fixedCost, (Object)bean.getBigDecimal("fixedCost"));
        this.checkEquals(this.fixedPrice, (Object)bean.getBigDecimal("fixedPrice"));
        this.checkEquals(this.unitCost, (Object)bean.getBigDecimal("unitCost"));
        this.checkEquals(this.unitPrice, (Object)bean.getBigDecimal("unitPrice"));
        this.checkEquals(this.serviceRatio, (Object)bean.getBigDecimal("serviceRatio"));
        this.checkEquals(this.discount, (Object)bean.getBigDecimal("discount"));
        this.checkEquals(this.tax, (Object)bean.getBigDecimal("tax"));
        this.checkEquals(this.total, (Object)bean.getBigDecimal("total"));
        Participation participation = (Participation)bean.getObject("template", Participation.class);
        if (participation == null) {
            Assert.assertNull((Object)this.group.getValue());
        } else {
            IMObjectBean participationBean = this.getBean((IMObject)participation);
            this.checkEquals(this.group, participationBean.getValue("group"));
        }
        this.checkEquals(this.clinician, bean.getTargetRef("clinician"));
        this.checkEquals(this.print, bean.getBoolean("print"));
    }
}

