/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow.roster;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.archetype.rules.workflow.Times;
import org.openvpms.archetype.rules.workflow.roster.RosterService;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.cache.BasicEhcacheManager;
import org.openvpms.component.business.service.cache.EhcacheManager;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.system.common.util.PropertySet;

public class RosterServiceTestCase
extends ArchetypeServiceTest {
    private RosterService service;
    private Entity area;
    private Party location;

    @Before
    public void setUp() {
        this.service = new RosterService(this.getArchetypeService(), (EhcacheManager)new BasicEhcacheManager(30L));
        this.location = TestHelper.createLocation();
        this.area = this.createArea();
    }

    @After
    public void tearDown() throws Exception {
        this.service.destroy();
    }

    @Test
    public void testGetSchedules() {
        IMObjectBean bean = this.getBean((IMObject)this.area);
        Party schedule1 = ScheduleTestHelper.createSchedule(this.location);
        Party schedule2 = ScheduleTestHelper.createSchedule(this.location);
        bean.addTarget("schedules", (IMObject)schedule1);
        bean.addTarget("schedules", (IMObject)schedule2);
        bean.save();
        List schedules1 = this.service.getSchedules(this.area.getObjectReference());
        Assert.assertEquals((long)2L, (long)schedules1.size());
        Assert.assertTrue((boolean)schedules1.contains(schedule1));
        Assert.assertTrue((boolean)schedules1.contains(schedule2));
        schedule2.setActive(false);
        this.save((IMObject)schedule2);
        List schedules2 = this.service.getSchedules(this.area.getObjectReference());
        Assert.assertEquals((long)1L, (long)schedules2.size());
        Assert.assertTrue((boolean)schedules2.contains(schedule1));
    }

    @Test
    public void testAddEvent() {
        Date date1 = TestHelper.getDate("2019-01-01");
        Date date2 = TestHelper.getDate("2019-01-02");
        Date date3 = TestHelper.getDate("2019-01-03");
        User user = TestHelper.createUser();
        ScheduleEvents a1 = this.checkAreaEvents(this.area, date1, 0);
        ScheduleEvents u1 = this.checkUserEvents(user, date1, 0);
        this.checkAreaEvents(this.area, date2, 0);
        this.checkUserEvents(user, date2, 0);
        Act event = this.createEvent(this.area, date1, user);
        ScheduleEvents a2 = this.checkAreaEvents(this.area, date1, 1);
        this.checkEvent(event, (PropertySet)a2.getEvents().get(0));
        Assert.assertNotEquals((long)a1.getModHash(), (long)a2.getModHash());
        ScheduleEvents u2 = this.checkUserEvents(user, date1, 1);
        this.checkEvent(event, (PropertySet)u2.getEvents().get(0));
        Assert.assertNotEquals((long)u1.getModHash(), (long)u2.getModHash());
        this.checkAreaEvents(this.area, date2, 0);
        this.checkUserEvents(user, date2, 0);
        this.checkAreaEvents(this.area, date3, 0);
        this.checkUserEvents(user, date3, 0);
    }

    @Test
    public void testChangeEventDate() {
        Date date1 = TestHelper.getDate("2019-01-01");
        Date date2 = TestHelper.getDate("2019-03-01");
        User user = TestHelper.createUser();
        ScheduleEvents a1 = this.checkAreaEvents(this.area, date1, 0);
        ScheduleEvents a2 = this.checkAreaEvents(this.area, date2, 0);
        ScheduleEvents u1 = this.checkUserEvents(user, date1, 0);
        ScheduleEvents u2 = this.checkUserEvents(user, date2, 0);
        Act event = this.createEvent(this.area, date1, user);
        ScheduleEvents a3 = this.checkAreaEvents(this.area, date1, 1);
        Assert.assertNotEquals((long)a1.getModHash(), (long)a3.getModHash());
        this.checkAreaEvents(this.area, date2, 0, a2.getModHash());
        ScheduleEvents u3 = this.checkUserEvents(user, date1, 1);
        Assert.assertNotEquals((long)u1.getModHash(), (long)u3.getModHash());
        this.checkUserEvents(user, date2, 0, u2.getModHash());
        event.setActivityStartTime(date2);
        event.setActivityEndTime(DateRules.getDate((Date)date2, (int)15, (DateUnits)DateUnits.MINUTES));
        this.save((IMObject)event);
        ScheduleEvents a4 = this.checkAreaEvents(this.area, date1, 0);
        ScheduleEvents u4 = this.checkUserEvents(user, date1, 0);
        ScheduleEvents a5 = this.checkAreaEvents(this.area, date2, 1);
        this.checkEvent(event, (PropertySet)a5.getEvents().get(0));
        ScheduleEvents u5 = this.checkUserEvents(user, date2, 1);
        this.checkEvent(event, (PropertySet)u5.getEvents().get(0));
        Assert.assertNotEquals((long)a3.getModHash(), (long)a4.getModHash());
        Assert.assertNotEquals((long)a2.getModHash(), (long)a5.getModHash());
        Assert.assertNotEquals((long)u3.getModHash(), (long)u4.getModHash());
        Assert.assertNotEquals((long)u2.getModHash(), (long)u5.getModHash());
    }

    @Test
    public void testChangeEventArea() {
        Date date = TestHelper.getDate("2019-01-01");
        Entity area1 = this.createArea();
        Entity area2 = this.createArea();
        Assert.assertEquals((long)-1L, (long)this.service.getModHash(area1, date));
        ScheduleEvents a1 = this.checkAreaEvents(area1, date, 0);
        Assert.assertNotEquals((long)-1L, (long)a1.getModHash());
        ScheduleEvents a2 = this.checkAreaEvents(area1, date, 0, a1.getModHash());
        Assert.assertEquals((long)a2.getModHash(), (long)this.service.getModHash(area1, date));
        Act event = this.createEvent(area1, date, TestHelper.createUser());
        ScheduleEvents a3 = this.checkAreaEvents(area1, date, 1);
        Assert.assertNotEquals((long)a3.getModHash(), (long)a2.getModHash());
        Assert.assertEquals((long)a3.getModHash(), (long)this.service.getModHash(area1, date));
        this.setArea(event, area2);
        ScheduleEvents a4 = this.checkAreaEvents(area1, date, 0);
        Assert.assertNotEquals((long)a4.getModHash(), (long)a3.getModHash());
        Assert.assertEquals((long)a4.getModHash(), (long)this.service.getModHash(area1, date));
        ScheduleEvents a5 = this.checkAreaEvents(area2, date, 1);
        Assert.assertNotEquals((long)-1L, (long)a5.getModHash());
        Assert.assertEquals((long)a5.getModHash(), (long)this.service.getModHash(area2, date));
    }

    @Test
    public void testChangeEventUser() {
        Date date = TestHelper.getDate("2019-01-01");
        User user1 = TestHelper.createUser();
        User user2 = TestHelper.createUser();
        Assert.assertEquals((long)-1L, (long)this.service.getModHash((Entity)user1, date));
        ScheduleEvents a1 = this.checkUserEvents(user1, date, 0);
        Assert.assertNotEquals((long)-1L, (long)a1.getModHash());
        ScheduleEvents a2 = this.checkUserEvents(user1, date, 0, a1.getModHash());
        Assert.assertEquals((long)a2.getModHash(), (long)this.getUserModHash(user1, date));
        Act event = this.createEvent(this.area, date, user1);
        ScheduleEvents a3 = this.checkUserEvents(user1, date, 1);
        Assert.assertNotEquals((long)a3.getModHash(), (long)a2.getModHash());
        Assert.assertEquals((long)a3.getModHash(), (long)this.getUserModHash(user1, date));
        IMObjectBean bean = this.getBean((IMObject)event);
        bean.setTarget("user", (IMObject)user2);
        bean.save();
        ScheduleEvents a4 = this.checkUserEvents(user1, date, 0);
        Assert.assertNotEquals((long)a4.getModHash(), (long)a3.getModHash());
        Assert.assertEquals((long)a4.getModHash(), (long)this.getUserModHash(user1, date));
        ScheduleEvents a5 = this.checkUserEvents(user2, date, 1);
        Assert.assertNotEquals((long)-1L, (long)a5.getModHash());
        Assert.assertEquals((long)a5.getModHash(), (long)this.getUserModHash(user2, date));
    }

    @Test
    public void testRemoveEvent() {
        Date date1 = TestHelper.getDate("2019-01-01");
        Date date2 = TestHelper.getDate("2019-01-02");
        Date date3 = TestHelper.getDate("2019-01-03");
        User user = TestHelper.createUser();
        ScheduleEvents a1 = this.checkAreaEvents(this.area, date1, 0);
        ScheduleEvents a2 = this.checkAreaEvents(this.area, date2, 0);
        ScheduleEvents a3 = this.checkAreaEvents(this.area, date3, 0);
        Assert.assertNotEquals((long)a1.getModHash(), (long)a2.getModHash());
        Assert.assertNotEquals((long)a1.getModHash(), (long)a3.getModHash());
        Act event = this.createEvent(this.area, date1, user);
        ScheduleEvents a4 = this.checkAreaEvents(this.area, date1, 1);
        Assert.assertNotEquals((long)a1.getModHash(), (long)a4.getModHash());
        this.checkAreaEvents(this.area, date2, 0, a2.getModHash());
        this.checkAreaEvents(this.area, date3, 0, a3.getModHash());
        this.remove((IMObject)event);
        ScheduleEvents a5 = this.checkAreaEvents(this.area, date1, 0);
        Assert.assertNotEquals((long)a1.getModHash(), (long)a5.getModHash());
        this.checkAreaEvents(this.area, date2, 0, a2.getModHash());
        this.checkAreaEvents(this.area, date3, 0, a3.getModHash());
    }

    @Test
    public void testAddEventOnDayBoundary() {
        Date date1 = TestHelper.getDate("2019-01-01");
        Date date2 = TestHelper.getDate("2019-01-02");
        Date date3 = TestHelper.getDate("2019-01-03");
        Date date4 = TestHelper.getDate("2019-01-04");
        User user = TestHelper.createUser();
        Act event1 = this.createEvent(this.area, "2019-01-02 00:00", "2019-01-02 08:00", user);
        Act event2 = this.createEvent(this.area, "2019-01-03 14:00", "2019-01-04 00:00", user);
        this.checkAreaEvents(this.area, date1, 0);
        this.checkUserEvents(user, date1, 0);
        ScheduleEvents a2 = this.checkAreaEvents(this.area, date2, 1);
        this.checkEvent(event1, (PropertySet)a2.getEvents().get(0));
        ScheduleEvents u2 = this.checkUserEvents(user, date2, 1);
        this.checkEvent(event1, (PropertySet)u2.getEvents().get(0));
        ScheduleEvents a3 = this.checkAreaEvents(this.area, date3, 1);
        this.checkEvent(event2, (PropertySet)a3.getEvents().get(0));
        ScheduleEvents u3 = this.checkUserEvents(user, date3, 1);
        this.checkEvent(event2, (PropertySet)u3.getEvents().get(0));
        this.checkAreaEvents(this.area, date4, 0);
        this.checkUserEvents(user, date4, 0);
    }

    @Test
    public void testMultiDayEvent() {
        Date date1 = TestHelper.getDate("2019-01-01");
        Date date2 = TestHelper.getDate("2019-01-02");
        Date date3 = TestHelper.getDate("2019-01-03");
        Date date4 = TestHelper.getDate("2019-01-04");
        User user = TestHelper.createUser();
        Act event = this.createEvent(this.area, "2019-01-02 18:00", "2019-01-03 06:00", user);
        this.checkAreaEvents(this.area, date1, 0);
        this.checkUserEvents(user, date1, 0);
        ScheduleEvents a2 = this.checkAreaEvents(this.area, date2, 1);
        this.checkEvent(event, (PropertySet)a2.getEvents().get(0));
        ScheduleEvents u2 = this.checkUserEvents(user, date2, 1);
        this.checkEvent(event, (PropertySet)u2.getEvents().get(0));
        ScheduleEvents a3 = this.checkAreaEvents(this.area, date3, 1);
        this.checkEvent(event, (PropertySet)a3.getEvents().get(0));
        ScheduleEvents u3 = this.checkUserEvents(user, date3, 1);
        this.checkEvent(event, (PropertySet)u3.getEvents().get(0));
        this.checkAreaEvents(this.area, date4, 0);
        this.checkUserEvents(user, date4, 0);
        this.remove((IMObject)event);
        this.checkAreaEvents(this.area, date2, 0);
        this.checkUserEvents(user, date2, 0);
        this.checkAreaEvents(this.area, date3, 0);
        this.checkUserEvents(user, date3, 0);
    }

    @Test
    public void testConcurrentChangeArea() throws Exception {
        for (int i = 0; i < 100; ++i) {
            System.out.println("Concurrent read/write run: " + i + " ");
            Entity area1 = this.createArea();
            Entity area2 = this.createArea();
            User user = TestHelper.createUser();
            Date date = TestHelper.getDate("2019-02-01");
            Act event = this.createEvent(area1, date, user);
            Callable<PropertySet> read1 = () -> {
                System.err.println("Read date1 thread=" + Thread.currentThread().getName());
                List events = this.service.getEvents(area1, date);
                Assert.assertFalse((events.size() > 1 ? 1 : 0) != 0);
                this.checkUserEvents(user, date, 1);
                return events.isEmpty() ? null : (PropertySet)events.get(0);
            };
            Callable<PropertySet> read2 = () -> {
                System.err.println("Read date2 thread=" + Thread.currentThread().getName());
                List events = this.service.getEvents(area2, date);
                Assert.assertFalse((events.size() > 1 ? 1 : 0) != 0);
                this.checkUserEvents(user, date, 1);
                return events.isEmpty() ? null : (PropertySet)events.get(0);
            };
            Callable<PropertySet> write = () -> {
                System.err.println("Writer thread=" + Thread.currentThread().getName());
                this.setArea(event, area2);
                return null;
            };
            this.runConcurrent(read1, read2, write);
            this.checkAreaEvents(area1, date, 0);
            this.checkAreaEvents(area2, date, 1);
            this.checkUserEvents(user, date, 1);
            System.out.println("OK");
        }
    }

    @Test
    public void testConcurrentChangeUser() throws Exception {
        for (int i = 0; i < 100; ++i) {
            System.out.println("Concurrent read/write run: " + i + " ");
            Entity area = this.createArea();
            User user1 = TestHelper.createUser();
            User user2 = TestHelper.createUser();
            Date date = TestHelper.getDate("2019-02-01");
            Date next = DateRules.getNextDate((Date)date);
            Act event = this.createEvent(area, date, user1);
            Callable<PropertySet> read1 = () -> {
                System.err.println("Read date1 thread=" + Thread.currentThread().getName());
                List events = this.service.getUserEvents(user1, date, next).getEvents();
                Assert.assertFalse((events.size() > 1 ? 1 : 0) != 0);
                return events.isEmpty() ? null : (PropertySet)events.get(0);
            };
            Callable<PropertySet> read2 = () -> {
                System.err.println("Read date2 thread=" + Thread.currentThread().getName());
                List events = this.service.getUserEvents(user2, date, next).getEvents();
                Assert.assertFalse((events.size() > 1 ? 1 : 0) != 0);
                return events.isEmpty() ? null : (PropertySet)events.get(0);
            };
            Callable<PropertySet> write = () -> {
                System.err.println("Writer thread=" + Thread.currentThread().getName());
                IMObjectBean bean = this.getBean((IMObject)event);
                bean.setTarget("user", (IMObject)user2);
                bean.save();
                return null;
            };
            this.runConcurrent(read1, read2, write);
            this.checkUserEvents(user1, date, 0);
            this.checkUserEvents(user2, date, 1);
            this.checkAreaEvents(area, date, 1);
            System.out.println("OK");
        }
    }

    @Test
    public void testGetOverlappingEvents() {
        Date start1 = TestHelper.getDatetime("2019-02-14 09:00:00");
        Date end1 = TestHelper.getDatetime("2019-02-14 09:15:00");
        Date start2 = TestHelper.getDatetime("2019-02-15 09:00:00");
        Date end2 = TestHelper.getDatetime("2019-02-15 09:15:00");
        Date beforeStart = TestHelper.getDatetime("2019-02-15 08:45:00");
        Date beforeEnd = TestHelper.getDatetime("2019-02-15 09:00:00");
        Date afterStart = TestHelper.getDatetime("2019-02-15 09:30:00");
        Date afterEnd = TestHelper.getDatetime("2019-02-15 09:45:00");
        Date overlap1Start = TestHelper.getDatetime("2019-02-15 09:05:00");
        Date overlap1End = TestHelper.getDatetime("2019-02-15 09:20:00");
        Date overlap2Start = TestHelper.getDatetime("2019-02-15 09:10:00");
        Date overlap2End = TestHelper.getDatetime("2019-02-15 09:25:00");
        User user = TestHelper.createUser();
        Times times1 = new Times(start1, end1);
        Times times2 = new Times(start2, end2);
        List<Times> list = Arrays.asList(times1, times2);
        Assert.assertNull((Object)this.service.getOverlappingEvents(list, user, 1));
        Act event1 = this.createEvent(this.area, start1, end1, user);
        this.checkTimes(this.service.getOverlappingEvents(list, user, 1), times1);
        this.remove((IMObject)event1);
        Act event2 = this.createEvent(this.area, start2, end2, user);
        this.checkTimes(this.service.getOverlappingEvents(list, user, 1), times2);
        this.remove((IMObject)event2);
        this.createEvent(this.area, beforeStart, beforeEnd, user);
        Assert.assertNull((Object)this.service.getOverlappingEvents(list, user, 1));
        this.createEvent(this.area, afterStart, afterEnd, user);
        Assert.assertNull((Object)this.service.getOverlappingEvents(list, user, 1));
        Act event5 = this.createEvent(this.area, overlap1Start, overlap1End, user);
        this.checkTimes(this.service.getOverlappingEvents(list, user, 1), Times.create((Act)event5));
        this.remove((IMObject)event5);
        Act event6 = this.createEvent(this.area, overlap2Start, overlap2End, user);
        this.checkTimes(this.service.getOverlappingEvents(list, user, 1), Times.create((Act)event6));
    }

    private void checkTimes(List<Times> events, Times ... times) {
        Assert.assertEquals((long)times.length, (long)events.size());
        for (int i = 0; i < times.length; ++i) {
            Times expected = times[i];
            Times actual = events.get(i);
            Assert.assertEquals((Object)expected.getStartTime(), (Object)actual.getStartTime());
            Assert.assertEquals((Object)expected.getEndTime(), (Object)actual.getEndTime());
        }
    }

    @SafeVarargs
    private final void runConcurrent(Callable<PropertySet> ... tasks) throws Exception {
        List<Callable<PropertySet>> list = Arrays.asList(tasks);
        ExecutorService executorService = Executors.newFixedThreadPool(list.size());
        List<Future<PropertySet>> futures = executorService.invokeAll(list);
        Assert.assertEquals((long)tasks.length, (long)futures.size());
        for (Future<PropertySet> future : futures) {
            future.get();
        }
    }

    private void setArea(Act event, Entity area) {
        IMObjectBean bean = this.getBean((IMObject)event);
        bean.setTarget("schedule", (IMObject)area);
        bean.save();
    }

    private ScheduleEvents checkUserEvents(User user, Date date, int size, long modHash) {
        ScheduleEvents events = this.checkUserEvents(user, date, size);
        Assert.assertEquals((long)modHash, (long)events.getModHash());
        return events;
    }

    private Entity createArea() {
        Entity result = this.create("entity.rosterArea", Entity.class);
        result.setName("Z Roster Area");
        IMObjectBean bean = this.getBean((IMObject)result);
        bean.setTarget("location", (IMObject)this.location);
        bean.save();
        return result;
    }

    private ScheduleEvents checkAreaEvents(Entity area, Date date, int size, long modHash) {
        ScheduleEvents events = this.checkAreaEvents(area, date, size);
        Assert.assertEquals((long)modHash, (long)events.getModHash());
        return events;
    }

    private ScheduleEvents checkAreaEvents(Entity area, Date date, int size) {
        ScheduleEvents events = this.service.getScheduleEvents(area, date);
        Assert.assertEquals((long)size, (long)events.size());
        return events;
    }

    private ScheduleEvents checkUserEvents(User user, Date date, int size) {
        ScheduleEvents events = this.service.getUserEvents(user, date, DateRules.getNextDate((Date)date));
        Assert.assertEquals((long)size, (long)events.size());
        return events;
    }

    private void checkUserModHash(User user, Date date, long expected) {
        long hash = this.getUserModHash(user, date);
        Assert.assertEquals((long)expected, (long)hash);
    }

    private long getUserModHash(User user, Date date) {
        return this.service.getUserModHash(user, date, DateRules.getNextDate((Date)date));
    }

    private void checkEvent(Act act, PropertySet set) {
        IMObjectBean bean = this.getBean((IMObject)act);
        Assert.assertEquals((Object)act.getObjectReference(), (Object)set.get("act.objectReference"));
        Assert.assertEquals((Object)act.getActivityStartTime(), (Object)set.get("act.startTime"));
        Assert.assertEquals((Object)act.getActivityEndTime(), (Object)set.get("act.endTime"));
        Assert.assertEquals((Object)bean.getTargetRef("schedule"), (Object)set.get("schedule.objectReference"));
        Assert.assertEquals((Object)bean.getTarget("schedule").getName(), (Object)set.get("schedule.name"));
        Assert.assertEquals((Object)bean.getTargetRef("location"), (Object)set.get("location.objectReference"));
        Assert.assertEquals((Object)bean.getTarget("location").getName(), (Object)set.get("location.name"));
        Assert.assertEquals((Object)bean.getTargetRef("user"), (Object)set.get("user.objectReference"));
        Assert.assertEquals((Object)bean.getTarget("user").getName(), (Object)set.get("user.name"));
        Set identities = act.getIdentities();
        Collection sync = (Collection)set.get("synchronisation");
        Assert.assertEquals((long)identities.size(), (long)sync.size());
        for (ActIdentity identity : identities) {
            Assert.assertTrue((boolean)sync.contains(identity));
        }
    }

    private Act createEvent(Entity area, Date date, User user) {
        Date startTime = DateRules.getDate((Date)date, (int)8, (DateUnits)DateUnits.HOURS);
        Date endTime = DateRules.getDate((Date)date, (int)17, (DateUnits)DateUnits.HOURS);
        return this.createEvent(area, startTime, endTime, user);
    }

    private Act createEvent(Entity area, String startTime, String endTime, User user) {
        return this.createEvent(area, TestHelper.getDatetime(startTime), TestHelper.getDatetime(endTime), user);
    }

    private Act createEvent(Entity area, Date startTime, Date endTime, User user) {
        Act event = this.create("act.rosterEvent", Act.class);
        event.setActivityStartTime(startTime);
        event.setActivityEndTime(endTime);
        IMObjectBean bean = this.getBean((IMObject)event);
        bean.setTarget("schedule", (IMObject)area);
        bean.setTarget("user", (IMObject)user);
        bean.setTarget("location", (IMObject)this.location);
        ActIdentity id1 = this.create("actIdentity.syncTest", ActIdentity.class);
        ActIdentity id2 = this.create("actIdentity.syncTest", ActIdentity.class);
        id1.setIdentity(UUID.randomUUID().toString());
        id2.setIdentity(UUID.randomUUID().toString());
        event.addIdentity(id1);
        event.addIdentity(id2);
        bean.save();
        return event;
    }
}

