/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.workflow.TaskRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.beans.factory.annotation.Autowired;

public class TaskRulesTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestSchedulingFactory schedulingFactory;
    private TaskRules rules;

    @Before
    public void setUp() {
        this.rules = new TaskRules((ArchetypeService)this.getArchetypeService());
    }

    @Test
    public void testGetWorkList() {
        Entity list = this.schedulingFactory.createWorkList();
        Act task = (Act)this.schedulingFactory.newTask().workList(list).build(false);
        Assert.assertEquals((Object)list, (Object)this.rules.getWorkList(task));
    }

    @Test
    public void testGetWorkListView() {
        Entity listA = this.schedulingFactory.createWorkList();
        Entity listB = this.schedulingFactory.createWorkList();
        Entity listC = this.schedulingFactory.createWorkList();
        Entity listD = this.schedulingFactory.createWorkList();
        Entity view1 = this.schedulingFactory.createWorkListView(listA, listB);
        Entity view2 = this.schedulingFactory.createWorkListView(listC);
        Party location1 = (Party)this.practiceFactory.newLocation().workListViews(view1).build();
        Party location2 = (Party)this.practiceFactory.newLocation().workListViews(view2).build();
        Assert.assertEquals((Object)view1, (Object)this.rules.getWorkListView(location1, listA));
        Assert.assertEquals((Object)view1, (Object)this.rules.getWorkListView(location1, listB));
        Assert.assertEquals((Object)view2, (Object)this.rules.getWorkListView(location2, listC));
        Assert.assertNull((Object)this.rules.getWorkListView(location2, listA));
        Assert.assertNull((Object)this.rules.getWorkListView(location2, listB));
        Assert.assertNull((Object)this.rules.getWorkListView(location2, listA));
        Assert.assertNull((Object)this.rules.getWorkListView(location1, listD));
        Assert.assertNull((Object)this.rules.getWorkListView(location2, listD));
    }

    @Test
    public void testHasTaskType() {
        Entity taskType = this.schedulingFactory.createTaskType();
        Entity worklist1 = (Entity)this.schedulingFactory.newWorkList().taskTypes(taskType).build();
        Entity worklist2 = this.schedulingFactory.createWorkList();
        Assert.assertTrue((boolean)this.rules.hasTaskType(worklist1, taskType));
        Assert.assertFalse((boolean)this.rules.hasTaskType(worklist2, taskType));
    }
}

