/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.workflow.ScheduleTestHelper;
import org.openvpms.archetype.rules.workflow.TaskQuery;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.LookupHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.ObjectSet;

public class TaskQueryTestCase
extends ArchetypeServiceTest {
    @Test
    public void testQuery() {
        IMObjectBean bean;
        int count = 10;
        Party workList = ScheduleTestHelper.createWorkList();
        Date from = DateUtils.truncate((Date)new Date(), (int)13);
        Act[] tasks = new Act[10];
        Date[] startTimes = new Date[10];
        Date[] endTimes = new Date[10];
        Date[] consultTimes = new Date[10];
        Party[] customers = new Party[10];
        Party[] patients = new Party[10];
        User[] clinicians = new User[10];
        Entity[] taskTypes = new Entity[10];
        for (int i = 0; i < 10; ++i) {
            Date startTime = new Date();
            Date consultTime = i % 2 == 0 ? new Date() : null;
            Date endTime = new Date();
            Party customer = TestHelper.createCustomer();
            Party patient = TestHelper.createPatient();
            User clinician = TestHelper.createClinician();
            Act task = ScheduleTestHelper.createTask(startTime, endTime, (Entity)workList, customer, patient);
            bean = this.getBean((IMObject)task);
            bean.setTarget("clinician", (IMObject)clinician);
            bean.setValue("consultStartTime", (Object)consultTime);
            tasks[i] = task;
            startTimes[i] = this.getTimestamp(startTime);
            consultTimes[i] = consultTime;
            endTimes[i] = this.getTimestamp(endTime);
            taskTypes[i] = (Entity)bean.getTarget("taskType", Entity.class);
            customers[i] = customer;
            patients[i] = patient;
            clinicians[i] = clinician;
            bean.save();
        }
        Date to = new Date();
        LookupService lookups = this.getLookupService();
        Map statusNames = LookupHelper.getNames((IArchetypeService)this.getArchetypeService(), (LookupService)lookups, (String)"act.customerTask", (String)"status");
        TaskQuery query = new TaskQuery((Entity)workList, from, to, statusNames, this.getArchetypeService());
        IPage page = query.query();
        Assert.assertNotNull((Object)page);
        List results = page.getResults();
        Assert.assertEquals((long)10L, (long)results.size());
        for (int i = 0; i < results.size(); ++i) {
            ObjectSet set = (ObjectSet)results.get(i);
            Assert.assertEquals((Object)tasks[i].getObjectReference(), (Object)set.get("act.objectReference"));
            Assert.assertEquals((Object)startTimes[i], (Object)set.get("act.startTime"));
            Assert.assertEquals((Object)endTimes[i], (Object)set.get("act.endTime"));
            Assert.assertEquals((Object)tasks[i].getStatus(), (Object)set.get("act.status"));
            Assert.assertEquals((Object)tasks[i].getReason(), (Object)set.get("act.reason"));
            bean = this.getBean((IMObject)tasks[i]);
            Assert.assertEquals((Object)bean.getString("notes"), (Object)set.get("notes"));
            Assert.assertEquals((Object)customers[i].getObjectReference(), (Object)set.get("customer.objectReference"));
            Assert.assertEquals((Object)customers[i].getName(), (Object)set.get("customer.name"));
            Assert.assertEquals((Object)patients[i].getObjectReference(), (Object)set.get("patient.objectReference"));
            Assert.assertEquals((Object)patients[i].getName(), (Object)set.get("patient.name"));
            Assert.assertEquals((Object)clinicians[i].getObjectReference(), (Object)set.get("clinician.objectReference"));
            Assert.assertEquals((Object)clinicians[i].getName(), (Object)set.get("clinician.name"));
            Assert.assertEquals((Object)workList.getObjectReference(), (Object)set.get("schedule.objectReference"));
            Assert.assertEquals((Object)workList.getName(), (Object)set.get("schedule.name"));
            Assert.assertEquals((Object)taskTypes[i].getObjectReference(), (Object)set.get("scheduleType.objectReference"));
            Assert.assertEquals((Object)taskTypes[i].getName(), (Object)set.get("scheduleType.name"));
            Assert.assertEquals((Object)consultTimes[i], (Object)set.get("consultStartTime"));
        }
    }

    private Date getTimestamp(Date timestamp) {
        return DateUtils.truncate((Date)new Date(timestamp.getTime()), (int)13);
    }
}

