/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.Times;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.scheduling.TestAppointmentBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestCalendarBlockBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestScheduleBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.archetype.test.builder.scheduling.TestTaskBuilder;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.springframework.beans.factory.annotation.Autowired;

public class AppointmentRulesTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestSchedulingFactory schedulingFactory;
    @Autowired
    private TestUserFactory userFactory;
    private AppointmentRules rules;

    @Before
    public void setUp() {
        this.rules = new AppointmentRules(this.getArchetypeService());
    }

    @Test
    public void testGetSlotSize() {
        Entity appointmentType = this.createAppointmentType();
        Entity schedule = this.createSchedule(15, DateUnits.MINUTES, 2, appointmentType);
        Assert.assertEquals((long)15L, (long)this.rules.getSlotSize(schedule));
    }

    @Test
    public void testGetDefaultAppointmentType() {
        Entity appointmentType1 = this.createAppointmentType();
        Entity appointmentType2 = this.createAppointmentType();
        Entity schedule = (Entity)this.schedulingFactory.newSchedule().location(this.practiceFactory.createLocation()).slotSize(15, DateUnits.MINUTES).build();
        Assert.assertNull((Object)this.rules.getDefaultAppointmentType(schedule));
        this.schedulingFactory.updateSchedule(schedule).addAppointmentType(appointmentType1, 2, false).build();
        Assert.assertNull((Object)this.rules.getDefaultAppointmentType(schedule));
        this.schedulingFactory.updateSchedule(schedule).addAppointmentType(appointmentType2, 2, true).build();
        Assert.assertEquals((Object)this.rules.getDefaultAppointmentType(schedule), (Object)appointmentType2);
    }

    @Test
    public void testCalculateEndTimeForMinsUnits() {
        Entity appointmentType = this.createAppointmentType();
        Entity schedule = this.createSchedule(15, DateUnits.MINUTES, 2, appointmentType);
        Date start = TestHelper.getDatetime("2006-08-22 09:00");
        Date end = this.rules.calculateEndTime(start, schedule, appointmentType);
        Date expected = TestHelper.getDatetime("2006-08-22 09:30");
        Assert.assertEquals((Object)expected, (Object)end);
    }

    @Test
    public void testCalculateEndTimeForHoursUnits() {
        Entity appointmentType = this.createAppointmentType();
        Entity schedule = this.createSchedule(1, DateUnits.HOURS, 3, appointmentType);
        Date start = TestHelper.getDatetime("2006-08-22 09:00");
        Date end = this.rules.calculateEndTime(start, schedule, appointmentType);
        Date expected = TestHelper.getDatetime("2006-08-22 12:00");
        Assert.assertEquals((Object)expected, (Object)end);
    }

    @Test
    public void testUpdateTaskStatus() {
        Entity appointmentType = this.createAppointmentType();
        Entity schedule = this.createSchedule(15, DateUnits.MINUTES, 2, appointmentType);
        Act appointment = this.createAppointment("2006-08-22 09:00", schedule, appointmentType);
        Act task = this.createTask();
        ((TestAppointmentBuilder)this.schedulingFactory.updateAppointment(appointment).status("IN_PROGRESS")).task(task).build();
        task = this.get(task);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)task.getStatus());
        this.checkStatus(appointment, "PENDING", task, "IN_PROGRESS");
        this.checkStatus(appointment, "CONFIRMED", task, "IN_PROGRESS");
        this.checkStatus(appointment, "CHECKED_IN", task, "IN_PROGRESS");
        this.checkStatus(appointment, "IN_PROGRESS", task, "IN_PROGRESS");
        this.checkStatus(appointment, "BILLED", task, "BILLED");
        this.checkStatus(appointment, "COMPLETED", task, "COMPLETED");
        this.checkStatus(appointment, "CANCELLED", task, "CANCELLED");
        this.checkStatus(appointment, "NO_SHOW", task, "CANCELLED");
    }

    @Test
    public void testUpdateAppointmentStatus() {
        Entity appointmentType = this.createAppointmentType();
        Entity schedule = this.createSchedule(15, DateUnits.MINUTES, 2, appointmentType);
        Act appointment = this.createAppointment("2006-08-22 09:00", schedule, appointmentType);
        Assert.assertEquals((Object)"PENDING", (Object)appointment.getStatus());
        Act task = this.createTask();
        ((TestAppointmentBuilder)this.schedulingFactory.updateAppointment(appointment).status("IN_PROGRESS")).task(task).build();
        this.checkStatus(task, "PENDING", appointment, "IN_PROGRESS");
        this.checkStatus(task, "IN_PROGRESS", appointment, "IN_PROGRESS");
        this.checkStatus(task, "BILLED", appointment, "BILLED");
        this.checkStatus(task, "COMPLETED", appointment, "COMPLETED");
        this.checkStatus(task, "CANCELLED", appointment, "CANCELLED");
    }

    @Test
    public void testGetActivePatientAppointment() {
        Party customer = this.customerFactory.createCustomer();
        Party patient = this.patientFactory.createPatient(customer);
        Entity appointmentType = this.createAppointmentType();
        Entity schedule = this.createSchedule(15, DateUnits.MINUTES, 2, appointmentType);
        Assert.assertNull((Object)this.rules.getActivePatientAppointment(patient));
        TestAppointmentBuilder builder = ((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime("2022-07-14 09:00")).endTime("2022-07-14 09:15")).customer(customer)).schedule(schedule).appointmentType(appointmentType);
        Act appointment1 = (Act)((TestAppointmentBuilder)builder.patient(patient)).build();
        Assert.assertNull((Object)this.rules.getActivePatientAppointment(patient));
        this.checkActivePatientAppointment(patient, appointment1, "CONFIRMED", null);
        this.checkActivePatientAppointment(patient, appointment1, "CHECKED_IN", appointment1);
        this.checkActivePatientAppointment(patient, appointment1, "IN_PROGRESS", appointment1);
        this.checkActivePatientAppointment(patient, appointment1, "BILLED", appointment1);
        this.checkActivePatientAppointment(patient, appointment1, "CANCELLED", null);
        this.checkActivePatientAppointment(patient, appointment1, "NO_SHOW", null);
        this.checkActivePatientAppointment(patient, appointment1, "COMPLETED", appointment1);
        Act appointment2 = (Act)((TestAppointmentBuilder)((TestAppointmentBuilder)builder.startTime("2023-07-14 11:00")).endTime("2023-07-14 11:15")).build();
        Assert.assertEquals((Object)appointment1, (Object)this.rules.getActivePatientAppointment(patient));
        this.checkActivePatientAppointment(patient, appointment2, "CONFIRMED", appointment1);
        this.checkActivePatientAppointment(patient, appointment2, "CHECKED_IN", appointment2);
    }

    @Test
    public void testGetActiveCustomerAppointments() {
        Party customer = this.customerFactory.createCustomer();
        Party patientA = this.patientFactory.createPatient(customer);
        Party patientB = this.patientFactory.createPatient(customer);
        Party patientC = this.patientFactory.createPatient(customer);
        Entity appointmentType = this.createAppointmentType();
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        Entity schedule1 = this.createSchedule(15, DateUnits.MINUTES, 2, appointmentType, location1);
        Entity schedule2 = this.createSchedule(15, DateUnits.MINUTES, 2, appointmentType, location2);
        TestAppointmentBuilder builder = ((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime("2022-07-14 09:00")).customer(customer)).appointmentType(appointmentType);
        Act appointmentA = (Act)((TestAppointmentBuilder)builder.schedule(schedule1).patient(patientA)).build();
        Act appointmentB = (Act)((TestAppointmentBuilder)builder.schedule(schedule1).patient(patientB)).build();
        Act appointmentC = (Act)((TestAppointmentBuilder)builder.schedule(schedule2).patient(patientC)).build();
        Assert.assertEquals((Object)"PENDING", (Object)appointmentA.getStatus());
        Assert.assertEquals((Object)"PENDING", (Object)appointmentA.getStatus());
        this.checkActiveCustomerAppointments(customer, location1, null, new Act[0]);
        this.checkActiveCustomerAppointments(customer, location2, null, new Act[0]);
        this.setStatus(appointmentA, "CONFIRMED");
        this.setStatus(appointmentC, "CONFIRMED");
        this.checkActiveCustomerAppointments(customer, location1, null, new Act[0]);
        this.checkActiveCustomerAppointments(customer, location2, null, new Act[0]);
        this.setStatus(appointmentA, "CHECKED_IN");
        this.setStatus(appointmentB, "IN_PROGRESS");
        this.setStatus(appointmentC, "IN_PROGRESS");
        this.checkActiveCustomerAppointments(customer, location1, null, appointmentA, appointmentB);
        this.checkActiveCustomerAppointments(customer, location2, null, appointmentC);
        this.setStatus(appointmentA, "ADMITTED");
        this.setStatus(appointmentB, "BILLED");
        this.checkActiveCustomerAppointments(customer, location1, null, appointmentA, appointmentB);
        this.checkActiveCustomerAppointments(customer, location2, null, appointmentC);
        this.checkActiveCustomerAppointments(customer, location1, appointmentB, appointmentA);
        this.setStatus(appointmentA, "COMPLETED");
        this.setStatus(appointmentB, "CANCELLED");
        this.setStatus(appointmentC, "NO_SHOW");
        this.checkActiveCustomerAppointments(customer, location1, null, new Act[0]);
        this.checkActiveCustomerAppointments(customer, location2, null, new Act[0]);
    }

    @Test
    public void testCopy() {
        Date arrival = TestHelper.getDatetime("2006-08-22 08:55");
        Date start = TestHelper.getDatetime("2006-08-22 09:00");
        Date end = TestHelper.getDatetime("2006-08-22 09:15");
        Entity appointmentType = this.createAppointmentType();
        Entity schedule = this.createSchedule(15, DateUnits.MINUTES, 2, appointmentType);
        Party customer = this.customerFactory.createCustomer();
        Party patient = this.patientFactory.createPatient();
        User clinician = this.userFactory.createClinician();
        Act task = this.createTask();
        Act appointment = (Act)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime(start)).endTime(end)).schedule(schedule).appointmentType(appointmentType).customer(customer)).patient(patient)).clinician(clinician)).status("IN_PROGRESS")).arrivalTime(arrival).notes("some notes")).task(task).build();
        Act copy = this.rules.copy(appointment);
        Assert.assertTrue((boolean)copy.isA("act.customerAppointment"));
        Assert.assertTrue((boolean)copy.getActRelationships().isEmpty());
        Assert.assertTrue((boolean)copy.isNew());
        IMObjectBean copyBean = this.getBean((IMObject)copy);
        Assert.assertEquals((long)0L, (long)DateRules.compareTo((Date)start, (Date)copy.getActivityStartTime()));
        Assert.assertEquals((long)0L, (long)DateRules.compareTo((Date)end, (Date)copy.getActivityEndTime()));
        Assert.assertEquals((Object)schedule, (Object)copyBean.getTarget("schedule"));
        Assert.assertEquals((Object)customer, (Object)copyBean.getTarget("customer"));
        Assert.assertEquals((Object)patient, (Object)copyBean.getTarget("patient"));
        Assert.assertEquals((Object)clinician, (Object)copyBean.getTarget("clinician"));
        Assert.assertEquals((Object)appointmentType, (Object)copyBean.getTarget("appointmentType"));
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)copy.getStatus());
        Assert.assertEquals((long)0L, (long)DateRules.compareTo((Date)arrival, (Date)copyBean.getDate("arrivalTime")));
        Assert.assertEquals((Object)"some notes", (Object)copyBean.getString("notes"));
        Assert.assertEquals((Object)appointment.getReason(), (Object)copyBean.getString("reason"));
    }

    @Test
    public void testGetScheduleView() {
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        Entity scheduleA = this.createSchedule(location1);
        Entity scheduleB = this.createSchedule(location1);
        Entity scheduleC = this.createSchedule(location2);
        Entity scheduleD = this.createSchedule(location2);
        Entity view1 = this.schedulingFactory.createScheduleView(scheduleA, scheduleB);
        Entity view2 = this.schedulingFactory.createScheduleView(scheduleC);
        this.practiceFactory.updateLocation(location1).scheduleViews(view1).build();
        this.practiceFactory.updateLocation(location2).scheduleViews(view2).build();
        Assert.assertEquals((Object)view1, (Object)this.rules.getScheduleView(location1, scheduleA));
        Assert.assertEquals((Object)view1, (Object)this.rules.getScheduleView(location1, scheduleB));
        Assert.assertEquals((Object)view2, (Object)this.rules.getScheduleView(location2, scheduleC));
        Assert.assertNull((Object)this.rules.getScheduleView(location2, scheduleA));
        Assert.assertNull((Object)this.rules.getScheduleView(location2, scheduleB));
        Assert.assertNull((Object)this.rules.getScheduleView(location2, scheduleA));
        Assert.assertNull((Object)this.rules.getScheduleView(location1, scheduleD));
        Assert.assertNull((Object)this.rules.getScheduleView(location2, scheduleD));
    }

    @Test
    public void testGetLocation() {
        Party location1 = this.practiceFactory.createLocation();
        Entity scheduleA = this.createSchedule(location1);
        Assert.assertEquals((Object)location1, (Object)this.rules.getLocation(scheduleA));
    }

    @Test
    public void testIsRemindersEnabled() {
        Entity schedule = this.createSchedule(this.practiceFactory.createLocation());
        Assert.assertFalse((boolean)this.rules.isRemindersEnabled(schedule));
        this.schedulingFactory.updateSchedule(schedule).sendReminders(true).build();
        Assert.assertTrue((boolean)this.rules.isRemindersEnabled(schedule));
        Entity appointmentType = this.schedulingFactory.createAppointmentType();
        Assert.assertFalse((boolean)this.rules.isRemindersEnabled(appointmentType));
        this.schedulingFactory.updateAppointmentType(appointmentType).sendReminders(true).build();
        Assert.assertTrue((boolean)this.rules.isRemindersEnabled(appointmentType));
        Assert.assertFalse((boolean)this.rules.isRemindersEnabled(null));
    }

    @Test
    public void testGetNoReminderPeriod() {
        final Entity config = this.create("entity.jobAppointmentReminder", Entity.class);
        AppointmentRules rules = new AppointmentRules(this.getArchetypeService()){

            protected Entity getAppointmentReminderJob() {
                return config;
            }
        };
        Assert.assertEquals((Object)Period.days((int)2), (Object)rules.getNoReminderPeriod());
    }

    @Test
    public void testIsBoardingAppointment() {
        Entity appointmentType = this.createAppointmentType();
        Entity schedule = this.createSchedule(15, DateUnits.MINUTES, 2, appointmentType);
        Act appointment = this.createAppointment("2006-08-22 09:00", schedule, appointmentType);
        Assert.assertFalse((boolean)this.rules.isBoardingAppointment(appointment));
        this.schedulingFactory.updateSchedule(schedule).cageType(this.schedulingFactory.createCageType()).build();
        Assert.assertTrue((boolean)this.rules.isBoardingAppointment(appointment));
    }

    @Test
    public void testGetBoardingDays() {
        this.checkGetDays(1, "2016-03-23 10:00:00", "2016-03-23 17:00:00");
        this.checkGetDays(1, "2016-03-23 10:00:00", "2016-03-24 00:00:00");
        this.checkGetDays(2, "2016-03-23 10:00:00", "2016-03-24 09:00:00");
        this.checkGetDays(2, "2016-03-23 10:00:00", "2016-03-24 10:00:00");
        this.checkGetDays(2, "2016-03-23 10:00:00", "2016-03-24 17:00:00");
        this.checkGetDays(3, "2016-03-23 10:00:00", "2016-03-25 09:00:00");
        this.checkGetDays(3, "2016-03-23 10:00:00", "2016-03-25 10:00:00");
        this.checkGetDays(3, "2016-03-23 10:00:00", "2016-03-25 17:00:00");
        this.checkGetDays(0, "2016-03-23 10:00:00", "2016-03-20 17:00:00");
    }

    @Test
    public void testGetBoardingNights() {
        this.checkGetNights(1, "2016-03-23 10:00:00", "2016-03-23 17:00:00");
        this.checkGetNights(1, "2016-03-23 10:00:00", "2016-03-24 00:00:00");
        this.checkGetNights(1, "2016-03-23 10:00:00", "2016-03-24 09:00:00");
        this.checkGetNights(1, "2016-03-23 10:00:00", "2016-03-24 10:00:00");
        this.checkGetNights(1, "2016-03-23 10:00:00", "2016-03-24 17:00:00");
        this.checkGetNights(2, "2016-03-23 10:00:00", "2016-03-25 09:00:00");
        this.checkGetNights(2, "2016-03-23 10:00:00", "2016-03-25 10:00:00");
        this.checkGetNights(2, "2016-03-23 10:00:00", "2016-03-25 17:00:00");
        this.checkGetNights(0, "2016-03-23 10:00:00", "2016-03-20 17:00:00");
    }

    @Test
    public void testGetEvent() {
        Entity appointmentType = this.createAppointmentType();
        Entity schedule = this.createSchedule(15, DateUnits.MINUTES, 2, appointmentType);
        Act appointment = this.createAppointment("2006-08-22 09:00", schedule, appointmentType);
        Assert.assertNull((Object)this.rules.getEvent(appointment));
        IMObjectBean bean = this.getBean((IMObject)appointment);
        Act event = PatientTestHelper.createEvent((Party)bean.getTarget("patient", Party.class));
        this.schedulingFactory.updateAppointment(appointment).event(event).build();
        Assert.assertEquals((Object)event, (Object)this.rules.getEvent(appointment));
    }

    @Test
    public void testGetPendingAppointments() {
        Party customer1 = this.customerFactory.createCustomer();
        Party patient1a = this.patientFactory.createPatient(customer1);
        Party patient1b = this.patientFactory.createPatient(customer1);
        Party customer2 = this.customerFactory.createCustomer();
        Party patient2 = this.patientFactory.createPatient();
        Party location = this.practiceFactory.createLocation();
        Entity appointmentType = this.createAppointmentType();
        Entity schedule = this.createSchedule(location, appointmentType);
        Date now = new Date();
        Act act1a = this.createAppointment(DateRules.getDate((Date)now, (int)-1, (DateUnits)DateUnits.HOURS), schedule, appointmentType, customer1, patient1a);
        Act act1b = this.createAppointment(DateRules.getDate((Date)now, (int)6, (DateUnits)DateUnits.MONTHS), schedule, appointmentType, customer1, patient1b);
        Act act1c = this.createAppointment(DateRules.getDate((Date)now, (int)9, (DateUnits)DateUnits.MONTHS), schedule, appointmentType, customer1, null);
        Act act1d = this.createAppointment(DateRules.getDate((Date)now, (int)2, (DateUnits)DateUnits.YEARS), schedule, appointmentType, customer1, patient1a);
        Act act2a = this.createAppointment(DateRules.getDate((Date)now, (int)-1, (DateUnits)DateUnits.YEARS), schedule, appointmentType, customer2, patient2);
        Act act2b = this.createAppointment(DateRules.getDate((Date)now, (int)1, (DateUnits)DateUnits.MONTHS), schedule, appointmentType, customer2, patient2);
        Act act2c = this.createAppointment(DateRules.getDate((Date)now, (int)6, (DateUnits)DateUnits.MONTHS), schedule, appointmentType, customer2, patient2);
        Act act2d = this.createAppointment(DateRules.getDate((Date)now, (int)9, (DateUnits)DateUnits.MONTHS), schedule, appointmentType, customer2, patient2);
        act1b.setStatus("CONFIRMED");
        act2b.setStatus("CANCELLED");
        act2d.setStatus("NO_SHOW");
        this.save((IMObject[])new Act[]{act1b, act2b, act2d});
        Assert.assertTrue((act1a.getActivityStartTime().compareTo(now) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((act2a.getActivityStartTime().compareTo(now) < 0 ? 1 : 0) != 0);
        this.checkAppointments(this.rules.getPendingCustomerAppointments(customer1, 1, DateUnits.YEARS), act1b, act1c);
        this.checkAppointments(this.rules.getPendingPatientAppointments(patient1a, 3, DateUnits.YEARS), act1d);
        this.checkAppointments(this.rules.getPendingPatientAppointments(patient1b, 1, DateUnits.YEARS), act1b);
        this.checkAppointments(this.rules.getPendingCustomerAppointments(customer2, 1, DateUnits.YEARS), act2c);
    }

    @Test
    public void testGetNextPatientAppointment() {
        String[] statuses;
        Party customer1 = this.customerFactory.createCustomer();
        Party patient1 = this.patientFactory.createPatient(customer1);
        Party patient2 = this.patientFactory.createPatient(customer1);
        Party location = this.practiceFactory.createLocation();
        Entity appointmentType = this.createAppointmentType();
        Entity schedule = this.createSchedule(location, appointmentType);
        Date start1 = DateRules.getYesterday();
        Date start2 = DateRules.getToday();
        Date start3 = DateRules.getTomorrow();
        Date before1 = DateRules.getDate((Date)start1, (int)-1, (DateUnits)DateUnits.MINUTES);
        Date after1 = DateRules.getDate((Date)start1, (int)1, (DateUnits)DateUnits.MINUTES);
        Date after2 = DateRules.getDate((Date)start2, (int)1, (DateUnits)DateUnits.MINUTES);
        Date after3 = DateRules.getDate((Date)start3, (int)1, (DateUnits)DateUnits.MINUTES);
        Act act1 = this.createAppointment(start1, schedule, appointmentType, customer1, patient1);
        this.setStatus(act1, "CONFIRMED");
        Act act2 = this.createAppointment(start2, schedule, appointmentType, customer1, patient1);
        Act act3 = this.createAppointment(start3, schedule, appointmentType, customer1, patient1);
        Assert.assertEquals((Object)act1, (Object)this.rules.getNextPatientAppointment(patient1, before1));
        Assert.assertEquals((Object)act1, (Object)this.rules.getNextPatientAppointment(patient1, start1));
        Assert.assertEquals((Object)act2, (Object)this.rules.getNextPatientAppointment(patient1, after1));
        Assert.assertEquals((Object)act2, (Object)this.rules.getNextPatientAppointment(patient1, start2));
        Assert.assertEquals((Object)act3, (Object)this.rules.getNextPatientAppointment(patient1, after2));
        Assert.assertEquals((Object)act3, (Object)this.rules.getNextPatientAppointment(patient1, start3));
        Assert.assertNull((Object)this.rules.getNextPatientAppointment(patient1, after3));
        for (String status : statuses = new String[]{"CANCELLED", "CHECKED_IN", "ADMITTED", "IN_PROGRESS", "ADMITTED", "COMPLETED", "NO_SHOW"}) {
            this.setStatus(act1, status);
            Assert.assertEquals((Object)act2, (Object)this.rules.getNextPatientAppointment(patient1, before1));
            Assert.assertEquals((Object)act2, (Object)this.rules.getNextPatientAppointment(patient1, start1));
        }
        Assert.assertNull((Object)this.rules.getNextPatientAppointment(patient2, before1));
    }

    @Test
    public void testGetSlotTime() {
        Date date1 = TestHelper.getDatetime("2015-03-05 09:00:00");
        Assert.assertEquals((Object)date1, (Object)this.rules.getSlotTime(date1, 15, false));
        Assert.assertEquals((Object)date1, (Object)this.rules.getSlotTime(date1, 15, true));
        Date date2 = TestHelper.getDatetime("2015-03-05 09:05:00");
        Assert.assertEquals((Object)TestHelper.getDatetime("2015-03-05 09:00:00"), (Object)this.rules.getSlotTime(date2, 15, false));
        Assert.assertEquals((Object)TestHelper.getDatetime("2015-03-05 09:15:00"), (Object)this.rules.getSlotTime(date2, 15, true));
        Date date3 = TestHelper.getDatetime("2015-03-05 12:15:00");
        Assert.assertEquals((Object)TestHelper.getDatetime("2015-03-05 12:00:00"), (Object)this.rules.getSlotTime(date3, 30, false));
        Assert.assertEquals((Object)TestHelper.getDatetime("2015-03-05 12:30:00"), (Object)this.rules.getSlotTime(date3, 30, true));
        Date date4 = TestHelper.getDatetime("2019-10-06 01:00:00");
        Assert.assertEquals((Object)TestHelper.getDatetime("2019-10-06 00:00:00"), (Object)this.rules.getSlotTime(date4, 1440, false));
        Assert.assertEquals((Object)TestHelper.getDatetime("2019-10-07 00:00:00"), (Object)this.rules.getSlotTime(date4, 1440, true));
        Date date5 = TestHelper.getDatetime("2020-04-05 01:00:00");
        Assert.assertEquals((Object)TestHelper.getDatetime("2020-04-05 00:00:00"), (Object)this.rules.getSlotTime(date5, 1440, false));
        Assert.assertEquals((Object)TestHelper.getDatetime("2020-04-06 00:00:00"), (Object)this.rules.getSlotTime(date5, 1440, true));
    }

    @Test
    public void testGetOverlap() {
        Party location = this.practiceFactory.createLocation();
        Entity appointmentType = this.createAppointmentType();
        Entity schedule1 = (Entity)this.newSchedule(location, appointmentType).unlimitedDuration().build();
        this.checkGetOverlap(schedule1, appointmentType);
        Entity schedule2 = (Entity)this.newSchedule(location, appointmentType).maxDuration(6, DateUnits.HOURS).build();
        this.checkGetOverlap(schedule2, appointmentType);
    }

    @Test
    public void testGetAppointmentEventLongerThanDuration() {
        Entity appointmentType = this.createAppointmentType();
        Entity schedule = this.schedulingFactory.createSchedule(this.practiceFactory.createLocation());
        Date from = TestHelper.getDate("2022-11-24");
        Assert.assertNull((Object)this.rules.getAppointmentEventLongerThanDuration(schedule, from, 10, DateUnits.MINUTES));
        Act appointment1 = this.createAppointment("2022-11-24 09:00", "2022-11-24 09:30", schedule, appointmentType);
        Assert.assertEquals((Object)appointment1, (Object)this.rules.getAppointmentEventLongerThanDuration(schedule, from, 10, DateUnits.MINUTES));
        Act block1 = (Act)((TestCalendarBlockBuilder)((TestCalendarBlockBuilder)((TestCalendarBlockBuilder)this.schedulingFactory.newCalendarBlock().startTime("2022-11-24 09:00")).endTime("2022-11-24 11:00")).schedule(schedule)).type(this.schedulingFactory.createCalendarBlockType()).build();
        Assert.assertEquals((Object)block1, (Object)this.rules.getAppointmentEventLongerThanDuration(schedule, from, 1, DateUnits.HOURS));
        Assert.assertNull((Object)this.rules.getAppointmentEventLongerThanDuration(schedule, DateRules.getNextDate((Date)from), 1, DateUnits.HOURS));
        Act appointment2 = this.createAppointment("2022-11-25 09:00", "2022-11-27 09:00", schedule, appointmentType);
        Assert.assertEquals((Object)appointment2, (Object)this.rules.getAppointmentEventLongerThanDuration(schedule, from, 1, DateUnits.DAYS));
        Assert.assertEquals((Object)appointment2, (Object)this.rules.getAppointmentEventLongerThanDuration(schedule, TestHelper.getDatetime("2022-11-27 08:59"), 1, DateUnits.DAYS));
        Assert.assertNull((Object)this.rules.getAppointmentEventLongerThanDuration(schedule, appointment2.getActivityEndTime(), 1, DateUnits.DAYS));
        Act appointment3 = this.createAppointment("2022-11-25 09:00", "2022-11-28 09:00", schedule, appointmentType);
        Assert.assertEquals((Object)appointment3, (Object)this.rules.getAppointmentEventLongerThanDuration(schedule, from, 2, DateUnits.DAYS));
    }

    @Test
    public void testSendReminder() {
        Entity appointmentType = this.createAppointmentType();
        Entity schedule = this.schedulingFactory.createSchedule(this.practiceFactory.createLocation());
        Act appointment = this.createAppointment(DateRules.getTomorrow(), schedule, appointmentType);
        Assert.assertFalse((boolean)this.rules.sendReminder(appointment));
        this.schedulingFactory.updateAppointment(appointment).sendReminder(true).build();
        Assert.assertTrue((boolean)this.rules.sendReminder(appointment));
    }

    @Test
    public void testSMSReminderSent() {
        Entity appointmentType = this.createAppointmentType();
        Entity schedule = this.schedulingFactory.createSchedule(this.practiceFactory.createLocation());
        Act appointment = this.createAppointment(DateRules.getTomorrow(), schedule, appointmentType);
        IMObjectBean bean = this.getBean((IMObject)appointment);
        Assert.assertNull((Object)bean.getDate("reminderSent"));
        Assert.assertNull((Object)bean.getString("smsStatus"));
        bean.setValue("reminderError", (Object)"foo");
        Date date1 = DateRules.getToday();
        this.rules.setSMSReminderSent(appointment, date1);
        Assert.assertEquals((Object)date1, (Object)bean.getDate("reminderSent"));
        Assert.assertNull((Object)bean.getString("reminderError"));
        Assert.assertEquals((Object)"SENT", (Object)bean.getString("smsStatus"));
        bean.setValue("smsStatus", (Object)"RECEIVED");
        Date date2 = DateRules.getNextDate((Date)date1);
        this.rules.setSMSReminderSent(appointment, date2);
        Assert.assertEquals((Object)date2, (Object)bean.getDate("reminderSent"));
        Assert.assertNull((Object)bean.getString("reminderError"));
        Assert.assertEquals((Object)"RECEIVED", (Object)bean.getString("smsStatus"));
        bean.setValue("smsStatus", (Object)"READ");
        Date date3 = DateRules.getNextDate((Date)date2);
        this.rules.setSMSReminderSent(appointment, date3);
        Assert.assertEquals((Object)date3, (Object)bean.getDate("reminderSent"));
        Assert.assertNull((Object)bean.getString("reminderError"));
        Assert.assertEquals((Object)"SENT", (Object)bean.getString("smsStatus"));
    }

    private void checkActivePatientAppointment(Party patient, Act appointment, String newStatus, Act expected) {
        this.setStatus(appointment, newStatus);
        Assert.assertEquals((Object)expected, (Object)this.rules.getActivePatientAppointment(patient));
    }

    private void checkActiveCustomerAppointments(Party customer, Party location, Act exclude, Act ... expected) {
        List matches = IterableUtils.toList((Iterable)this.rules.getActiveCustomerAppointments(customer, location, exclude));
        Assert.assertEquals((Object)matches, Arrays.asList(expected));
    }

    private void checkGetOverlap(Entity schedule, Entity appointmentType) {
        Date start = TestHelper.getDatetime("2020-05-16 09:00");
        Date end = TestHelper.getDatetime("2020-05-16 09:30");
        Date before = TestHelper.getDatetime("2020-05-16 08:30");
        Date during = TestHelper.getDatetime("2020-05-16 09:15");
        Date after = TestHelper.getDatetime("2020-05-16 09:45");
        this.checkOverlap(start, end, schedule, null);
        Act appointment = this.createAppointment("2020-05-16 09:00", schedule, appointmentType);
        this.save((IMObject)appointment);
        this.checkOverlap(before, start, schedule, null);
        this.checkOverlap(end, after, schedule, null);
        this.checkOverlap(start, end, schedule, appointment);
        this.checkOverlap(start, during, schedule, appointment);
        this.checkOverlap(during, end, schedule, appointment);
        this.checkOverlap(before, during, schedule, appointment);
        this.checkOverlap(during, after, schedule, appointment);
        this.setStatus(appointment, "CANCELLED");
        this.checkOverlap(before, start, schedule, null);
        this.checkOverlap(end, after, schedule, null);
        this.checkOverlap(start, end, schedule, null);
        this.checkOverlap(start, during, schedule, null);
        this.checkOverlap(during, end, schedule, null);
        this.checkOverlap(before, during, schedule, null);
        this.checkOverlap(during, after, schedule, null);
    }

    private void setStatus(Act act, String status) {
        act.setStatus(status);
        this.save((IMObject)act);
    }

    private void checkOverlap(Date startTime, Date endTime, Entity schedule, Act overlap) {
        Times times = this.rules.getOverlap(startTime, endTime, schedule);
        if (overlap == null) {
            Assert.assertNull((Object)times);
        } else {
            Assert.assertEquals((Object)overlap.getActivityStartTime(), (Object)times.getStartTime());
            Assert.assertEquals((Object)overlap.getActivityEndTime(), (Object)times.getEndTime());
            Assert.assertEquals((Object)overlap.getObjectReference(), (Object)times.getReference());
        }
    }

    private void checkGetDays(int expected, String startTime, String endTime) {
        Date start = TestHelper.getDatetime(startTime);
        Date end = TestHelper.getDatetime(endTime);
        Assert.assertEquals((long)expected, (long)this.rules.getBoardingDays(start, end));
        Act appointment = (Act)((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime(start)).endTime(end)).build(false);
        Assert.assertEquals((long)expected, (long)this.rules.getBoardingDays(appointment));
    }

    private void checkGetNights(int expected, String startTime, String endTime) {
        Date start = TestHelper.getDatetime(startTime);
        Date end = TestHelper.getDatetime(endTime);
        Assert.assertEquals((long)expected, (long)this.rules.getBoardingNights(start, end));
    }

    private void checkAppointments(Iterable<Act> iterable, Act ... expected) {
        ArrayList result = new ArrayList();
        CollectionUtils.addAll(result, iterable);
        Assert.assertEquals((long)expected.length, (long)result.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], result.get(i));
        }
    }

    private Act createAppointment(String startTime, Entity schedule, Entity appointmentType) {
        return this.createAppointment(TestHelper.getDatetime(startTime), schedule, appointmentType);
    }

    private Act createAppointment(String startTime, String endTime, Entity schedule, Entity appointmentType) {
        return this.createAppointment(TestHelper.getDatetime(startTime), TestHelper.getDatetime(endTime), schedule, appointmentType);
    }

    private Act createAppointment(Date startTime, Entity schedule, Entity appointmentType) {
        return this.createAppointment(startTime, null, schedule, appointmentType);
    }

    private Act createAppointment(Date startTime, Date endTime, Entity schedule, Entity appointmentType) {
        return (Act)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime(startTime)).endTime(endTime)).schedule(schedule).appointmentType(appointmentType).customer(this.customerFactory.createCustomer())).patient(this.patientFactory.createPatient())).build();
    }

    private Act createAppointment(Date startTime, Entity schedule, Entity appointmentType, Party customer, Party patient) {
        return (Act)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime(startTime)).schedule(schedule).appointmentType(appointmentType).customer(customer)).patient(patient)).build();
    }

    private Act createTask() {
        Entity taskType = this.createTaskType();
        Party customer = this.customerFactory.createCustomer();
        Entity workList = this.schedulingFactory.createWorkList();
        return (Act)((TestTaskBuilder)((TestTaskBuilder)((TestTaskBuilder)((TestTaskBuilder)this.schedulingFactory.newTask().status("PENDING")).startTime(new Date())).endTime(new Date())).taskType(taskType).customer(customer)).workList(workList).build();
    }

    private Entity createAppointmentType() {
        return this.schedulingFactory.createAppointmentType();
    }

    private Entity createTaskType() {
        return this.schedulingFactory.createTaskType();
    }

    private Entity createSchedule(int slotSize, DateUnits slotUnits, int noSlots, Entity appointmentType) {
        return this.createSchedule(slotSize, slotUnits, noSlots, appointmentType, this.practiceFactory.createLocation());
    }

    private Entity createSchedule(int slotSize, DateUnits slotUnits, int noSlots, Entity appointmentType, Party location) {
        return (Entity)this.newSchedule(slotSize, slotUnits, noSlots, appointmentType, location).build();
    }

    private TestScheduleBuilder newSchedule(int slotSize, DateUnits slotUnits, int noSlots, Entity appointmentType, Party location) {
        return this.schedulingFactory.newSchedule().location(location).slotSize(slotSize, slotUnits).addAppointmentType(appointmentType, noSlots, true);
    }

    private Entity createSchedule(Party location) {
        return this.createSchedule(location, this.createAppointmentType());
    }

    private Entity createSchedule(Party location, Entity appointmentType) {
        return (Entity)this.newSchedule(location, appointmentType).build();
    }

    private TestScheduleBuilder newSchedule(Party location, Entity appointmentType) {
        return this.newSchedule(15, DateUnits.MINUTES, 2, appointmentType, location);
    }

    private void checkStatus(Act source, String status, Act linked, String expectedStatus) {
        source.setStatus(status);
        linked = this.get(linked);
        Date endTime = linked.getActivityEndTime();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.save((IMObject)source);
        linked = this.get(linked);
        Assert.assertNotNull((Object)linked);
        Assert.assertEquals((Object)expectedStatus, (Object)linked.getStatus());
        if (TypeHelper.isA((IMObject)linked, (String)"act.customerTask")) {
            if ("COMPLETED".equals(expectedStatus)) {
                Assert.assertTrue((linked.getActivityEndTime().compareTo(endTime) > 0 ? 1 : 0) != 0);
            } else {
                Assert.assertEquals((Object)endTime, (Object)linked.getActivityEndTime());
            }
        }
    }
}

