/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.AppointmentQuery;
import org.openvpms.archetype.rules.workflow.ScheduleArchetypes;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.scheduling.TestAppointmentBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestCalendarBlockBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.LookupHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.ObjectSet;
import org.springframework.beans.factory.annotation.Autowired;

public class AppointmentQueryTestCase
extends ArchetypeServiceTest {
    private Map<String, String> statusNames;
    private Map<String, String> reasonNames;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestLookupFactory lookupFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestSchedulingFactory schedulingFactory;
    @Autowired
    private TestUserFactory userFactory;

    @Before
    public void setUp() {
        IArchetypeService service = this.getArchetypeService();
        LookupService lookups = this.getLookupService();
        this.statusNames = LookupHelper.getNames((IArchetypeService)service, (LookupService)lookups, (String)"act.customerAppointment", (String)"status");
        this.reasonNames = LookupHelper.getNames((IArchetypeService)service, (LookupService)lookups, (String)"act.customerAppointment", (String)"reason");
    }

    @Test
    public void testQuery() {
        int count = 10;
        Entity schedule = this.schedulingFactory.createSchedule(this.practiceFactory.createLocation());
        Date from = DateUtils.truncate((Date)new Date(), (int)13);
        Act[] appointments = new Act[10];
        Date[] startTimes = new Date[10];
        Date[] endTimes = new Date[10];
        Date[] arrivalTimes = new Date[10];
        Party[] customers = new Party[10];
        Party[] patients = new Party[10];
        User[] clinicians = new User[10];
        Entity[] appointmentTypes = new Entity[10];
        for (int i = 0; i < 10; ++i) {
            Act appointment;
            Date startTime = new Date();
            Date arrivalTime = i % 2 == 0 ? new Date() : null;
            Date endTime = new Date();
            Party customer = this.customerFactory.createCustomer();
            Party patient = this.patientFactory.createPatient();
            User clinician = this.userFactory.createClinician();
            Entity appointmentType = this.schedulingFactory.createAppointmentType();
            Lookup reason = (Lookup)((TestLookupBuilder)this.lookupFactory.newLookup(ScheduleArchetypes.VISIT_REASON).uniqueCode("XREASON")).build();
            appointments[i] = appointment = (Act)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime(startTime)).endTime(endTime)).schedule(schedule).appointmentType(appointmentType).customer(customer)).patient(patient)).clinician(clinician)).arrivalTime(arrivalTime).reason(reason.getCode())).build();
            startTimes[i] = this.getTimestamp(startTime);
            arrivalTimes[i] = arrivalTime;
            endTimes[i] = this.getTimestamp(endTime);
            appointmentTypes[i] = appointmentType;
            customers[i] = customer;
            patients[i] = patient;
            clinicians[i] = clinician;
        }
        Date to = new Date();
        AppointmentQuery query = new AppointmentQuery(schedule, from, to, this.statusNames, this.reasonNames, this.getArchetypeService());
        IPage page = query.query();
        Assert.assertNotNull((Object)page);
        List results = page.getResults();
        Assert.assertEquals((long)10L, (long)results.size());
        for (int i = 0; i < results.size(); ++i) {
            ObjectSet set = (ObjectSet)results.get(i);
            Assert.assertEquals((Object)appointments[i].getObjectReference(), (Object)set.get("act.objectReference"));
            Assert.assertEquals((Object)startTimes[i], (Object)set.get("act.startTime"));
            Assert.assertEquals((Object)endTimes[i], (Object)set.get("act.endTime"));
            Assert.assertEquals((Object)appointments[i].getStatus(), (Object)set.get("act.status"));
            Assert.assertEquals((Object)appointments[i].getReason(), (Object)set.get("act.reason"));
            IMObjectBean bean = this.getBean((IMObject)appointments[i]);
            Assert.assertEquals((Object)bean.getString("notes"), (Object)set.get("notes"));
            Assert.assertEquals((Object)customers[i].getObjectReference(), (Object)set.get("customer.objectReference"));
            Assert.assertEquals((Object)customers[i].getName(), (Object)set.get("customer.name"));
            Assert.assertEquals((Object)patients[i].getObjectReference(), (Object)set.get("patient.objectReference"));
            Assert.assertEquals((Object)patients[i].getName(), (Object)set.get("patient.name"));
            Assert.assertEquals((Object)clinicians[i].getObjectReference(), (Object)set.get("clinician.objectReference"));
            Assert.assertEquals((Object)clinicians[i].getName(), (Object)set.get("clinician.name"));
            Assert.assertEquals((Object)schedule.getObjectReference(), (Object)set.get("schedule.objectReference"));
            Assert.assertEquals((Object)schedule.getName(), (Object)set.get("schedule.name"));
            Assert.assertEquals((Object)appointmentTypes[i].getObjectReference(), (Object)set.get("scheduleType.objectReference"));
            Assert.assertEquals((Object)appointmentTypes[i].getName(), (Object)set.get("scheduleType.name"));
            Assert.assertEquals((Object)arrivalTimes[i], (Object)set.get("arrivalTime"));
        }
    }

    @Test
    public void testDateRanges() {
        Party location = this.practiceFactory.createLocation();
        Entity schedule1 = (Entity)this.schedulingFactory.newSchedule().location(location).unlimitedDuration().build();
        Entity schedule2 = (Entity)this.schedulingFactory.newSchedule().location(location).unlimitedDuration().build();
        this.checkDateRanges(schedule1, schedule2);
    }

    @Test
    public void testDateRangesForSchedulesWithMaxDuration() {
        Party location = this.practiceFactory.createLocation();
        Entity schedule1 = (Entity)this.schedulingFactory.newSchedule().location(location).maxDuration(5, DateUnits.DAYS).build();
        Entity schedule2 = (Entity)this.schedulingFactory.newSchedule().location(location).maxDuration(5, DateUnits.DAYS).build();
        this.checkDateRanges(schedule1, schedule2);
    }

    @Test
    public void testMaxDurationMisconfiguration() {
        Entity schedule1 = (Entity)this.schedulingFactory.newSchedule().noMaxDuration().location(this.practiceFactory.createLocation()).build();
        Date from = TestHelper.getDate("2015-01-03");
        Date to = TestHelper.getDate("2015-01-04");
        this.createAppointment(schedule1, "2015-01-01 10:00:00", "2015-01-01 10:30:00");
        this.createBlock(schedule1, "2015-01-02 11:00:00", "2015-01-02 10:30:00");
        Act act0 = this.createAppointment(schedule1, "2015-01-01 10:30:00", "2015-01-04 12:30:00");
        Act act1 = this.createBlock(schedule1, "2015-01-02 22:00:00", "2015-01-04 02:00:00");
        Act act2 = this.createBlock(schedule1, "2015-01-02 10:00:00", "2015-01-03 11:00:00");
        Act act3 = this.createAppointment(schedule1, "2015-01-02 22:00:00", "2015-01-03 11:00:00");
        Act act4 = this.createBlock(schedule1, "2015-01-03 00:00:00", "2015-01-03 11:00:00");
        Act act5 = this.createAppointment(schedule1, "2015-01-03 00:00:00", "2015-01-04 00:00:00");
        Act act6 = this.createBlock(schedule1, "2015-01-03 11:00:00", "2015-01-03 12:00:00");
        Act act7 = this.createAppointment(schedule1, "2015-01-03 12:00:00", "2015-01-04 00:00:00");
        Act act8 = this.createBlock(schedule1, "2015-01-03 12:00:00", "2015-01-04 02:00:00");
        Act act9 = this.createAppointment(schedule1, "2015-01-03 13:00:00", "2015-01-04 03:00:00");
        this.createAppointment(schedule1, "2015-01-04 12:30:00", "2015-01-04 13:30:00");
        this.createBlock(schedule1, "2015-01-04 12:30:00", "2015-01-05 10:30:00");
        AppointmentQuery query1 = new AppointmentQuery(schedule1, from, to, this.statusNames, this.reasonNames, this.getArchetypeService());
        List events1 = query1.query().getResults();
        Assert.assertEquals((long)10L, (long)events1.size());
        Assert.assertEquals((Object)act0.getObjectReference(), (Object)((ObjectSet)events1.get(0)).get("act.objectReference"));
        Assert.assertEquals((Object)act1.getObjectReference(), (Object)((ObjectSet)events1.get(1)).get("act.objectReference"));
        Assert.assertEquals((Object)act2.getObjectReference(), (Object)((ObjectSet)events1.get(2)).get("act.objectReference"));
        Assert.assertEquals((Object)act3.getObjectReference(), (Object)((ObjectSet)events1.get(3)).get("act.objectReference"));
        Assert.assertEquals((Object)act4.getObjectReference(), (Object)((ObjectSet)events1.get(4)).get("act.objectReference"));
        Assert.assertEquals((Object)act5.getObjectReference(), (Object)((ObjectSet)events1.get(5)).get("act.objectReference"));
        Assert.assertEquals((Object)act6.getObjectReference(), (Object)((ObjectSet)events1.get(6)).get("act.objectReference"));
        Assert.assertEquals((Object)act7.getObjectReference(), (Object)((ObjectSet)events1.get(7)).get("act.objectReference"));
        Assert.assertEquals((Object)act8.getObjectReference(), (Object)((ObjectSet)events1.get(8)).get("act.objectReference"));
        Assert.assertEquals((Object)act9.getObjectReference(), (Object)((ObjectSet)events1.get(9)).get("act.objectReference"));
        this.schedulingFactory.updateSchedule(schedule1).maxDuration(2, DateUnits.HOURS).build();
        AppointmentQuery query2 = new AppointmentQuery(schedule1, from, to, this.statusNames, this.reasonNames, this.getArchetypeService());
        List events2 = query2.query().getResults();
        Assert.assertEquals((long)7L, (long)events2.size());
        Assert.assertEquals((Object)act1.getObjectReference(), (Object)((ObjectSet)events2.get(0)).get("act.objectReference"));
        Assert.assertEquals((Object)act3.getObjectReference(), (Object)((ObjectSet)events2.get(1)).get("act.objectReference"));
        Assert.assertEquals((Object)act4.getObjectReference(), (Object)((ObjectSet)events2.get(2)).get("act.objectReference"));
        Assert.assertEquals((Object)act5.getObjectReference(), (Object)((ObjectSet)events2.get(3)).get("act.objectReference"));
        Assert.assertEquals((Object)act6.getObjectReference(), (Object)((ObjectSet)events2.get(4)).get("act.objectReference"));
        Assert.assertEquals((Object)act7.getObjectReference(), (Object)((ObjectSet)events2.get(5)).get("act.objectReference"));
        Assert.assertEquals((Object)act8.getObjectReference(), (Object)((ObjectSet)events2.get(6)).get("act.objectReference"));
    }

    private void checkDateRanges(Entity schedule1, Entity schedule2) {
        Date from = TestHelper.getDatetime("2015-01-03 10:30:00");
        Date to = TestHelper.getDatetime("2015-01-03 12:30:00");
        this.createAppointment(schedule1, "2015-01-01 10:00:00", "2015-01-01 10:30:00");
        this.createBlock(schedule1, "2015-01-02 11:00:00", "2015-01-03 10:30:00");
        this.createAppointment(schedule1, "2015-01-03 10:00:00", "2015-01-03 10:30:00");
        Act act0 = this.createAppointment(schedule1, "2015-01-01 10:30:00", "2015-01-04 12:30:00");
        Act act1 = this.createBlock(schedule1, "2015-01-03 10:00:00", "2015-01-03 11:00:00");
        Act act2 = this.createAppointment(schedule1, "2015-01-03 10:30:00", "2015-01-03 11:00:00");
        Act act3 = this.createBlock(schedule1, "2015-01-03 10:30:00", "2015-01-03 12:30:00");
        Act act4 = this.createAppointment(schedule1, "2015-01-03 11:00:00", "2015-01-03 12:00:00");
        Act act5 = this.createBlock(schedule1, "2015-01-03 12:00:00", "2015-01-03 12:30:00");
        Act act6 = this.createAppointment(schedule1, "2015-01-03 12:00:00", "2015-01-03 13:00:00");
        this.createAppointment(schedule1, "2015-01-03 12:30:00", "2015-01-03 13:30:00");
        this.createBlock(schedule1, "2015-01-03 12:30:00", "2015-01-04 10:30:00");
        this.createAppointment(schedule1, "2015-01-04 10:00:00", "2015-01-04 10:30:00");
        this.createAppointment(schedule2, "2015-01-01 10:30:00", "2015-01-04 12:30:00");
        this.createBlock(schedule2, "2015-01-03 10:00:00", "2015-01-03 11:00:00");
        this.createAppointment(schedule2, "2015-01-03 10:30:00", "2015-01-03 11:00:00");
        AppointmentQuery query = new AppointmentQuery(schedule1, from, to, this.statusNames, this.reasonNames, this.getArchetypeService());
        IPage page = query.query();
        List appointments = page.getResults();
        Assert.assertEquals((long)7L, (long)appointments.size());
        Assert.assertEquals((Object)act0.getObjectReference(), (Object)((ObjectSet)appointments.get(0)).get("act.objectReference"));
        Assert.assertEquals((Object)act1.getObjectReference(), (Object)((ObjectSet)appointments.get(1)).get("act.objectReference"));
        Assert.assertEquals((Object)act2.getObjectReference(), (Object)((ObjectSet)appointments.get(2)).get("act.objectReference"));
        Assert.assertEquals((Object)act3.getObjectReference(), (Object)((ObjectSet)appointments.get(3)).get("act.objectReference"));
        Assert.assertEquals((Object)act4.getObjectReference(), (Object)((ObjectSet)appointments.get(4)).get("act.objectReference"));
        Assert.assertEquals((Object)act5.getObjectReference(), (Object)((ObjectSet)appointments.get(5)).get("act.objectReference"));
        Assert.assertEquals((Object)act6.getObjectReference(), (Object)((ObjectSet)appointments.get(6)).get("act.objectReference"));
    }

    private Date getTimestamp(Date timestamp) {
        return DateUtils.truncate((Date)new Date(timestamp.getTime()), (int)13);
    }

    private Act createAppointment(Entity schedule, String from, String to) {
        Party customer = this.customerFactory.createCustomer();
        Party patient = this.patientFactory.createPatient();
        return (Act)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime(from)).endTime(to)).schedule(schedule).appointmentType(this.schedulingFactory.createAppointmentType()).customer(customer)).patient(patient)).build();
    }

    private Act createBlock(Entity schedule, String from, String to) {
        return (Act)((TestCalendarBlockBuilder)((TestCalendarBlockBuilder)((TestCalendarBlockBuilder)this.schedulingFactory.newCalendarBlock().startTime(from)).endTime(to)).schedule(schedule)).type(this.schedulingFactory.createCalendarBlockType()).build();
    }
}

