/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.user;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.settings.AbstractSettingsTest;
import org.openvpms.archetype.rules.user.PasswordPolicy;
import org.openvpms.archetype.rules.user.PasswordPolicySettings;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;

public class PasswordPolicySettingsTestCase
extends AbstractSettingsTest {
    @Test
    public void testDefaults() {
        PasswordPolicySettings policy = new PasswordPolicySettings(this.getSettings());
        this.checkPolicy((PasswordPolicy)policy, 8, true, true, true, true);
    }

    @Test
    public void testUpdate() {
        PasswordPolicySettings policy = new PasswordPolicySettings(this.getSettings());
        Assert.assertEquals((long)8L, (long)policy.getMinLength());
        Assert.assertTrue((boolean)policy.lowercaseRequired());
        Assert.assertTrue((boolean)policy.specialRequired());
        Entity entity = this.getSingleton("entity.globalSettingsPassword");
        IMObjectBean bean = this.getBean((IMObject)entity);
        bean.setValue("minLength", (Object)6);
        bean.setValue("lowercase", (Object)false);
        bean.setValue("special", (Object)false);
        bean.save();
        this.checkPolicy((PasswordPolicy)policy, 6, false, true, true, false);
        bean.setValue("uppercase", (Object)false);
        bean.save();
        this.checkPolicy((PasswordPolicy)policy, 6, false, false, true, false);
        bean.setValue("number", (Object)false);
        bean.save();
        this.checkPolicy((PasswordPolicy)policy, 6, false, false, false, false);
    }

    private void checkPolicy(PasswordPolicy policy, int minLength, boolean lowercase, boolean uppercase, boolean number, boolean special) {
        Assert.assertEquals((long)minLength, (long)policy.getMinLength());
        Assert.assertEquals((long)100L, (long)policy.getMaxLength());
        Assert.assertEquals((Object)lowercase, (Object)policy.lowercaseRequired());
        Assert.assertEquals((Object)uppercase, (Object)policy.uppercaseRequired());
        Assert.assertEquals((Object)number, (Object)policy.numberRequired());
        Assert.assertEquals((Object)special, (Object)policy.specialRequired());
    }
}

