/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.supplier;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.supplier.AbstractSupplierTest;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;

public class SupplierActTestCase
extends AbstractSupplierTest {
    @Test
    public void testDeleteInvoice() {
        this.checkDelete("act.supplierAccountChargesInvoice", "act.supplierAccountInvoiceItem");
    }

    @Test
    public void testDeleteCredit() {
        this.checkDelete("act.supplierAccountChargesCredit", "act.supplierAccountCreditItem");
    }

    @Test
    public void testDeletePayment() {
        this.checkDelete("act.supplierAccountPayment", "act.supplierAccountPaymentCash");
    }

    @Test
    public void testDeleteRefund() {
        this.checkDelete("act.supplierAccountRefund", "act.supplierAccountRefundCash");
    }

    @Test
    public void testDeleteOrder() {
        this.checkDelete("act.supplierOrder", "act.supplierOrderItem");
    }

    @Test
    public void testDeleteDelivery() {
        this.checkDelete("act.supplierDelivery", "act.supplierDeliveryItem");
    }

    @Test
    public void testDeleteDeliveryLinkedToOrder() {
        Party supplier = this.getSupplier();
        Product product = this.getProduct();
        List<Act> order = this.createActs(supplier, product, "act.supplierOrder", "act.supplierOrderItem");
        List<Act> delivery = this.createActs(supplier, product, "act.supplierDelivery", "act.supplierDeliveryItem");
        Act deliveryItem = delivery.get(1);
        IMObjectBean deliveryItemBean = this.getBean((IMObject)deliveryItem);
        Act orderItem = order.get(1);
        deliveryItemBean.addTarget("order", (IMObject)orderItem, "deliveries");
        this.save((IMObject[])new Act[]{deliveryItem, orderItem});
        this.checkDelete(delivery);
        Assert.assertNotNull((Object)this.get((IMObject)order.get(0)));
        Assert.assertNotNull((Object)this.get(orderItem));
    }

    @Test
    public void testDeleteReturn() {
        this.checkDelete("act.supplierReturn", "act.supplierReturnItem");
    }

    @Test
    public void testDeleteReturnLinkedToOrder() {
        Party supplier = this.getSupplier();
        Product product = this.getProduct();
        List<Act> order = this.createActs(supplier, product, "act.supplierOrder", "act.supplierOrderItem");
        List<Act> supplierReturn = this.createActs(supplier, product, "act.supplierReturn", "act.supplierReturnItem");
        Act returnItem = supplierReturn.get(1);
        IMObjectBean returnItemBean = this.getBean((IMObject)returnItem);
        Act orderItem = order.get(1);
        returnItemBean.addTarget("order", (IMObject)orderItem, "return");
        this.save((IMObject[])new Act[]{returnItem, orderItem});
        this.checkDelete(supplierReturn);
        Assert.assertNotNull((Object)this.get((IMObject)order.get(0)));
        Assert.assertNotNull((Object)this.get(orderItem));
    }

    private void checkDelete(String shortName, String itemShortName) {
        List<Act> acts = this.createActs(this.getSupplier(), this.getProduct(), shortName, itemShortName);
        this.checkDelete(acts);
    }

    private void checkDelete(List<Act> acts) {
        Act parent = acts.get(0);
        Act child = acts.get(1);
        Assert.assertNotNull((Object)this.get(parent));
        Assert.assertNotNull((Object)this.get(child));
        this.remove((IMObject)parent);
        Assert.assertNull((Object)this.get(parent));
        Assert.assertNull((Object)this.get(child));
    }

    private List<Act> createActs(Party supplier, Product product, String shortName, String itemShortName) {
        IMObjectBean bean = this.createAct(shortName, supplier);
        Act act = (Act)bean.getObject();
        FinancialAct item = this.create(itemShortName, FinancialAct.class);
        IMObjectBean itemBean = this.getBean((IMObject)item);
        if (itemBean.hasNode("product")) {
            itemBean.setTarget("product", (IMObject)product);
        }
        item.setQuantity(BigDecimal.ONE);
        this.getArchetypeService().deriveValues((IMObject)item);
        ActRelationship relationship = (ActRelationship)bean.addTarget("items", (IMObject)item);
        item.addActRelationship(relationship);
        ArrayList<Act> acts = new ArrayList<Act>();
        acts.add(act);
        acts.add((Act)item);
        this.save(acts);
        return acts;
    }

    protected IMObjectBean createAct(String shortName, Party supplier) {
        return this.createAct(shortName, supplier, this.getStockLocation());
    }

    protected IMObjectBean createAct(String shortName, Party supplier, Party stockLocation) {
        Act act = this.create(shortName, Act.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("supplier", (IMObject)supplier);
        if (bean.hasNode("stockLocation")) {
            bean.setTarget("stockLocation", (IMObject)stockLocation);
        }
        return bean;
    }
}

