/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.supplier;

import java.math.BigDecimal;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.supplier.TestSupplierFactory;
import org.openvpms.archetype.test.builder.supplier.delivery.TestDeliveryBuilder;
import org.openvpms.archetype.test.builder.supplier.delivery.TestDeliveryItemBuilder;
import org.openvpms.archetype.test.builder.supplier.delivery.TestReturnBuilder;
import org.openvpms.archetype.test.builder.supplier.delivery.TestReturnItemBuilder;
import org.openvpms.archetype.test.builder.supplier.order.TestOrderBuilder;
import org.openvpms.archetype.test.builder.supplier.order.TestOrderItemBuilder;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSupplierTest
extends ArchetypeServiceTest {
    protected static final String PACKAGE_UNITS = "BOX";
    protected static final String PACKAGE_UNIT_CODE = "BX";
    @Autowired
    protected TestProductFactory productFactory;
    @Autowired
    protected TestLookupFactory lookupFactory;
    @Autowired
    protected TestPracticeFactory practiceFactory;
    @Autowired
    protected TestSupplierFactory supplierFactory;
    private Party supplier;
    private Party stockLocation;
    private Product product;
    private Party practice;
    private Party practiceLocation;

    @Before
    public void setUp() {
        this.product = this.productFactory.createMedication();
        this.stockLocation = this.createStockLocation();
        this.practiceLocation = (Party)this.practiceFactory.newLocation().stockLocation(this.stockLocation).build();
        this.practice = (Party)((TestPracticeBuilder)this.practiceFactory.newPractice().addAddress("1234 Broadwater Avenue", "CAPE_WOOLAMAI", "VIC", "3925", new String[0])).locations(this.practiceLocation).build();
        this.supplier = this.supplierFactory.createSupplier();
        this.lookupFactory.createUnitOfMeasure(PACKAGE_UNITS, PACKAGE_UNIT_CODE);
    }

    protected Party getSupplier() {
        return this.supplier;
    }

    protected Product getProduct() {
        return this.product;
    }

    protected Party getPractice() {
        return this.practice;
    }

    protected Party getPracticeLocation() {
        return this.practiceLocation;
    }

    protected Party getStockLocation() {
        return this.stockLocation;
    }

    protected FinancialAct createOrder(Party supplier, FinancialAct ... orderItems) {
        return this.createOrder(supplier, this.stockLocation, orderItems);
    }

    protected FinancialAct createOrder(Party supplier, Party stockLocation, FinancialAct ... orderItems) {
        TestOrderBuilder builder = this.newOrder(supplier, stockLocation, orderItems);
        return (FinancialAct)builder.build();
    }

    protected TestOrderBuilder newOrder(FinancialAct ... orderItems) {
        return this.newOrder(this.getSupplier(), this.getStockLocation(), orderItems);
    }

    protected TestOrderBuilder newOrder(Party supplier, Party stockLocation, FinancialAct ... orderItems) {
        TestOrderBuilder builder = (TestOrderBuilder)((TestOrderBuilder)this.supplierFactory.newOrder().supplier(supplier)).stockLocation(stockLocation);
        for (FinancialAct item : orderItems) {
            builder.add(item);
        }
        return builder;
    }

    protected FinancialAct createOrderItem(Product product, BigDecimal quantity, int packageSize, BigDecimal unitPrice) {
        return (FinancialAct)this.newOrderItem(product, quantity, packageSize, unitPrice).build();
    }

    protected FinancialAct createOrderItem(Product product, BigDecimal quantity, int packageSize, String packageUnits, BigDecimal unitPrice) {
        return (FinancialAct)this.newOrderItem(product, quantity, packageSize, packageUnits, unitPrice).build();
    }

    protected FinancialAct createDelivery(Party supplier, Product product, BigDecimal quantity, int packageSize, BigDecimal unitPrice) {
        return this.createDelivery(supplier, product, quantity, packageSize, unitPrice, BigDecimal.ZERO);
    }

    protected FinancialAct createDelivery(Party supplier, Product product, BigDecimal quantity, int packageSize, BigDecimal unitPrice, BigDecimal listPrice) {
        return (FinancialAct)((TestDeliveryBuilder)((TestDeliveryItemBuilder)((TestDeliveryItemBuilder)((TestDeliveryItemBuilder)((TestDeliveryItemBuilder)((TestDeliveryItemBuilder)((TestDeliveryItemBuilder)((TestDeliveryBuilder)((TestDeliveryBuilder)this.supplierFactory.newDelivery().supplier(supplier)).stockLocation(this.stockLocation)).item().product(product)).quantity(quantity)).packageSize(packageSize)).packageUnits(PACKAGE_UNITS)).unitPrice(unitPrice)).listPrice(listPrice)).add()).supplierNotes("Some notes").build();
    }

    protected FinancialAct createDelivery(Party supplier, Product product, BigDecimal quantity, int packageSize, BigDecimal unitPrice, FinancialAct orderItem) {
        FinancialAct item = this.createDeliveryItem(product, quantity, packageSize, unitPrice, orderItem);
        return this.createDelivery(supplier, item);
    }

    protected FinancialAct createDelivery(Party supplier, FinancialAct ... deliveryItems) {
        TestDeliveryBuilder builder = (TestDeliveryBuilder)((TestDeliveryBuilder)this.supplierFactory.newDelivery().supplier(supplier)).stockLocation(this.stockLocation);
        for (FinancialAct item : deliveryItems) {
            builder.add(item);
        }
        return (FinancialAct)builder.build();
    }

    protected FinancialAct createDeliveryItem(Product product, BigDecimal quantity, int packageSize, BigDecimal unitPrice, FinancialAct orderItem) {
        return (FinancialAct)((TestDeliveryItemBuilder)((TestDeliveryItemBuilder)((TestDeliveryItemBuilder)((TestDeliveryItemBuilder)((TestDeliveryItemBuilder)this.supplierFactory.newDeliveryItem().product(product)).quantity(quantity)).packageSize(packageSize)).packageUnits(PACKAGE_UNITS)).unitPrice(unitPrice)).order(orderItem).build(false);
    }

    protected FinancialAct createReturn(Party supplier, Product product, BigDecimal quantity, int packageSize, BigDecimal unitPrice) {
        return this.createReturn(supplier, product, quantity, packageSize, unitPrice, BigDecimal.ZERO);
    }

    protected FinancialAct createReturn(Party supplier, Product product, BigDecimal quantity, int packageSize, BigDecimal unitPrice, BigDecimal listPrice) {
        return (FinancialAct)((TestReturnBuilder)((TestReturnItemBuilder)((TestReturnItemBuilder)((TestReturnItemBuilder)((TestReturnItemBuilder)((TestReturnItemBuilder)((TestReturnItemBuilder)((TestReturnBuilder)((TestReturnBuilder)this.supplierFactory.newReturn().supplier(supplier)).stockLocation(this.stockLocation)).item().product(product)).quantity(quantity)).packageSize(packageSize)).packageUnits(PACKAGE_UNITS)).unitPrice(unitPrice)).listPrice(listPrice)).add()).build();
    }

    protected FinancialAct createReturn(Party supplier, Product product, BigDecimal quantity, int packageSize, BigDecimal unitPrice, FinancialAct orderItem) {
        return (FinancialAct)((TestReturnBuilder)((TestReturnItemBuilder)((TestReturnItemBuilder)((TestReturnItemBuilder)((TestReturnItemBuilder)((TestReturnItemBuilder)((TestReturnBuilder)((TestReturnBuilder)this.supplierFactory.newReturn().supplier(supplier)).stockLocation(this.stockLocation)).item().product(product)).quantity(quantity)).packageSize(packageSize)).packageUnits(PACKAGE_UNITS)).unitPrice(unitPrice)).order(orderItem).add()).build();
    }

    protected Party createStockLocation() {
        return this.practiceFactory.createStockLocation(new Party[0]);
    }

    protected void checkProductStockLocationRelationship(Product product, BigDecimal quantity) {
        product = this.get(product);
        IMObjectBean bean = this.getBean((IMObject)product);
        List values = bean.getValues("stockLocations", Relationship.class, Predicates.targetEquals((IMObject)this.stockLocation));
        if (quantity == null) {
            Assert.assertTrue((boolean)values.isEmpty());
        } else {
            Assert.assertEquals((long)1L, (long)values.size());
            IMObjectBean relBean = this.getBean((IMObject)values.get(0));
            this.checkEquals(quantity, relBean.getBigDecimal("quantity"));
        }
    }

    protected TestOrderItemBuilder newOrderItem(Product product, BigDecimal quantity, int packageSize, BigDecimal unitPrice) {
        return this.newOrderItem(product, quantity, packageSize, PACKAGE_UNITS, unitPrice);
    }

    protected TestOrderItemBuilder newOrderItem(Product product, BigDecimal quantity, int packageSize, String packageUnits, BigDecimal unitPrice) {
        return (TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)this.supplierFactory.newOrderItem().product(product)).quantity(quantity)).packageSize(packageSize)).packageUnits(packageUnits)).unitPrice(unitPrice)).listPrice(BigDecimal.ZERO);
    }
}

