/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.stock.io;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.product.ProductTestHelper;
import org.openvpms.archetype.rules.stock.io.StockCSVWriter;
import org.openvpms.archetype.rules.stock.io.StockData;
import org.openvpms.archetype.rules.stock.io.StockDataImporter;
import org.openvpms.archetype.rules.stock.io.StockDataSet;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;

public class StockDataImporterTestCase
extends ArchetypeServiceTest {
    private DocumentHandlers handlers;
    private StockDataImporter importer;

    @Before
    public void setUp() {
        this.handlers = new DocumentHandlers((ArchetypeService)this.getArchetypeService());
        this.importer = new StockDataImporter(this.getArchetypeService(), this.handlers, ',');
    }

    @Test
    public void testLoad() {
        Party location = ProductTestHelper.createStockLocation();
        Product product1 = TestHelper.createProduct();
        Product product2 = TestHelper.createProduct();
        Product product3 = TestHelper.createProduct();
        Product product4 = TestHelper.createProduct();
        StockData data1 = this.createStockData(location, product1, "Mls", BigDecimal.ONE, BigDecimal.TEN);
        StockData data2 = this.createStockData(location, product2, "Each", BigDecimal.ONE, BigDecimal.ONE);
        StockData data3 = this.createStockData(location, product3, "Packet", new BigDecimal("-10"), BigDecimal.ZERO);
        StockData data4 = this.createStockData(location, product4, "Unit", new BigDecimal("-10"), new BigDecimal("-5"));
        Document document = this.createCSV(Arrays.asList(data1, data2, data3, data4));
        StockDataSet set = this.importer.load((org.openvpms.component.model.document.Document)document, "A note");
        Assert.assertEquals((long)3L, (long)set.getData().size());
        Assert.assertEquals((long)0L, (long)set.getErrors().size());
        Assert.assertNotNull((Object)set.getAdjustment());
        IMObjectBean bean = this.getBean((IMObject)set.getAdjustment());
        Assert.assertEquals((Object)"A note", (Object)set.getAdjustment().getReason());
        List items = bean.getTargets("items", Act.class);
        Assert.assertEquals((long)3L, (long)items.size());
        this.checkItem(items, product1, new BigDecimal("9"));
        this.checkItem(items, product3, BigDecimal.TEN);
        this.checkItem(items, product4, new BigDecimal("5"));
    }

    @Test
    public void testNoChanges() {
        Party location = ProductTestHelper.createStockLocation();
        Product product = TestHelper.createProduct();
        StockData data = this.createStockData(location, product, "Mls", BigDecimal.ONE, BigDecimal.ONE);
        Document document = this.createCSV(Collections.singletonList(data));
        StockDataSet set = this.importer.load((org.openvpms.component.model.document.Document)document, "A note");
        Assert.assertEquals((long)0L, (long)set.getErrors().size());
        Assert.assertEquals((long)0L, (long)set.getData().size());
        Assert.assertNull((Object)set.getAdjustment());
    }

    @Test
    public void testMultipleStockLocations() {
        Party location1 = ProductTestHelper.createStockLocation();
        Party location2 = ProductTestHelper.createStockLocation();
        Product product = TestHelper.createProduct();
        StockData data1 = this.createStockData(location1, product, "Mls", BigDecimal.ONE, BigDecimal.TEN);
        StockData data2 = this.createStockData(location2, product, "Mls", BigDecimal.ONE, BigDecimal.TEN);
        Document document = this.createCSV(Arrays.asList(data1, data2));
        StockDataSet set = this.importer.load((org.openvpms.component.model.document.Document)document, "A note");
        Assert.assertEquals((long)1L, (long)set.getErrors().size());
        Assert.assertEquals((Object)("Expected " + location1.getId() + " for Stock Location Identifier but got " + location2.getId()), (Object)((StockData)set.getErrors().get(0)).getError());
        Assert.assertEquals((long)1L, (long)set.getData().size());
        Assert.assertNull((Object)set.getAdjustment());
    }

    @Test
    public void testMissingLocation() {
        Party location = ProductTestHelper.createStockLocation();
        Product product = TestHelper.createProduct();
        StockData data = this.createStockData(location, product, "Mls", BigDecimal.ONE, BigDecimal.TEN);
        this.remove((IMObject)location);
        Document document = this.createCSV(Collections.singletonList(data));
        StockDataSet set = this.importer.load((org.openvpms.component.model.document.Document)document, "A note");
        Assert.assertEquals((long)1L, (long)set.getErrors().size());
        Assert.assertEquals((Object)"Stock location not found", (Object)((StockData)set.getErrors().get(0)).getError());
        Assert.assertEquals((long)0L, (long)set.getData().size());
        Assert.assertNull((Object)set.getAdjustment());
    }

    @Test
    public void testDifferentStockLocationName() {
        Party location = ProductTestHelper.createStockLocation();
        location.setName("Old name");
        StockData data = this.createStockData(location, TestHelper.createProduct(), "Mls", BigDecimal.ONE, BigDecimal.TEN);
        location.setName("New name");
        this.save((IMObject)location);
        Document document = this.createCSV(Collections.singletonList(data));
        StockDataSet set = this.importer.load((org.openvpms.component.model.document.Document)document, "A note");
        Assert.assertEquals((long)1L, (long)set.getErrors().size());
        Assert.assertEquals((Object)"Expected 'New name' but got 'Old name'", (Object)((StockData)set.getErrors().get(0)).getError());
        Assert.assertEquals((long)0L, (long)set.getData().size());
        Assert.assertNull((Object)set.getAdjustment());
    }

    @Test
    public void testMissingProduct() {
        Party location = ProductTestHelper.createStockLocation();
        Product product = TestHelper.createProduct();
        StockData data = this.createStockData(location, product, "Mls", BigDecimal.ONE, BigDecimal.TEN);
        this.remove((IMObject)product);
        Document document = this.createCSV(Collections.singletonList(data));
        StockDataSet set = this.importer.load((org.openvpms.component.model.document.Document)document, "A note");
        Assert.assertEquals((long)1L, (long)set.getErrors().size());
        Assert.assertEquals((Object)"Product not found", (Object)((StockData)set.getErrors().get(0)).getError());
        Assert.assertEquals((long)0L, (long)set.getData().size());
        Assert.assertNull((Object)set.getAdjustment());
    }

    @Test
    public void testDifferentProductName() {
        Party location = ProductTestHelper.createStockLocation();
        Product product = TestHelper.createProduct();
        product.setName("Old name");
        this.save((IMObject)product);
        StockData data = this.createStockData(location, product, "Mls", BigDecimal.ONE, BigDecimal.TEN);
        product.setName("New name");
        this.save((IMObject)product);
        Document document = this.createCSV(Collections.singletonList(data));
        StockDataSet set = this.importer.load((org.openvpms.component.model.document.Document)document, "A note");
        Assert.assertEquals((long)1L, (long)set.getErrors().size());
        Assert.assertEquals((Object)"Expected 'New name' but got 'Old name'", (Object)((StockData)set.getErrors().get(0)).getError());
        Assert.assertEquals((long)0L, (long)set.getData().size());
        Assert.assertNull((Object)set.getAdjustment());
    }

    @Test
    public void testMissingProductForSameQuantities() {
        Party location = ProductTestHelper.createStockLocation();
        Product product = TestHelper.createProduct();
        StockData data = this.createStockData(location, product, "Mls", BigDecimal.ONE, BigDecimal.ONE);
        this.remove((IMObject)product);
        Document document = this.createCSV(Collections.singletonList(data));
        StockDataSet set = this.importer.load((org.openvpms.component.model.document.Document)document, "A note");
        Assert.assertEquals((long)1L, (long)set.getErrors().size());
        Assert.assertEquals((Object)"Product not found", (Object)((StockData)set.getErrors().get(0)).getError());
        Assert.assertEquals((long)0L, (long)set.getData().size());
        Assert.assertNull((Object)set.getAdjustment());
    }

    private Document createCSV(List<StockData> data) {
        StockCSVWriter writer = new StockCSVWriter(this.handlers, ',');
        return writer.write("test.csv", data.iterator());
    }

    private void checkItem(List<Act> acts, Product product, BigDecimal quantity) {
        for (Act act : acts) {
            IMObjectBean bean = this.getBean((IMObject)act);
            if (!product.getObjectReference().equals((Object)bean.getTargetRef("product"))) continue;
            this.checkEquals(quantity, bean.getBigDecimal("quantity"));
            return;
        }
        Assert.fail((String)"Product not found");
    }

    private StockData createStockData(Party stockLocation, Product product, String sellingUnits, BigDecimal quantity, BigDecimal newQuantity) {
        return new StockData(stockLocation.getId(), stockLocation.getName(), product.getId(), product.getName(), sellingUnits, quantity, newQuantity);
    }
}

