/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product.io;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.io.AbstractProductIOTest;
import org.openvpms.archetype.rules.product.io.PriceData;
import org.openvpms.archetype.rules.product.io.ProductData;
import org.openvpms.archetype.rules.product.io.ProductDataComparator;
import org.openvpms.archetype.rules.product.io.ProductIOException;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.archetype.test.builder.product.TestFixedPriceBuilder;
import org.openvpms.archetype.test.builder.product.TestPriceTemplateProductBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.service.archetype.ArchetypeService;

public class ProductDataComparatorTestCase
extends AbstractProductIOTest {
    private Product product;
    private ProductPrice fixed1;
    private ProductPrice unit1;
    private ProductDataComparator comparator;

    @Before
    public void setUp() {
        ProductPriceRules rules = new ProductPriceRules((ArchetypeService)this.getArchetypeService());
        this.comparator = new ProductDataComparator(rules, (ArchetypeService)this.getArchetypeService());
        this.product = this.createProduct("Product 1", "P1", new ProductPrice[0]);
        this.fixed1 = this.createFixedPrice("1.0", "0.5", "100", "10", "2013-02-01", "2013-04-01", true);
        this.unit1 = this.createUnitPrice("1.92", "1.2", "60", "10", "2013-02-02", "2013-04-02");
        this.product.addProductPrice(this.fixed1);
        this.product.addProductPrice(this.unit1);
        this.save((IMObject)this.product);
    }

    @Test
    public void testCompareNoChanges() {
        ProductData data = this.createProduct(this.product);
        Assert.assertNull((Object)this.comparator.compare(this.product, data));
    }

    @Test
    public void testComparePrintedNameChange() {
        ProductData data = this.createProduct(this.product);
        data.setPrintedName("Foo");
        ProductData changed = this.comparator.compare(this.product, data);
        Assert.assertNotNull((Object)changed);
        Assert.assertEquals((Object)data.getName(), (Object)changed.getName());
        Assert.assertEquals((Object)this.product.getObjectReference(), (Object)changed.getReference());
        Assert.assertEquals((Object)"Foo", (Object)changed.getPrintedName());
        Assert.assertEquals((long)0L, (long)changed.getFixedPrices().size());
        Assert.assertEquals((long)0L, (long)changed.getUnitPrices().size());
    }

    @Test
    public void testFixedPriceCostChange() {
        ProductData data = this.createProduct(this.product);
        ((PriceData)data.getFixedPrices().get(0)).setCost(BigDecimal.ONE);
        PriceData fixedPrice = this.checkFixedPriceChange(data);
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)fixedPrice.getCost());
    }

    @Test
    public void testFixedPriceChange() {
        ProductData data = this.createProduct(this.product);
        ((PriceData)data.getFixedPrices().get(0)).setPrice(BigDecimal.TEN);
        PriceData fixedPrice = this.checkFixedPriceChange(data);
        Assert.assertEquals((Object)BigDecimal.TEN, (Object)fixedPrice.getPrice());
    }

    @Test
    public void testFixedPriceFromDateChange() {
        ProductData data = this.createProduct(this.product);
        Date date = TestHelper.getDate("2013-03-01");
        ((PriceData)data.getFixedPrices().get(0)).setFrom(date);
        PriceData fixedPrice = this.checkFixedPriceChange(data);
        Assert.assertEquals((Object)date, (Object)fixedPrice.getFrom());
    }

    @Test
    public void testFixedPriceToDateChange() {
        ProductData data = this.createProduct(this.product);
        Date date = TestHelper.getDate("2013-12-01");
        ((PriceData)data.getFixedPrices().get(0)).setTo(date);
        PriceData fixedPrice = this.checkFixedPriceChange(data);
        Assert.assertEquals((Object)date, (Object)fixedPrice.getTo());
    }

    @Test
    public void testFixedPriceOverlap() {
        this.checkFixedPriceOverlap("2012-01-01", null);
        this.checkFixedPriceOverlap("2012-01-01", "2013-02-02");
        this.checkFixedPriceOverlap("2013-02-03", "2013-02-04");
        this.checkFixedPriceOverlap("2013-03-31", null);
    }

    @Test
    public void testUnitPriceCostChange() {
        ProductData data = this.createProduct(this.product);
        ((PriceData)data.getUnitPrices().get(0)).setCost(BigDecimal.ONE);
        PriceData unitPrice = this.checkUnitPriceChange(data);
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)unitPrice.getCost());
    }

    @Test
    public void testUnitPriceChange() {
        ProductData data = this.createProduct(this.product);
        ((PriceData)data.getUnitPrices().get(0)).setPrice(BigDecimal.TEN);
        PriceData unitPrice = this.checkUnitPriceChange(data);
        Assert.assertEquals((Object)BigDecimal.TEN, (Object)unitPrice.getPrice());
    }

    @Test
    public void testUnitPriceFromDateChange() {
        ProductData data = this.createProduct(this.product);
        Date date = TestHelper.getDate("2013-03-01");
        ((PriceData)data.getUnitPrices().get(0)).setFrom(date);
        PriceData unitPrice = this.checkUnitPriceChange(data);
        Assert.assertEquals((Object)date, (Object)unitPrice.getFrom());
    }

    @Test
    public void testUnitPriceToDateChange() {
        ProductData data = this.createProduct(this.product);
        Date date = TestHelper.getDate("2013-12-01");
        ((PriceData)data.getUnitPrices().get(0)).setTo(date);
        PriceData unitPrice = this.checkUnitPriceChange(data);
        Assert.assertEquals((Object)date, (Object)unitPrice.getTo());
    }

    @Test
    public void testAddOverlappingUnitPrice() {
        this.checkUnitPriceOverlap("2012-01-01", null);
        this.checkUnitPriceOverlap("2012-01-01", "2013-02-03");
        this.checkUnitPriceOverlap("2013-02-03", "2013-02-04");
        this.checkUnitPriceOverlap("2013-04-01", null);
    }

    @Test
    public void testAddUnitPriceWithNoStartDate() {
        ProductData data = this.createProduct(this.product);
        Set locations = Collections.emptySet();
        data.addUnitPrice(-1L, new BigDecimal("1.0"), new BigDecimal("0.5"), BigDecimal.TEN, null, null, locations, 1);
        try {
            this.comparator.compare(this.product, data);
            Assert.fail((String)"Expected ProductIOException");
        }
        catch (ProductIOException exception) {
            Assert.assertEquals((Object)"A price start date is required", (Object)exception.getMessage());
        }
    }

    @Test
    public void testAddFixedPriceWithNoStartDate() {
        ProductData data = this.createProduct(this.product);
        Set groups = Collections.emptySet();
        data.addFixedPrice(-1L, new BigDecimal("1.0"), new BigDecimal("0.5"), BigDecimal.TEN, null, null, true, groups, 1);
        try {
            this.comparator.compare(this.product, data);
            Assert.fail((String)"Expected ProductIOException");
        }
        catch (ProductIOException exception) {
            Assert.assertEquals((Object)"A price start date is required", (Object)exception.getMessage());
        }
    }

    @Test
    public void testAddUnitPriceBeforeExisting() {
        ProductData data = this.createProduct(this.product);
        BigDecimal unitCost = new BigDecimal("0.5");
        BigDecimal unitPrice = new BigDecimal("1.0");
        Date from = TestHelper.getDate("2012-01-01");
        Date to = TestHelper.getDate("2013-02-02");
        Set<Lookup> groups = Collections.emptySet();
        data.addUnitPrice(-1L, unitPrice, unitCost, BigDecimal.TEN, from, to, groups, 1);
        PriceData changed = this.checkUnitPriceChange(data);
        this.checkPrice(changed, unitCost, unitPrice, BigDecimal.TEN, from, to, groups);
    }

    @Test
    public void testAddUnitPriceAfterExisting() {
        ProductData data = this.createProduct(this.product);
        BigDecimal unitCost = new BigDecimal("0.5");
        BigDecimal unitPrice = new BigDecimal("1.0");
        Date from = TestHelper.getDate("2013-04-02");
        Date to = TestHelper.getDate("2013-06-01");
        Set<Lookup> groups = Collections.emptySet();
        data.addUnitPrice(-1L, unitPrice, unitCost, BigDecimal.TEN, from, to, groups, 1);
        PriceData changed = this.checkUnitPriceChange(data);
        this.checkPrice(changed, unitCost, unitPrice, BigDecimal.TEN, from, to, groups);
    }

    @Test
    public void testAddNewUnitPriceWithSameDates() {
        ProductData data = this.createProduct(this.product);
        BigDecimal unitCost = new BigDecimal("0.5");
        BigDecimal unitPrice = new BigDecimal("1.0");
        Set groups = Collections.emptySet();
        data.addUnitPrice(-1L, unitPrice, unitCost, BigDecimal.TEN, this.unit1.getFromDate(), this.unit1.getToDate(), groups, 1);
        try {
            this.comparator.compare(this.product, data);
            Assert.fail((String)"Expected ProductIOException to be thrown");
        }
        catch (ProductIOException expected) {
            Assert.assertEquals((Object)"Duplicate unit price", (Object)expected.getMessage());
        }
    }

    @Test
    public void testCloseExistingFixedPrice() {
        this.fixed1.setToDate(null);
        this.save((IMObject)this.product);
        ProductData data = this.createProduct(this.product);
        BigDecimal fixedCost = new BigDecimal("1.5");
        BigDecimal fixedPrice = new BigDecimal("2.0");
        Date from = TestHelper.getDate("2013-04-02");
        Date to = TestHelper.getDate("2013-06-01");
        Set<Lookup> groups = Collections.emptySet();
        data.addFixedPrice(-1L, fixedPrice, fixedCost, BigDecimal.TEN, from, to, true, groups, 1);
        ProductData changed = this.comparator.compare(this.product, data);
        Assert.assertNotNull((Object)changed);
        Assert.assertEquals((long)2L, (long)changed.getFixedPrices().size());
        this.checkPrice((PriceData)changed.getFixedPrices().get(0), new BigDecimal("0.5"), this.fixed1.getPrice(), BigDecimal.TEN, this.fixed1.getFromDate(), from, groups);
        this.checkPrice((PriceData)changed.getFixedPrices().get(1), fixedCost, fixedPrice, BigDecimal.TEN, from, to, groups);
    }

    @Test
    public void testCloseExistingUnitPrice() {
        this.unit1.setToDate(null);
        this.save((IMObject)this.product);
        ProductData data = this.createProduct(this.product);
        BigDecimal unitCost = new BigDecimal("0.5");
        BigDecimal unitPrice = new BigDecimal("1.0");
        Date from = TestHelper.getDate("2013-04-02");
        Date to = TestHelper.getDate("2013-06-01");
        Set<Lookup> groups = Collections.emptySet();
        data.addUnitPrice(-1L, unitPrice, unitCost, BigDecimal.TEN, from, to, groups, 1);
        ProductData changed = this.comparator.compare(this.product, data);
        Assert.assertNotNull((Object)changed);
        Assert.assertEquals((long)2L, (long)changed.getUnitPrices().size());
        this.checkPrice((PriceData)changed.getUnitPrices().get(0), new BigDecimal("1.2"), this.unit1.getPrice(), BigDecimal.TEN, this.unit1.getFromDate(), from, groups);
        this.checkPrice((PriceData)changed.getUnitPrices().get(1), unitCost, unitPrice, BigDecimal.TEN, from, to, groups);
    }

    @Test
    public void testUpdateLinkedPrice() {
        ProductPrice linkedFixedPrice = ((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(1)).dateRange("2014-01-01", null)).defaultPrice(true).build();
        Product template = (Product)((TestPriceTemplateProductBuilder)this.productFactory.newPriceTemplate().addPrice(linkedFixedPrice)).build();
        this.product.getProductPrices().remove(this.fixed1);
        ((AbstractTestIMObjectBuilder)this.productFactory.updateProduct(this.product).addPriceTemplate(template, new Date(), null)).build();
        ProductData data = this.createProduct(this.product);
        Assert.assertEquals((long)1L, (long)data.getFixedPrices().size());
        PriceData fixedPrice = (PriceData)data.getFixedPrices().get(0);
        Assert.assertEquals((long)linkedFixedPrice.getId(), (long)fixedPrice.getId());
        fixedPrice.setFrom(TestHelper.getDate("2014-02-01"));
        try {
            this.comparator.compare(this.product, data);
            Assert.fail((String)"Expected ProductIOException to be thrown");
        }
        catch (ProductIOException exception) {
            Assert.assertEquals((Object)"Cannot update linked price", (Object)exception.getMessage());
        }
    }

    @Test
    public void testFixedPriceMaxDiscountChange() {
        ProductData data = this.createProduct(this.product);
        BigDecimal maxDiscount = new BigDecimal("17.5");
        ((PriceData)data.getFixedPrices().get(0)).setMaxDiscount(maxDiscount);
        PriceData fixedPrice = this.checkFixedPriceChange(data);
        this.checkEquals(maxDiscount, fixedPrice.getMaxDiscount());
    }

    @Test
    public void testUnitPriceMaxDiscountChange() {
        ProductData data = this.createProduct(this.product);
        BigDecimal maxDiscount = new BigDecimal("17.5");
        ((PriceData)data.getUnitPrices().get(0)).setMaxDiscount(maxDiscount);
        PriceData unitPrice = this.checkUnitPriceChange(data);
        this.checkEquals(maxDiscount, unitPrice.getMaxDiscount());
    }

    @Test
    public void testAddPricingGroupsToFixedPrice() {
        Lookup groupA = this.productFactory.createPricingGroup("A");
        Lookup groupB = this.productFactory.createPricingGroup("B");
        ProductData data = this.createProduct(this.product);
        Set<Lookup> groups = this.getSet(groupA, groupB);
        ((PriceData)data.getFixedPrices().get(0)).setPricingGroups(groups);
        PriceData fixedPrice = this.checkFixedPriceChange(data);
        Assert.assertEquals(groups, (Object)fixedPrice.getPricingGroups());
    }

    @Test
    public void testAddPricingGroupsToUnitPrice() {
        Lookup groupA = this.productFactory.createPricingGroup("A");
        Lookup groupB = this.productFactory.createPricingGroup("B");
        ProductData data = this.createProduct(this.product);
        Set<Lookup> groups = this.getSet(groupA, groupB);
        ((PriceData)data.getUnitPrices().get(0)).setPricingGroups(groups);
        PriceData unitPrice = this.checkUnitPriceChange(data);
        Assert.assertEquals(groups, (Object)unitPrice.getPricingGroups());
    }

    @Test
    public void testDeleteFixedPricePricingGroups() {
        Lookup groupA = this.productFactory.createPricingGroup("A");
        Lookup groupB = this.productFactory.createPricingGroup("B");
        this.fixed1.addClassification(groupA);
        this.fixed1.addClassification(groupB);
        ProductData data = this.createProduct(this.product);
        Set groups = Collections.emptySet();
        ((PriceData)data.getFixedPrices().get(0)).setPricingGroups(groups);
        PriceData fixedPrice = this.checkFixedPriceChange(data);
        Assert.assertEquals(groups, (Object)fixedPrice.getPricingGroups());
    }

    @Test
    public void testDeleteUnitPricePricingGroups() {
        Lookup groupA = this.productFactory.createPricingGroup("A");
        Lookup groupB = this.productFactory.createPricingGroup("B");
        this.unit1.addClassification(groupA);
        this.unit1.addClassification(groupB);
        ProductData data = this.createProduct(this.product);
        Set groups = Collections.emptySet();
        ((PriceData)data.getUnitPrices().get(0)).setPricingGroups(groups);
        PriceData unitPrice = this.checkUnitPriceChange(data);
        Assert.assertEquals(groups, (Object)unitPrice.getPricingGroups());
    }

    @Test
    public void testAddUnitPriceWithDifferentPricingGroup() {
        Lookup groupA = this.productFactory.createPricingGroup("A");
        ProductData data = this.createProduct(this.product);
        Set<Lookup> groups = this.getSet(groupA);
        BigDecimal unitPrice = new BigDecimal("1.0");
        BigDecimal unitCost = new BigDecimal("0.5");
        data.addUnitPrice(-1L, unitPrice, unitCost, BigDecimal.TEN, this.unit1.getFromDate(), this.unit1.getToDate(), groups, 1);
        PriceData changed = this.checkUnitPriceChange(data);
        this.checkPrice(changed, unitCost, unitPrice, BigDecimal.TEN, this.unit1.getFromDate(), this.unit1.getToDate(), groups);
    }

    @Test
    public void testUnitPriceSwapPriceGroups() {
        Lookup groupA = this.productFactory.createPricingGroup("A");
        Lookup groupB = this.productFactory.createPricingGroup("B");
        ProductPrice unit2 = this.createUnitPrice("2.55", "1.5", "70", "10", "2013-02-02", "2013-04-02");
        this.unit1.addClassification(groupA);
        unit2.addClassification(groupB);
        this.product.addProductPrice(unit2);
        this.save((IMObject)this.product);
        ProductData data = this.createProduct(this.product);
        PriceData unitPrice1 = this.getPrice(data.getUnitPrices(), this.unit1.getId());
        PriceData unitPrice2 = this.getPrice(data.getUnitPrices(), unit2.getId());
        unitPrice1.setPricingGroups(this.getSet(groupB));
        unitPrice2.setPricingGroups(this.getSet(groupA));
        ProductData changed = this.comparator.compare(this.product, data);
        Assert.assertNotNull((Object)changed);
        Assert.assertEquals((long)2L, (long)changed.getUnitPrices().size());
        unitPrice1 = this.getPrice(changed.getUnitPrices(), this.unit1.getId());
        unitPrice2 = this.getPrice(changed.getUnitPrices(), unit2.getId());
        Date fromDate = this.unit1.getFromDate();
        Date toDate = this.unit1.getToDate();
        this.checkPrice(unitPrice1, new BigDecimal("1.2"), this.unit1.getPrice(), BigDecimal.TEN, fromDate, toDate, this.getSet(groupB));
        this.checkPrice(unitPrice2, new BigDecimal("1.5"), unit2.getPrice(), BigDecimal.TEN, fromDate, toDate, this.getSet(groupA));
    }

    @Test
    public void testMissingCostAndMaxDiscount() {
        IMObjectBean bean = this.getBean((IMObject)this.fixed1);
        bean.setValue("cost", null);
        bean.setValue("maxDiscount", null);
        ProductData data = this.createProduct(this.product);
        PriceData price = this.getPrice(data.getFixedPrices(), this.fixed1.getId());
        this.checkEquals(BigDecimal.ZERO, price.getCost());
        this.checkEquals(BigDecimal.ZERO, price.getMaxDiscount());
        ProductData changed = this.comparator.compare(this.product, data);
        Assert.assertNull((Object)changed);
    }

    private PriceData getPrice(List<PriceData> prices, long id) {
        PriceData result = null;
        for (PriceData price : prices) {
            if (price.getId() != id) continue;
            result = price;
            break;
        }
        if (result == null) {
            Assert.fail((String)("Price with id=" + id + " not found"));
        }
        return result;
    }

    private Set<Lookup> getSet(Lookup ... lookups) {
        return new HashSet<Lookup>(Arrays.asList(lookups));
    }

    private void checkFixedPriceOverlap(String from, String to) {
        ProductData data = this.createProduct(this.product);
        BigDecimal unitCost = new BigDecimal("0.5");
        BigDecimal unitPrice = new BigDecimal("1.0");
        Date fromDate = TestHelper.getDate(from);
        Date toDate = TestHelper.getDate(to);
        Set locations = Collections.emptySet();
        data.addFixedPrice(-1L, unitPrice, unitCost, BigDecimal.TEN, fromDate, toDate, true, locations, 1);
        PriceData changed = this.checkFixedPriceChange(data);
        Assert.assertEquals((Object)fromDate, (Object)changed.getFrom());
        Assert.assertEquals((Object)toDate, (Object)changed.getTo());
    }

    private void checkUnitPriceOverlap(String from, String to) {
        ProductData data = this.createProduct(this.product);
        BigDecimal unitCost = new BigDecimal("0.5");
        BigDecimal unitPrice = new BigDecimal("1.0");
        Set locations = Collections.emptySet();
        data.addUnitPrice(-1L, unitPrice, unitCost, BigDecimal.TEN, TestHelper.getDate(from), TestHelper.getDate(to), locations, 1);
        try {
            this.comparator.compare(this.product, data);
            Assert.fail((String)"Expected ProductIOException");
        }
        catch (ProductIOException exception) {
            Assert.assertEquals((Object)"Unit price dates overlap an existing unit price", (Object)exception.getMessage());
        }
    }

    private void checkPrice(PriceData data, BigDecimal expectedCost, BigDecimal expectedPrice, BigDecimal expectedMaxDiscount, Date expectedFrom, Date expectedTo, Set<Lookup> expectedGroups) {
        this.checkEquals(expectedCost, data.getCost());
        this.checkEquals(expectedPrice, data.getPrice());
        this.checkEquals(expectedMaxDiscount, data.getMaxDiscount());
        Assert.assertEquals((Object)expectedFrom, (Object)data.getFrom());
        Assert.assertEquals((Object)expectedTo, (Object)data.getTo());
        Assert.assertEquals(expectedGroups, (Object)data.getPricingGroups());
    }

    private PriceData checkUnitPriceChange(ProductData data) {
        ProductData changed = this.comparator.compare(this.product, data);
        Assert.assertNotNull((Object)changed);
        Assert.assertEquals((long)0L, (long)changed.getFixedPrices().size());
        Assert.assertEquals((long)1L, (long)changed.getUnitPrices().size());
        return (PriceData)changed.getUnitPrices().get(0);
    }

    private PriceData checkFixedPriceChange(ProductData data) {
        ProductData changed = this.comparator.compare(this.product, data);
        Assert.assertNotNull((Object)changed);
        Assert.assertEquals((long)0L, (long)changed.getUnitPrices().size());
        Assert.assertEquals((long)1L, (long)changed.getFixedPrices().size());
        return (PriceData)changed.getFixedPrices().get(0);
    }
}

