/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.product.AbstractProductTest;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.ProductPriceTestHelper;
import org.openvpms.archetype.rules.product.ProductPriceUpdater;
import org.openvpms.archetype.rules.product.ProductRules;
import org.openvpms.archetype.rules.product.ProductSupplier;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.springframework.beans.factory.annotation.Autowired;

public class ProductPriceUpdaterTestCase
extends AbstractProductTest {
    @Autowired
    private PracticeRules practiceRules;
    @Autowired
    private ProductPriceRules priceRules;
    private ProductPriceUpdater updater;
    private static final String PACKAGE_UNITS = "BOX";

    @Before
    public void setUp() {
        TestHelper.getPractice();
        TestHelper.getLookup("lookup.uom", PACKAGE_UNITS);
        this.updater = new ProductPriceUpdater(this.priceRules, this.practiceRules, this.getArchetypeService());
    }

    @Test
    public void testUpdateForMedication() {
        Product product = TestHelper.createProduct("product.medication", null);
        this.checkUpdate(product);
    }

    @Test
    public void testUpdateForMerchandise() {
        Product product = TestHelper.createProduct("product.merchandise", null);
        this.checkUpdate(product);
    }

    @Test
    public void testCustomUnitPrice() {
        Product product = TestHelper.createProduct("product.medication", null);
        Party supplier = TestHelper.createSupplier();
        ProductPrice price1 = this.addUnitPrice(product, BigDecimal.ONE, BigDecimal.ZERO);
        Date now = new Date();
        int packageSize = 30;
        this.addProductSupplier(product, supplier, packageSize, "10.00", "20.00", true);
        this.updater.update(product);
        this.save((IMObject)product);
        Date toDate1 = ProductPriceTestHelper.checkToDateSet(price1, now);
        product = this.get(product);
        Assert.assertEquals((long)2L, (long)product.getProductPrices().size());
        ProductPriceTestHelper.checkPrice(product.getProductPrices(), BigDecimal.ONE, BigDecimal.ZERO, price1.getFromDate(), toDate1);
        ProductPrice price2 = ProductPriceTestHelper.checkPrice(product.getProductPrices(), new BigDecimal("1.34"), new BigDecimal("0.67"), toDate1, null);
        price2.setPrice(new BigDecimal("1.35"));
        this.updater.update(product);
        this.save((IMObject)product);
        product = this.get(product);
        Assert.assertEquals((long)2L, (long)product.getProductPrices().size());
        ProductPriceTestHelper.checkPrice(product.getProductPrices(), BigDecimal.ONE, BigDecimal.ZERO, price1.getFromDate(), toDate1);
        ProductPriceTestHelper.checkPrice(product.getProductPrices(), new BigDecimal("1.35"), new BigDecimal("0.67"), toDate1, null);
    }

    @Test
    public void testUpdateWithPriceHistory() {
        BigDecimal cost = BigDecimal.ONE;
        BigDecimal markup = BigDecimal.valueOf(100L);
        BigDecimal price = BigDecimal.valueOf(2L);
        BigDecimal maxDiscount = BigDecimal.valueOf(100L);
        Product product = TestHelper.createProduct("product.medication", null);
        Party supplier = TestHelper.createSupplier();
        ProductPrice unit1 = ProductPriceTestHelper.createUnitPrice(price, cost, markup, maxDiscount, null, DateRules.getYesterday());
        ProductPrice unit2 = ProductPriceTestHelper.createUnitPrice(price, cost, markup, maxDiscount, DateRules.getToday(), null);
        ProductPrice unit3 = ProductPriceTestHelper.createUnitPrice(price, cost, markup, maxDiscount, (Date)null, null);
        ProductPrice unit4 = ProductPriceTestHelper.createUnitPrice(price, cost, markup, maxDiscount, DateRules.getTomorrow(), null);
        product.addProductPrice(unit1);
        product.addProductPrice(unit2);
        product.addProductPrice(unit3);
        product.addProductPrice(unit4);
        int packageSize = 30;
        ProductRules rules = new ProductRules(this.getArchetypeService(), this.getLookupService());
        ProductSupplier ps = rules.createProductSupplier(product, supplier);
        ps.setPackageUnits(PACKAGE_UNITS);
        ps.setPackageSize(packageSize);
        ps.setAutoPriceUpdate(true);
        ps.setNettPrice(new BigDecimal("10.00"));
        ps.setListPrice(new BigDecimal("20.00"));
        this.updater.update(product);
        BigDecimal newCost = new BigDecimal("0.67");
        BigDecimal newPrice = new BigDecimal("1.34");
        ProductPriceTestHelper.checkPrice(unit1, price, cost);
        ProductPriceTestHelper.checkPrice(unit2, newPrice, newCost);
        ProductPriceTestHelper.checkPrice(unit3, newPrice, newCost);
        ProductPriceTestHelper.checkPrice(unit4, price, cost);
    }

    @Test
    public void testPricingGroups() {
        Product product = TestHelper.createProduct("product.medication", null);
        ProductPrice price1 = this.addUnitPrice(product, "1", "100", "2", "GROUP1");
        ProductPrice price2 = this.addUnitPrice(product, "1", "200", "3", "GROUP2");
        ProductPrice price3 = this.addUnitPrice(product, "1", "300", "4", null);
        ProductPrice price4 = this.addUnitPrice(product, "1", "400", "5", null);
        price4.setToDate(DateRules.getYesterday());
        Party supplier = TestHelper.createSupplier();
        int packageSize = 30;
        this.addProductSupplier(product, supplier, packageSize, "10.00", "20.00", true);
        this.updater.update(product);
        this.save((IMObject)product);
        price1 = this.get(price1);
        price2 = this.get(price2);
        price3 = this.get(price3);
        price4 = this.get(price4);
        ProductPriceTestHelper.checkPrice(price1, new BigDecimal("1.34"), new BigDecimal("0.67"));
        ProductPriceTestHelper.checkPrice(price2, new BigDecimal("2.01"), new BigDecimal("0.67"));
        ProductPriceTestHelper.checkPrice(price3, new BigDecimal("2.68"), new BigDecimal("0.67"));
        ProductPriceTestHelper.checkPrice(price4, new BigDecimal("5"), new BigDecimal("1"));
    }

    @Test
    public void testMinPrice() {
        Product product1 = TestHelper.createProduct("product.medication", null);
        Product product2 = TestHelper.createProduct("product.medication", null);
        ProductPrice price1 = this.addUnitPrice(product1, BigDecimal.ONE, BigDecimal.ZERO);
        ProductPrice price2 = this.addUnitPrice(product2, BigDecimal.ONE, BigDecimal.ZERO);
        this.save((IMObject)product1);
        this.save((IMObject)product2);
        Date now1 = new Date();
        Party supplier = TestHelper.createSupplier();
        this.addProductSupplier(product1, supplier, 30, "10.00", "20.00", true);
        this.updater.update(product1);
        this.save((IMObject)product1);
        product1 = this.get(product1);
        Date toDate1 = ProductPriceTestHelper.checkToDateSet(price1, now1);
        ProductPriceTestHelper.checkPrice(product1.getProductPrices(), BigDecimal.ONE, BigDecimal.ZERO, MathRules.ONE_HUNDRED, MathRules.ONE_HUNDRED, price1.getFromDate(), toDate1, null);
        ProductPriceTestHelper.checkPrice(product1.getProductPrices(), new BigDecimal("1.34"), new BigDecimal("0.67"), MathRules.ONE_HUNDRED, MathRules.ONE_HUNDRED, toDate1, null, null);
        Lookup lookup = TestHelper.getCurrency("AUD");
        IMObjectBean bean = this.getBean((IMObject)lookup);
        bean.setValue("minPrice", (Object)new BigDecimal("0.20"));
        bean.save();
        Date now2 = new Date();
        this.addProductSupplier(product2, supplier, 30, "12.00", "22.00", true);
        this.updater.update(product2);
        this.save((IMObject)product2);
        product2 = this.get(product2);
        Date toDate2 = ProductPriceTestHelper.checkToDateSet(price2, now2);
        ProductPriceTestHelper.checkPrice(product2.getProductPrices(), BigDecimal.ONE, BigDecimal.ZERO, MathRules.ONE_HUNDRED, MathRules.ONE_HUNDRED, price2.getFromDate(), toDate2, null);
        ProductPriceTestHelper.checkPrice(product2.getProductPrices(), new BigDecimal("1.46"), new BigDecimal("0.73"), MathRules.ONE_HUNDRED, MathRules.ONE_HUNDRED, toDate2, null, null);
    }

    @Test
    public void testSaveProductSupplierWithNullListPrice() {
        BigDecimal cost = BigDecimal.ONE;
        BigDecimal markup = BigDecimal.valueOf(100L);
        BigDecimal price = BigDecimal.valueOf(2L);
        BigDecimal maxDiscount = BigDecimal.valueOf(100L);
        Product product = TestHelper.createProduct("product.medication", null);
        Party supplier = TestHelper.createSupplier();
        Date unit1ToDate = DateRules.getYesterday();
        Date unit2FromDate = DateRules.getToday();
        Date unit3FromDate = DateRules.getTomorrow();
        ProductPrice unit1 = ProductPriceTestHelper.createUnitPrice(price, cost, markup, maxDiscount, null, unit1ToDate);
        ProductPrice unit2 = ProductPriceTestHelper.createUnitPrice(price, cost, markup, maxDiscount, unit2FromDate, null);
        ProductPrice unit3 = ProductPriceTestHelper.createUnitPrice(price, cost, markup, maxDiscount, unit3FromDate, null);
        product.addProductPrice(unit1);
        product.addProductPrice(unit2);
        product.addProductPrice(unit3);
        int packageSize = 30;
        ProductRules rules = new ProductRules(this.getArchetypeService(), this.getLookupService());
        ProductSupplier ps = rules.createProductSupplier(product, supplier);
        ps.setPackageUnits(PACKAGE_UNITS);
        ps.setPackageSize(packageSize);
        ps.setAutoPriceUpdate(true);
        ps.setNettPrice(new BigDecimal("10.00"));
        ps.setListPrice(new BigDecimal("20.00"));
        this.updater.update(product);
        this.save((IMObject)product);
        product = this.get(product);
        BigDecimal newCost1 = new BigDecimal("0.67");
        BigDecimal newPrice1 = new BigDecimal("1.34");
        Assert.assertEquals((long)3L, (long)product.getProductPrices().size());
        ProductPriceTestHelper.checkPrice(product.getProductPrices(), price, cost, null, unit1ToDate);
        ProductPriceTestHelper.checkPrice(product.getProductPrices(), newPrice1, newCost1, unit2FromDate, null);
        ProductPriceTestHelper.checkPrice(product.getProductPrices(), price, cost, unit3FromDate, null);
        ps = this.getProductSupplier(product, ps);
        ps.setListPrice(null);
        this.updater.update(product);
        this.save((IMObject)product);
        product = this.get(product);
        Assert.assertEquals((long)3L, (long)product.getProductPrices().size());
        ProductPriceTestHelper.checkPrice(product.getProductPrices(), price, cost, null, unit1ToDate);
        ProductPriceTestHelper.checkPrice(product.getProductPrices(), newPrice1, newCost1, unit2FromDate, null);
        ProductPriceTestHelper.checkPrice(product.getProductPrices(), price, cost, unit3FromDate, null);
        Date now = new Date();
        ps = this.getProductSupplier(product, ps);
        ps.setListPrice(new BigDecimal("22.00"));
        this.updater.update(product);
        this.save((IMObject)product);
        BigDecimal newCost2 = new BigDecimal("0.73");
        BigDecimal newPrice2 = new BigDecimal("1.46");
        product = this.get(product);
        Assert.assertEquals((long)4L, (long)product.getProductPrices().size());
        Date unit2ToDate = ProductPriceTestHelper.checkToDateSet(this.get(unit2), now);
        ProductPriceTestHelper.checkPrice(product.getProductPrices(), price, cost, null, unit1ToDate);
        ProductPriceTestHelper.checkPrice(product.getProductPrices(), newPrice1, newCost1, unit2FromDate, unit2ToDate);
        ProductPriceTestHelper.checkPrice(product.getProductPrices(), price, cost, unit3FromDate, null);
        ProductPriceTestHelper.checkPrice(product.getProductPrices(), newPrice2, newCost2, unit2ToDate, null);
    }

    @Test
    public void testUpdateForProductSupplier() {
        Product product = TestHelper.createProduct();
        Party supplier1 = TestHelper.createSupplier();
        Party supplier2 = TestHelper.createSupplier();
        BigDecimal initialCost = BigDecimal.ZERO;
        BigDecimal initialPrice = BigDecimal.ONE;
        ProductPrice price = this.addUnitPrice(product, initialPrice, initialCost);
        ProductSupplier ps1 = this.addProductSupplier(product, supplier1);
        ps1.setAutoPriceUpdate(true);
        ps1.setPackageSize(10);
        ps1.setListPrice(new BigDecimal("15.00"));
        int packageSize = 30;
        ProductSupplier ps2 = this.addProductSupplier(product, supplier2);
        ps2.setPackageSize(packageSize);
        Assert.assertFalse((boolean)ps2.isAutoPriceUpdate());
        this.updater.update(product, ps2, true);
        Assert.assertEquals((long)1L, (long)product.getProductPrices().size());
        this.checkPrice(product, initialCost, initialPrice);
        Date now = new Date();
        ps2.setListPrice(new BigDecimal("20.00"));
        ps2.setAutoPriceUpdate(true);
        this.updater.update(product, ps2, true);
        Date toDate = ProductPriceTestHelper.checkToDateSet(price, now);
        this.save((IMObject)product);
        product = this.get(product);
        Assert.assertEquals((long)2L, (long)product.getProductPrices().size());
        ProductPriceTestHelper.checkPrice(product.getProductPrices(), BigDecimal.ONE, BigDecimal.ZERO, price.getFromDate(), toDate);
        ProductPriceTestHelper.checkPrice(product.getProductPrices(), new BigDecimal("1.34"), new BigDecimal("0.67"), toDate, null);
        supplier2.setActive(false);
        this.save((IMObject)supplier2);
        ps2.setNettPrice(new BigDecimal("15.00"));
        ps2.setListPrice(new BigDecimal("30.00"));
        this.updater.update(product, ps2, true);
        product = this.get(product);
        Assert.assertEquals((long)2L, (long)product.getProductPrices().size());
        ProductPriceTestHelper.checkPrice(product.getProductPrices(), BigDecimal.ONE, BigDecimal.ZERO, price.getFromDate(), toDate);
        ProductPriceTestHelper.checkPrice(product.getProductPrices(), new BigDecimal("1.34"), new BigDecimal("0.67"), toDate, null);
    }

    private ProductSupplier getProductSupplier(Product product, ProductSupplier existing) {
        IMObjectBean bean = this.getBean((IMObject)product);
        Relationship result = (Relationship)bean.getValue("suppliers", Relationship.class, relationship -> existing.getRelationship().equals(relationship));
        Assert.assertNotNull((Object)result);
        return new ProductSupplier(result, this.getArchetypeService());
    }

    private ProductPrice addUnitPrice(Product product, String cost, String markup, String price, String pricingGroup) {
        ProductPrice unit = ProductPriceTestHelper.createUnitPrice(new BigDecimal(price), new BigDecimal(cost), new BigDecimal(markup), BigDecimal.valueOf(100L), (Date)null, null);
        if (pricingGroup != null) {
            unit.addClassification(ProductPriceTestHelper.getPricingGroup(pricingGroup));
        }
        product.addProductPrice(unit);
        return unit;
    }

    private void checkUpdate(Product product) {
        Party supplier = TestHelper.createSupplier();
        BigDecimal initialCost = BigDecimal.ZERO;
        BigDecimal initialPrice = BigDecimal.ONE;
        ProductPrice price = this.addUnitPrice(product, initialPrice, initialCost);
        int packageSize = 30;
        ProductSupplier ps = this.addProductSupplier(product, supplier);
        ps.setPackageSize(packageSize);
        Assert.assertFalse((boolean)ps.isAutoPriceUpdate());
        this.updater.update(product);
        Assert.assertEquals((long)1L, (long)product.getProductPrices().size());
        this.checkPrice(product, initialCost, initialPrice);
        Date now = new Date();
        ps.setNettPrice(new BigDecimal("10.00"));
        ps.setListPrice(new BigDecimal("20.00"));
        ps.setAutoPriceUpdate(true);
        this.updater.update(product);
        Date toDate = ProductPriceTestHelper.checkToDateSet(price, now);
        this.save((IMObject)product);
        product = this.get(product);
        Assert.assertEquals((long)2L, (long)product.getProductPrices().size());
        ProductPriceTestHelper.checkPrice(product.getProductPrices(), BigDecimal.ONE, BigDecimal.ZERO, price.getFromDate(), toDate);
        ProductPriceTestHelper.checkPrice(product.getProductPrices(), new BigDecimal("1.34"), new BigDecimal("0.67"), toDate, null);
        supplier = this.get(supplier);
        supplier.setActive(false);
        this.save((IMObject)supplier);
        ps.setNettPrice(new BigDecimal("15.00"));
        ps.setListPrice(new BigDecimal("30.00"));
        this.updater.update(product);
        this.save((IMObject)product);
        product = this.get(product);
        Assert.assertEquals((long)2L, (long)product.getProductPrices().size());
        ProductPriceTestHelper.checkPrice(product.getProductPrices(), BigDecimal.ONE, BigDecimal.ZERO, price.getFromDate(), toDate);
        ProductPriceTestHelper.checkPrice(product.getProductPrices(), new BigDecimal("1.34"), new BigDecimal("0.67"), toDate, null);
    }

    private void checkPrice(Product product, BigDecimal cost, BigDecimal price) {
        product = this.get(product);
        Set prices = product.getProductPrices();
        Assert.assertEquals((long)1L, (long)prices.size());
        ProductPrice p = prices.toArray(new ProductPrice[0])[0];
        IMObjectBean bean = this.getBean((IMObject)p);
        this.checkEquals(cost, bean.getBigDecimal("cost"));
        this.checkEquals(price, bean.getBigDecimal("price"));
    }

    private ProductSupplier addProductSupplier(Product product, Party supplier) {
        ProductRules rules = new ProductRules(this.getArchetypeService(), this.getLookupService());
        ProductSupplier ps = rules.createProductSupplier(product, supplier);
        ps.setPackageUnits(PACKAGE_UNITS);
        return ps;
    }

    private ProductSupplier addProductSupplier(Product product, Party supplier, int packageSize, String nettPrice, String listPrice, boolean autoPriceUpdate) {
        ProductSupplier result = this.addProductSupplier(product, supplier);
        result.setPackageSize(packageSize);
        result.setNettPrice(new BigDecimal(nettPrice));
        result.setListPrice(new BigDecimal(listPrice));
        result.setAutoPriceUpdate(autoPriceUpdate);
        return result;
    }
}

