/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.helper.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;

public class ProductPriceTestHelper {
    public static ProductPrice createFixedPrice(Date from, Date to, boolean defaultPrice, Lookup pricingGroup) {
        ProductPrice result = ProductPriceTestHelper.createFixedPrice(from, to, defaultPrice);
        result.setName("Fixed Price - " + pricingGroup.getName());
        result.addClassification(pricingGroup);
        return result;
    }

    public static ProductPrice createFixedPrice(Date from, Date to, boolean defaultPrice) {
        ProductPrice result = ProductPriceTestHelper.createPrice("productPrice.fixedPrice", from, to);
        IMObjectBean bean = new IMObjectBean((IMObject)result);
        bean.setValue("default", (Object)defaultPrice);
        return result;
    }

    public static ProductPrice createFixedPrice(BigDecimal price, BigDecimal cost, BigDecimal markup, BigDecimal maxDiscount, String from, String to, boolean defaultPrice) {
        ProductPrice result = ProductPriceTestHelper.createFixedPrice(from, to, defaultPrice);
        IMObjectBean bean = new IMObjectBean((IMObject)result);
        bean.setValue("price", (Object)price);
        bean.setValue("cost", (Object)cost);
        bean.setValue("markup", (Object)markup);
        bean.setValue("maxDiscount", (Object)maxDiscount);
        return result;
    }

    public static ProductPrice createFixedPrice(BigDecimal price, BigDecimal cost, BigDecimal markup, BigDecimal maxDiscount, Date from, Date to, boolean defaultPrice) {
        ProductPrice result = ProductPriceTestHelper.createFixedPrice(from, to, defaultPrice);
        IMObjectBean bean = new IMObjectBean((IMObject)result);
        bean.setValue("price", (Object)price);
        bean.setValue("cost", (Object)cost);
        bean.setValue("markup", (Object)markup);
        bean.setValue("maxDiscount", (Object)maxDiscount);
        return result;
    }

    public static ProductPrice createUnitPrice(String from, String to) {
        return ProductPriceTestHelper.createPrice("productPrice.unitPrice", from, to);
    }

    public static ProductPrice createUnitPrice(Date from, Date to) {
        return ProductPriceTestHelper.createPrice("productPrice.unitPrice", from, to);
    }

    public static ProductPrice createUnitPrice(String from, String to, Lookup pricingGroup) {
        ProductPrice price = ProductPriceTestHelper.createPrice("productPrice.unitPrice", from, to);
        price.setName("Unit Price - " + pricingGroup.getName());
        price.addClassification(pricingGroup);
        return price;
    }

    public static ProductPrice createUnitPrice(BigDecimal price, BigDecimal cost, Date from, Date to) {
        return ProductPriceTestHelper.createUnitPrice(price, cost, MathRules.ONE_HUNDRED, MathRules.ONE_HUNDRED, from, to);
    }

    public static ProductPrice createUnitPrice(BigDecimal price, BigDecimal cost, BigDecimal markup, BigDecimal maxDiscount, String from, String to) {
        return ProductPriceTestHelper.createUnitPrice(price, cost, markup, maxDiscount, TestHelper.getDate(from), TestHelper.getDate(to));
    }

    public static ProductPrice createUnitPrice(BigDecimal price, BigDecimal cost, BigDecimal markup, BigDecimal maxDiscount, Date from, Date to) {
        ProductPrice result = ProductPriceTestHelper.createUnitPrice(from, to);
        IMObjectBean bean = new IMObjectBean((IMObject)result);
        bean.setValue("price", (Object)price);
        bean.setValue("cost", (Object)cost);
        bean.setValue("markup", (Object)markup);
        bean.setValue("maxDiscount", (Object)maxDiscount);
        return result;
    }

    public static Lookup getPricingGroup(String code) {
        return TestHelper.getLookup("lookup.pricingGroup", code);
    }

    public static ProductPrice createUnitPrice(BigDecimal price, BigDecimal cost, BigDecimal markup, BigDecimal maxDiscount, Date from, Date to, Lookup pricingGroup) {
        ProductPrice result = ProductPriceTestHelper.createUnitPrice(price, cost, markup, maxDiscount, from, to);
        result.addClassification(pricingGroup);
        return result;
    }

    public static ProductPrice createFixedPrice(String from, String to, boolean defaultPrice, Lookup pricingGroup) {
        ProductPrice fixedPrice = ProductPriceTestHelper.createFixedPrice(from, to, defaultPrice);
        fixedPrice.addClassification(pricingGroup);
        return fixedPrice;
    }

    public static ProductPrice createFixedPrice(String from, String to, boolean defaultPrice) {
        Date fromDate = from != null ? TestHelper.getDate(from) : null;
        Date toDate = to != null ? TestHelper.getDate(to) : null;
        return ProductPriceTestHelper.createFixedPrice(fromDate, toDate, defaultPrice);
    }

    public static ProductPrice createPrice(String shortName, Date from, Date to) {
        ProductPrice result = (ProductPrice)TestHelper.create(shortName);
        result.setName("XPrice");
        result.setPrice(BigDecimal.ONE);
        result.setFromDate(from);
        result.setToDate(to);
        return result;
    }

    public static ProductPrice createPrice(String shortName, String from, String to) {
        Date fromDate = from != null ? TestHelper.getDate(from) : null;
        Date toDate = to != null ? TestHelper.getDate(to) : null;
        return ProductPriceTestHelper.createPrice(shortName, fromDate, toDate);
    }

    public static ProductPrice createFixedPrice(String price, String cost, String markup, String maxDiscount, String from, String to, boolean defaultPrice) {
        return ProductPriceTestHelper.createFixedPrice(new BigDecimal(price), new BigDecimal(cost), new BigDecimal(markup), new BigDecimal(maxDiscount), from, to, defaultPrice);
    }

    public static ProductPrice createFixedPrice(String price, String cost, String markup, String maxDiscount, Date from, Date to, boolean defaultPrice) {
        return ProductPriceTestHelper.createFixedPrice(new BigDecimal(price), new BigDecimal(cost), new BigDecimal(markup), new BigDecimal(maxDiscount), from, to, defaultPrice);
    }

    public static ProductPrice createUnitPrice(String price, String cost, String markup, String maxDiscount, String from, String to) {
        return ProductPriceTestHelper.createUnitPrice(new BigDecimal(price), new BigDecimal(cost), new BigDecimal(markup), new BigDecimal(maxDiscount), from, to);
    }

    public static ProductPrice createUnitPrice(String price, String cost, String markup, String maxDiscount, Date from, Date to) {
        return ProductPriceTestHelper.createUnitPrice(new BigDecimal(price), new BigDecimal(cost), new BigDecimal(markup), new BigDecimal(maxDiscount), from, to);
    }

    public static List<ProductPrice> getPrices(Product product, String archetype) {
        return ProductPriceTestHelper.sort(product.getProductPrices().stream().filter(Predicates.isA((String[])new String[]{archetype})).collect(Collectors.toList()));
    }

    public static List<ProductPrice> sort(Collection<ProductPrice> prices) {
        ArrayList<ProductPrice> result = new ArrayList<ProductPrice>(prices);
        result.sort((o1, o2) -> {
            int compare = DateRules.compareTo((Date)o1.getFromDate(), (Date)o2.getFromDate());
            if (compare == 0) {
                compare = Long.compare(o1.getId(), o2.getId());
            }
            return compare;
        });
        return result;
    }

    public static void checkPrice(ProductPrice productPrice, BigDecimal price, BigDecimal cost) {
        IMObjectBean bean = new IMObjectBean((IMObject)productPrice);
        TestHelper.checkEquals(price, bean.getBigDecimal("price"));
        TestHelper.checkEquals(cost, bean.getBigDecimal("cost"));
    }

    public static void checkPrice(ProductPrice productPrice, BigDecimal price, BigDecimal cost, BigDecimal markup, BigDecimal maxDiscount) {
        ProductPriceTestHelper.checkPrice(productPrice, price, cost, markup, maxDiscount, null);
    }

    public static void checkPrice(ProductPrice productPrice, BigDecimal price, BigDecimal cost, BigDecimal markup, BigDecimal maxDiscount, Lookup pricingGroup) {
        ProductPriceTestHelper.checkPrice(productPrice, price, cost);
        IMObjectBean bean = new IMObjectBean((IMObject)productPrice);
        TestHelper.checkEquals(markup, bean.getBigDecimal("markup"));
        TestHelper.checkEquals(maxDiscount, bean.getBigDecimal("maxDiscount"));
        List groups = bean.getValues("pricingGroups", Lookup.class);
        if (pricingGroup != null) {
            Assert.assertEquals((long)1L, (long)groups.size());
            Assert.assertTrue((boolean)groups.contains(pricingGroup));
        } else {
            Assert.assertTrue((boolean)groups.isEmpty());
        }
    }

    public static void checkPrice(ProductPrice productPrice, BigDecimal price, BigDecimal cost, BigDecimal markup, BigDecimal maxDiscount, Date from, Date to) {
        ProductPriceTestHelper.checkPrice(productPrice, price, cost, markup, maxDiscount, from, to, null);
    }

    public static void checkPrice(ProductPrice productPrice, BigDecimal price, BigDecimal cost, BigDecimal markup, BigDecimal maxDiscount, Date from, Date to, Lookup pricingGroup) {
        ProductPriceTestHelper.checkPrice(productPrice, price, cost, markup, maxDiscount, pricingGroup);
        Assert.assertEquals((long)0L, (long)DateRules.compareTo((Date)from, (Date)productPrice.getFromDate()));
        Assert.assertEquals((long)0L, (long)DateRules.compareTo((Date)to, (Date)productPrice.getToDate()));
    }

    public static ProductPrice checkPrice(Collection<ProductPrice> prices, BigDecimal price, BigDecimal cost, Date from, Date to) {
        return ProductPriceTestHelper.checkPrice(prices, price, cost, MathRules.ONE_HUNDRED, MathRules.ONE_HUNDRED, from, to, null);
    }

    public static ProductPrice checkPrice(Collection<ProductPrice> prices, BigDecimal price, BigDecimal cost, BigDecimal markup, BigDecimal maxDiscount, Date from, Date to, Lookup pricingGroup) {
        ProductPrice match = null;
        int matches = 0;
        for (ProductPrice p : prices) {
            IMObjectBean bean = new IMObjectBean((IMObject)p);
            if (!MathRules.equals((BigDecimal)bean.getBigDecimal("cost"), (BigDecimal)cost) || !MathRules.equals((BigDecimal)price, (BigDecimal)p.getPrice()) || DateRules.compareTo((Date)from, (Date)p.getFromDate(), (boolean)true) != 0 || DateRules.compareTo((Date)to, (Date)p.getToDate(), (boolean)true) != 0 || !Objects.equals(pricingGroup, bean.getObject("pricingGroups"))) continue;
            match = p;
            ++matches;
            TestHelper.checkEquals(markup, bean.getBigDecimal("markup"));
            TestHelper.checkEquals(maxDiscount, bean.getBigDecimal("maxDiscount"));
        }
        Assert.assertNotNull(match);
        Assert.assertEquals((long)1L, (long)matches);
        return match;
    }

    public static Date checkToDateSet(ProductPrice price, Date after) {
        Date toDate = price.getToDate();
        Assert.assertNotNull((Object)toDate);
        Assert.assertTrue((DateRules.compareTo((Date)toDate, (Date)after, (boolean)true) >= 0 ? 1 : 0) != 0);
        return toDate;
    }
}

