/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.prefs;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.prefs.PreferencesCopier;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.user.User;

public class PreferencesCopierTestCase
extends ArchetypeServiceTest {
    @Test
    public void testCopy() {
        User user1 = TestHelper.createUser();
        Entity root1 = this.create("entity.preferences", Entity.class);
        Entity group1a = this.create("entity.preferenceGroupGeneral", Entity.class);
        Entity group1b = this.create("entity.preferenceGroupSummary", Entity.class);
        IMObjectBean bean = this.getBean((IMObject)root1);
        bean.addTarget("groups", (IMObject)group1a);
        bean.addTarget("groups", (IMObject)group1b);
        bean.setTarget("user", (IMObject)user1);
        IMObjectBean group1aBean = this.getBean((IMObject)group1a);
        group1aBean.setValue("homePage", (Object)"workflow.scheduling");
        group1aBean.setValue("customerHistory", (Object)"not copied");
        group1aBean.setValue("patientHistory", (Object)"not copied");
        IMObjectBean group1bBean = this.getBean((IMObject)group1b);
        group1bBean.setValue("showReferral", (Object)"ALWAYS");
        this.save((IMObject[])new Entity[]{root1, group1a, group1b});
        User user2 = TestHelper.createUser();
        List objects = PreferencesCopier.copy((Entity)root1, (Reference)user2.getObjectReference(), (IArchetypeService)this.getArchetypeService());
        Assert.assertEquals((long)3L, (long)objects.size());
        Entity root2 = (Entity)this.get(objects, "entity.preferences");
        Entity group2a = (Entity)this.get(objects, "entity.preferenceGroupGeneral");
        Entity group2b = (Entity)this.get(objects, "entity.preferenceGroupSummary");
        Assert.assertNotEquals((long)root2.getId(), (long)root1.getId());
        Assert.assertNotEquals((long)group2a.getId(), (long)group1a.getId());
        Assert.assertNotEquals((long)group2b.getId(), (long)group1b.getId());
        this.save(objects);
        IMObjectBean bean2 = this.getBean((IMObject)root2);
        List groups = bean2.getTargets("groups", Policies.orderBySequence());
        Assert.assertEquals((long)2L, (long)groups.size());
        Assert.assertEquals((Object)group2a, groups.get(0));
        Assert.assertEquals((Object)group2b, groups.get(1));
        Assert.assertEquals((Object)user2, (Object)bean2.getTarget("user"));
        IMObjectBean group2aBean = this.getBean((IMObject)group2a);
        Assert.assertEquals((Object)"workflow.scheduling", (Object)group2aBean.getString("homePage"));
        Assert.assertNull((Object)group2aBean.getString("customerHistory"));
        Assert.assertNull((Object)group2aBean.getString("patientHistory"));
        IMObjectBean group2bBean = this.getBean((IMObject)group2b);
        Assert.assertEquals((Object)"ALWAYS", (Object)group2bBean.getString("showReferral"));
    }

    private IMObject get(List<IMObject> objects, String shortName) {
        for (IMObject object : objects) {
            if (!TypeHelper.isA((IMObject)object, (String)shortName)) continue;
            return object;
        }
        throw new IllegalStateException("Failed to find object with short name " + shortName);
    }
}

