/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.prefs;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.prefs.PreferenceMonitor;
import org.openvpms.archetype.rules.prefs.PreferenceServiceImpl;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public class PreferenceMonitorTestCase
extends ArchetypeServiceTest {
    @Autowired
    PlatformTransactionManager transactionManager;
    private Preferences preferences;

    @Before
    public void setUp() {
        PreferenceServiceImpl service = new PreferenceServiceImpl(this.getArchetypeService(), this.transactionManager);
        User user = TestHelper.createUser();
        this.preferences = service.getPreferences((Party)user, null, true);
    }

    @Test
    public void testMonitorPreference() {
        this.preferences.setPreference("entity.preferenceGroupSummary", "showCustomerAccount", (Object)true);
        this.preferences.setPreference("entity.preferenceGroupSummary", "showReferral", (Object)"ACTIVE");
        PreferenceMonitor monitor = new PreferenceMonitor(this.preferences);
        monitor.add("entity.preferenceGroupSummary", "showCustomerAccount");
        Assert.assertFalse((boolean)monitor.changed());
        this.preferences.setPreference("entity.preferenceGroupSummary", "showCustomerAccount", (Object)false);
        Assert.assertTrue((boolean)monitor.changed());
        Assert.assertFalse((boolean)monitor.changed());
        this.preferences.setPreference("entity.preferenceGroupSummary", "showReferral", (Object)"NEVER");
        Assert.assertFalse((boolean)monitor.changed());
    }

    @Test
    public void testMonitorGroup() {
        this.preferences.setPreference("entity.preferenceGroupSummary", "showCustomerAccount", (Object)true);
        this.preferences.setPreference("entity.preferenceGroupSummary", "showReferral", (Object)"ACTIVE");
        PreferenceMonitor monitor = new PreferenceMonitor(this.preferences);
        monitor.add("entity.preferenceGroupSummary");
        Assert.assertFalse((boolean)monitor.changed());
        this.preferences.setPreference("entity.preferenceGroupSummary", "showCustomerAccount", (Object)false);
        this.preferences.setPreference("entity.preferenceGroupSummary", "showReferral", (Object)"ALWAYS");
        Assert.assertTrue((boolean)monitor.changed());
        Assert.assertFalse((boolean)monitor.changed());
        this.preferences.setPreference("entity.preferenceGroupSummary", "showReferral", (Object)"NEVER");
        Assert.assertTrue((boolean)monitor.changed());
        Assert.assertFalse((boolean)monitor.changed());
    }
}

