/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.reminder;

import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.reminder.ReminderCount;
import org.openvpms.archetype.rules.patient.reminder.ReminderRule;
import org.openvpms.archetype.rules.patient.reminder.ReminderTestHelper;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

public class ReminderTypeTestCase
extends ArchetypeServiceTest {
    @Test
    public void testGetDueDate() {
        Date start = TestHelper.getDate("2007-01-01");
        Date days30 = TestHelper.getDate("2007-01-31");
        Date month1 = TestHelper.getDate("2007-02-01");
        Date month3 = TestHelper.getDate("2007-04-01");
        Date year2 = TestHelper.getDate("2009-01-01");
        this.checkGetDueDate(start, days30, 30, DateUnits.DAYS);
        this.checkGetDueDate(start, month1, 1, DateUnits.MONTHS);
        this.checkGetDueDate(start, month3, 3, DateUnits.MONTHS);
        this.checkGetDueDate(start, year2, 2, DateUnits.YEARS);
    }

    @Test
    public void testGetCancelDate() {
        Date start = TestHelper.getDate("2007-01-01");
        Date days30 = TestHelper.getDate("2007-01-31");
        Date month1 = TestHelper.getDate("2007-02-01");
        Date month3 = TestHelper.getDate("2007-04-01");
        Date year2 = TestHelper.getDate("2009-01-01");
        this.checkGetCancelDate(start, days30, 30, DateUnits.DAYS);
        this.checkGetCancelDate(start, month1, 1, DateUnits.MONTHS);
        this.checkGetCancelDate(start, month3, 3, DateUnits.MONTHS);
        this.checkGetCancelDate(start, year2, 2, DateUnits.YEARS);
    }

    @Test
    public void testShouldCancel() {
        Date dueDate = TestHelper.getDate("2007-01-01");
        Date days30 = TestHelper.getDate("2007-01-31");
        Date month3 = TestHelper.getDate("2007-04-01");
        Date year2 = TestHelper.getDate("2009-01-01");
        this.checkShouldCancel(dueDate, days30, false, 31, DateUnits.DAYS);
        this.checkShouldCancel(dueDate, days30, true, 30, DateUnits.DAYS);
        this.checkShouldCancel(dueDate, month3, false, 4, DateUnits.MONTHS);
        this.checkShouldCancel(dueDate, month3, true, 2, DateUnits.MONTHS);
        this.checkShouldCancel(dueDate, year2, false, 3, DateUnits.YEARS);
        this.checkShouldCancel(dueDate, year2, true, 1, DateUnits.YEARS);
    }

    @Test
    public void testNoUnits() {
        IMObjectBean bean = this.createReminderTypeBean();
        bean.setValue("defaultUnits", null);
        bean.setValue("cancelUnits", null);
        ReminderType type = new ReminderType((Entity)bean.getObject(Entity.class), (ArchetypeService)this.getArchetypeService());
        Assert.assertEquals((Object)DateUnits.YEARS, (Object)type.getDefaultUnits());
        Assert.assertEquals((Object)DateUnits.YEARS, (Object)type.getCancelUnits());
    }

    @Test
    public void testGetNextDueDate() {
        ReminderType type1 = new ReminderType(ReminderTestHelper.createReminderType(new Lookup[0]), (ArchetypeService)this.getArchetypeService());
        Date dueDate = TestHelper.getDate("2007-01-01");
        Assert.assertNull((Object)type1.getNextDueDate(dueDate, 0));
        IMObjectBean bean2 = this.createReminderTypeBean();
        bean2.setValue("defaultInterval", (Object)1);
        this.addReminderCount((Entity)bean2.getObject(Entity.class), 0, 3, DateUnits.MONTHS);
        ReminderType type2 = new ReminderType((Entity)bean2.getObject(Entity.class), (ArchetypeService)this.getArchetypeService());
        Date expected2 = TestHelper.getDate("2007-04-01");
        Date actual2 = type2.getNextDueDate(dueDate, 0);
        Assert.assertEquals((Object)expected2, (Object)actual2);
        IMObjectBean bean3 = this.createReminderTypeBean();
        bean3.setValue("defaultInterval", (Object)1);
        this.addReminderCount((Entity)bean3.getObject(Entity.class), 0, 3, DateUnits.MONTHS);
        this.addReminderCount((Entity)bean3.getObject(Entity.class), 1, 1, DateUnits.YEARS);
        ReminderType type3 = new ReminderType((Entity)bean3.getObject(Entity.class), (ArchetypeService)this.getArchetypeService());
        Date expected3 = TestHelper.getDate("2008-01-01");
        Date actual3 = type3.getNextDueDate(dueDate, 1);
        Assert.assertEquals((Object)expected3, (Object)actual3);
    }

    @Test
    public void testIsInteractive() {
        Entity entity = ReminderTestHelper.createReminderType(new Lookup[0]);
        IMObjectBean bean = this.getBean((IMObject)entity);
        ReminderType t1 = new ReminderType(entity, (ArchetypeService)this.getArchetypeService());
        Assert.assertFalse((boolean)t1.isInteractive());
        bean.setValue("interactive", (Object)true);
        Assert.assertFalse((boolean)t1.isInteractive());
        ReminderType t2 = new ReminderType(entity, (ArchetypeService)this.getArchetypeService());
        Assert.assertTrue((boolean)t2.isInteractive());
        bean.setValue("interactive", (Object)false);
        Assert.assertTrue((boolean)t2.isInteractive());
        ReminderType t3 = new ReminderType(entity, (ArchetypeService)this.getArchetypeService());
        Assert.assertFalse((boolean)t3.isInteractive());
    }

    @Test
    public void testGetReminderCounts() {
        Entity entity = ReminderTestHelper.createReminderType(new Lookup[0]);
        Entity contact0 = ReminderTestHelper.createContactRule();
        Entity email0 = ReminderTestHelper.createEmailRule();
        Entity sms0 = ReminderTestHelper.createSMSRule();
        ReminderTestHelper.addReminderCount(entity, 0, 0, DateUnits.DAYS, null, contact0, email0, sms0);
        Entity email1 = ReminderTestHelper.createEmailRule();
        Entity sms1 = ReminderTestHelper.createSMSRule();
        ReminderTestHelper.addReminderCount(entity, 1, 30, DateUnits.DAYS, null, email1, sms1);
        Entity list2 = ReminderTestHelper.createListRule();
        ReminderTestHelper.addReminderCount(entity, 2, 60, DateUnits.DAYS, null, list2);
        ReminderType reminderType = new ReminderType(entity, (ArchetypeService)this.getArchetypeService());
        this.checkReminderCount(reminderType.getReminderCount(0), 0, 0, DateUnits.DAYS, contact0, email0, sms0);
        this.checkReminderCount(reminderType.getReminderCount(1), 1, 30, DateUnits.DAYS, email1, sms1);
        this.checkReminderCount(reminderType.getReminderCount(2), 2, 60, DateUnits.DAYS, list2);
        Assert.assertNull((Object)reminderType.getReminderCount(3));
        List counts = reminderType.getReminderCounts();
        Assert.assertEquals((long)3L, (long)counts.size());
        this.checkReminderCount((ReminderCount)counts.get(0), 0, 0, DateUnits.DAYS, contact0, email0, sms0);
        this.checkReminderCount((ReminderCount)counts.get(1), 1, 30, DateUnits.DAYS, email1, sms1);
        this.checkReminderCount((ReminderCount)counts.get(2), 2, 60, DateUnits.DAYS, list2);
    }

    private void checkReminderCount(ReminderCount count, int expectedCount, int expectedInterval, DateUnits expectedUnits, Entity ... expectedRules) {
        Assert.assertEquals((long)expectedCount, (long)count.getCount());
        Assert.assertEquals((long)expectedInterval, (long)count.getInterval());
        Assert.assertEquals((Object)expectedUnits, (Object)count.getUnits());
        List rules = count.getRules();
        Assert.assertEquals((long)expectedRules.length, (long)rules.size());
        for (int i = 0; i < expectedRules.length; ++i) {
            ReminderRule expected = new ReminderRule((IMObject)expectedRules[i], (ArchetypeService)this.getArchetypeService());
            Assert.assertEquals((Object)expected, rules.get(i));
        }
    }

    private void checkGetDueDate(Date start, Date expected, int interval, DateUnits units) {
        IMObjectBean bean = this.createReminderTypeBean();
        bean.setValue("defaultInterval", (Object)interval);
        bean.setValue("defaultUnits", (Object)units.toString());
        ReminderType type = new ReminderType((Entity)bean.getObject(Entity.class), (ArchetypeService)this.getArchetypeService());
        Assert.assertEquals((long)interval, (long)type.getDefaultInterval());
        Assert.assertEquals((Object)units, (Object)type.getDefaultUnits());
        Date due = type.getDueDate(start);
        Assert.assertEquals((Object)expected, (Object)due);
    }

    private void checkGetCancelDate(Date start, Date expected, int interval, DateUnits units) {
        IMObjectBean bean = this.createReminderTypeBean();
        bean.setValue("cancelInterval", (Object)interval);
        bean.setValue("cancelUnits", (Object)units.toString());
        ReminderType type = new ReminderType((Entity)bean.getObject(Entity.class), (ArchetypeService)this.getArchetypeService());
        Assert.assertEquals((long)interval, (long)type.getCancelInterval());
        Assert.assertEquals((Object)units, (Object)type.getCancelUnits());
        Date cancel = type.getCancelDate(start);
        Assert.assertEquals((Object)expected, (Object)cancel);
    }

    private void checkShouldCancel(Date dueDate, Date cancelDate, boolean expected, int interval, DateUnits units) {
        IMObjectBean bean = this.createReminderTypeBean();
        bean.setValue("cancelInterval", (Object)interval);
        bean.setValue("cancelUnits", (Object)units.toString());
        ReminderType type = new ReminderType((Entity)bean.getObject(Entity.class), (ArchetypeService)this.getArchetypeService());
        Assert.assertEquals((Object)expected, (Object)type.shouldCancel(dueDate, cancelDate));
    }

    private IMObjectBean createReminderTypeBean() {
        return this.getBean((IMObject)ReminderTestHelper.createReminderType(new Lookup[0]));
    }

    private void addReminderCount(Entity reminderType, int reminderCount, int interval, DateUnits units) {
        Entity template = this.create("entity.documentTemplate", Entity.class);
        template.setName("XTemplate-" + System.currentTimeMillis());
        this.save((IMObject)template);
        ReminderTestHelper.addReminderCount(reminderType, reminderCount, interval, units, template, new Entity[0]);
    }
}

