/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.reminder;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderRule;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.helper.IMObjectBean;
import org.openvpms.component.business.service.lookup.LookupServiceHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;

public class ReminderTestHelper
extends TestHelper {
    public static Entity createReminderType(Lookup ... groups) {
        return ReminderTestHelper.createReminderType(1, DateUnits.MONTHS, groups);
    }

    public static Entity createReminderType(int defaultInterval, DateUnits defaultUnits, Lookup ... groups) {
        return ReminderTestHelper.createReminderType(defaultInterval, defaultUnits, 2 * defaultInterval, defaultUnits, groups);
    }

    public static Entity createReminderType(int defaultInterval, DateUnits defaultUnits, int cancelInterval, DateUnits cancelUnits, Lookup ... groups) {
        Entity reminder = ReminderTestHelper.create("entity.reminderType", Entity.class);
        IMObjectBean bean = new IMObjectBean((IMObject)reminder);
        bean.setValue("name", (Object)"XReminderType");
        bean.setValue("defaultInterval", (Object)defaultInterval);
        bean.setValue("defaultUnits", (Object)defaultUnits.toString());
        if (cancelUnits != null) {
            bean.setValue("cancelInterval", (Object)cancelInterval);
            bean.setValue("cancelUnits", (Object)cancelUnits.toString());
        }
        for (Lookup group : groups) {
            reminder.addClassification(group);
        }
        bean.save();
        return reminder;
    }

    public static Entity createReminderCount(int count, int interval, DateUnits units, Entity template, Entity ... rules) {
        Entity entity = ReminderTestHelper.create("entity.reminderCount", Entity.class);
        IMObjectBean bean = new IMObjectBean((IMObject)entity);
        bean.setValue("count", (Object)count);
        bean.setValue("interval", (Object)interval);
        bean.setValue("units", (Object)units);
        if (template != null) {
            bean.addTarget("template", (IMObject)template);
        }
        int sequence = 0;
        for (Entity rule : rules) {
            Relationship relationship = bean.addTarget("rules", (IMObject)rule);
            IMObjectBean relationshipBean = new IMObjectBean((IMObject)relationship);
            relationshipBean.setValue("sequence", (Object)sequence++);
        }
        bean.save();
        return entity;
    }

    public static Entity addReminderCount(Entity reminderType, int count, int interval, DateUnits units, Entity template, Entity ... rules) {
        Entity reminderCount = ReminderTestHelper.createReminderCount(count, interval, units, template, rules);
        IMObjectBean bean = new IMObjectBean((IMObject)reminderType);
        bean.addTarget("counts", (IMObject)reminderCount);
        bean.save();
        return reminderCount;
    }

    public static Entity createContactRule() {
        return ReminderTestHelper.createRule(true, false, false, false, false, false, ReminderRule.SendTo.ANY);
    }

    public static Entity createEmailRule() {
        return ReminderTestHelper.createRule(false, true, false, false, false, false, ReminderRule.SendTo.ANY);
    }

    public static Entity createSMSRule() {
        return ReminderTestHelper.createRule(false, false, true, false, false, false, ReminderRule.SendTo.ANY);
    }

    public static Entity createPrintRule() {
        return ReminderTestHelper.createRule(false, false, false, true, false, false, ReminderRule.SendTo.ANY);
    }

    public static Entity createExportRule() {
        return ReminderTestHelper.createRule(false, false, false, false, true, false, ReminderRule.SendTo.ANY);
    }

    public static Entity createListRule() {
        return ReminderTestHelper.createRule(false, false, false, false, false, true, ReminderRule.SendTo.ANY);
    }

    public static Entity createRule(boolean contact, boolean email, boolean sms, boolean print, boolean export, boolean list, ReminderRule.SendTo sendTo) {
        Entity rule = ReminderTestHelper.create("entity.reminderRule", Entity.class);
        IMObjectBean bean = new IMObjectBean((IMObject)rule);
        bean.setValue("contact", (Object)contact);
        bean.setValue("email", (Object)email);
        bean.setValue("sms", (Object)sms);
        bean.setValue("print", (Object)print);
        bean.setValue("export", (Object)export);
        bean.setValue("list", (Object)list);
        bean.setValue("sendTo", (Object)sendTo.toString());
        bean.save();
        return rule;
    }

    public static Act createReminder(Party patient, Entity reminderType, Date initialTime) {
        Act reminder = ReminderTestHelper.createReminder(patient, reminderType);
        IMObjectBean bean = new IMObjectBean((IMObject)reminder);
        bean.setValue("initialTime", (Object)initialTime);
        ReminderRules rules = new ReminderRules(ArchetypeServiceHelper.getArchetypeService(), new PatientRules(null, null, ArchetypeServiceHelper.getArchetypeService(), (LookupService)LookupServiceHelper.getLookupService()));
        Date due = rules.calculateReminderDueDate(initialTime, reminderType);
        reminder.setActivityStartTime(due);
        reminder.setActivityEndTime(due);
        ReminderTestHelper.save((IMObject)reminder);
        return reminder;
    }

    public static Act createReminderWithDueDate(Party patient, Entity reminderType, Date dueDate) {
        Act reminder = ReminderTestHelper.createReminder(patient, reminderType);
        reminder.setActivityStartTime(dueDate);
        reminder.setActivityEndTime(dueDate);
        ReminderTestHelper.save((IMObject)reminder);
        return reminder;
    }

    public static Act createReminder(Party patient, Entity reminderType) {
        Act act = ReminderTestHelper.create("act.patientReminder", Act.class);
        IMObjectBean bean = new IMObjectBean((IMObject)act);
        Date due = new Date();
        bean.setValue("startTime", (Object)due);
        bean.setValue("endTime", (Object)due);
        act.setStatus("IN_PROGRESS");
        bean.setTarget("patient", (IMObject)patient);
        bean.setTarget("reminderType", (IMObject)reminderType);
        return act;
    }

    public static Act createReminder(Date dueDate, Party patient, Entity reminderType, Act ... items) {
        return ReminderTestHelper.createReminder(dueDate, patient, reminderType, "IN_PROGRESS", items);
    }

    public static Act createReminder(Date dueDate, Party patient, Entity reminderType, String status, Act ... items) {
        Act act = ReminderTestHelper.createReminder(patient, reminderType);
        act.setActivityStartTime(dueDate);
        act.setActivityEndTime(dueDate);
        act.setStatus(status);
        ArrayList<Act> toSave = new ArrayList<Act>();
        toSave.add(act);
        if (items.length > 0) {
            IMObjectBean bean = new IMObjectBean((IMObject)act);
            for (Act item : items) {
                bean.addTarget("items", (IMObject)item, "reminder");
                toSave.add(item);
            }
        }
        ReminderTestHelper.save(toSave);
        return act;
    }

    public static Act createEmailReminder(Date send, Date dueDate, String status, int count) {
        return ReminderTestHelper.createReminderItem("act.patientReminderItemEmail", send, dueDate, status, count);
    }

    public static Act createSMSReminder(Date send, Date dueDate, String status, int count) {
        return ReminderTestHelper.createReminderItem("act.patientReminderItemSMS", send, dueDate, status, count);
    }

    public static Act createPrintReminder(Date send, Date dueDate, String status, int count) {
        return ReminderTestHelper.createReminderItem("act.patientReminderItemPrint", send, dueDate, status, count);
    }

    public static Act createExportReminder(Date send, Date dueDate, String status, int count) {
        return ReminderTestHelper.createReminderItem("act.patientReminderItemExport", send, dueDate, status, count);
    }

    public static Act createListReminder(Date send, Date dueDate, String status, int count) {
        return ReminderTestHelper.createReminderItem("act.patientReminderItemList", send, dueDate, status, count);
    }

    public static List<Act> createReminders(int count, Entity reminderType) {
        ArrayList<Act> result = new ArrayList<Act>();
        Date dueDate = new Date();
        for (int i = 0; i < count; ++i) {
            Party customer = ReminderTestHelper.createCustomer();
            Party patient = ReminderTestHelper.createPatient(customer);
            Act reminder = ReminderTestHelper.createReminderWithDueDate(patient, reminderType, dueDate);
            result.add(reminder);
        }
        return result;
    }

    public static Entity createDocumentTemplate() {
        return ReminderTestHelper.createDocumentTemplate(null, null);
    }

    public static Entity createDocumentTemplate(boolean emailTemplate, boolean smsTemplate) {
        Entity email = emailTemplate ? ReminderTestHelper.createEmailTemplate("subject", "text") : null;
        Entity sms = smsTemplate ? ReminderTestHelper.createSMSTemplate("TEXT", "some plain text") : null;
        return ReminderTestHelper.createDocumentTemplate(email, sms);
    }

    public static Entity createDocumentTemplate(Entity emailTemplate, Entity smsTemplate) {
        DocumentHandlers handlers = new DocumentHandlers((ArchetypeService)ArchetypeServiceHelper.getArchetypeService());
        TestDocumentFactory factory = new TestDocumentFactory((ArchetypeService)ArchetypeServiceHelper.getArchetypeService(), handlers);
        return (Entity)((TestDocumentTemplateBuilder)factory.newTemplate().type("act.patientDocumentForm").document("/documents/vaccination first reminder.odt", "application/vnd.oasis.opendocument.text")).emailTemplate(emailTemplate).smsTemplate(smsTemplate).build();
    }

    public static Entity createEmailTemplate(String subject, String message) {
        Entity entity = TestHelper.create("entity.documentTemplateEmailSystem", Entity.class);
        IMObjectBean bean = new IMObjectBean((IMObject)entity);
        bean.setValue("name", (Object)subject);
        bean.setValue("subject", (Object)subject);
        bean.setValue("contentType", (Object)"TEXT");
        bean.setValue("content", (Object)message);
        bean.save();
        return entity;
    }

    public static Entity createSMSTemplate(String type, String expression) {
        Entity template = ReminderTestHelper.create("entity.documentTemplateSMSReminder", Entity.class);
        IMObjectBean bean = new IMObjectBean((IMObject)template);
        bean.setValue("name", (Object)(type + " template"));
        bean.setValue("contentType", (Object)type);
        bean.setValue("content", (Object)expression);
        bean.save();
        return template;
    }

    private static Act createReminderItem(String shortName, Date send, Date dueDate, String status, int count) {
        Act act = ReminderTestHelper.create(shortName, Act.class);
        act.setActivityStartTime(send);
        act.setActivityEndTime(dueDate);
        act.setStatus(status);
        IMObjectBean bean = new IMObjectBean((IMObject)act);
        bean.setValue("count", (Object)count);
        return act;
    }
}

