/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.reminder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderCount;
import org.openvpms.archetype.rules.patient.reminder.ReminderRule;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemBuilder;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.object.IMObjectGraphVerifier;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFormBuilder;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderBuilder;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderFactory;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderTypeBuilder;
import org.openvpms.archetype.test.builder.product.TestMedicationProductBuilder;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.component.business.service.archetype.helper.IMObjectGraph;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class ReminderRulesTestCase
extends ArchetypeServiceTest {
    @Autowired
    private PatientRules patientRules;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestReminderFactory reminderFactory;
    @Autowired
    private PlatformTransactionManager transactionManager;
    private ReminderRules rules;

    @Before
    public void setUp() {
        this.rules = new ReminderRules(this.getArchetypeService(), this.patientRules);
    }

    @Test
    public void testMarkMatchingRemindersCompleted() {
        Lookup group1 = this.reminderFactory.createReminderGroup();
        Lookup group2 = this.reminderFactory.createReminderGroup();
        Party patient1 = this.patientFactory.createPatient();
        Party patient2 = this.patientFactory.createPatient();
        Act reminder0 = this.createReminder(patient1, new Lookup[0]);
        this.checkReminder(reminder0, "IN_PROGRESS");
        this.rules.markMatchingRemindersCompleted(reminder0);
        Act reminder1 = this.createReminder(patient1, group1);
        this.rules.markMatchingRemindersCompleted(reminder1);
        this.checkReminder(reminder1, "IN_PROGRESS");
        this.checkReminder(reminder0, "IN_PROGRESS");
        Act reminder2 = this.createReminder(patient2, group2);
        this.rules.markMatchingRemindersCompleted(reminder2);
        this.checkReminder(reminder2, "IN_PROGRESS");
        this.checkReminder(reminder1, "IN_PROGRESS");
        Act reminder3 = this.createReminder(patient1, group1);
        this.rules.markMatchingRemindersCompleted(reminder3);
        this.checkReminder(reminder3, "IN_PROGRESS");
        this.checkReminder(reminder1, "COMPLETED");
        Act reminder4 = this.createReminder(patient2, group1, group2);
        this.rules.markMatchingRemindersCompleted(reminder4);
        this.checkReminder(reminder4, "IN_PROGRESS");
        this.checkReminder(reminder2, "COMPLETED");
        Entity reminderType = this.reminderFactory.createReminderType();
        Act reminder5 = this.createReminder(patient1, reminderType);
        Act reminder6 = this.createReminder(patient2, reminderType);
        this.rules.markMatchingRemindersCompleted(reminder5);
        this.rules.markMatchingRemindersCompleted(reminder6);
        this.checkReminder(reminder5, "IN_PROGRESS");
        this.checkReminder(reminder6, "IN_PROGRESS");
        Act reminder7 = this.createReminder(patient1, reminderType);
        this.rules.markMatchingRemindersCompleted(reminder7);
        this.checkReminder(reminder5, "COMPLETED");
        this.checkReminder(reminder6, "IN_PROGRESS");
        this.checkReminder(reminder7, "IN_PROGRESS");
    }

    @Test
    public void testMarkMatchingRemindersCompletedForList() {
        Entity reminderType = this.reminderFactory.createReminderType();
        Party patient1 = this.patientFactory.createPatient();
        Party patient2 = this.patientFactory.createPatient();
        Act reminder0 = this.createReminder(patient1, reminderType);
        Act reminder1 = this.createReminder(patient2, reminderType);
        this.checkReminder(reminder0, "IN_PROGRESS");
        this.checkReminder(reminder1, "IN_PROGRESS");
        Act reminder2 = this.createReminder(patient1, reminderType);
        Act reminder3 = this.createReminder(patient2, reminderType);
        Act reminder3dup = this.createReminder(patient2, reminderType);
        List<Act> reminders = Arrays.asList(reminder2, reminder3, reminder3dup);
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        template.execute(status -> {
            this.save(reminders);
            this.rules.markMatchingRemindersCompleted(reminders);
            return null;
        });
        this.checkReminder(reminder0, "COMPLETED");
        this.checkReminder(reminder1, "COMPLETED");
        this.checkReminder(reminder2, "IN_PROGRESS");
        this.checkReminder(reminder3, "IN_PROGRESS");
        this.checkReminder(reminder3dup, "COMPLETED");
    }

    @Test
    public void testStopperReminder() {
        Party patient = this.patientFactory.createPatient();
        Entity reminderType = this.reminderFactory.createReminderType();
        Act reminder1 = this.createReminder(patient, reminderType);
        this.checkReminder(reminder1, "IN_PROGRESS");
        Act reminder2 = this.createReminder(patient, reminderType);
        this.rules.markMatchingRemindersCompleted(reminder2);
        this.checkReminder(reminder1, "COMPLETED");
        this.checkReminder(reminder2, "IN_PROGRESS");
        Act reminder3 = (Act)this.newReminder(patient, reminderType).dueDate(new Date()).build();
        this.rules.markMatchingRemindersCompleted(reminder3);
        this.checkReminder(reminder1, "COMPLETED");
        this.checkReminder(reminder2, "COMPLETED");
        this.checkReminder(reminder3, "COMPLETED");
    }

    @Test
    public void testCalculateReminderDueDate() {
        this.checkCalculateReminderDueDate(1, DateUnits.DAYS, "2007-01-01", "2007-01-02");
        this.checkCalculateReminderDueDate(2, DateUnits.WEEKS, "2007-01-01", "2007-01-15");
        this.checkCalculateReminderDueDate(2, DateUnits.MONTHS, "2007-01-01", "2007-03-01");
        this.checkCalculateReminderDueDate(5, DateUnits.YEARS, "2007-01-01", "2012-01-01");
    }

    @Test
    public void testCalculateProductReminderDueDate() {
        this.checkCalculateProductReminderDueDate(1, DateUnits.DAYS, "2007-01-01", "2007-01-02");
        this.checkCalculateProductReminderDueDate(2, DateUnits.WEEKS, "2007-01-01", "2007-01-15");
        this.checkCalculateProductReminderDueDate(2, DateUnits.MONTHS, "2007-01-01", "2007-03-01");
        this.checkCalculateProductReminderDueDate(5, DateUnits.YEARS, "2007-01-01", "2012-01-01");
    }

    @Test
    public void testGetNextReminderDate() {
        Entity reminderType = (Entity)this.reminderFactory.newReminderType().defaultInterval(1, DateUnits.YEARS).newCount().count(0).interval(-1, DateUnits.MONTHS).add().newCount().count(1).interval(-2, DateUnits.WEEKS).add().newCount().count(2).interval(0, DateUnits.DAYS).add().newCount().count(3).interval(1, DateUnits.MONTHS).add().build();
        Date today = DateRules.getToday();
        Date due = DateRules.getDate((Date)today, (int)1, (DateUnits)DateUnits.YEARS);
        Date next0 = DateRules.getDate((Date)due, (int)-1, (DateUnits)DateUnits.MONTHS);
        Date next1 = DateRules.getDate((Date)due, (int)-2, (DateUnits)DateUnits.WEEKS);
        Date next2 = DateRules.getDate((Date)due, (int)0, (DateUnits)DateUnits.DAYS);
        Date next3 = DateRules.getDate((Date)due, (int)1, (DateUnits)DateUnits.MONTHS);
        Assert.assertEquals((Object)next0, (Object)this.rules.getNextReminderDate(due, reminderType, 0));
        Assert.assertEquals((Object)next1, (Object)this.rules.getNextReminderDate(due, reminderType, 1));
        Assert.assertEquals((Object)next2, (Object)this.rules.getNextReminderDate(due, reminderType, 2));
        Assert.assertEquals((Object)next3, (Object)this.rules.getNextReminderDate(due, reminderType, 3));
        Assert.assertNull((Object)this.rules.getNextReminderDate(due, reminderType, 4));
    }

    @Test
    public void testShouldCancel() {
        Lookup group = this.reminderFactory.createReminderGroup();
        Party patient = this.patientFactory.createPatient();
        Entity reminderType = (Entity)this.reminderFactory.newReminderType().defaultInterval(1, DateUnits.MONTHS).cancelInterval(0, DateUnits.MONTHS).addGroups(group.getCode()).build();
        Act reminder = (Act)this.newReminder(patient, reminderType).date("2007-01-01").build();
        Date due = TestHelper.getDate("2007-02-01");
        Assert.assertEquals((Object)due, (Object)reminder.getActivityStartTime());
        Assert.assertEquals((Object)due, (Object)reminder.getActivityEndTime());
        this.checkShouldCancel(reminder, "2007-01-01", false);
        this.checkShouldCancel(reminder, "2007-01-31", false);
        this.checkShouldCancel(reminder, "2007-02-01", true);
        this.reminderFactory.updateReminderType(reminderType).cancelInterval(2, DateUnits.WEEKS).build();
        this.checkShouldCancel(reminder, "2007-02-01", false);
        this.checkShouldCancel(reminder, "2007-02-14", false);
        this.checkShouldCancel(reminder, "2007-02-15", true);
        this.patientFactory.updatePatient(patient).deceased(true).build();
        this.checkShouldCancel(reminder, "2007-02-01", true);
    }

    @Test
    public void testUpdateReminder() {
        Party patient = this.patientFactory.createPatient();
        Entity reminderType = (Entity)this.reminderFactory.newReminderType().defaultInterval(3, DateUnits.MONTHS).newCount().count(0).interval(0, DateUnits.WEEKS).newRule().email().add().add().newCount().count(1).interval(1, DateUnits.MONTHS).newRule().email().add().add().build();
        Act reminder = this.createReminder(patient, reminderType, "2016-01-01", "IN_PROGRESS");
        Date due = TestHelper.getDate("2016-04-01");
        Assert.assertEquals((Object)due, (Object)reminder.getActivityStartTime());
        Assert.assertEquals((Object)due, (Object)reminder.getActivityEndTime());
        TestReminderBuilder builder = this.reminderFactory.updateReminder(reminder);
        builder.newEmailReminder().dueDate(due).sendDate(due).add().newPrintReminder().dueDate(due).sendDate(due).add().build();
        Act item1 = builder.getItems().get(0);
        Act item2 = builder.getItems().get(1);
        Assert.assertFalse((boolean)this.rules.updateReminder(reminder, item1));
        item2.setStatus("COMPLETED");
        this.save((IMObject)item2);
        Assert.assertTrue((boolean)this.rules.updateReminder(reminder, item1));
        Assert.assertEquals((Object)TestHelper.getDate("2016-05-01"), (Object)reminder.getActivityStartTime());
    }

    @Test
    public void testGetReminderTypes() {
        Entity reminderType1 = this.reminderFactory.createReminderType();
        Entity reminderType2 = (Entity)this.reminderFactory.newReminderType().defaultInterval(1, DateUnits.YEARS).addSpecies("CANINE").build();
        Entity reminderType3 = (Entity)this.reminderFactory.newReminderType().defaultInterval(1, DateUnits.YEARS).addSpecies("FELINE").build();
        Entity reminderType4 = (Entity)this.reminderFactory.newReminderType().defaultInterval(1, DateUnits.YEARS).addSpecies("CANINE", "FELINE").build();
        Product product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().addProductReminder(reminderType1, 1, DateUnits.YEARS)).addProductReminder(reminderType2, 1, DateUnits.YEARS)).addProductReminder(reminderType3, 1, DateUnits.YEARS)).addProductReminder(reminderType4, 1, DateUnits.YEARS)).build();
        Map matches1 = this.rules.getReminderTypes(product, null);
        Assert.assertEquals((long)4L, (long)matches1.size());
        TestHelper.assertIncluded(matches1.keySet(), reminderType1, reminderType2, reminderType3, reminderType4);
        Map matches2 = this.rules.getReminderTypes(product, "CANINE");
        Assert.assertEquals((long)3L, (long)matches2.size());
        TestHelper.assertIncluded(matches2.keySet(), reminderType1, reminderType2, reminderType4);
        Map matches3 = this.rules.getReminderTypes(product, "FELINE");
        Assert.assertEquals((long)3L, (long)matches3.size());
        TestHelper.assertIncluded(matches3.keySet(), reminderType1, reminderType3, reminderType4);
        Map matches4 = this.rules.getReminderTypes(product, "BOVINE");
        Assert.assertEquals((long)1L, (long)matches4.size());
        TestHelper.assertIncluded(matches4.keySet(), reminderType1);
    }

    @Test
    public void testGetDocumentFormReminderForInvoiceItem() {
        Party patient = this.patientFactory.createPatient();
        DocumentAct form = this.patientFactory.createForm(patient);
        Assert.assertNull((Object)this.rules.getDocumentFormReminder(form));
        FinancialAct item = (FinancialAct)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)this.accountFactory.newInvoiceItem().patient(patient)).medicationProduct()).quantity(1)).unitPrice(1)).addDocument(form).build();
        Assert.assertNull((Object)this.rules.getDocumentFormReminder(form));
        Entity reminderType1 = this.reminderFactory.createReminderType();
        Act reminder1 = (Act)this.newReminder(patient, reminderType1).dueDate("2012-01-12").build();
        this.accountFactory.updateInvoiceItem(item).addReminders(reminder1).build();
        Assert.assertEquals((Object)reminder1, (Object)this.rules.getDocumentFormReminder(form));
        Entity reminderType2 = this.reminderFactory.createReminderType();
        Act reminder2 = (Act)this.newReminder(patient, reminderType2).dueDate("2012-01-11").build();
        this.accountFactory.updateInvoiceItem(item).addReminders(reminder2).build();
        Assert.assertEquals((Object)reminder2, (Object)this.rules.getDocumentFormReminder(form));
        Entity reminderType3 = this.reminderFactory.createReminderType();
        Act reminder3 = (Act)this.newReminder(patient, reminderType3).dueDate("2012-01-11").build();
        this.accountFactory.updateInvoiceItem(item).addReminders(reminder3).build();
        Assert.assertEquals((Object)reminder2, (Object)this.rules.getDocumentFormReminder(form));
    }

    @Test
    public void testGetDocumentFormReminderForProduct() {
        Party patient = this.patientFactory.createPatient();
        Product product = this.productFactory.createMedication();
        DocumentAct form = (DocumentAct)((TestPatientFormBuilder)this.patientFactory.newForm().patient(patient)).template().product(product).build();
        Assert.assertNull((Object)this.rules.getDocumentFormReminder(form));
        Entity reminderType1 = this.reminderFactory.createReminderType();
        TestMedicationProductBuilder productBuilder = this.productFactory.updateMedication(product);
        ((TestMedicationProductBuilder)productBuilder.addProductReminder(reminderType1, 2, DateUnits.YEARS)).build();
        EntityLink productReminder1 = productBuilder.getProductReminders().get(0);
        Act reminder1 = this.rules.getDocumentFormReminder(form);
        Assert.assertNotNull((Object)reminder1);
        Assert.assertTrue((boolean)reminder1.isNew());
        Date dueDate1 = this.rules.calculateProductReminderDueDate(form.getActivityStartTime(), (Relationship)productReminder1);
        this.checkReminder(reminder1, reminderType1, patient, product, dueDate1);
        Entity reminderType2 = this.reminderFactory.createReminderType();
        ((TestMedicationProductBuilder)productBuilder.addProductReminder(reminderType2, 1, DateUnits.YEARS)).build();
        Relationship productReminder2 = (Relationship)productBuilder.getProductReminders().get(0);
        Date dueDate2 = this.rules.calculateProductReminderDueDate(form.getActivityStartTime(), productReminder2);
        Assert.assertTrue((dueDate2.compareTo(dueDate1) < 0 ? 1 : 0) != 0);
        Act reminder2 = this.rules.getDocumentFormReminder(form);
        Assert.assertNotNull((Object)reminder2);
        Assert.assertTrue((boolean)reminder2.isNew());
        this.checkReminder(reminder2, reminderType2, patient, product, dueDate2);
    }

    @Test
    public void testGetDocumentFormReminderForInvoiceAndProduct() {
        Entity reminderType1 = this.reminderFactory.createReminderType();
        TestMedicationProductBuilder productBuilder = this.productFactory.newMedication();
        Product product = (Product)((TestMedicationProductBuilder)productBuilder.addProductReminder(reminderType1, 1, DateUnits.YEARS)).build();
        Party patient = this.patientFactory.createPatient();
        DocumentAct form = (DocumentAct)((TestPatientFormBuilder)this.patientFactory.newForm().patient(patient)).template().product(product).build();
        EntityLink relationship = productBuilder.getProductReminders().get(0);
        Date dueDate1 = this.rules.calculateProductReminderDueDate(form.getActivityStartTime(), (Relationship)relationship);
        Act reminder1 = this.rules.getDocumentFormReminder(form);
        Assert.assertNotNull((Object)reminder1);
        Assert.assertTrue((boolean)reminder1.isNew());
        this.checkReminder(reminder1, reminderType1, patient, product, dueDate1);
        FinancialAct item = (FinancialAct)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)this.accountFactory.newInvoiceItem().patient(patient)).product(product)).unitPrice(1)).addDocument(form).build();
        Entity reminderType2 = this.reminderFactory.createReminderType();
        Act reminder2 = (Act)this.newReminder(patient, reminderType2).dueDate("2012-01-12").build();
        this.accountFactory.updateInvoiceItem(item).addReminders(reminder2).build();
        Assert.assertEquals((Object)reminder2, (Object)this.rules.getDocumentFormReminder(form));
    }

    @Test
    public void testGetDueState() {
        Lookup group = this.reminderFactory.createReminderGroup();
        Party patient = this.patientFactory.createPatient();
        Entity reminderType = (Entity)this.reminderFactory.newReminderType().defaultInterval(1, DateUnits.MONTHS).addGroups(group.getCode()).build();
        Date start = TestHelper.getDate("2012-01-01");
        Date due = this.rules.calculateReminderDueDate(start, reminderType);
        Act reminder = (Act)this.newReminder(patient, reminderType).date(start).build();
        Assert.assertEquals((Object)due, (Object)reminder.getActivityStartTime());
        Assert.assertEquals((Object)due, (Object)reminder.getActivityEndTime());
        Assert.assertEquals((Object)ReminderRules.DueState.NOT_DUE, (Object)this.rules.getDueState(reminder, TestHelper.getDate("2012-01-01")));
        Assert.assertEquals((Object)ReminderRules.DueState.NOT_DUE, (Object)this.rules.getDueState(reminder, TestHelper.getDate("2012-01-31")));
        Assert.assertEquals((Object)ReminderRules.DueState.DUE, (Object)this.rules.getDueState(reminder, TestHelper.getDate("2012-02-01")));
        Assert.assertEquals((Object)ReminderRules.DueState.OVERDUE, (Object)this.rules.getDueState(reminder, TestHelper.getDate("2012-02-02")));
        this.reminderFactory.updateReminderType(reminderType).sensitivityInterval(5, DateUnits.DAYS).build();
        Assert.assertEquals((Object)ReminderRules.DueState.NOT_DUE, (Object)this.rules.getDueState(reminder, TestHelper.getDate("2012-01-01")));
        Assert.assertEquals((Object)ReminderRules.DueState.DUE, (Object)this.rules.getDueState(reminder, TestHelper.getDate("2012-01-27")));
        Assert.assertEquals((Object)ReminderRules.DueState.DUE, (Object)this.rules.getDueState(reminder, TestHelper.getDate("2012-02-01")));
        Assert.assertEquals((Object)ReminderRules.DueState.DUE, (Object)this.rules.getDueState(reminder, TestHelper.getDate("2012-02-06")));
        Assert.assertEquals((Object)ReminderRules.DueState.OVERDUE, (Object)this.rules.getDueState(reminder, TestHelper.getDate("2012-02-07")));
    }

    @Test
    public void testCalculateProductReminderDueDateForMissingPeriodUOM() {
        Entity reminderType = this.reminderFactory.createReminderType();
        TestMedicationProductBuilder productBuilder = this.productFactory.newMedication();
        ((TestMedicationProductBuilder)productBuilder.addProductReminder(reminderType, 1, DateUnits.MONTHS)).build();
        EntityLink productReminder = productBuilder.getProductReminders().get(0);
        Date start = TestHelper.getDate("2015-03-25");
        Date due1 = this.rules.calculateProductReminderDueDate(start, (Relationship)productReminder);
        Assert.assertEquals((Object)TestHelper.getDate("2015-04-25"), (Object)due1);
        this.getBean((IMObject)productReminder).setValue("periodUom", null);
        Date due2 = this.rules.calculateProductReminderDueDate(start, (Relationship)productReminder);
        Assert.assertEquals((Object)TestHelper.getDate("2016-03-25"), (Object)due2);
    }

    @Test
    public void testGetReminders() {
        Party patient = this.patientFactory.createPatient();
        Entity reminderType = this.reminderFactory.createReminderType();
        Act reminder1 = this.createReminder(patient, reminderType, "2016-04-13 11:59:59", "IN_PROGRESS");
        Act reminder2 = this.createReminder(patient, reminderType, "2016-04-14 10:10:10", "IN_PROGRESS");
        Act reminder3 = this.createReminder(patient, reminderType, "2016-04-14 11:10:10", "COMPLETED");
        Act reminder4 = this.createReminder(patient, reminderType, "2016-04-15 10:10:10", "CANCELLED");
        Act reminder5 = this.createReminder(patient, reminderType, "2016-04-15 11:00:00", "IN_PROGRESS");
        List<Act> acts = this.getActs(this.rules.getReminders(patient, TestHelper.getDatetime("2016-04-14 10:00:00"), TestHelper.getDatetime("2016-04-15 11:00:00")));
        Assert.assertEquals((long)3L, (long)acts.size());
        Assert.assertFalse((boolean)acts.contains(reminder1));
        Assert.assertTrue((boolean)acts.contains(reminder2));
        Assert.assertTrue((boolean)acts.contains(reminder3));
        Assert.assertTrue((boolean)acts.contains(reminder4));
        Assert.assertFalse((boolean)acts.contains(reminder5));
    }

    @Test
    public void testGetRemindersForProductType() {
        Party patient = this.patientFactory.createPatient();
        Entity productType1 = this.productFactory.createProductType("Z Vaccination 1");
        Entity productType2 = this.productFactory.createProductType("Z Vaccination 2");
        Product product1 = this.productFactory.createMedication(productType1);
        Product product2 = this.productFactory.createMedication(productType2);
        Product product3 = this.productFactory.createMedication();
        Entity reminderType = this.reminderFactory.createReminderType();
        Act reminder1 = this.createReminder(patient, reminderType, product1, "2016-04-13 11:59:59", "IN_PROGRESS");
        Act reminder2 = this.createReminder(patient, reminderType, product2, "2016-04-14 10:10:10", "IN_PROGRESS");
        Act reminder3 = this.createReminder(patient, reminderType, product1, "2016-04-14 11:10:10", "COMPLETED");
        Act reminder4 = this.createReminder(patient, reminderType, product3, "2016-04-15 10:10:10", "CANCELLED");
        Act reminder5 = this.createReminder(patient, reminderType, product1, "2016-04-15 11:00:00", "IN_PROGRESS");
        List<Act> acts1 = this.getActs(this.rules.getReminders(patient, productType1.getName(), TestHelper.getDatetime("2016-04-14 10:00:00"), TestHelper.getDatetime("2016-04-15 11:00:00")));
        Assert.assertEquals((long)1L, (long)acts1.size());
        Assert.assertFalse((boolean)acts1.contains(reminder1));
        Assert.assertFalse((boolean)acts1.contains(reminder2));
        Assert.assertTrue((boolean)acts1.contains(reminder3));
        Assert.assertFalse((boolean)acts1.contains(reminder4));
        Assert.assertFalse((boolean)acts1.contains(reminder5));
        List<Act> acts2 = this.getActs(this.rules.getReminders(patient, productType2.getName(), TestHelper.getDatetime("2016-04-14 10:00:00"), TestHelper.getDatetime("2016-04-15 11:00:00")));
        Assert.assertEquals((long)1L, (long)acts2.size());
        Assert.assertTrue((boolean)acts2.contains(reminder2));
        List<Act> acts3 = this.getActs(this.rules.getReminders(patient, "Z Vacc*", TestHelper.getDatetime("2016-04-14 10:00:00"), TestHelper.getDatetime("2016-04-15 11:00:00")));
        Assert.assertEquals((long)2L, (long)acts3.size());
        Assert.assertTrue((boolean)acts3.contains(reminder2));
        Assert.assertTrue((boolean)acts3.contains(reminder3));
    }

    @Test
    public void testMarkMatchingAlertsCompleted() {
        Entity alertTypeA = this.patientFactory.createAlertType();
        Entity alertTypeB = this.patientFactory.createAlertType();
        Party patient1 = this.patientFactory.createPatient();
        Party patient2 = this.patientFactory.createPatient();
        Act alert0 = this.patientFactory.createAlert(patient1, alertTypeA);
        this.rules.markMatchingAlertsCompleted(alert0);
        this.checkAlert(alert0, "IN_PROGRESS");
        Act alert1 = this.patientFactory.createAlert(patient1, alertTypeB);
        this.rules.markMatchingAlertsCompleted(alert1);
        this.checkAlert(alert1, "IN_PROGRESS");
        this.checkAlert(alert0, "IN_PROGRESS");
        Act alert2 = this.patientFactory.createAlert(patient2, alertTypeA);
        this.rules.markMatchingAlertsCompleted(alert2);
        this.checkAlert(alert2, "IN_PROGRESS");
        this.checkAlert(alert1, "IN_PROGRESS");
        this.checkAlert(alert0, "IN_PROGRESS");
        Act alert3 = this.patientFactory.createAlert(patient1, alertTypeB);
        this.rules.markMatchingAlertsCompleted(alert3);
        this.checkAlert(alert3, "IN_PROGRESS");
        this.checkAlert(alert1, "COMPLETED");
    }

    @Test
    public void testMarkMatchingAlertsCompletedForList() {
        Entity alertType = this.patientFactory.createAlertType();
        Party patient1 = this.patientFactory.createPatient();
        Party patient2 = this.patientFactory.createPatient();
        Act alert0 = this.patientFactory.createAlert(patient1, alertType);
        Act alert1 = this.patientFactory.createAlert(patient2, alertType);
        Act alert2 = this.patientFactory.createAlert(patient1, alertType);
        Act alert3 = this.patientFactory.createAlert(patient2, alertType);
        Act alert3dup = this.patientFactory.createAlert(patient2, alertType);
        List<Act> alerts = Arrays.asList(alert2, alert3, alert3dup);
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        template.execute(status -> {
            this.rules.markMatchingAlertsCompleted(alerts);
            return null;
        });
        this.checkAlert(alert0, "COMPLETED");
        this.checkAlert(alert1, "COMPLETED");
        this.checkAlert(alert2, "IN_PROGRESS");
        this.checkAlert(alert3, "IN_PROGRESS");
        this.checkAlert(alert3dup, "COMPLETED");
    }

    @Test
    public void testCopyReminderType() {
        Entity template1 = this.documentFactory.createTemplate("act.patientDocumentForm");
        Entity template2 = this.documentFactory.createTemplate("act.patientDocumentForm");
        Entity template3 = this.documentFactory.createTemplate("act.patientDocumentForm");
        Entity template4 = this.documentFactory.createTemplate("act.patientDocumentForm");
        Lookup group = this.reminderFactory.createReminderGroup();
        Entity reminderType = (Entity)((TestReminderTypeBuilder)((TestReminderTypeBuilder)this.reminderFactory.newReminderType().name("Vaccination")).description("Vaccination reminder")).groupBy(ReminderType.GroupBy.PATIENT).interactive(true).defaultInterval(1, DateUnits.YEARS).cancelInterval(2, DateUnits.WEEKS).sensitivityInterval(5, DateUnits.DAYS).addSpecies("CANINE").addGroups(group).newCount().count(0).interval(-1, DateUnits.MONTHS).template(template1).newRule().email().add().add().newCount().count(1).interval(-2, DateUnits.WEEKS).template(template2).newRule().sms().add().add().newCount().count(2).interval(0, DateUnits.DAYS).template(template3).newRule().print().add().add().newCount().count(3).interval(1, DateUnits.MONTHS).template(template4).newRule().sendTo(ReminderRule.SendTo.ANY).contact().export().list().add().add().build();
        IMObjectGraph graph = this.rules.copyReminderType(reminderType);
        IMObjectGraphVerifier verifier = new IMObjectGraphVerifier();
        verifier.primaryArchetype("entity.reminderType").count("entity.reminderType", 1).count("entity.reminderCount", 4).count("entity.reminderRule", 4).verify(graph);
        for (IMObject object : graph.getObjects()) {
            Assert.assertTrue((boolean)object.isNew());
            Assert.assertTrue((boolean)object.isActive());
        }
        this.save(graph.getObjects());
        Entity copy = (Entity)graph.getPrimary(Entity.class);
        Assert.assertEquals((Object)"Vaccination", (Object)copy.getName());
        Assert.assertEquals((Object)"Vaccination reminder", (Object)copy.getDescription());
        Assert.assertTrue((boolean)copy.isActive());
        ReminderType type = new ReminderType(copy, (ArchetypeService)this.getArchetypeService());
        IMObjectBean copyBean = this.getBean((IMObject)copy);
        List species = copyBean.getValues("species", Lookup.class);
        Assert.assertEquals((long)1L, (long)species.size());
        Assert.assertEquals((Object)"CANINE", (Object)((Lookup)species.get(0)).getCode());
        Assert.assertEquals((Object)ReminderType.GroupBy.PATIENT, (Object)type.getGroupBy());
        Assert.assertEquals((long)4L, (long)type.getReminderCounts().size());
        Assert.assertEquals((long)1L, (long)type.getDefaultInterval());
        Assert.assertEquals((Object)DateUnits.YEARS, (Object)type.getDefaultUnits());
        Assert.assertEquals((long)2L, (long)type.getCancelInterval());
        Assert.assertEquals((Object)DateUnits.WEEKS, (Object)type.getCancelUnits());
        Assert.assertEquals((long)5L, (long)copyBean.getInt("sensitivityInterval"));
        Assert.assertEquals((Object)DateUnits.DAYS, (Object)DateUnits.fromString((String)copyBean.getString("sensitivityUnits")));
        Assert.assertTrue((boolean)type.isInteractive());
        Assert.assertEquals((long)1L, (long)type.getGroups().size());
        Assert.assertEquals((Object)group, type.getGroups().get(0));
        List<ReminderRule> rules1 = this.checkCount(type, 0, -1, DateUnits.MONTHS, template1);
        Assert.assertEquals((long)1L, (long)rules1.size());
        this.checkRule(rules1.get(0), false, true, false, false, false, false, ReminderRule.SendTo.FIRST);
        List<ReminderRule> rules2 = this.checkCount(type, 1, -2, DateUnits.WEEKS, template2);
        Assert.assertEquals((long)1L, (long)rules2.size());
        this.checkRule(rules2.get(0), false, false, true, false, false, false, ReminderRule.SendTo.FIRST);
        List<ReminderRule> rules3 = this.checkCount(type, 2, 0, DateUnits.DAYS, template3);
        Assert.assertEquals((long)1L, (long)rules3.size());
        this.checkRule(rules3.get(0), false, false, false, true, false, false, ReminderRule.SendTo.FIRST);
        List<ReminderRule> rules4 = this.checkCount(type, 3, 1, DateUnits.MONTHS, template4);
        Assert.assertEquals((long)1L, (long)rules4.size());
        this.checkRule(rules4.get(0), true, false, false, false, true, true, ReminderRule.SendTo.ANY);
        Set<Entity> originalObjects = this.getReminderTypeObjects(reminderType);
        Set<Entity> copyObjects = this.getReminderTypeObjects(copy);
        Assert.assertEquals((long)9L, (long)originalObjects.size());
        Assert.assertEquals((long)originalObjects.size(), (long)copyObjects.size());
        for (Entity object : originalObjects) {
            Assert.assertFalse((boolean)copyObjects.contains(object));
        }
    }

    private List<ReminderRule> checkCount(ReminderType type, int count, int interval, DateUnits units, Entity template) {
        ReminderCount actual = type.getReminderCount(count);
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((long)interval, (long)actual.getInterval());
        Assert.assertEquals((Object)units, (Object)actual.getUnits());
        Assert.assertEquals((Object)template, (Object)actual.getTemplate().getEntity());
        return actual.getRules();
    }

    private void checkRule(ReminderRule rule, boolean contact, boolean email, boolean sms, boolean print, boolean export, boolean list, ReminderRule.SendTo sendTo) {
        Assert.assertEquals((Object)contact, (Object)rule.isContact());
        Assert.assertEquals((Object)email, (Object)rule.isEmail());
        Assert.assertEquals((Object)sms, (Object)rule.isSMS());
        Assert.assertEquals((Object)print, (Object)rule.isPrint());
        Assert.assertEquals((Object)export, (Object)rule.isExport());
        Assert.assertEquals((Object)list, (Object)rule.isList());
        Assert.assertEquals((Object)(sendTo == null ? ReminderRule.SendTo.ANY : sendTo), (Object)rule.getSendTo());
    }

    private Set<Entity> getReminderTypeObjects(Entity reminderType) {
        HashSet<Entity> set = new HashSet<Entity>();
        set.add(reminderType);
        for (Entity count : this.getBean((IMObject)reminderType).getTargets("counts", Entity.class)) {
            set.add(count);
            set.addAll(this.getBean((IMObject)count).getTargets("rules", Entity.class));
        }
        return set;
    }

    private List<Act> getActs(Iterable<Act> acts) {
        ArrayList<Act> result = new ArrayList<Act>();
        CollectionUtils.addAll(result, acts);
        return result;
    }

    private Act createReminder(Party patient, Entity reminderType, String date, String status) {
        return (Act)this.newReminder(patient, reminderType, date, status).build();
    }

    private Act createReminder(Party patient, Entity reminderType, Product product, String date, String status) {
        return (Act)this.newReminder(patient, reminderType, date, status).product(product).build();
    }

    private void checkReminder(Act reminder, Entity reminderType, Party patient, Product product, Date dueDate) {
        IMObjectBean bean = this.getBean((IMObject)reminder);
        Assert.assertEquals((Object)patient, (Object)bean.getTarget("patient"));
        Assert.assertEquals((Object)reminderType, (Object)bean.getTarget("reminderType"));
        Assert.assertEquals((Object)product, (Object)bean.getTarget("product"));
        Assert.assertEquals((Object)dueDate, (Object)reminder.getActivityStartTime());
        Assert.assertEquals((Object)dueDate, (Object)reminder.getActivityEndTime());
    }

    private Act createReminder(Party patient, Lookup ... groups) {
        Entity reminderType = (Entity)this.reminderFactory.newReminderType().defaultInterval(1, DateUnits.MONTHS).addGroups(groups).build();
        return this.createReminder(patient, reminderType);
    }

    private Act createReminder(Party patient, Entity reminderType) {
        return (Act)this.newReminder(patient, reminderType).build();
    }

    private TestReminderBuilder newReminder(Party patient, Entity reminderType, String date, String status) {
        return (TestReminderBuilder)this.newReminder(patient, reminderType).date(date).status(status);
    }

    private TestReminderBuilder newReminder(Party patient, Entity reminderType) {
        return ((TestReminderBuilder)this.reminderFactory.newReminder().patient(patient)).reminderType(reminderType);
    }

    private void checkReminder(Act reminder, String status) {
        reminder = this.get(reminder);
        Assert.assertNotNull((Object)reminder);
        Assert.assertEquals((Object)status, (Object)reminder.getStatus());
        IMObjectBean bean = this.getBean((IMObject)reminder);
        Date date = bean.getDate("completedDate");
        if ("COMPLETED".equals(status)) {
            Assert.assertNotNull((Object)date);
        } else {
            Assert.assertNull((Object)date);
        }
    }

    private void checkAlert(Act alert, String status) {
        alert = this.get(alert);
        Assert.assertNotNull((Object)alert);
        Assert.assertEquals((Object)status, (Object)alert.getStatus());
        if ("COMPLETED".equals(status)) {
            Assert.assertNotNull((Object)alert.getActivityEndTime());
        }
    }

    private void checkCalculateReminderDueDate(int defaultInterval, DateUnits defaultUnits, String startDate, String expectedDate) {
        Lookup group = this.reminderFactory.createReminderGroup();
        Entity reminderType = (Entity)this.reminderFactory.newReminderType().defaultInterval(defaultInterval, defaultUnits).addGroups(group).build();
        Date start = TestHelper.getDate(startDate);
        Date expected = TestHelper.getDate(expectedDate);
        Date to = this.rules.calculateReminderDueDate(start, reminderType);
        Assert.assertEquals((Object)expected, (Object)to);
    }

    private void checkCalculateProductReminderDueDate(int period, DateUnits units, String startDate, String expectedDate) {
        Relationship relationship = this.create("entityLink.productReminder", Relationship.class);
        IMObjectBean bean = this.getBean((IMObject)relationship);
        bean.setValue("period", (Object)period);
        bean.setValue("periodUom", (Object)units.toString());
        Date start = TestHelper.getDate(startDate);
        Date expected = TestHelper.getDate(expectedDate);
        Date to = this.rules.calculateProductReminderDueDate(start, relationship);
        Assert.assertEquals((Object)expected, (Object)to);
    }

    private void checkShouldCancel(Act reminder, String date, boolean expected) {
        Assert.assertEquals((Object)expected, (Object)this.rules.shouldCancel(reminder, TestHelper.getDate(date)));
    }
}

