/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.reminder;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.reminder.PagedReminderItemIterator;
import org.openvpms.archetype.rules.patient.reminder.ReminderItemQueryFactory;
import org.openvpms.archetype.rules.patient.reminder.ReminderTestHelper;
import org.openvpms.archetype.rules.practice.Location;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ObjectSet;

public class PagedReminderItemIteratorTestCase
extends ArchetypeServiceTest {
    @Test
    public void testIteration() {
        int total = 15;
        ReminderItemQueryFactory factory = this.createItems(total);
        for (int pageSize = 1; pageSize <= total + 1; ++pageSize) {
            this.checkCount(total, factory, pageSize);
        }
    }

    @Test
    public void testUpdateAll() {
        int total = 15;
        IArchetypeService service = this.getArchetypeService();
        for (int pageSize = 1; pageSize <= total + 1; ++pageSize) {
            ReminderItemQueryFactory factory = this.createItems(total);
            PagedReminderItemIterator iterator = new PagedReminderItemIterator(factory, pageSize, service);
            int count = this.update(iterator, 1);
            Assert.assertEquals((long)total, (long)count);
            factory.setStatus("COMPLETED");
            this.checkCount(total, factory, pageSize);
            factory.setStatus("PENDING");
            this.checkCount(0, factory, pageSize);
        }
    }

    @Test
    public void testUpdateEverySecond() {
        int total = 15;
        IArchetypeService service = this.getArchetypeService();
        for (int pageSize = 1; pageSize <= total + 1; ++pageSize) {
            ReminderItemQueryFactory factory = this.createItems(total);
            PagedReminderItemIterator iterator = new PagedReminderItemIterator(factory, pageSize, service);
            int count = this.update(iterator, 2);
            Assert.assertEquals((long)total, (long)count);
            factory.setStatus("COMPLETED");
            this.checkCount(7, factory, pageSize);
            factory.setStatus("PENDING");
            this.checkCount(8, factory, pageSize);
        }
    }

    private void checkCount(int expectedCount, ReminderItemQueryFactory factory, int pageSize) {
        PagedReminderItemIterator iterator = new PagedReminderItemIterator(factory, pageSize, this.getArchetypeService());
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        Assert.assertEquals((long)expectedCount, (long)count);
    }

    private int update(PagedReminderItemIterator iterator, int completeEvery) {
        int count = 0;
        int i = 0;
        while (iterator.hasNext()) {
            ObjectSet set = (ObjectSet)iterator.next();
            if (++i == completeEvery) {
                i = 0;
                Act item = (Act)set.get("item");
                item.setStatus("COMPLETED");
                this.save((IMObject)item);
                iterator.updated();
            }
            ++count;
        }
        return count;
    }

    private ReminderItemQueryFactory createItems(int count) {
        Entity reminderType = ReminderTestHelper.createReminderType(1, DateUnits.YEARS, new Lookup[0]);
        Party location = TestHelper.createLocation();
        Party customer = TestHelper.createCustomer();
        IMObjectBean bean = this.getBean((IMObject)customer);
        bean.setTarget("practice", (IMObject)location);
        bean.save();
        Party patient = TestHelper.createPatient(customer);
        Date today = DateRules.getToday();
        Date tomorrow = DateRules.getTomorrow();
        for (int i = 0; i < count; ++i) {
            Act item = ReminderTestHelper.createListReminder(today, tomorrow, "PENDING", 0);
            ReminderTestHelper.createReminder(tomorrow, patient, reminderType, item);
        }
        ReminderItemQueryFactory factory = new ReminderItemQueryFactory();
        factory.setStatus("PENDING");
        factory.setLocation(new Location(location));
        return factory;
    }
}

