/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.reminder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.reminder.GroupingReminderIterator;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderGroupingPolicy;
import org.openvpms.archetype.rules.patient.reminder.ReminderItemQueryFactory;
import org.openvpms.archetype.rules.patient.reminder.ReminderTestHelper;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.archetype.rules.patient.reminder.ReminderTypes;
import org.openvpms.archetype.rules.patient.reminder.Reminders;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class GroupingReminderIteratorTestCase
extends ArchetypeServiceTest {
    private Act emailReminderA1;
    private Act smsReminderA1;
    private Act emailReminderA2;
    private Act smsReminderA2;
    private Act printReminderA3;
    private Act emailReminderB1;
    private Act smsReminderB1;
    private Act printReminderB2;
    private Act emailReminderC1;
    private Act emailReminderC2;
    private Act listReminderC3;
    private Act listReminderC4;
    private Act listReminderC5;
    private Act listReminderC6;
    private ReminderItemQueryFactory factory;
    private ReminderTypes reminderTypes;

    @Before
    public void setUp() {
        Date today = DateRules.getToday();
        Date now = new Date();
        Date tomorrow = DateRules.getTomorrow();
        Entity reminderType1 = this.createReminderType("PATIENT");
        Entity reminderType2 = this.createReminderType("CUSTOMER");
        Entity reminderType3 = this.createReminderType("PATIENT");
        Entity reminderType4 = this.createReminderType(null);
        Entity reminderType5 = this.createReminderType(null);
        Party customer1 = TestHelper.createCustomer("B", "B", true);
        Party customer2 = TestHelper.createCustomer("A", "A", true);
        Party patientA = TestHelper.createPatient("Spot", customer1, true);
        Party patientB = TestHelper.createPatient("Fido", customer1, true);
        Party patientC = TestHelper.createPatient("Rukus", customer2, true);
        this.emailReminderA1 = ReminderTestHelper.createEmailReminder(now, tomorrow, "PENDING", 0);
        this.smsReminderA1 = ReminderTestHelper.createSMSReminder(now, tomorrow, "PENDING", 0);
        ReminderTestHelper.createReminder(tomorrow, patientA, reminderType1, this.emailReminderA1, this.smsReminderA1);
        this.emailReminderA2 = ReminderTestHelper.createEmailReminder(now, tomorrow, "PENDING", 0);
        this.smsReminderA2 = ReminderTestHelper.createSMSReminder(now, tomorrow, "PENDING", 0);
        ReminderTestHelper.createReminder(tomorrow, patientA, reminderType1, this.emailReminderA2, this.smsReminderA2);
        this.printReminderA3 = ReminderTestHelper.createPrintReminder(now, tomorrow, "PENDING", 0);
        ReminderTestHelper.createReminder(tomorrow, patientA, reminderType2, this.printReminderA3);
        this.emailReminderB1 = ReminderTestHelper.createEmailReminder(now, tomorrow, "PENDING", 0);
        this.smsReminderB1 = ReminderTestHelper.createSMSReminder(now, tomorrow, "PENDING", 0);
        ReminderTestHelper.createReminder(tomorrow, patientB, reminderType1, this.emailReminderB1, this.smsReminderB1);
        this.printReminderB2 = ReminderTestHelper.createPrintReminder(now, tomorrow, "PENDING", 0);
        ReminderTestHelper.createReminder(tomorrow, patientB, reminderType2, this.printReminderB2);
        this.emailReminderC1 = ReminderTestHelper.createEmailReminder(now, tomorrow, "PENDING", 0);
        ReminderTestHelper.createReminder(tomorrow, patientC, reminderType1, this.emailReminderC1);
        this.emailReminderC2 = ReminderTestHelper.createEmailReminder(now, tomorrow, "PENDING", 0);
        ReminderTestHelper.createReminder(tomorrow, patientC, reminderType3, this.emailReminderC2);
        this.listReminderC3 = ReminderTestHelper.createListReminder(now, tomorrow, "PENDING", 0);
        ReminderTestHelper.createReminder(tomorrow, patientC, reminderType2, this.listReminderC3);
        this.listReminderC4 = ReminderTestHelper.createListReminder(now, tomorrow, "PENDING", 0);
        ReminderTestHelper.createReminder(tomorrow, patientC, reminderType4, this.listReminderC4);
        this.listReminderC5 = ReminderTestHelper.createListReminder(now, tomorrow, "PENDING", 0);
        ReminderTestHelper.createReminder(tomorrow, patientC, reminderType5, this.listReminderC5);
        this.listReminderC6 = ReminderTestHelper.createListReminder(now, tomorrow, "PENDING", 0);
        ReminderTestHelper.createReminder(tomorrow, patientC, reminderType2, this.listReminderC6);
        this.factory = new ReminderItemQueryFactory("act.patientReminderItem*", new String[]{"PENDING"}, today, tomorrow);
        this.reminderTypes = new ReminderTypes((ArchetypeService)this.getArchetypeService());
    }

    @Test
    public void testIterator() {
        GroupingReminderIterator iterator = new GroupingReminderIterator(this.factory, this.reminderTypes, 10, ReminderGroupingPolicy.ALL, ReminderGroupingPolicy.ALL, this.getArchetypeService());
        this.check(iterator, ReminderType.GroupBy.PATIENT, this.emailReminderC1, this.emailReminderC2);
        this.check(iterator, ReminderType.GroupBy.NONE, this.listReminderC3);
        this.check(iterator, ReminderType.GroupBy.NONE, this.listReminderC4);
        this.check(iterator, ReminderType.GroupBy.NONE, this.listReminderC5);
        this.check(iterator, ReminderType.GroupBy.NONE, this.listReminderC6);
        this.check(iterator, ReminderType.GroupBy.PATIENT, this.emailReminderB1);
        this.check(iterator, ReminderType.GroupBy.PATIENT, this.emailReminderA1, this.emailReminderA2);
        this.check(iterator, ReminderType.GroupBy.CUSTOMER, this.printReminderB2, this.printReminderA3);
        this.check(iterator, ReminderType.GroupBy.PATIENT, this.smsReminderB1);
        this.check(iterator, ReminderType.GroupBy.PATIENT, this.smsReminderA1, this.smsReminderA2);
    }

    @Test
    public void testIteratorGroupByCustomerDisabled() {
        GroupingReminderIterator iterator = new GroupingReminderIterator(this.factory, this.reminderTypes, 10, ReminderGroupingPolicy.NONE, ReminderGroupingPolicy.ALL, this.getArchetypeService());
        this.check(iterator, ReminderType.GroupBy.PATIENT, this.emailReminderC1, this.emailReminderC2);
        this.check(iterator, ReminderType.GroupBy.NONE, this.listReminderC3);
        this.check(iterator, ReminderType.GroupBy.NONE, this.listReminderC4);
        this.check(iterator, ReminderType.GroupBy.NONE, this.listReminderC5);
        this.check(iterator, ReminderType.GroupBy.NONE, this.listReminderC6);
        this.check(iterator, ReminderType.GroupBy.PATIENT, this.emailReminderB1);
        this.check(iterator, ReminderType.GroupBy.PATIENT, this.emailReminderA1, this.emailReminderA2);
        this.check(iterator, ReminderType.GroupBy.NONE, this.printReminderB2);
        this.check(iterator, ReminderType.GroupBy.NONE, this.printReminderA3);
        this.check(iterator, ReminderType.GroupBy.PATIENT, this.smsReminderB1);
        this.check(iterator, ReminderType.GroupBy.PATIENT, this.smsReminderA1, this.smsReminderA2);
    }

    @Test
    public void testIteratorGroupByPatientDisabled() {
        GroupingReminderIterator iterator = new GroupingReminderIterator(this.factory, this.reminderTypes, 10, ReminderGroupingPolicy.ALL, ReminderGroupingPolicy.NONE, this.getArchetypeService());
        this.check(iterator, ReminderType.GroupBy.NONE, this.emailReminderC1);
        this.check(iterator, ReminderType.GroupBy.NONE, this.emailReminderC2);
        this.check(iterator, ReminderType.GroupBy.NONE, this.listReminderC3);
        this.check(iterator, ReminderType.GroupBy.NONE, this.listReminderC4);
        this.check(iterator, ReminderType.GroupBy.NONE, this.listReminderC5);
        this.check(iterator, ReminderType.GroupBy.NONE, this.listReminderC6);
        this.check(iterator, ReminderType.GroupBy.NONE, this.emailReminderB1);
        this.check(iterator, ReminderType.GroupBy.NONE, this.emailReminderA1);
        this.check(iterator, ReminderType.GroupBy.NONE, this.emailReminderA2);
        this.check(iterator, ReminderType.GroupBy.CUSTOMER, this.printReminderB2, this.printReminderA3);
        this.check(iterator, ReminderType.GroupBy.NONE, this.smsReminderB1);
        this.check(iterator, ReminderType.GroupBy.NONE, this.smsReminderA1);
        this.check(iterator, ReminderType.GroupBy.NONE, this.smsReminderA2);
    }

    @Test
    public void testIteratorGroupBySMSDisabled() {
        ReminderGroupingPolicy noSMS = ReminderGroupingPolicy.getPolicy((boolean)true, (boolean)true, (boolean)false);
        GroupingReminderIterator iterator = new GroupingReminderIterator(this.factory, this.reminderTypes, 10, noSMS, noSMS, this.getArchetypeService());
        this.check(iterator, ReminderType.GroupBy.PATIENT, this.emailReminderC1, this.emailReminderC2);
        this.check(iterator, ReminderType.GroupBy.NONE, this.listReminderC3);
        this.check(iterator, ReminderType.GroupBy.NONE, this.listReminderC4);
        this.check(iterator, ReminderType.GroupBy.NONE, this.listReminderC5);
        this.check(iterator, ReminderType.GroupBy.NONE, this.listReminderC6);
        this.check(iterator, ReminderType.GroupBy.PATIENT, this.emailReminderB1);
        this.check(iterator, ReminderType.GroupBy.PATIENT, this.emailReminderA1, this.emailReminderA2);
        this.check(iterator, ReminderType.GroupBy.CUSTOMER, this.printReminderB2, this.printReminderA3);
        this.check(iterator, ReminderType.GroupBy.NONE, this.smsReminderB1);
        this.check(iterator, ReminderType.GroupBy.NONE, this.smsReminderA1);
        this.check(iterator, ReminderType.GroupBy.NONE, this.smsReminderA2);
    }

    @Test
    public void testUpdate() {
        GroupingReminderIterator iterator = new GroupingReminderIterator(this.factory, this.reminderTypes, 2, ReminderGroupingPolicy.ALL, ReminderGroupingPolicy.ALL, this.getArchetypeService());
        this.complete(iterator, ReminderType.GroupBy.PATIENT, this.emailReminderC1, this.emailReminderC2);
        this.complete(iterator, ReminderType.GroupBy.NONE, this.listReminderC3);
        this.complete(iterator, ReminderType.GroupBy.NONE, this.listReminderC4);
        this.complete(iterator, ReminderType.GroupBy.NONE, this.listReminderC5);
        this.complete(iterator, ReminderType.GroupBy.NONE, this.listReminderC6);
        this.complete(iterator, ReminderType.GroupBy.PATIENT, this.emailReminderB1);
        this.complete(iterator, ReminderType.GroupBy.PATIENT, this.emailReminderA1, this.emailReminderA2);
        this.complete(iterator, ReminderType.GroupBy.CUSTOMER, this.printReminderB2, this.printReminderA3);
        this.complete(iterator, ReminderType.GroupBy.PATIENT, this.smsReminderB1);
        this.complete(iterator, ReminderType.GroupBy.PATIENT, this.smsReminderA1, this.smsReminderA2);
    }

    private void check(GroupingReminderIterator iterator, ReminderType.GroupBy groupBy, Act ... expected) {
        List<Act> list = Arrays.asList(expected);
        boolean found = false;
        while (iterator.hasNext()) {
            Reminders sets = iterator.next();
            List<Act> next = this.getItems(sets.getReminders());
            if (!next.equals(list)) continue;
            Assert.assertEquals((Object)groupBy, (Object)sets.getGroupBy());
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found);
    }

    private void complete(GroupingReminderIterator iterator, ReminderType.GroupBy groupBy, Act ... expected) {
        this.check(iterator, groupBy, expected);
        for (Act act : expected) {
            act.setStatus("COMPLETED");
            this.save((IMObject)act);
        }
        iterator.updated();
    }

    private List<Act> getItems(List<ReminderEvent> events) {
        ArrayList<Act> result = new ArrayList<Act>();
        for (ReminderEvent event : events) {
            result.add(event.getItem());
        }
        return result;
    }

    private Entity createReminderType(String groupBy) {
        Entity result = ReminderTestHelper.createReminderType(1, DateUnits.YEARS, new Lookup[0]);
        IMObjectBean bean = this.getBean((IMObject)result);
        bean.setValue("groupBy", (Object)groupBy);
        bean.save();
        return result;
    }
}

