/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.prescription;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.prescription.PrescriptionRules;
import org.openvpms.archetype.rules.patient.prescription.PrescriptionTestHelper;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;

public class PrescriptionRulesTestCase
extends ArchetypeServiceTest {
    private PrescriptionRules rules;
    private Party patient;
    private Product product;
    private User clinician;

    @Before
    public void setUp() {
        this.rules = new PrescriptionRules(this.getArchetypeService());
        this.patient = TestHelper.createPatient();
        this.product = TestHelper.createProduct();
        this.clinician = TestHelper.createClinician();
    }

    @Test
    public void testCanDispense() {
        Act act1 = this.createPrescription(1, 1, DateRules.getToday());
        Act act2 = this.createPrescription(1, 1, DateRules.getTomorrow());
        Act act3 = this.createPrescription(1, 1, DateRules.getYesterday());
        Assert.assertTrue((boolean)this.rules.canDispense(act1));
        Assert.assertTrue((boolean)this.rules.canDispense(act2));
        Assert.assertFalse((boolean)this.rules.canDispense(act3));
        this.dispense(act1, 1);
        this.dispense(act1, 1);
        Assert.assertFalse((boolean)this.rules.canDispense(act1));
        this.dispense(act2, 1);
        Assert.assertTrue((boolean)this.rules.canDispense(act2));
        this.dispense(act2, 1);
        Assert.assertFalse((boolean)this.rules.canDispense(act2));
    }

    @Test
    public void testQuantity() {
        Act act = this.createPrescription(2, 5, DateRules.getTomorrow());
        this.checkEquals(new BigDecimal("2"), this.rules.getQuantity(act));
    }

    @Test
    public void testRepeats() {
        Act act = this.createPrescription(2, 5, DateRules.getTomorrow());
        Assert.assertEquals((long)5L, (long)this.rules.getRepeats(act));
    }

    @Test
    public void testDispensed() {
        Act act1 = this.createPrescription(2, 0, DateRules.getTomorrow());
        Act act2 = this.createPrescription(2, 5, DateRules.getTomorrow());
        Assert.assertEquals((long)0L, (long)this.rules.getDispensed(act1));
        this.dispense(act1, 2);
        Assert.assertEquals((long)1L, (long)this.rules.getDispensed(act1));
        this.dispense(act2, 2);
        this.dispense(act2, 2);
        this.dispense(act2, 2);
        Assert.assertEquals((long)3L, (long)this.rules.getDispensed(act2));
    }

    @Test
    public void testGetPrescription() {
        Date yesterday = DateRules.getYesterday();
        Date today = DateRules.getToday();
        Act act1 = this.createPrescription(1, 1, today);
        Act act2 = this.createPrescription(1, 1, DateRules.getTomorrow());
        Act act3 = this.createPrescription(1, 1, yesterday);
        Assert.assertEquals((Object)act1, (Object)this.rules.getPrescription(this.patient, this.product));
        Assert.assertEquals((Object)act1, (Object)this.rules.getPrescription(this.patient, this.product, today));
        Assert.assertEquals((Object)act2, (Object)this.rules.getPrescription(this.patient, this.product, Collections.singletonList(act1)));
        Assert.assertEquals((Object)act2, (Object)this.rules.getPrescription(this.patient, this.product, today, Collections.singletonList(act1)));
        this.dispense(act1, 1);
        this.dispense(act1, 1);
        Assert.assertEquals((Object)act2, (Object)this.rules.getPrescription(this.patient, this.product));
        this.dispense(act2, 1);
        this.dispense(act2, 1);
        Assert.assertNull((Object)this.rules.getPrescription(this.patient, this.product));
        Assert.assertEquals((Object)act3, (Object)this.rules.getPrescription(this.patient, this.product, yesterday));
        this.dispense(act3, 1);
        this.dispense(act3, 1);
        Assert.assertNull((Object)this.rules.getPrescription(this.patient, this.product, yesterday));
    }

    private void dispense(Act prescription, int quantity) {
        this.dispense(prescription, BigDecimal.valueOf(quantity));
    }

    private void dispense(Act prescription, BigDecimal quantity) {
        Act medication = this.create("act.patientMedication", Act.class);
        IMObjectBean bean = this.getBean((IMObject)prescription);
        bean.addTarget("dispensing", (IMObject)medication, "prescription");
        IMObjectBean medBean = this.getBean((IMObject)medication);
        medBean.setValue("quantity", (Object)quantity);
        medBean.setTarget("patient", (IMObject)this.patient);
        medBean.setTarget("product", (IMObject)this.product);
        this.save((IMObject[])new Act[]{prescription, medication});
    }

    private Act createPrescription(int quantity, int repeats, Date expiryDate) {
        return PrescriptionTestHelper.createPrescription(this.patient, this.product, this.clinician, quantity, repeats, expiryDate);
    }
}

