/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.text.WordUtils;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.helper.IMObjectBean;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;

public class PatientTestHelper {
    public static Party createPatient(String name, String species, String breed, Date dateOfBirth, Party owner) {
        Party patient = TestHelper.createPatient(owner);
        patient.setName(name);
        Lookup speciesLookup = TestHelper.getLookup("lookup.species", species, WordUtils.capitalize((String)species.toLowerCase()), true);
        Lookup breedLookup = TestHelper.getLookup("lookup.breed", breed, speciesLookup, "lookupRelationship.speciesBreed");
        breedLookup.setName(WordUtils.capitalize((String)breed.toLowerCase()));
        TestHelper.save((IMObject)breedLookup);
        IMObjectBean bean = new IMObjectBean((IMObject)patient);
        bean.setValue("species", (Object)species);
        bean.setValue("breed", (Object)breed);
        bean.setValue("dateOfBirth", (Object)dateOfBirth);
        bean.save();
        return patient;
    }

    public static Party createPatient(String name, String species, String breed, String sex, Date dateOfBirth, String microchip, String colour, Party owner) {
        Party patient = PatientTestHelper.createPatient(name, species, breed, dateOfBirth, owner);
        IMObjectBean bean = new IMObjectBean((IMObject)patient);
        bean.setValue("sex", (Object)sex);
        if (microchip != null) {
            patient.addIdentity(TestHelper.createEntityIdentity("entityIdentity.microchip", microchip));
        }
        bean.setValue("colour", (Object)colour);
        bean.save();
        return patient;
    }

    public static Act createMedication(Party patient) {
        return PatientTestHelper.createMedication(patient, TestHelper.createProduct());
    }

    public static Act createMedication(Party patient, Product product) {
        return PatientTestHelper.createMedication(new Date(), patient, product);
    }

    public static Act createMedication(Date startTime, Party patient, Product product) {
        Act act = PatientTestHelper.createAct("act.patientMedication", startTime, patient, null);
        IMObjectBean bean = new IMObjectBean((IMObject)act);
        bean.setTarget("product", (IMObject)product);
        bean.save();
        return act;
    }

    public static Act createEvent(Party patient) {
        return PatientTestHelper.createEvent(patient, null);
    }

    public static Act createEvent(Party patient, User clinician) {
        return PatientTestHelper.createAct("act.patientClinicalEvent", new Date(), patient, clinician);
    }

    public static Act createEvent(Date startTime, Party patient, Act ... items) {
        return PatientTestHelper.createEvent(startTime, null, patient, null, items);
    }

    public static Act createEvent(Date startTime, Party patient, User clinician, Act ... items) {
        return PatientTestHelper.createEvent(startTime, null, patient, clinician, items);
    }

    public static Act createEvent(Date startTime, Date endTime, Party patient, User clinician, Act ... items) {
        Act act = PatientTestHelper.createEvent(patient, clinician);
        act.setActivityStartTime(startTime);
        act.setActivityEndTime(endTime);
        IMObjectBean bean = new IMObjectBean((IMObject)act);
        for (Act item : items) {
            if (item instanceof FinancialAct) {
                bean.addTarget("chargeItems", (IMObject)item, "event");
                continue;
            }
            if (item.isA("act.patientClinicalProblem")) {
                bean.addTarget("items", (IMObject)item, "events");
                continue;
            }
            bean.addTarget("items", (IMObject)item, "event");
        }
        ArrayList<Act> acts = new ArrayList<Act>();
        acts.add(act);
        acts.addAll(Arrays.asList(items));
        TestHelper.save(acts);
        return act;
    }

    public static Act createProblem(Date startTime, Party patient, Act ... items) {
        return PatientTestHelper.createProblem(startTime, patient, null, items);
    }

    public static Act createProblem(Date startTime, Party patient, User clinician, Act ... items) {
        return PatientTestHelper.createProblem(startTime, patient, clinician, null, "HEART_MURMUR", items);
    }

    public static Act createProblem(Date startTime, Party patient, User clinician, String presentComplaint, String diagnosis, Act ... items) {
        Act act = PatientTestHelper.createAct("act.patientClinicalProblem", startTime, patient, clinician);
        IMObjectBean bean = new IMObjectBean((IMObject)act);
        if (diagnosis != null) {
            act.setReason(TestHelper.getLookup("lookup.diagnosis", diagnosis).getCode());
        }
        if (presentComplaint != null) {
            bean.setValue("presentingComplaint", (Object)TestHelper.getLookup("lookup.presentingComplaint", presentComplaint).getCode());
        }
        for (Act item : items) {
            ActRelationship relationship = (ActRelationship)bean.addTarget("items", (IMObject)item);
            item.addActRelationship(relationship);
        }
        ArrayList<Act> acts = new ArrayList<Act>();
        acts.add(act);
        acts.addAll(Arrays.asList(items));
        TestHelper.save(acts);
        return act;
    }

    public static Act createNote(Date startTime, Party patient) {
        return PatientTestHelper.createNote(startTime, patient, null);
    }

    public static Act createNote(Date startTime, Party patient, User clinician) {
        return PatientTestHelper.createNote(startTime, patient, clinician, null);
    }

    public static Act createNote(Date startTime, Party patient, User clinician, String note) {
        Act act = PatientTestHelper.createAct("act.patientClinicalNote", startTime, patient, clinician);
        if (note != null) {
            IMObjectBean bean = new IMObjectBean((IMObject)act);
            bean.setValue("note", (Object)note);
        }
        TestHelper.save((IMObject)act);
        return act;
    }

    public static void addAddendum(Act act, Act addendum) {
        IMObjectBean bean = new IMObjectBean((IMObject)act);
        ActRelationship relationship = (ActRelationship)bean.addTarget("addenda", (IMObject)addendum);
        addendum.addActRelationship(relationship);
        TestHelper.save(new IMObject[]{act, addendum});
    }

    public static Act createAddendum(Date startTime, Party patient, User clinician) {
        return PatientTestHelper.createAddendum(startTime, patient, clinician, null);
    }

    public static Act createAddendum(Date startTime, Party patient, User clinician, String note) {
        Act act = PatientTestHelper.createAct("act.patientClinicalAddendum", startTime, patient, clinician);
        if (note != null) {
            IMObjectBean bean = new IMObjectBean((IMObject)act);
            bean.setValue("note", (Object)note);
        }
        TestHelper.save((IMObject)act);
        return act;
    }

    public static Act createWeight(Party patient, BigDecimal weight, WeightUnits units) {
        return PatientTestHelper.createWeight(patient, new Date(), weight, units);
    }

    public static Act createWeight(Party patient, Date startTime, BigDecimal weight, WeightUnits units) {
        Act act = PatientTestHelper.createWeight(startTime, patient, null);
        IMObjectBean bean = new IMObjectBean((IMObject)act);
        bean.setValue("weight", (Object)weight);
        bean.setValue("units", (Object)units.toString());
        TestHelper.save((IMObject)act);
        return act;
    }

    public static Act createWeight(Date startTime, Party patient) {
        return PatientTestHelper.createWeight(startTime, patient, null);
    }

    public static Act createWeight(Date startTime, Party patient, User clinician) {
        Act act = PatientTestHelper.createAct("act.patientWeight", startTime, patient, clinician);
        TestHelper.save((IMObject)act);
        return act;
    }

    public static Act createAct(String shortName, Date startTime, Party patient, User clinician) {
        Act act = TestHelper.create(shortName, Act.class);
        act.setActivityStartTime(startTime);
        IMObjectBean bean = new IMObjectBean((IMObject)act);
        bean.setTarget("patient", (IMObject)patient);
        if (clinician != null) {
            bean.setTarget("clinician", (IMObject)clinician);
        }
        return act;
    }

    public static DocumentAct createInvestigation(Party patient, Entity investigationType) {
        return PatientTestHelper.createInvestigation(patient, null, investigationType);
    }

    public static DocumentAct createInvestigation(Party patient, User clinician, Entity investigationType) {
        return PatientTestHelper.createInvestigation(patient, clinician, null, investigationType);
    }

    public static DocumentAct createInvestigation(Party patient, User clinician, Party location, Entity investigationType) {
        return PatientTestHelper.createInvestigation(new Date(), patient, clinician, location, investigationType);
    }

    public static DocumentAct createInvestigation(Date startTime, Party patient, User clinician, Party location, Entity investigationType) {
        return PatientTestHelper.createInvestigation(startTime, patient, clinician, location, investigationType, null);
    }

    public static DocumentAct createInvestigation(Date startTime, Party patient, User clinician, Party location, Entity investigationType, Product product) {
        return PatientTestHelper.createInvestigation(startTime, patient, clinician, location, investigationType, product, null);
    }

    public static DocumentAct createInvestigation(Date startTime, Party patient, User clinician, Party location, Entity investigationType, Product product, Entity laboratory) {
        DocumentAct act = (DocumentAct)PatientTestHelper.createAct("act.patientInvestigation", startTime, patient, clinician);
        IMObjectBean bean = new IMObjectBean((IMObject)act);
        if (location != null) {
            bean.setTarget("location", (IMObject)location);
        }
        bean.setTarget("investigationType", (IMObject)investigationType);
        if (product != null) {
            bean.addTarget("products", (IMObject)product);
        }
        if (laboratory != null) {
            bean.setTarget("laboratory", (IMObject)laboratory);
        }
        bean.save();
        return act;
    }

    public static Act createInvestigationVersion(Date startTime, Entity investigationType) {
        DocumentAct act = TestHelper.create("act.patientInvestigationVersion", DocumentAct.class);
        act.setActivityStartTime(startTime);
        IMObjectBean bean = new IMObjectBean((IMObject)act);
        bean.setTarget("investigationType", (IMObject)investigationType);
        TestHelper.save((IMObject)act);
        return act;
    }

    public static void addReport(DocumentAct investigation) {
        Document document = TestHelper.create("document.text", Document.class);
        document.setName("Z Test document");
        investigation.setDocument(document.getObjectReference());
        TestHelper.save(new IMObject[]{investigation, document});
    }

    public static DocumentAct createDocumentAttachment(Date startTime, Party patient) {
        return PatientTestHelper.createDocumentAttachment(startTime, patient, null);
    }

    public static DocumentAct createDocumentAttachment(Date startTime, Party patient, String fileName) {
        return PatientTestHelper.createDocumentAttachment(startTime, patient, fileName, null);
    }

    public static DocumentAct createDocumentAttachment(Date startTime, Party patient, String fileName, ActIdentity identity) {
        DocumentAct act = (DocumentAct)PatientTestHelper.createAct("act.patientDocumentAttachment", startTime, patient, null);
        act.setFileName(fileName);
        if (identity != null) {
            act.addIdentity(identity);
        }
        TestHelper.save((IMObject)act);
        return act;
    }

    public static DocumentAct createDocumentAttachmentVersion(Date startTime) {
        DocumentAct act = TestHelper.create("act.patientDocumentAttachmentVersion", DocumentAct.class);
        act.setActivityStartTime(startTime);
        TestHelper.save((IMObject)act);
        return act;
    }

    public static DocumentAct createDocumentForm(Party patient) {
        return PatientTestHelper.createDocumentForm(patient, null);
    }

    public static DocumentAct createDocumentForm(Party patient, Product product) {
        return PatientTestHelper.createDocumentForm(new Date(), patient, product);
    }

    public static DocumentAct createDocumentForm(Date startTime, Party patient, Product product) {
        return PatientTestHelper.createDocumentForm(startTime, patient, product, null);
    }

    public static DocumentAct createDocumentForm(Date startTime, Party patient, Product product, Entity template) {
        DocumentAct act = (DocumentAct)PatientTestHelper.createAct("act.patientDocumentForm", startTime, patient, null);
        if (product != null || template != null) {
            IMObjectBean bean = new IMObjectBean((IMObject)act);
            bean.setTarget("product", (IMObject)product);
            bean.setTarget("documentTemplate", (IMObject)template);
        }
        TestHelper.save((IMObject)act);
        return act;
    }

    public static DocumentAct createDocumentImage(Date startTime, Party patient) {
        DocumentAct act = (DocumentAct)PatientTestHelper.createAct("act.patientDocumentImage", startTime, patient, null);
        TestHelper.save((IMObject)act);
        return act;
    }

    public static DocumentAct createDocumentImageVersion(Date startTime) {
        DocumentAct act = TestHelper.create("act.patientDocumentAttachmentVersion", DocumentAct.class);
        act.setActivityStartTime(startTime);
        TestHelper.save((IMObject)act);
        return act;
    }

    public static DocumentAct createDocumentLetter(Date startTime, Party patient, Act ... versions) {
        return PatientTestHelper.createDocumentLetter(startTime, patient, null, versions);
    }

    public static DocumentAct createDocumentLetter(Date startTime, Party patient, Product product, Act ... versions) {
        DocumentAct act = (DocumentAct)PatientTestHelper.createAct("act.patientDocumentLetter", startTime, patient, null);
        ArrayList<Object> toSave = new ArrayList<Object>();
        toSave.add(act);
        IMObjectBean bean = new IMObjectBean((IMObject)act);
        if (product != null) {
            bean.setTarget("product", (IMObject)product);
        }
        if (versions.length > 0) {
            for (Act version : versions) {
                ActRelationship relationship = (ActRelationship)bean.addTarget("versions", (IMObject)version);
                version.addActRelationship(relationship);
                toSave.add(version);
            }
        }
        TestHelper.save(toSave);
        return act;
    }

    public static DocumentAct createDocumentLetterVersion(Date startTime) {
        DocumentAct act = TestHelper.create("act.patientDocumentLetterVersion", DocumentAct.class);
        act.setActivityStartTime(startTime);
        TestHelper.save((IMObject)act);
        return act;
    }

    public static EntityIdentity createMicrochip(String microchip) {
        EntityIdentity result = TestHelper.create("entityIdentity.microchip", EntityIdentity.class);
        IMObjectBean bean = new IMObjectBean((IMObject)result);
        bean.setValue("microchip", (Object)microchip);
        return result;
    }

    public static EntityIdentity createPetTag(String tag) {
        EntityIdentity result = TestHelper.create("entityIdentity.petTag", EntityIdentity.class);
        IMObjectBean bean = new IMObjectBean((IMObject)result);
        bean.setValue("petTag", (Object)tag);
        return result;
    }
}

