/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient;

import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.PatientAgeFormatter;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.patient.TestVisitBuilder;
import org.openvpms.archetype.test.builder.patient.TestWeightBuilder;
import org.openvpms.archetype.test.builder.supplier.TestSupplierFactory;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.PeriodRelationship;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.beans.factory.annotation.Autowired;

public class PatientRulesTestCase
extends ArchetypeServiceTest {
    @Autowired
    private PracticeService practiceService;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestSupplierFactory supplierFactory;
    private PatientRules rules;
    private PracticeRules practiceRules;

    @Before
    public void setUp() {
        this.practiceRules = new PracticeRules((ArchetypeService)this.getArchetypeService(), null);
        this.rules = new PatientRules(this.practiceRules, this.practiceService, this.getArchetypeService(), this.getLookupService());
    }

    @Test
    public void testGetOwner() {
        Party patient1 = this.patientFactory.createPatient();
        Assert.assertNull((Object)this.rules.getOwner(patient1));
        Assert.assertNull((Object)this.rules.getOwnerReference(patient1));
        Party customer = this.customerFactory.createCustomer();
        Party patient2 = this.patientFactory.createPatient();
        Party customer2 = this.customerFactory.createCustomer();
        Party customer3 = this.customerFactory.createCustomer();
        this.rules.addPatientLocationRelationship(customer2, patient2);
        this.rules.addPatientOwnerRelationship(customer3, patient2);
        this.deactivateRelationship(patient2, "entityRelationship.patientOwner");
        this.rules.addPatientOwnerRelationship(customer, patient2);
        Assert.assertEquals((Object)customer, (Object)this.rules.getOwner(patient2));
        Assert.assertEquals((Object)customer.getObjectReference(), (Object)this.rules.getOwnerReference(patient2));
        this.deactivateRelationship(patient2, "entityRelationship.patientOwner");
        Assert.assertNull((Object)this.rules.getOwner(patient2));
        Assert.assertNull((Object)this.rules.getOwnerReference(patient2));
    }

    @Test
    public void testGetOwnerFromAct() {
        Party patient = this.patientFactory.createPatient();
        Party customer1 = this.customerFactory.createCustomer();
        Party customer2 = this.customerFactory.createCustomer();
        this.checkOwner(patient, "2006-12-10", null);
        EntityRelationship r1 = this.rules.addPatientOwnerRelationship(customer1, patient);
        EntityRelationship r2 = this.rules.addPatientOwnerRelationship(customer2, patient);
        r1.setActiveStartTime(TestHelper.getDate("2007-01-01"));
        r1.setActiveEndTime(TestHelper.getDate("2007-01-31"));
        r2.setActiveStartTime(TestHelper.getDate("2007-02-02"));
        r2.setActiveEndTime(null);
        this.save((IMObject)patient);
        this.save((IMObject)customer1);
        this.save((IMObject)customer2);
        this.checkOwner(patient, "2006-12-10", customer1);
        this.checkOwner(patient, "2007-01-01", customer1);
        this.checkOwner(patient, "2007-01-31", customer2);
        this.checkOwner(patient, "2007-02-01", customer2);
        this.checkOwner(patient, "2007-02-02", customer2);
        this.checkOwner(patient, "2008-01-01", customer2);
    }

    @Test
    public void testIsOwner() {
        Party patient1 = this.patientFactory.createPatient();
        Party customer1 = this.customerFactory.createCustomer();
        Party patient2 = this.patientFactory.createPatient();
        Party customer2 = this.customerFactory.createCustomer();
        this.rules.addPatientOwnerRelationship(customer1, patient2);
        this.rules.addPatientLocationRelationship(customer2, patient2);
        Assert.assertFalse((boolean)this.rules.isOwner(customer1, patient1));
        Assert.assertTrue((boolean)this.rules.isOwner(customer1, patient2));
        this.deactivateRelationship(patient2, "entityRelationship.patientOwner");
        Assert.assertFalse((boolean)this.rules.isOwner(customer1, patient2));
    }

    @Test
    public void testGetLocation() {
        Party patient1 = this.patientFactory.createPatient();
        Assert.assertNull((Object)this.rules.getLocation(patient1));
        Party customer = this.customerFactory.createCustomer();
        Party patient2 = this.patientFactory.createPatient();
        this.rules.addPatientLocationRelationship(customer, patient2);
        Assert.assertEquals((Object)customer, (Object)this.rules.getLocation(patient2));
        this.deactivateRelationship(patient2, "entityRelationship.patientLocation");
        Assert.assertNull((Object)this.rules.getOwner(patient2));
        Assert.assertNull((Object)this.rules.getOwnerReference(patient2));
    }

    @Test
    public void testGetLocationFromAct() {
        Party patient = this.patientFactory.createPatient();
        Party customer1 = this.customerFactory.createCustomer();
        Party customer2 = this.customerFactory.createCustomer();
        this.checkLocation(patient, "2006-12-10", null);
        EntityRelationship r1 = this.rules.addPatientLocationRelationship(customer1, patient);
        EntityRelationship r2 = this.rules.addPatientLocationRelationship(customer2, patient);
        r1.setActiveStartTime(TestHelper.getDate("2007-01-01"));
        r1.setActiveEndTime(TestHelper.getDate("2007-01-31"));
        r2.setActiveStartTime(TestHelper.getDate("2007-02-02"));
        r2.setActiveEndTime(null);
        this.save((IMObject)patient);
        this.save((IMObject)customer1);
        this.save((IMObject)customer2);
        this.checkLocation(patient, "2006-12-10", customer1);
        this.checkLocation(patient, "2007-01-01", customer1);
        this.checkLocation(patient, "2007-01-31", customer2);
        this.checkLocation(patient, "2007-02-01", customer2);
        this.checkLocation(patient, "2007-02-02", customer2);
        this.checkLocation(patient, "2008-01-01", customer2);
    }

    @Test
    public void testGetReferralVet() {
        Party vet = this.supplierFactory.createVet();
        Party patient = (Party)this.patientFactory.newPatient().addReferredFrom(vet, new Date()).build(false);
        IMObjectBean bean = this.getBean((IMObject)patient);
        PeriodRelationship referral = (PeriodRelationship)bean.getObject("referrals", PeriodRelationship.class);
        Assert.assertNotNull((Object)referral);
        Assert.assertTrue((boolean)referral.isA("entityRelationship.referredFrom"));
        Party vet2 = this.rules.getReferralVet(patient, new Date());
        Assert.assertEquals((Object)vet, (Object)vet2);
        Date start = new Date();
        Date end = new Date(start.getTime() + 1L);
        Date later = new Date(end.getTime() + 1L);
        referral.setActiveStartTime(start);
        referral.setActiveEndTime(end);
        Assert.assertNull((Object)this.rules.getReferralVet(patient, later));
    }

    @Test
    public void testGetPatientWeight() {
        Party patient = this.patientFactory.createPatient();
        Assert.assertNull((Object)this.rules.getPatientWeight(patient));
        ((TestWeightBuilder)((TestWeightBuilder)this.patientFactory.newWeight().patient(patient)).startTime("2006-12-22")).weight(5).build();
        Assert.assertEquals((Object)"5 Kilograms", (Object)this.rules.getPatientWeight(patient));
        ((TestWeightBuilder)((TestWeightBuilder)this.patientFactory.newWeight().patient(patient)).startTime("2007-02-25")).weight(13, WeightUnits.POUNDS).build();
        Assert.assertEquals((Object)"13 Pounds", (Object)this.rules.getPatientWeight(patient));
    }

    @Test
    public void testSetInactive() {
        Party patient = (Party)this.patientFactory.newPatient().build(false);
        Assert.assertTrue((boolean)patient.isActive());
        this.rules.setInactive(patient);
        patient = this.get(patient);
        Assert.assertFalse((boolean)patient.isActive());
    }

    @Test
    public void testDeceased() {
        Party patient = (Party)this.patientFactory.newPatient().build(false);
        Assert.assertFalse((boolean)this.rules.isDeceased(patient));
        this.rules.setDeceased(patient);
        patient = this.get(patient);
        Assert.assertTrue((boolean)this.rules.isDeceased(patient));
    }

    @Test
    public void testDesexed() {
        Party patient = (Party)this.patientFactory.newPatient().build(false);
        Assert.assertFalse((boolean)this.rules.isDesexed(patient));
        this.rules.setDesexed(patient);
        patient = this.get(patient);
        Assert.assertTrue((boolean)this.rules.isDesexed(patient));
    }

    @Test
    public void testGetMicrochipNumber() {
        Party patient = (Party)this.patientFactory.newPatient().build(false);
        Assert.assertNull((Object)this.rules.getMicrochipNumber(patient));
        EntityIdentity microchip = this.patientFactory.createMicrochip("1234567");
        patient.addIdentity(microchip);
        Assert.assertEquals((Object)"1234567", (Object)this.rules.getMicrochipNumber(patient));
        microchip.setActive(false);
        Assert.assertNull((Object)this.rules.getMicrochipNumber(patient));
    }

    @Test
    public void testGetMicrochipNumbers() {
        Party patient = (Party)this.patientFactory.newPatient().build(false);
        Assert.assertNull((Object)this.rules.getMicrochipNumbers(patient));
        EntityIdentity microchip1 = this.patientFactory.createMicrochip("123");
        patient.addIdentity(microchip1);
        this.save((IMObject)patient);
        Assert.assertEquals((Object)"123", (Object)this.rules.getMicrochipNumbers(patient));
        EntityIdentity microchip2 = this.patientFactory.createMicrochip("456");
        patient.addIdentity(microchip2);
        this.save((IMObject)patient);
        Assert.assertEquals((Object)"456, 123", (Object)this.rules.getMicrochipNumbers(patient));
    }

    @Test
    public void testGetPetTag() {
        Party patient = (Party)this.patientFactory.newPatient().build(false);
        Assert.assertNull((Object)this.rules.getPetTag(patient));
        EntityIdentity tag = this.create("entityIdentity.petTag", EntityIdentity.class);
        IMObjectBean tagBean = this.getBean((IMObject)tag);
        tagBean.setValue("petTag", (Object)"1234567");
        patient.addIdentity(tag);
        Assert.assertEquals((Object)"1234567", (Object)this.rules.getPetTag(patient));
        tag.setActive(false);
        Assert.assertNull((Object)this.rules.getPetTag(patient));
    }

    @Test
    public void testGetCage() {
        Party patient = (Party)this.patientFactory.newPatient().build(false);
        Assert.assertNull((Object)this.rules.getCage(patient));
        this.patientFactory.updatePatient(patient).cage("PURPLE_1").build(false);
        Assert.assertEquals((Object)"Purple 1", (Object)this.rules.getCage(patient));
    }

    @Test
    public void testGetRabiesTag() {
        Party patient = (Party)this.patientFactory.newPatient().build(false);
        Assert.assertNull((Object)this.rules.getRabiesTag(patient));
        EntityIdentity tag = this.create("entityIdentity.rabiesTag", EntityIdentity.class);
        tag.setIdentity("1234567");
        patient.addIdentity(tag);
        Assert.assertEquals((Object)"1234567", (Object)this.rules.getRabiesTag(patient));
        tag.setActive(false);
        Assert.assertNull((Object)this.rules.getRabiesTag(patient));
    }

    @Test
    public void testGetPatientAgeNoBirthDate() {
        Party patient = (Party)this.patientFactory.newPatient().build(false);
        String age = this.rules.getPatientAge(patient);
        Assert.assertEquals((Object)"No Birthdate", (Object)age);
    }

    @Test
    public void testGetPatientAgeWithBirthDate() {
        Date birthDate = TestHelper.getDate("2010-01-01");
        Party patient = (Party)this.patientFactory.newPatient().dateOfBirth("2010-01-01").build(false);
        String age = this.rules.getPatientAge(patient);
        PatientAgeFormatter formatter = new PatientAgeFormatter(this.getLookupService(), this.practiceRules, (ArchetypeService)this.getArchetypeService());
        String expected = formatter.format(birthDate);
        Assert.assertEquals((Object)expected, (Object)age);
    }

    @Test
    public void testGetPatientAgeWithDeceasedDate() {
        Date birth = TestHelper.getDate("2010-01-01");
        Date deceased = TestHelper.getDate("2011-05-01");
        Party patient = (Party)this.patientFactory.newPatient().dateOfBirth(birth).deceased(true).dateOfDeath(deceased).build(false);
        IMObjectBean bean = this.getBean((IMObject)patient);
        bean.setValue("dateOfBirth", (Object)birth);
        bean.setValue("deceasedDate", (Object)deceased);
        String age = this.rules.getPatientAge(patient);
        PatientAgeFormatter formatter = new PatientAgeFormatter(this.getLookupService(), this.practiceRules, (ArchetypeService)this.getArchetypeService());
        String expected = formatter.format(birth, deceased);
        Assert.assertEquals((Object)expected, (Object)age);
    }

    @Test
    public void testIsAllergy() {
        Party patient = this.patientFactory.createPatient();
        Entity other = this.patientFactory.createAlertType("Z Alert Type 1");
        Entity allergy = this.patientFactory.createAlertType("Z Alert Type 2", "ALLERGY");
        Entity aggression = this.patientFactory.createAlertType("Z Alert Type 3", "AGGRESSION");
        Act act1 = this.patientFactory.createAlert(patient, other);
        Assert.assertFalse((boolean)this.rules.isAllergy(act1));
        Act act2 = this.patientFactory.createAlert(patient, allergy);
        Assert.assertTrue((boolean)this.rules.isAllergy(act2));
        Act act3 = this.patientFactory.createAlert(patient, aggression);
        Assert.assertFalse((boolean)this.rules.isAllergy(act3));
    }

    private void checkOwner(Party patient, String date, Party expected) {
        Act act = (Act)((TestVisitBuilder)((TestVisitBuilder)this.patientFactory.newVisit().patient(patient)).startTime(date)).build(false);
        Assert.assertEquals((Object)expected, (Object)this.rules.getOwner(act));
    }

    private void checkLocation(Party patient, String date, Party expected) {
        Act act = (Act)((TestVisitBuilder)((TestVisitBuilder)this.patientFactory.newVisit().patient(patient)).startTime(date)).build(false);
        Assert.assertEquals((Object)expected, (Object)this.rules.getLocation(act));
    }

    private void deactivateRelationship(Party patient, String shortName) {
        for (Relationship relationship : patient.getEntityRelationships()) {
            if (!relationship.isA(shortName)) continue;
            relationship.setActive(false);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

