/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.math;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.test.TestHelper;

public class MathRulesTestCase {
    @Test
    public void testCalculateTotal() {
        BigDecimal fixedPrice = BigDecimal.valueOf(10L);
        BigDecimal discount = BigDecimal.valueOf(5L);
        BigDecimal unitPrice1 = new BigDecimal("0.50");
        BigDecimal quantity = BigDecimal.valueOf(2L);
        TestHelper.checkEquals(BigDecimal.valueOf(6L), MathRules.calculateTotal((BigDecimal)fixedPrice, (BigDecimal)unitPrice1, (BigDecimal)quantity, (BigDecimal)discount, (int)2));
        TestHelper.checkEquals(BigDecimal.valueOf(-6L), MathRules.calculateTotal((BigDecimal)fixedPrice, (BigDecimal)unitPrice1, (BigDecimal)quantity.negate(), (BigDecimal)discount, (int)2));
        BigDecimal unitPrice2 = new BigDecimal("0.514");
        TestHelper.checkEquals(new BigDecimal("6.03"), MathRules.calculateTotal((BigDecimal)fixedPrice, (BigDecimal)unitPrice2, (BigDecimal)quantity, (BigDecimal)discount, (int)2));
        TestHelper.checkEquals(new BigDecimal("-6.03"), MathRules.calculateTotal((BigDecimal)fixedPrice, (BigDecimal)unitPrice2, (BigDecimal)quantity.negate(), (BigDecimal)discount, (int)2));
        BigDecimal fixedPrice3 = new BigDecimal("12.00");
        BigDecimal discount3 = new BigDecimal("106.08");
        BigDecimal unitPrice3 = new BigDecimal("37.63");
        BigDecimal quantity3 = new BigDecimal("2.50");
        TestHelper.checkEquals(BigDecimal.ZERO, MathRules.calculateTotal((BigDecimal)fixedPrice3, (BigDecimal)unitPrice3, (BigDecimal)quantity3, (BigDecimal)discount3, (int)2));
        TestHelper.checkEquals(BigDecimal.ZERO, MathRules.calculateTotal((BigDecimal)fixedPrice3, (BigDecimal)unitPrice3, (BigDecimal)quantity3.negate(), (BigDecimal)discount3, (int)2));
        TestHelper.checkEquals(BigDecimal.ZERO, MathRules.calculateTotal((BigDecimal)fixedPrice, (BigDecimal)unitPrice1, (BigDecimal)BigDecimal.ZERO, (BigDecimal)discount, (int)2));
        TestHelper.checkEquals(BigDecimal.ZERO, MathRules.calculateTotal((BigDecimal)fixedPrice, (BigDecimal)unitPrice2, (BigDecimal)BigDecimal.ZERO, (BigDecimal)discount, (int)2));
        TestHelper.checkEquals(BigDecimal.ZERO, MathRules.calculateTotal((BigDecimal)fixedPrice3, (BigDecimal)unitPrice3, (BigDecimal)BigDecimal.ZERO, (BigDecimal)discount3, (int)2));
        TestHelper.checkEquals(BigDecimal.ZERO, MathRules.calculateTotal((BigDecimal)fixedPrice, (BigDecimal)unitPrice1, (BigDecimal)BigDecimal.ZERO.negate(), (BigDecimal)discount, (int)2));
    }

    @Test
    public void testIntersects() {
        this.checkIntersects(false, "1", "10", "10", "20");
        this.checkIntersects(false, "1", "10", "11", "20");
        this.checkIntersects(false, "1", "10", "10", null);
        this.checkIntersects(false, null, "10", "10", "20");
        this.checkIntersects(false, null, "10", "11", "20");
        this.checkIntersects(false, null, "10", "10", null);
        this.checkIntersects(false, null, "10", "11", null);
        this.checkIntersects(false, "10", "20", "1", "10");
        this.checkIntersects(false, "11", "20", "1", "10");
        this.checkIntersects(false, "10", null, "1", "10");
        this.checkIntersects(false, "11", null, "1", "10");
        this.checkIntersects(false, "10", "20", null, "10");
        this.checkIntersects(false, "10", null, null, "10");
        this.checkIntersects(false, "11", null, null, "10");
        this.checkIntersects(true, "1", "11", "10", "20");
        this.checkIntersects(true, "9", "20", "1", "10");
        this.checkIntersects(true, "1", "20", "1", "20");
        this.checkIntersects(true, "5", "6", "1", "20");
        this.checkIntersects(true, "1", "5", "1", "20");
        this.checkIntersects(true, "5", "20", "1", "20");
        this.checkIntersects(true, "1", "20", "5", "6");
        this.checkIntersects(true, "1", "20", "1", "5");
        this.checkIntersects(true, "1", "20", "5", "20");
    }

    @Test
    public void testIntersectsForUnboundedNumericRange() {
        this.checkIntersects(true, null, null, null, null);
        this.checkIntersects(true, null, null, "1", null);
        this.checkIntersects(true, null, null, "1", "31");
        this.checkIntersects(true, null, null, null, "31");
        this.checkIntersects(true, "1", null, null, null);
        this.checkIntersects(true, "1", "31", null, null);
        this.checkIntersects(true, null, "31", null, null);
    }

    private void checkIntersects(boolean intersects, String from1, String to1, String from2, String to2) {
        Assert.assertEquals((Object)intersects, (Object)MathRules.intersects((BigDecimal)this.getValue(from1), (BigDecimal)this.getValue(to1), (BigDecimal)this.getValue(from2), (BigDecimal)this.getValue(to2)));
    }

    private BigDecimal getValue(String value) {
        return value != null ? new BigDecimal(value) : null;
    }
}

