/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.math.Currency;
import org.openvpms.archetype.rules.math.CurrencyException;
import org.openvpms.archetype.test.TestHelper;

public class CurrencyTestCase {
    @Test
    public void testRound() {
        Currency halfUp = new Currency(this.getCurrency("AUD"), RoundingMode.HALF_UP, new BigDecimal("0.05"));
        Currency halfDown = new Currency(this.getCurrency("AUD"), RoundingMode.HALF_DOWN, new BigDecimal("0.05"));
        Currency halfEven = new Currency(this.getCurrency("AUD"), RoundingMode.HALF_EVEN, new BigDecimal("0.05"));
        this.checkRound(halfUp, "1.95", "1.95");
        this.checkRound(halfUp, "1.951", "1.95");
        this.checkRound(halfUp, "1.955", "1.96");
        this.checkRound(halfUp, "1.959", "1.96");
        this.checkRound(halfDown, "1.95", "1.95");
        this.checkRound(halfDown, "1.951", "1.95");
        this.checkRound(halfDown, "1.955", "1.95");
        this.checkRound(halfDown, "1.959", "1.96");
        this.checkRound(halfEven, "1.95", "1.95");
        this.checkRound(halfEven, "1.951", "1.95");
        this.checkRound(halfEven, "1.955", "1.96");
        this.checkRound(halfEven, "1.959", "1.96");
        this.checkRound(halfEven, "1.965", "1.96");
    }

    @Test
    public void testRoundCash() {
        Currency halfUp = new Currency(this.getCurrency("AUD"), RoundingMode.HALF_UP, new BigDecimal("0.05"));
        this.checkRoundCash(halfUp, "1.925", "1.95");
        this.checkRoundCash(halfUp, "1.95", "1.95");
        this.checkRoundCash(halfUp, "1.96", "1.95");
        this.checkRoundCash(halfUp, "1.97", "1.95");
        this.checkRoundCash(halfUp, "1.975", "2.00");
        this.checkRoundCash(halfUp, "1.98", "2.00");
        Currency halfDown = new Currency(this.getCurrency("AUD"), RoundingMode.HALF_DOWN, new BigDecimal("0.05"));
        this.checkRoundCash(halfDown, "1.925", "1.90");
        this.checkRoundCash(halfDown, "1.95", "1.95");
        this.checkRoundCash(halfDown, "1.96", "1.95");
        this.checkRoundCash(halfDown, "1.97", "1.95");
        this.checkRoundCash(halfDown, "1.975", "1.95");
        this.checkRoundCash(halfDown, "1.98", "2.00");
        Currency halfEven = new Currency(this.getCurrency("AUD"), RoundingMode.HALF_EVEN, new BigDecimal("0.05"));
        this.checkRoundCash(halfEven, "1.925", "1.90");
        this.checkRoundCash(halfEven, "1.95", "1.95");
        this.checkRoundCash(halfEven, "1.96", "1.95");
        this.checkRoundCash(halfEven, "1.97", "1.95");
        this.checkRoundCash(halfEven, "1.975", "2.00");
        this.checkRoundCash(halfEven, "1.98", "2.00");
    }

    @Test
    public void testValidRoundingModes() {
        for (RoundingMode mode : RoundingMode.values()) {
            boolean valid = mode == RoundingMode.HALF_UP || mode == RoundingMode.HALF_DOWN || mode == RoundingMode.HALF_EVEN;
            try {
                new Currency(this.getCurrency("AUD"), mode, new BigDecimal("0.05"));
                if (valid) continue;
                Assert.fail((String)("Expected " + (Object)((Object)mode) + " to throw an exception"));
            }
            catch (CurrencyException exception) {
                if (!valid) continue;
                Assert.fail((String)("Expected " + (Object)((Object)mode) + " to not throw an exception"));
            }
        }
    }

    @Test
    public void testRoundPrice() {
        BigDecimal minDenomination = new BigDecimal("0.01");
        BigDecimal minPrice = new BigDecimal("0.05");
        java.util.Currency AUD = this.getCurrency("AUD");
        Currency halfUp = new Currency(AUD, RoundingMode.HALF_UP, minDenomination, minPrice);
        this.checkRoundPrice(halfUp, "1.925", "1.95");
        this.checkRoundPrice(halfUp, "1.95", "1.95");
        this.checkRoundPrice(halfUp, "1.96", "1.95");
        this.checkRoundPrice(halfUp, "1.97", "1.95");
        this.checkRoundPrice(halfUp, "1.975", "2.00");
        this.checkRoundPrice(halfUp, "1.98", "2.00");
        this.checkRoundPrice(halfUp, "0.00", "0.00");
        this.checkRoundPrice(halfUp, "0.01", "0.05");
        this.checkRoundPrice(halfUp, "0.06", "0.05");
        Currency halfDown = new Currency(AUD, RoundingMode.HALF_DOWN, minDenomination, minPrice);
        this.checkRoundPrice(halfDown, "1.925", "1.90");
        this.checkRoundPrice(halfDown, "1.95", "1.95");
        this.checkRoundPrice(halfDown, "1.96", "1.95");
        this.checkRoundPrice(halfDown, "1.97", "1.95");
        this.checkRoundPrice(halfDown, "1.975", "1.95");
        this.checkRoundPrice(halfDown, "1.98", "2.00");
        this.checkRoundPrice(halfDown, "0.00", "0.00");
        this.checkRoundPrice(halfDown, "0.01", "0.05");
        this.checkRoundPrice(halfDown, "0.06", "0.05");
        Currency halfEven = new Currency(AUD, RoundingMode.HALF_EVEN, minDenomination, minPrice);
        this.checkRoundPrice(halfEven, "1.925", "1.90");
        this.checkRoundPrice(halfEven, "1.95", "1.95");
        this.checkRoundPrice(halfEven, "1.96", "1.95");
        this.checkRoundPrice(halfEven, "1.97", "1.95");
        this.checkRoundPrice(halfEven, "1.975", "2.00");
        this.checkRoundPrice(halfEven, "1.98", "2.00");
        this.checkRoundPrice(halfEven, "0.00", "0.00");
        this.checkRoundPrice(halfEven, "0.01", "0.05");
        this.checkRoundPrice(halfEven, "0.06", "0.05");
        this.checkRoundPrice(halfUp, "-1.925", "-1.95");
        this.checkRoundPrice(halfUp, "-0.01", "-0.05");
        this.checkRoundPrice(halfDown, "-1.925", "-1.90");
        this.checkRoundPrice(halfDown, "-0.01", "-0.05");
        this.checkRoundPrice(halfEven, "-1.925", "-1.90");
        this.checkRoundPrice(halfEven, "-0.01", "-0.05");
    }

    @Test
    public void getMinimumDenomination() {
        Currency aud = new Currency(this.getCurrency("AUD"), RoundingMode.HALF_UP);
        TestHelper.checkEquals(new BigDecimal("0.01"), aud.getMinimumDenomination());
        Currency jpy = new Currency(this.getCurrency("JPY"), RoundingMode.HALF_UP);
        TestHelper.checkEquals(BigDecimal.ONE, jpy.getMinimumDenomination());
        Currency xau = new Currency(this.getCurrency("XAU"), RoundingMode.HALF_UP);
        TestHelper.checkEquals(new BigDecimal("0.01"), xau.getMinimumDenomination());
        Currency nzd = new Currency(this.getCurrency("NZD"), RoundingMode.HALF_UP, new BigDecimal("0.05"));
        TestHelper.checkEquals(new BigDecimal("0.05"), nzd.getMinimumDenomination());
    }

    @Test
    public void getMinimumPrice() {
        Currency aud = new Currency(this.getCurrency("AUD"), RoundingMode.HALF_UP);
        TestHelper.checkEquals(new BigDecimal("0.01"), aud.getMinimumPrice());
        Currency jpy = new Currency(this.getCurrency("JPY"), RoundingMode.HALF_UP);
        TestHelper.checkEquals(BigDecimal.ONE, jpy.getMinimumPrice());
        Currency xau = new Currency(this.getCurrency("XAU"), RoundingMode.HALF_UP);
        TestHelper.checkEquals(new BigDecimal("0.01"), xau.getMinimumPrice());
        Currency nzd = new Currency(this.getCurrency("NZD"), RoundingMode.HALF_UP, new BigDecimal("0.05"));
        TestHelper.checkEquals(new BigDecimal("0.01"), nzd.getMinimumPrice());
        Currency gbp = new Currency(this.getCurrency("GBP"), RoundingMode.HALF_UP, new BigDecimal("0.05"), new BigDecimal("0.20"));
        TestHelper.checkEquals(new BigDecimal("0.20"), gbp.getMinimumPrice());
    }

    @Test
    public void getDefaultRoundingAmount() {
        Currency aud = new Currency(this.getCurrency("AUD"), RoundingMode.HALF_UP);
        TestHelper.checkEquals(new BigDecimal("0.01"), aud.getDefaultRoundingAmount());
        Currency jpy = new Currency(this.getCurrency("JPY"), RoundingMode.HALF_UP);
        TestHelper.checkEquals(BigDecimal.ONE, jpy.getDefaultRoundingAmount());
        Currency xau = new Currency(this.getCurrency("XAU"), RoundingMode.HALF_UP);
        TestHelper.checkEquals(new BigDecimal("0.01"), xau.getDefaultRoundingAmount());
    }

    private void checkRound(Currency currency, String value, String expected) {
        BigDecimal e = new BigDecimal(expected);
        Assert.assertEquals((Object)e, (Object)currency.round(new BigDecimal(value)));
        Assert.assertEquals((Object)e, (Object)currency.roundTo(new BigDecimal(value), currency.getDefaultRoundingAmount()));
    }

    private void checkRoundCash(Currency currency, String value, String expected) {
        BigDecimal e = new BigDecimal(expected);
        Assert.assertEquals((Object)e, (Object)currency.roundCash(new BigDecimal(value)));
    }

    private void checkRoundPrice(Currency currency, String value, String expected) {
        BigDecimal e = new BigDecimal(expected);
        Assert.assertEquals((Object)e, (Object)currency.roundPrice(new BigDecimal(value)));
    }

    private java.util.Currency getCurrency(String code) {
        return java.util.Currency.getInstance(code);
    }
}

