/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.laboratory;

import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.helper.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;

public class LaboratoryTestHelper {
    public static Entity createLaboratory(Entity ... locations) {
        Entity result = (Entity)TestHelper.create("entity.laboratoryServiceTest");
        result.setName(TestHelper.randomName("X-Laboratory-"));
        IMObjectBean bean = new IMObjectBean((IMObject)result);
        for (Entity location : locations) {
            bean.addTarget("locations", (IMObject)location);
        }
        bean.save();
        return result;
    }

    public static Entity createDevice(Entity laboratory) {
        Entity result = TestHelper.create("entity.laboratoryDevice", Entity.class);
        result.setName(TestHelper.randomName("X-Device-"));
        EntityIdentity deviceId = TestHelper.create("entityIdentity.laboratoryDeviceTest", EntityIdentity.class);
        String id = TestHelper.randomName("DEVICE");
        deviceId.setIdentity(id);
        deviceId.setName(id);
        result.addIdentity(deviceId);
        IMObjectBean bean = new IMObjectBean((IMObject)result);
        bean.setTarget("laboratory", (IMObject)laboratory);
        bean.save();
        return result;
    }

    public static Entity createDevice(Entity laboratory, Party ... locations) {
        Entity result = TestHelper.create("entity.laboratoryDevice", Entity.class);
        result.setName(TestHelper.randomName("X-Device-"));
        EntityIdentity deviceId = TestHelper.create("entityIdentity.laboratoryDeviceTest", EntityIdentity.class);
        String id = TestHelper.randomName("DEVICE");
        deviceId.setIdentity(id);
        deviceId.setName(id);
        result.addIdentity(deviceId);
        IMObjectBean bean = new IMObjectBean((IMObject)result);
        bean.setTarget("laboratory", (IMObject)laboratory);
        for (Party location : locations) {
            bean.addTarget("locations", (IMObject)location);
        }
        bean.save();
        return result;
    }

    public static Entity createTest(Entity investigationType, Entity ... laboratories) {
        Entity result = LaboratoryTestHelper.createTest(investigationType);
        if (laboratories.length > 0) {
            IMObjectBean bean = new IMObjectBean((IMObject)result);
            for (Entity lab : laboratories) {
                bean.addTarget("laboratories", (IMObject)lab);
            }
        }
        TestHelper.save((IMObject)result);
        return result;
    }

    public static Entity createTest() {
        return LaboratoryTestHelper.createTest(LaboratoryTestHelper.createInvestigationType());
    }

    public static Entity createTest(Entity investigationType) {
        return LaboratoryTestHelper.createTest(investigationType, false);
    }

    public static Entity createTest(Entity investigationType, boolean group) {
        return LaboratoryTestHelper.createTest(investigationType, group, "NO");
    }

    public static Entity createTest(Entity investigationType, boolean group, String useDevice) {
        Entity result = TestHelper.create("entity.laboratoryTest", Entity.class);
        result.setName(TestHelper.randomName("X-LaboratoryTest-"));
        EntityIdentity code = TestHelper.create("entityIdentity.laboratoryTest", EntityIdentity.class);
        code.setIdentity(result.getName());
        result.addIdentity(code);
        IMObjectBean bean = new IMObjectBean((IMObject)result);
        bean.setTarget("investigationType", (IMObject)investigationType);
        bean.setValue("group", (Object)group);
        bean.setValue("useDevice", (Object)useDevice);
        bean.save();
        return result;
    }

    public static Entity createHL7Test(Entity investigationType) {
        Entity result = TestHelper.create("entity.laboratoryTestHL7", Entity.class);
        result.setName(TestHelper.randomName("X-HL7LaboratoryTest-"));
        EntityIdentity code = TestHelper.create("entityIdentity.laboratoryTest", EntityIdentity.class);
        code.setIdentity(result.getName());
        result.addIdentity(code);
        IMObjectBean bean = new IMObjectBean((IMObject)result);
        bean.setTarget("investigationType", (IMObject)investigationType);
        bean.save();
        return result;
    }

    public static Entity createInvestigationType() {
        Entity result = TestHelper.create("entity.investigationType", Entity.class);
        result.setName(TestHelper.randomName("X-TestInvestigationType-"));
        TestHelper.save((IMObject)result);
        return result;
    }

    public static Entity createInvestigationType(Entity laboratory, Entity ... devices) {
        Entity investigation = LaboratoryTestHelper.createInvestigationType();
        IMObjectBean bean = new IMObjectBean((IMObject)investigation);
        bean.setTarget("laboratory", (IMObject)laboratory);
        for (Entity device : devices) {
            bean.addTarget("devices", (IMObject)device);
        }
        bean.save();
        return investigation;
    }
}

