/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.till;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.finance.till.TillBalanceQuery;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ObjectSet;
import org.springframework.beans.factory.annotation.Autowired;

public class TillBalanceQueryTestCase
extends ArchetypeServiceTest {
    @Autowired
    private CustomerAccountRules rules;
    private Party customer;
    private Entity till;

    @Before
    public void setUp() {
        this.customer = TestHelper.createCustomer();
        this.till = FinancialTestHelper.createTill();
    }

    @Test
    public void testPaymentWithAdjustment() {
        Date date1 = TestHelper.getDatetime("2015-01-22 10:00:00");
        Date date2 = TestHelper.getDatetime("2015-04-22 11:00:00");
        FinancialAct balance = FinancialTestHelper.createTillBalance(this.till);
        List<FinancialAct> acts = FinancialTestHelper.createPaymentCash(BigDecimal.TEN, this.customer, this.till, "POSTED");
        Assert.assertEquals((long)2L, (long)acts.size());
        FinancialAct payment = acts.get(0);
        payment.setActivityStartTime(date1);
        FinancialAct paymentItem = acts.get(1);
        FinancialAct adjustment = this.create("act.tillBalanceAdjustment", FinancialAct.class);
        IMObjectBean bean = this.getBean((IMObject)adjustment);
        bean.setValue("startTime", (Object)date2);
        bean.setValue("credit", (Object)false);
        bean.setTarget("till", (IMObject)this.till);
        bean.setValue("amount", (Object)BigDecimal.TEN);
        IMObjectBean balanceBean = this.getBean((IMObject)balance);
        balanceBean.addTarget("items", (IMObject)payment, "tillBalance");
        balanceBean.addTarget("items", (IMObject)adjustment, "tillBalance");
        this.save((IMObject[])new FinancialAct[]{balance, payment, paymentItem, adjustment});
        TillBalanceQuery query = new TillBalanceQuery(balance, this.getArchetypeService());
        List results = query.query().getResults();
        Assert.assertEquals((long)2L, (long)results.size());
        this.check((ObjectSet)results.get(0), balance, payment, (Act)paymentItem, BigDecimal.TEN);
        this.check((ObjectSet)results.get(1), balance, adjustment, null, BigDecimal.TEN.negate());
    }

    @Test
    public void testPaymentWithRefund() {
        Date date1 = TestHelper.getDatetime("2015-01-22 10:00:00");
        Date date2 = TestHelper.getDatetime("2015-04-22 11:00:00");
        FinancialAct balance = FinancialTestHelper.createTillBalance(this.till);
        List<FinancialAct> acts = FinancialTestHelper.createPaymentCash(BigDecimal.TEN, this.customer, this.till, "POSTED");
        Assert.assertEquals((long)2L, (long)acts.size());
        FinancialAct payment = acts.get(0);
        payment.setActivityStartTime(date1);
        FinancialAct paymentItem = acts.get(1);
        IMObjectBean bean = this.getBean((IMObject)balance);
        bean.addTarget("items", (IMObject)payment, "tillBalance");
        this.save((IMObject[])new FinancialAct[]{balance, payment, paymentItem});
        FinancialAct refund = this.rules.reverse(acts.get(0), date2, "reversal", null, true, balance);
        IMObjectBean refundBean = this.getBean((IMObject)refund);
        List items = refundBean.getTargets("items", Act.class);
        Assert.assertEquals((long)1L, (long)items.size());
        Act refundItem = (Act)items.get(0);
        TillBalanceQuery query = new TillBalanceQuery(balance, this.getArchetypeService());
        List results = query.query().getResults();
        Assert.assertEquals((long)2L, (long)results.size());
        this.check((ObjectSet)results.get(0), balance, payment, (Act)paymentItem, BigDecimal.TEN);
        this.check((ObjectSet)results.get(1), balance, refund, refundItem, BigDecimal.TEN.negate());
    }

    private void check(ObjectSet set, FinancialAct balance, FinancialAct act, Act item, BigDecimal amount) {
        Assert.assertEquals((Object)balance, (Object)set.get("tillBalance"));
        Assert.assertEquals((Object)act, (Object)set.get("act"));
        Assert.assertEquals((Object)item, (Object)set.get("item"));
        this.checkEquals(amount, set.getBigDecimal("amount"));
    }
}

