/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.tax;

import java.math.BigDecimal;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.tax.TaxRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TaxRulesTestCase
extends ArchetypeServiceTest {
    private Lookup taxType;
    private TaxRules rules;

    @Before
    public void setUp() {
        this.taxType = TestHelper.createTaxType(BigDecimal.TEN);
        Party practice = this.create("party.organisationPractice", Party.class);
        this.rules = new TaxRules(practice, (ArchetypeService)this.getArchetypeService());
    }

    @Test
    public void testGetTaxRate() {
        Product productNoTax = this.createProduct();
        BigDecimal noTax = this.rules.getTaxRate(productNoTax);
        this.checkEquals(BigDecimal.ZERO, noTax);
        Product product10Tax = this.createProductWithTax();
        BigDecimal percent10 = new BigDecimal(10);
        this.checkEquals(percent10, this.rules.getTaxRate(product10Tax));
        Product productType10Tax = this.createProductWithProductTypeTax();
        this.checkEquals(percent10, this.rules.getTaxRate(productType10Tax));
    }

    @Test
    public void testCalculateTax() {
        Product productNoTax = this.createProduct();
        BigDecimal ten = new BigDecimal(10);
        this.checkEquals(BigDecimal.ZERO, this.rules.calculateTax(ten, productNoTax, false));
        this.checkEquals(BigDecimal.ZERO, this.rules.calculateTax(ten, productNoTax, true));
        Product product10Tax = this.createProductWithTax();
        this.checkEquals(BigDecimal.ONE, this.rules.calculateTax(ten, product10Tax, false));
        this.checkEquals(new BigDecimal("0.909"), this.rules.calculateTax(ten, product10Tax, true));
        Product productType10Tax = this.createProductWithProductTypeTax();
        this.checkEquals(BigDecimal.ONE, this.rules.calculateTax(ten, productType10Tax, false));
        this.checkEquals(new BigDecimal("0.909"), this.rules.calculateTax(ten, productType10Tax, true));
    }

    @Test
    public void testGetTaxRateForInvalidProductType() {
        Product productNoTax = this.createProduct();
        Entity productType = this.create("entity.productType", Entity.class);
        IMObjectBean bean = this.getBean((IMObject)productNoTax);
        Relationship relationship = bean.addTarget("type", (IMObject)productType);
        relationship.setTarget(null);
        BigDecimal rate = this.rules.getTaxRate(productNoTax);
        this.checkEquals(BigDecimal.ZERO, rate);
    }

    private Product createProduct() {
        Product product = this.create("product.medication", Product.class);
        IMObjectBean bean = this.getBean((IMObject)product);
        bean.setValue("name", (Object)("TaxRulesTestCase-product" + product.hashCode()));
        return product;
    }

    private Product createProductWithTax() {
        Product product = this.createProduct();
        product.addClassification(this.taxType);
        this.save((IMObject)product);
        return product;
    }

    private Product createProductWithProductTypeTax() {
        Product product = TestHelper.createProduct();
        Entity type = this.create("entity.productType", Entity.class);
        type.setName("TaxRulesTestCase-entity" + type.hashCode());
        type.addClassification(this.taxType);
        IMObjectBean bean = this.getBean((IMObject)product);
        bean.addTarget("type", (IMObject)type);
        this.save((IMObject[])new Entity[]{product, type});
        return product;
    }
}

