/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.payment;

import java.math.BigDecimal;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.AbstractCustomerAccountTest;
import org.openvpms.archetype.test.builder.customer.account.TestCashPaymentItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCashRefundItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestEFTPaymentItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestEFTRefundItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestRefundBuilder;
import org.openvpms.archetype.test.builder.eft.TestEFTPOSPaymentBuilder;
import org.openvpms.archetype.test.builder.eft.TestEFTPOSRefundBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.business.service.ruleengine.RuleEngineException;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.springframework.beans.factory.annotation.Autowired;

public class PaymentRulesTestCase
extends AbstractCustomerAccountTest {
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;

    @Test
    public void testRemovePaymentRefundForPostedPayment() {
        FinancialAct unsaved = ((TestPaymentBuilder)this.newPayment((FinancialAct)((TestCashPaymentItemBuilder)this.accountFactory.newCashPaymentItem().amount(BigDecimal.TEN)).build(false)).status("POSTED")).build(false);
        this.checkRemovePaymentRefundForPostedAct(unsaved, false);
        FinancialAct savedInProgress = (FinancialAct)((TestPaymentBuilder)this.newPayment((FinancialAct)((TestCashPaymentItemBuilder)this.accountFactory.newCashPaymentItem().amount(BigDecimal.TEN)).build(false)).status("IN_PROGRESS")).build();
        savedInProgress.setStatus("POSTED");
        this.checkRemovePaymentRefundForPostedAct(savedInProgress, false);
        FinancialAct savedPosted = (FinancialAct)((TestPaymentBuilder)this.newPayment((FinancialAct)((TestCashPaymentItemBuilder)this.accountFactory.newCashPaymentItem().amount(BigDecimal.TEN)).build(false)).status("POSTED")).build();
        this.checkRemovePaymentRefundForPostedAct(savedPosted, true);
    }

    @Test
    public void testRemovePaymentRefundForPostedRefund() {
        FinancialAct unsaved = ((TestRefundBuilder)this.newRefund((FinancialAct)((TestCashRefundItemBuilder)this.accountFactory.newCashRefundItem().amount(BigDecimal.TEN)).build(false)).status("POSTED")).build(false);
        this.checkRemovePaymentRefundForPostedAct(unsaved, false);
        FinancialAct savedInProgress = (FinancialAct)((TestRefundBuilder)this.newRefund((FinancialAct)((TestCashRefundItemBuilder)this.accountFactory.newCashRefundItem().amount(BigDecimal.TEN)).build(false)).status("IN_PROGRESS")).build();
        savedInProgress.setStatus("POSTED");
        this.checkRemovePaymentRefundForPostedAct(savedInProgress, false);
        FinancialAct savedPosted = (FinancialAct)((TestRefundBuilder)this.newRefund((FinancialAct)((TestCashRefundItemBuilder)this.accountFactory.newCashRefundItem().amount(BigDecimal.TEN)).build(false)).status("POSTED")).build();
        this.checkRemovePaymentRefundForPostedAct(savedPosted, true);
    }

    @Test
    public void testRemovePayment() {
        FinancialAct item = (FinancialAct)((TestCashPaymentItemBuilder)this.accountFactory.newCashPaymentItem().amount(BigDecimal.TEN)).build(false);
        FinancialAct payment = this.createPayment(item);
        Assert.assertNotNull((Object)this.get(payment));
        Assert.assertNotNull((Object)this.get(item));
        this.remove((IMObject)payment);
        Assert.assertNull((Object)this.get(payment));
        Assert.assertNull((Object)this.get(item));
    }

    @Test
    public void testRemoveRefund() {
        FinancialAct item = (FinancialAct)((TestCashRefundItemBuilder)this.accountFactory.newCashRefundItem().amount(BigDecimal.TEN)).build(false);
        FinancialAct refund = this.createRefund(item);
        Assert.assertNotNull((Object)this.get(refund));
        Assert.assertNotNull((Object)this.get(item));
        this.remove((IMObject)refund);
        Assert.assertNull((Object)this.get(refund));
        Assert.assertNull((Object)this.get(item));
    }

    @Test
    public void testRemovePaymentWithEFTTransactions() {
        this.checkRemovePaymentWithEFT("PENDING", false);
        this.checkRemovePaymentWithEFT("IN_PROGRESS", false);
        this.checkRemovePaymentWithEFT("APPROVED", false);
        this.checkRemovePaymentWithEFT("DECLINED", false);
        this.checkRemovePaymentWithEFT("ERROR", false);
        this.checkRemovePaymentWithEFT("NO_TERMINAL", true);
    }

    @Test
    public void testRemoveEFTPaymentItem() {
        this.checkRemoveEFTPaymentItem("PENDING", false);
        this.checkRemoveEFTPaymentItem("IN_PROGRESS", false);
        this.checkRemoveEFTPaymentItem("APPROVED", false);
        this.checkRemoveEFTPaymentItem("DECLINED", false);
        this.checkRemoveEFTPaymentItem("ERROR", false);
        this.checkRemoveEFTPaymentItem("NO_TERMINAL", true);
    }

    @Test
    public void testRemoveRefundWithEFTTransactions() {
        this.checkRemoveRefundWithEFT("PENDING", false);
        this.checkRemoveRefundWithEFT("IN_PROGRESS", false);
        this.checkRemoveRefundWithEFT("APPROVED", false);
        this.checkRemoveRefundWithEFT("DECLINED", false);
        this.checkRemoveRefundWithEFT("ERROR", false);
        this.checkRemoveRefundWithEFT("NO_TERMINAL", true);
    }

    @Test
    public void testRemoveEFTRefundItem() {
        this.checkRemoveEFTRefundItem("PENDING", false);
        this.checkRemoveEFTRefundItem("IN_PROGRESS", false);
        this.checkRemoveEFTRefundItem("APPROVED", false);
        this.checkRemoveEFTRefundItem("DECLINED", false);
        this.checkRemoveEFTRefundItem("ERROR", false);
        this.checkRemoveEFTRefundItem("NO_TERMINAL", true);
    }

    private void checkRemovePaymentRefundForPostedAct(FinancialAct act, boolean fail) {
        try {
            this.remove((IMObject)act);
            if (fail) {
                Assert.fail((String)"Expected remove to fail");
            }
            Assert.assertNull((Object)this.get(act));
        }
        catch (RuleEngineException exception) {
            if (fail) {
                Throwable cause = ExceptionUtils.getRootCause((Throwable)exception.getCause());
                Assert.assertEquals((Object)"Act is POSTED", (Object)cause.getMessage());
            }
            Assert.fail((String)"Expected remove to succeed");
        }
    }

    private void checkRemovePaymentWithEFT(String status, boolean expectDeleted) {
        FinancialAct transaction = this.createEFTPOSPayment(status);
        FinancialAct item = (FinancialAct)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)this.accountFactory.newEFTPaymentItem().addTransaction(transaction)).amount(BigDecimal.TEN)).build(false);
        FinancialAct payment = this.createPayment(item);
        this.remove((IMObject)payment);
        Assert.assertNull((Object)this.get(payment));
        Assert.assertNull((Object)this.get(item));
        if (expectDeleted) {
            Assert.assertNull((Object)this.get(transaction));
        } else {
            Assert.assertNotNull((Object)this.get(transaction));
        }
    }

    private void checkRemoveEFTPaymentItem(String status, boolean expectDeleted) {
        FinancialAct transaction = this.createEFTPOSPayment(status);
        FinancialAct item = (FinancialAct)((TestEFTPaymentItemBuilder)((TestEFTPaymentItemBuilder)this.accountFactory.newEFTPaymentItem().addTransaction(transaction)).amount(BigDecimal.TEN)).build(false);
        FinancialAct payment = this.createPayment(item);
        this.remove((IMObject)item);
        Assert.assertNotNull((Object)this.get(payment));
        Assert.assertNull((Object)this.get(item));
        if (expectDeleted) {
            Assert.assertNull((Object)this.get(transaction));
        } else {
            Assert.assertNotNull((Object)this.get(transaction));
        }
    }

    private FinancialAct createPayment(FinancialAct item) {
        return (FinancialAct)this.newPayment(item).build();
    }

    private TestPaymentBuilder newPayment(FinancialAct item) {
        return (TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(this.getCustomer())).till(this.getTill())).add(item)).status("IN_PROGRESS");
    }

    private FinancialAct createEFTPOSPayment(String status) {
        return (FinancialAct)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)((TestEFTPOSPaymentBuilder)this.accountFactory.newEFTPOSPayment().customer(this.getCustomer())).terminal(this.practiceFactory.createEFTPOSTerminal())).amount(BigDecimal.TEN)).location(this.practiceFactory.createLocation())).status(status)).build();
    }

    private void checkRemoveRefundWithEFT(String status, boolean expectDeleted) {
        FinancialAct transaction = this.createEFTPOSRefund(status);
        FinancialAct item = (FinancialAct)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)this.accountFactory.newEFTRefundItem().addTransaction(transaction)).amount(BigDecimal.TEN)).build(false);
        FinancialAct refund = this.createRefund(item);
        this.remove((IMObject)refund);
        Assert.assertNull((Object)this.get(refund));
        Assert.assertNull((Object)this.get(item));
        if (expectDeleted) {
            Assert.assertNull((Object)this.get(transaction));
        } else {
            Assert.assertNotNull((Object)this.get(transaction));
        }
    }

    private void checkRemoveEFTRefundItem(String status, boolean expectDeleted) {
        FinancialAct transaction = this.createEFTPOSRefund(status);
        FinancialAct item = (FinancialAct)((TestEFTRefundItemBuilder)((TestEFTRefundItemBuilder)this.accountFactory.newEFTRefundItem().addTransaction(transaction)).amount(BigDecimal.TEN)).build(false);
        FinancialAct refund = this.createRefund(item);
        this.remove((IMObject)item);
        Assert.assertNotNull((Object)this.get(refund));
        Assert.assertNull((Object)this.get(item));
        if (expectDeleted) {
            Assert.assertNull((Object)this.get(transaction));
        } else {
            Assert.assertNotNull((Object)this.get(transaction));
        }
    }

    private FinancialAct createRefund(FinancialAct item) {
        return (FinancialAct)this.newRefund(item).build();
    }

    private TestRefundBuilder newRefund(FinancialAct item) {
        return (TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().customer(this.getCustomer())).till(this.getTill())).add(item)).status("IN_PROGRESS");
    }

    private FinancialAct createEFTPOSRefund(String status) {
        return (FinancialAct)((TestEFTPOSRefundBuilder)((TestEFTPOSRefundBuilder)((TestEFTPOSRefundBuilder)((TestEFTPOSRefundBuilder)((TestEFTPOSRefundBuilder)this.accountFactory.newEFTPOSRefund().customer(this.getCustomer())).terminal(this.practiceFactory.createEFTPOSTerminal())).amount(BigDecimal.TEN)).location(this.practiceFactory.createLocation())).status(status)).build();
    }
}

