/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.order;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.order.OrderRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;

public class OrderRulesTestCase
extends ArchetypeServiceTest {
    @Test
    public void testHasOrdersForCustomer() {
        OrderRules rules = new OrderRules(this.getArchetypeService());
        Party customer1 = TestHelper.createCustomer();
        Party customer2 = TestHelper.createCustomer();
        Party patient1 = TestHelper.createPatient();
        Party patient2 = TestHelper.createPatient();
        Assert.assertFalse((boolean)rules.hasOrders(customer1));
        Act act1 = this.createOrder(customer1, patient1);
        Assert.assertTrue((boolean)rules.hasOrders(customer1));
        Assert.assertFalse((boolean)rules.hasOrders(customer2));
        act1.setStatus("POSTED");
        this.save((IMObject)act1);
        Assert.assertFalse((boolean)rules.hasOrders(customer1));
        Act act2 = this.createReturn(customer2, patient2);
        Assert.assertTrue((boolean)rules.hasOrders(customer2));
        act2.setStatus("POSTED");
        this.save((IMObject)act2);
        Assert.assertFalse((boolean)rules.hasOrders(customer2));
    }

    @Test
    public void testHasOrdersForCustomerAndPatient() {
        OrderRules rules = new OrderRules(this.getArchetypeService());
        Party customer1 = TestHelper.createCustomer();
        Party customer2 = TestHelper.createCustomer();
        Party patient1 = TestHelper.createPatient();
        Party patient2 = TestHelper.createPatient();
        Assert.assertFalse((boolean)rules.hasOrders(customer1, patient1));
        Act act1 = this.createOrder(customer1, patient1);
        Assert.assertTrue((boolean)rules.hasOrders(customer1, patient1));
        Assert.assertFalse((boolean)rules.hasOrders(customer1, patient2));
        Assert.assertFalse((boolean)rules.hasOrders(customer2, patient2));
        Assert.assertFalse((boolean)rules.hasOrders(customer2, patient1));
        act1.setStatus("POSTED");
        this.save((IMObject)act1);
        Assert.assertFalse((boolean)rules.hasOrders(customer1, patient1));
        Act act2 = this.createReturn(customer2, patient2);
        Assert.assertTrue((boolean)rules.hasOrders(customer2, patient2));
        act2.setStatus("POSTED");
        this.save((IMObject)act2);
        Assert.assertFalse((boolean)rules.hasOrders(customer2, patient2));
    }

    @Test
    public void testGetOrdersForCustomer() {
        Party customer1 = TestHelper.createCustomer();
        Party customer2 = TestHelper.createCustomer();
        Party patient1 = TestHelper.createPatient();
        Party patient2 = TestHelper.createPatient();
        this.checkGetOrders(customer1, new Act[0]);
        Act act1 = this.createOrder(customer1, patient1);
        Act act2 = this.createReturn(customer1, patient1);
        this.checkGetOrders(customer1, act1, act2);
        this.checkGetOrders(customer2, new Act[0]);
        act1.setStatus("POSTED");
        this.save((IMObject)act1);
        this.checkGetOrders(customer1, act2);
        this.addItem(act2, patient1);
        this.checkGetOrders(customer1, act2);
        this.addItem(act2, patient2);
        this.checkGetOrders(customer1, act2);
    }

    @Test
    public void testGetOrdersForCustomerAndPatient() {
        Party customer1 = TestHelper.createCustomer();
        Party customer2 = TestHelper.createCustomer();
        Party patient1 = TestHelper.createPatient();
        Party patient2 = TestHelper.createPatient();
        this.checkGetOrders(customer1, patient1, new Act[0]);
        Act act1 = this.createOrder(customer1, patient1);
        Act act2 = this.createReturn(customer1, patient1);
        this.checkGetOrders(customer1, patient1, act1, act2);
        this.checkGetOrders(customer1, patient2, new Act[0]);
        this.checkGetOrders(customer2, patient2, new Act[0]);
        this.checkGetOrders(customer2, patient1, new Act[0]);
        act1.setStatus("POSTED");
        this.save((IMObject)act1);
        this.checkGetOrders(customer1, patient1, act2);
        this.addItem(act2, patient1);
        this.checkGetOrders(customer1, patient1, act2);
        this.addItem(act2, patient2);
        this.checkGetOrders(customer1, patient1, act2);
        this.checkGetOrders(customer1, patient2, act2);
    }

    private void checkGetOrders(Party customer, Act ... expected) {
        OrderRules rules = new OrderRules(this.getArchetypeService());
        List orders = rules.getOrders(customer);
        this.checkOrders(orders, expected);
    }

    private void checkGetOrders(Party customer, Party patient, Act ... expected) {
        OrderRules rules = new OrderRules(this.getArchetypeService());
        List orders = rules.getOrders(customer, patient);
        this.checkOrders(orders, expected);
    }

    private void checkOrders(List<Act> orders, Act[] expected) {
        Assert.assertEquals((long)expected.length, (long)orders.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)orders.get(i));
        }
    }

    private Act createOrder(Party customer, Party patient) {
        return this.createOrderReturn("act.customerOrderPharmacy", customer, patient);
    }

    private Act createReturn(Party customer, Party patient) {
        return this.createOrderReturn("act.customerReturnPharmacy", customer, patient);
    }

    private Act createOrderReturn(String shortName, Party customer, Party patient) {
        Act order = this.create(shortName, Act.class);
        IMObjectBean bean = this.getBean((IMObject)order);
        bean.setTarget("customer", (IMObject)customer);
        this.addItem(order, patient);
        return order;
    }

    private void addItem(Act act, Party patient) {
        String shortName = TypeHelper.isA((IMObject)act, (String)"act.customerOrderPharmacy") ? "act.customerOrderItemPharmacy" : "act.customerReturnItemPharmacy";
        IMObjectBean bean = this.getBean((IMObject)act);
        Act item = this.create(shortName, Act.class);
        IMObjectBean itemBean = this.getBean((IMObject)item);
        itemBean.setTarget("patient", (IMObject)patient);
        Relationship relationship = bean.addTarget("items", (IMObject)item);
        item.addActRelationship((ActRelationship)relationship);
        this.save((IMObject[])new Act[]{act, item});
    }
}

