/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.invoice;

import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemBuilder;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryFactory;
import org.openvpms.archetype.test.builder.patient.TestInvestigationBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientAlertBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFormBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientMedicationBuilder;
import org.openvpms.archetype.test.builder.patient.TestVisitBuilder;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderBuilder;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.product.TestServiceProductBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.archetype.test.builder.scheduling.TestTaskBuilder;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.springframework.beans.factory.annotation.Autowired;

public class InvoiceRulesTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestLaboratoryFactory laboratoryFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestSchedulingFactory schedulingFactory;
    @Autowired
    private TestReminderFactory reminderFactory;
    @Autowired
    private TestUserFactory userFactory;
    private Party customer;
    private Party patient;
    private User clinician;

    @Before
    public void setUp() {
        this.customer = this.customerFactory.createCustomer();
        this.clinician = this.userFactory.createClinician();
        this.patient = this.patientFactory.createPatient();
    }

    @Test
    public void testRemoveInvoice() {
        this.checkRemove(true, true);
        this.checkRemove(false, true);
    }

    @Test
    public void testRemoveInvoiceItem() {
        this.checkRemove(true, false);
        this.checkRemove(false, false);
    }

    @Test
    public void testRemoveInvoiceItemHavingInvestigationsWithResults() {
        Product product = this.productFactory.createMedication();
        TestInvoiceItemBuilder itemBuilder = this.newInvoiceItem(product);
        DocumentAct investigation1 = this.createInvestigation("IN_PROGRESS");
        DocumentAct investigation2 = this.createInvestigationWithReport("IN_PROGRESS");
        DocumentAct investigation3 = this.createInvestigationWithReport("CANCELLED");
        DocumentAct investigation4 = this.createInvestigationWithReport("POSTED");
        itemBuilder.addInvestigations(investigation1, investigation2, investigation3, investigation4);
        TestInvoiceBuilder invoiceBuilder = (TestInvoiceBuilder)itemBuilder.add();
        FinancialAct invoice = (FinancialAct)invoiceBuilder.build();
        this.remove((IMObject)invoice);
        Assert.assertNull((Object)this.get(invoice));
        Assert.assertNull((Object)this.get(investigation1));
        Assert.assertNotNull((Object)this.get(investigation2));
        Assert.assertNotNull((Object)this.get(investigation3));
        Assert.assertNotNull((Object)this.get(investigation4));
    }

    @Test
    public void testDemographicUpdates() {
        FinancialAct invoice = this.createInvoice(this.createDesexingProduct());
        IMObjectBean bean = this.getBean((IMObject)this.patient);
        Assert.assertFalse((boolean)bean.getBoolean("desexed"));
        invoice.setStatus("POSTED");
        this.save((IMObject)invoice);
        bean = this.get(bean);
        Assert.assertTrue((boolean)bean.getBoolean("desexed"));
    }

    private void checkRemove(boolean inProgressMedication, boolean removeInvoice) {
        Product product = this.productFactory.createMedication();
        TestInvoiceItemBuilder itemBuilder = this.newInvoiceItem(product);
        Act medication = (Act)((TestPatientMedicationBuilder)((TestPatientMedicationBuilder)this.patientFactory.newMedication().patient(this.patient)).product(product).status(inProgressMedication ? "IN_PROGRESS" : "POSTED")).build();
        itemBuilder.medication(medication);
        Act visit = (Act)((TestVisitBuilder)((TestVisitBuilder)this.patientFactory.newVisit().patient(this.patient)).status("IN_PROGRESS")).build();
        itemBuilder.visit(visit);
        DocumentAct investigation1 = this.createInvestigation("IN_PROGRESS");
        DocumentAct investigation2 = this.createInvestigation("CANCELLED");
        DocumentAct investigation3 = this.createInvestigation("POSTED");
        itemBuilder.addInvestigations(investigation1, investigation2, investigation3);
        DocumentAct document1 = this.createDocument(product, "IN_PROGRESS");
        DocumentAct document2 = this.createDocument(product, "COMPLETED");
        DocumentAct document3 = this.createDocument(product, "POSTED");
        itemBuilder.addDocuments(document1, document2, document3);
        Act reminder1 = this.createReminder("IN_PROGRESS");
        Act reminder2 = this.createReminder("CANCELLED");
        Act reminder3 = this.createReminder("COMPLETED");
        itemBuilder.addReminders(reminder1, reminder2, reminder3);
        Act alert1 = this.createAlert("IN_PROGRESS");
        Act alert2 = this.createAlert("COMPLETED");
        itemBuilder.addAlerts(alert1, alert2);
        Act task1 = this.createTask("PENDING");
        Act task2 = this.createTask("IN_PROGRESS");
        Act task3 = this.createTask("CANCELLED");
        Act task4 = this.createTask("BILLED");
        Act task5 = this.createTask("COMPLETED");
        itemBuilder.addTasks(task1, task2, task3, task4, task5);
        TestInvoiceBuilder invoiceBuilder = (TestInvoiceBuilder)itemBuilder.add();
        FinancialAct invoice = (FinancialAct)invoiceBuilder.build();
        FinancialAct item = invoiceBuilder.getItems().get(0);
        item = this.get(item);
        IMObjectBean bean = this.getBean((IMObject)item);
        Assert.assertEquals((Object)visit, (Object)bean.getSource("event"));
        Assert.assertEquals((Object)medication, (Object)bean.getTarget("dispensing"));
        List investigations = bean.getTargets("investigations", DocumentAct.class);
        Assert.assertEquals((long)3L, (long)investigations.size());
        List documents = bean.getTargets("documents", Act.class);
        Assert.assertEquals((long)3L, (long)documents.size());
        List reminders = bean.getTargets("reminders", Act.class);
        Assert.assertEquals((long)3L, (long)reminders.size());
        List alerts = bean.getTargets("alerts", Act.class);
        Assert.assertEquals((long)2L, (long)alerts.size());
        if (removeInvoice) {
            this.remove((IMObject)invoice);
            Assert.assertNull((Object)this.get(invoice));
        } else {
            this.remove(bean.getObject());
        }
        Assert.assertNull((Object)this.get(item));
        Assert.assertNotNull((Object)this.get(visit));
        Assert.assertNull((Object)this.get(medication));
        Assert.assertNull((Object)this.get(investigation1));
        Assert.assertNotNull((Object)this.get(investigation2));
        Assert.assertNotNull((Object)this.get(investigation3));
        Assert.assertNull((Object)this.get(document1));
        Assert.assertNotNull((Object)this.get(document2));
        Assert.assertNotNull((Object)this.get(document3));
        Assert.assertNull((Object)this.get(reminder1));
        Assert.assertNull((Object)this.get(reminder2));
        Assert.assertNotNull((Object)this.get(reminder3));
        Assert.assertNull((Object)this.get(alert1));
        Assert.assertNotNull((Object)this.get(alert2));
        Assert.assertNull((Object)this.get(task1));
        Assert.assertNull((Object)this.get(task2));
        Assert.assertNull((Object)this.get(task3));
        Assert.assertNotNull((Object)this.get(task4));
        Assert.assertNotNull((Object)this.get(task5));
    }

    private DocumentAct createDocument(Product product, String status) {
        Entity template = this.documentFactory.createTemplate("act.patientDocumentForm");
        return (DocumentAct)((TestPatientFormBuilder)((TestPatientFormBuilder)((TestPatientFormBuilder)this.patientFactory.newForm().patient(this.patient)).template(template).product(product).clinician(this.clinician)).status(status)).build();
    }

    private FinancialAct createInvoice(Product product) {
        return (FinancialAct)((TestInvoiceBuilder)this.newInvoiceItem(product).add()).build();
    }

    private TestInvoiceItemBuilder newInvoiceItem(Product product) {
        return (TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceBuilder)((TestInvoiceBuilder)this.accountFactory.newInvoice().customer(this.customer)).status("IN_PROGRESS")).item().patient(this.patient)).clinician(this.clinician)).product(product);
    }

    private Act createReminder(String status) {
        Entity reminderType = this.reminderFactory.createReminderType();
        return (Act)((TestReminderBuilder)((TestReminderBuilder)this.reminderFactory.newReminder().patient(this.patient)).reminderType(reminderType).status(status)).build();
    }

    private Act createAlert(String status) {
        Entity alertType = this.patientFactory.createAlertType();
        return (Act)((TestPatientAlertBuilder)((TestPatientAlertBuilder)this.patientFactory.newAlert().patient(this.patient)).alertType(alertType).status(status)).build();
    }

    private Act createTask(String status) {
        return (Act)((TestTaskBuilder)((TestTaskBuilder)((TestTaskBuilder)((TestTaskBuilder)this.schedulingFactory.newTask().startTime(new Date())).taskType(this.schedulingFactory.createTaskType()).workList(this.schedulingFactory.createWorkList()).customer(this.customer)).patient(this.patient)).status(status)).build();
    }

    private DocumentAct createInvestigation(String status) {
        return (DocumentAct)this.newInvestigation(status).build();
    }

    private DocumentAct createInvestigationWithReport(String status) {
        return (DocumentAct)this.newInvestigation(status).report(this.documentFactory.createText()).build();
    }

    private TestInvestigationBuilder newInvestigation(String status) {
        Entity investigationType = this.laboratoryFactory.createInvestigationType();
        return (TestInvestigationBuilder)((TestInvestigationBuilder)((TestInvestigationBuilder)this.patientFactory.newInvestigation().patient(this.patient)).clinician(this.clinician)).investigationType(investigationType).status(status);
    }

    private Product createDesexingProduct() {
        Lookup lookup = this.productFactory.createDemographicUpdate("patient.entity", "party:setPatientDesexed(.)");
        return (Product)((TestServiceProductBuilder)this.productFactory.newService().addDemographicUpdate(lookup)).build();
    }
}

