/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.invoice;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.invoice.ChargeItemDocumentLinker;
import org.openvpms.archetype.rules.finance.invoice.ChargeItemEventLinker;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.patient.PatientHistoryChanges;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.beans.factory.annotation.Autowired;

public class ChargeItemEventLinkerTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestLaboratoryFactory laboratoryFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestUserFactory userFactory;
    private Party location;
    private User clinician;
    private MedicalRecordRules rules;

    @Before
    public void setUp() {
        this.clinician = this.userFactory.createClinician();
        this.location = this.practiceFactory.createLocation();
        this.rules = new MedicalRecordRules(this.getArchetypeService());
    }

    @Test
    public void testSingleLink() {
        Date startTime = new Date();
        Party patient = this.patientFactory.createPatient();
        FinancialAct item = this.createInvoiceItem(startTime, patient);
        Assert.assertNull((Object)this.rules.getEvent(patient, startTime, this.location));
        ChargeItemEventLinker linker = new ChargeItemEventLinker((ArchetypeService)this.getArchetypeService());
        PatientHistoryChanges changes = new PatientHistoryChanges(this.location, (ArchetypeService)this.getArchetypeService());
        linker.link(item, changes);
        Act event = this.rules.getEvent(patient, startTime, this.location);
        Assert.assertNotNull((Object)event);
        this.checkEvent(item, event, this.location);
        linker.link(item, changes);
        this.checkEvent(item, event, this.location);
    }

    @Test
    public void testMultipleLinkSameStartTime() {
        Date startTime = new Date();
        Party patient = this.patientFactory.createPatient();
        FinancialAct item1 = this.createInvoiceItem(startTime, patient);
        FinancialAct item2 = this.createInvoiceItem(startTime, patient);
        ChargeItemEventLinker linker = new ChargeItemEventLinker((ArchetypeService)this.getArchetypeService());
        List<FinancialAct> items = Arrays.asList(item1, item2);
        linker.link(items, new PatientHistoryChanges(this.location, (ArchetypeService)this.getArchetypeService()));
        Act event = this.rules.getEvent(patient, startTime, this.location);
        Assert.assertNotNull((Object)event);
        this.checkEvent(item1, event, this.location);
        this.checkEvent(item2, event, this.location);
        linker.link(items, new PatientHistoryChanges(this.location, (ArchetypeService)this.getArchetypeService()));
        this.checkEvent(item1, event, this.location);
        this.checkEvent(item2, event, this.location);
    }

    @Test
    public void testMultipleLinkDifferentStartTime() {
        Date startTime1 = TestHelper.getDate("2011-01-09");
        Date startTime2 = TestHelper.getDate("2011-01-02");
        Party patient = this.patientFactory.createPatient();
        FinancialAct item1 = this.createInvoiceItem(startTime1, patient);
        FinancialAct item2 = this.createInvoiceItem(startTime2, patient);
        ChargeItemEventLinker linker1 = new ChargeItemEventLinker((ArchetypeService)this.getArchetypeService());
        List<FinancialAct> items = Arrays.asList(item1, item2);
        linker1.link(items, new PatientHistoryChanges(this.location, (ArchetypeService)this.getArchetypeService()));
        Act event1 = this.rules.getEvent(patient, startTime1, this.location);
        Act event2 = this.rules.getEvent(patient, startTime2, this.location);
        Assert.assertNotNull((Object)event1);
        Assert.assertNotNull((Object)event2);
        Assert.assertNotEquals((Object)event1, (Object)event2);
        this.checkEvent(item1, event1, this.location);
        this.checkEvent(item2, event2, this.location);
        linker1.link(items, new PatientHistoryChanges(this.location, (ArchetypeService)this.getArchetypeService()));
        this.checkEvent(item1, event1, this.location);
        this.checkEvent(item2, event2, this.location);
        FinancialAct item3 = this.createInvoiceItem(startTime1, patient);
        Party location2 = this.practiceFactory.createLocation();
        ChargeItemEventLinker linker2 = new ChargeItemEventLinker((ArchetypeService)this.getArchetypeService());
        linker2.link(item3, new PatientHistoryChanges(location2, (ArchetypeService)this.getArchetypeService()));
        Act event3 = this.rules.getEvent(patient, startTime1, location2);
        Assert.assertNotEquals((long)event3.getId(), (long)event1.getId());
        Assert.assertNotEquals((long)event3.getId(), (long)event2.getId());
        this.checkEvent(item3, event3, location2);
    }

    @Test
    public void testDifferentPatients() {
        Date startTime = new Date();
        Party patient1 = this.patientFactory.createPatient();
        Party patient2 = this.patientFactory.createPatient();
        FinancialAct item1 = this.createInvoiceItem(startTime, patient1);
        FinancialAct item2 = this.createInvoiceItem(startTime, patient2);
        ChargeItemEventLinker linker = new ChargeItemEventLinker((ArchetypeService)this.getArchetypeService());
        List<FinancialAct> items = Arrays.asList(item1, item2);
        linker.link(items, new PatientHistoryChanges(this.location, (ArchetypeService)this.getArchetypeService()));
        Act event1 = this.rules.getEvent(patient1, startTime, this.location);
        Assert.assertNotNull((Object)event1);
        Act event2 = this.rules.getEvent(patient2, startTime, this.location);
        Assert.assertNotNull((Object)event2);
        Assert.assertNotEquals((Object)event1, (Object)event2);
        this.checkEvent(item1, event1, this.location);
        this.checkEvent(item2, event2, this.location);
        linker.link(items, new PatientHistoryChanges(this.location, (ArchetypeService)this.getArchetypeService()));
        this.checkEvent(item1, event1, this.location);
        this.checkEvent(item2, event2, this.location);
    }

    @Test
    public void testLinkForDifferentEvents() {
        Date date1 = TestHelper.getDate("2013-05-15");
        Date date2 = TestHelper.getDate("2013-05-16");
        Party patient = this.patientFactory.createPatient();
        Act event1 = this.rules.createEvent(patient, date1, (Entity)this.clinician, this.location);
        Act event2 = this.rules.createEvent(patient, date2, (Entity)this.clinician, this.location);
        FinancialAct item = this.createInvoiceItem(date1, patient);
        ChargeItemEventLinker linker = new ChargeItemEventLinker((ArchetypeService)this.getArchetypeService());
        linker.link(event1, (Act)item, new PatientHistoryChanges(this.location, (ArchetypeService)this.getArchetypeService()));
        this.checkEvent(item, event1, this.location);
        linker.link(event1, (Act)item, new PatientHistoryChanges(this.location, (ArchetypeService)this.getArchetypeService()));
        this.checkEvent(item, event1, this.location);
        linker.link(event2, (Act)item, new PatientHistoryChanges(this.location, (ArchetypeService)this.getArchetypeService()));
        item = this.get(item);
        this.checkEvent(item, event1, this.location);
        IMObjectBean event2Bean = this.getBean((IMObject)event2);
        Assert.assertFalse((boolean)event2Bean.hasTarget("items", (IMObject)item));
        IMObjectBean itemBean = this.getBean((IMObject)item);
        Assert.assertEquals((long)3L, (long)item.getSourceActRelationships().size());
        for (Relationship relationship : item.getSourceActRelationships()) {
            Assert.assertFalse((boolean)event2Bean.hasTarget("items", relationship.getTarget()));
        }
    }

    @Test
    public void testChangePatient() {
        Date startTime = new Date();
        Party patient1 = this.patientFactory.createPatient();
        Party patient2 = this.patientFactory.createPatient();
        FinancialAct item1 = this.createInvoiceItem(startTime, patient1);
        FinancialAct item2 = this.createInvoiceItem(startTime, patient2);
        ChargeItemEventLinker linker = new ChargeItemEventLinker((ArchetypeService)this.getArchetypeService());
        List<FinancialAct> items = Arrays.asList(item1, item2);
        linker.link(items, new PatientHistoryChanges(this.location, (ArchetypeService)this.getArchetypeService()));
        Act event1 = this.rules.getEvent(patient1, startTime, this.location);
        Assert.assertNotNull((Object)event1);
        Act event2 = this.rules.getEvent(patient2, startTime, this.location);
        Assert.assertNotNull((Object)event2);
        Assert.assertNotEquals((Object)event1, (Object)event2);
        this.checkEvent(item1, event1, this.location);
        this.checkEvent(item2, event2, this.location);
        IMObjectBean itemBean = this.getBean((IMObject)item2);
        itemBean.setTarget("patient", (IMObject)patient1);
        itemBean.save();
        linker.link(items, new PatientHistoryChanges(this.location, (ArchetypeService)this.getArchetypeService()));
        this.checkEvent(item1, event1, this.location);
        event1 = this.get(event1);
        IMObjectBean event1Bean = this.getBean((IMObject)event1);
        Assert.assertTrue((boolean)event1Bean.hasTarget("chargeItems", (IMObject)item2));
        event2 = this.get(event2);
        IMObjectBean event2Bean = this.getBean((IMObject)event2);
        Assert.assertFalse((boolean)event2Bean.hasTarget("chargeItems", (IMObject)item2));
    }

    private void checkEvent(FinancialAct item, Act event, Party location) {
        item = this.get(item);
        event = this.get(event);
        Assert.assertNotNull((Object)item);
        Assert.assertNotNull((Object)event);
        IMObjectBean bean = this.getBean((IMObject)item);
        List dispensing = bean.getTargets("dispensing", Act.class);
        List investigations = bean.getTargets("investigations", Act.class);
        List documents = bean.getTargets("documents", Act.class);
        Assert.assertEquals((long)1L, (long)dispensing.size());
        Assert.assertEquals((long)1L, (long)investigations.size());
        Assert.assertEquals((long)1L, (long)documents.size());
        IMObjectBean eventBean = this.getBean((IMObject)event);
        if (location == null) {
            Assert.assertNull((Object)eventBean.getTarget("location"));
        } else {
            Assert.assertEquals((Object)location.getObjectReference(), (Object)eventBean.getTargetRef("location"));
        }
        Assert.assertTrue((boolean)eventBean.hasTarget("chargeItems", (IMObject)item));
        Assert.assertTrue((boolean)eventBean.hasTarget("items", (IMObject)investigations.get(0)));
        Assert.assertTrue((boolean)eventBean.hasTarget("items", (IMObject)dispensing.get(0)));
        Assert.assertTrue((boolean)eventBean.hasTarget("items", (IMObject)documents.get(0)));
    }

    private FinancialAct createInvoiceItem(Date startTime, Party patient) {
        FinancialAct act = this.create("act.customerAccountInvoiceItem", FinancialAct.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        act.setActivityStartTime(startTime);
        bean.setTarget("patient", (IMObject)patient);
        bean.setTarget("clinician", (IMObject)this.clinician);
        Entity investigationType = this.laboratoryFactory.createInvestigationType();
        Entity test = this.laboratoryFactory.createTest(investigationType);
        Entity template = this.createDocumentTemplate();
        Product product = this.createProduct(test, template);
        Act medication = this.createMedication(product, patient);
        bean.setTarget("product", (IMObject)product);
        bean.addTarget("dispensing", (IMObject)medication);
        Act investigation = this.createInvestigation(investigationType, patient);
        bean.addTarget("investigations", (IMObject)investigation);
        this.save((IMObject[])new Act[]{act, medication, investigation});
        ChargeItemDocumentLinker linker = new ChargeItemDocumentLinker(act, this.getArchetypeService());
        linker.link();
        return act;
    }

    private Entity createDocumentTemplate() {
        return this.documentFactory.createTemplate("act.patientDocumentForm");
    }

    private Product createProduct(Entity test, Entity template) {
        Product product = this.create("product.medication", Product.class);
        IMObjectBean bean = this.getBean((IMObject)product);
        bean.setValue("name", (Object)"XProduct");
        bean.addTarget("tests", (IMObject)test);
        bean.addTarget("documents", (IMObject)template);
        bean.save();
        return product;
    }

    private Act createMedication(Product product, Party patient) {
        Act act = this.create("act.patientMedication", Act.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("patient", (IMObject)patient);
        bean.setTarget("product", (IMObject)product);
        return act;
    }

    private Act createInvestigation(Entity investigationType, Party patient) {
        Act act = this.create("act.patientInvestigation", Act.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("patient", (IMObject)patient);
        bean.setTarget("investigationType", (IMObject)investigationType);
        return act;
    }
}

