/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.invoice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.invoice.ChargeItemDocumentLinker;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.patient.PatientHistoryChanges;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemBuilder;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class ChargeItemDocumentLinkerTestCase
extends ArchetypeServiceTest {
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestUserFactory userFactory;

    @Test
    public void testSimpleLink() {
        Party patient = this.patientFactory.createPatient();
        Entity template1 = this.documentFactory.createTemplate("act.patientDocumentForm");
        Entity template2 = this.documentFactory.createTemplate("act.patientDocumentLetter");
        Product product1 = this.createProduct(template1);
        User clinician = this.userFactory.createClinician();
        Party location = this.practiceFactory.createLocation();
        PatientHistoryChanges changes = new PatientHistoryChanges(location, (ArchetypeService)this.getArchetypeService());
        Product product2 = this.createProduct(template2);
        Product product3 = this.createProduct(template1, template2);
        Product product4 = this.createProduct(new Entity[0]);
        FinancialAct item = this.createItem(patient, product1, clinician);
        this.save((IMObject)item);
        ChargeItemDocumentLinker linker = new ChargeItemDocumentLinker(item, this.getArchetypeService());
        linker.link();
        IMObjectBean bean = this.getBean((IMObject)item);
        List documents = bean.getTargets("documents", Act.class);
        Assert.assertEquals((long)1L, (long)documents.size());
        Act document1 = (Act)documents.get(0);
        Assert.assertTrue((boolean)TypeHelper.isA((IMObject)document1, (String)"act.patientDocumentForm"));
        this.checkDocument(document1, patient, product1, template1, clinician, item);
        bean.setTarget("product", (IMObject)product2);
        linker.link();
        documents = bean.getTargets("documents", Act.class);
        Assert.assertEquals((long)1L, (long)documents.size());
        Act document2 = (Act)documents.get(0);
        Assert.assertTrue((boolean)TypeHelper.isA((IMObject)document2, (String)"act.patientDocumentLetter"));
        this.checkDocument(document2, patient, product2, template2, clinician, item);
        bean.setTarget("product", (IMObject)product3);
        linker.prepare(changes);
        this.saveInTxn(changes);
        documents = bean.getTargets("documents", Act.class);
        Assert.assertEquals((long)2L, (long)documents.size());
        Act doc3template1 = this.getDocument(documents, template1);
        Act doc3template2 = this.getDocument(documents, template2);
        Assert.assertTrue((boolean)TypeHelper.isA((IMObject)doc3template1, (String)"act.patientDocumentForm"));
        Assert.assertTrue((boolean)TypeHelper.isA((IMObject)doc3template2, (String)"act.patientDocumentLetter"));
        this.checkDocument(doc3template1, patient, product3, template1, clinician, item);
        this.checkDocument(doc3template2, patient, product3, template2, clinician, item);
        bean.setTarget("product", (IMObject)product4);
        linker.link();
        documents = bean.getTargets("documents", Act.class);
        Assert.assertEquals((long)0L, (long)documents.size());
    }

    @Test
    public void testRecreateDocumentActsForDifferentParticipant() {
        User clinician1 = this.userFactory.createClinician();
        User clinician2 = this.userFactory.createClinician();
        Party patient1 = this.patientFactory.createPatient();
        Party patient2 = this.patientFactory.createPatient();
        Entity template1 = this.documentFactory.createTemplate("act.patientDocumentForm");
        Entity template2 = this.documentFactory.createTemplate("act.patientDocumentLetter");
        Product product1 = this.createProduct(template1);
        Product product2 = this.createProduct(template2);
        FinancialAct item = this.createItem(patient1, product1, clinician1);
        ChargeItemDocumentLinker linker = new ChargeItemDocumentLinker(item, this.getArchetypeService());
        linker.link();
        IMObjectBean bean = this.getBean((IMObject)item);
        List documents = bean.getTargets("documents", Act.class);
        Assert.assertEquals((long)1L, (long)documents.size());
        Act document1 = (Act)documents.get(0);
        this.checkDocument(document1, patient1, product1, template1, clinician1, item);
        linker.link();
        documents = bean.getTargets("documents", Act.class);
        Assert.assertEquals((long)1L, (long)documents.size());
        Act same = (Act)documents.get(0);
        Assert.assertEquals((Object)document1, (Object)same);
        bean.setTarget("product", (IMObject)product2);
        linker.link();
        documents = bean.getTargets("documents", Act.class);
        Assert.assertEquals((long)1L, (long)documents.size());
        Act different1 = (Act)documents.get(0);
        Assert.assertNotEquals((Object)document1, (Object)different1);
        Assert.assertNull((Object)this.get(document1));
        this.checkDocument(different1, patient1, product2, template2, clinician1, item);
        bean.setTarget("patient", (IMObject)patient2);
        linker.link();
        documents = bean.getTargets("documents", Act.class);
        Assert.assertEquals((long)1L, (long)documents.size());
        Act different2 = (Act)documents.get(0);
        Assert.assertNotEquals((Object)different1, (Object)different2);
        Assert.assertNull((Object)this.get(different1));
        this.checkDocument(different2, patient2, product2, template2, clinician1, item);
        bean.setTarget("clinician", (IMObject)clinician2);
        linker.link();
        documents = bean.getTargets("documents", Act.class);
        Assert.assertEquals((long)1L, (long)documents.size());
        Act different3 = (Act)documents.get(0);
        Assert.assertNotEquals((Object)different2, (Object)different3);
        Assert.assertNull((Object)this.get(different2));
        this.checkDocument(different3, patient2, product2, template2, clinician2, item);
    }

    @Test
    public void testRecreateDocumentsLinkedToEvent() {
        Party location = this.practiceFactory.createLocation();
        Party patient = this.patientFactory.createPatient();
        Entity template1 = this.documentFactory.createTemplate("act.patientDocumentForm");
        Entity template2 = this.documentFactory.createTemplate("act.patientDocumentLetter");
        Product product = this.createProduct(template1, template2);
        User clinician1 = this.userFactory.createClinician();
        User clinician2 = this.userFactory.createClinician();
        FinancialAct item = this.createItem(patient, product, clinician1);
        IMObjectBean bean = this.getBean((IMObject)item);
        bean.save();
        ChargeItemDocumentLinker linker = new ChargeItemDocumentLinker(item, this.getArchetypeService());
        linker.link();
        List documents = bean.getTargets("documents", Act.class);
        Assert.assertEquals((long)2L, (long)documents.size());
        MedicalRecordRules rules = new MedicalRecordRules(this.getArchetypeService());
        Act event = rules.getEventForAddition(patient, new Date(), null, location);
        for (Act document : documents) {
            rules.linkMedicalRecords(event, document);
        }
        event = this.get(event);
        Assert.assertEquals((long)2L, (long)event.getSourceActRelationships().size());
        bean.setTarget("clinician", (IMObject)clinician2);
        linker.link();
        event = this.get(event);
        Assert.assertEquals((long)0L, (long)event.getSourceActRelationships().size());
    }

    private FinancialAct createItem(Party patient, Product product, User clinician) {
        return (FinancialAct)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)this.accountFactory.newInvoiceItem().patient(patient)).product(product)).quantity(1)).clinician(clinician)).build();
    }

    private void checkDocument(Act document, Party patient, Product product, Entity template, User clinician, FinancialAct item) {
        Assert.assertEquals((long)0L, (long)DateRules.compareTo((Date)item.getActivityStartTime(), (Date)document.getActivityStartTime(), (boolean)true));
        IMObjectBean docBean = this.getBean((IMObject)document);
        Assert.assertEquals((Object)patient, (Object)docBean.getTarget("patient"));
        Assert.assertEquals((Object)template, (Object)docBean.getTarget("documentTemplate"));
        Assert.assertEquals((Object)product, (Object)docBean.getTarget("product"));
        Assert.assertEquals((Object)clinician, (Object)docBean.getTarget("clinician"));
    }

    private void saveInTxn(PatientHistoryChanges changes) {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        template.execute(status -> {
            changes.save();
            return null;
        });
    }

    private Act getDocument(List<Act> documents, Entity template) {
        Reference templateRef = template.getObjectReference();
        for (Act document : documents) {
            IMObjectBean bean = this.getBean((IMObject)document);
            if (!Objects.equals(templateRef, bean.getTargetRef("documentTemplate"))) continue;
            return document;
        }
        Assert.fail((String)"Template not found");
        return null;
    }

    private Product createProduct(Entity ... templates) {
        Product product = this.create("product.medication", Product.class);
        IMObjectBean bean = this.getBean((IMObject)product);
        bean.setValue("name", (Object)"XProduct");
        for (Entity template : templates) {
            bean.addTarget("documents", (IMObject)template);
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(product);
        objects.addAll(Arrays.asList(templates));
        this.save(objects);
        return product;
    }
}

