/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.discount;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.discount.DiscountRules;
import org.openvpms.archetype.rules.finance.discount.DiscountTestHelper;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.PeriodRelationship;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;

public class DiscountRulesTestCase
extends ArchetypeServiceTest {
    private Entity discount10;
    private Entity discount5;
    private Entity costDiscount0;
    private Entity costDiscount10;
    private Entity discountGroup;
    private Entity costDiscountGroup;
    private Entity fixedDiscount10;
    private Entity fixedDiscount5;
    private Entity fixedDiscountGroup;
    private Party practice;
    private Lookup taxType;
    private DiscountRules rules;

    @Before
    public void setUp() {
        this.discount10 = DiscountTestHelper.createDiscount(BigDecimal.TEN, true, "PERCENTAGE");
        this.discount5 = DiscountTestHelper.createDiscount(BigDecimal.valueOf(5L), true, "PERCENTAGE");
        this.costDiscount0 = DiscountTestHelper.createDiscount(BigDecimal.ZERO, true, "COST_RATE");
        this.costDiscount10 = DiscountTestHelper.createDiscount(BigDecimal.TEN, true, "COST_RATE");
        this.fixedDiscount10 = DiscountTestHelper.createDiscount(BigDecimal.TEN, true, "FIXED");
        this.fixedDiscount5 = DiscountTestHelper.createDiscount(BigDecimal.valueOf(5L), true, "FIXED");
        this.discountGroup = this.createDiscountGroup(this.discount10, this.discount5);
        this.costDiscountGroup = this.createDiscountGroup(this.costDiscount0, this.costDiscount10);
        this.fixedDiscountGroup = this.createDiscountGroup(this.fixedDiscount5, this.fixedDiscount10);
        this.rules = new DiscountRules(this.getArchetypeService());
        this.practice = (Party)TestHelper.create("party.organisationPractice");
        this.taxType = TestHelper.createTaxType(BigDecimal.TEN);
        this.practice.addClassification(this.taxType);
    }

    @Test
    public void testCalculateDiscountForNoDiscounts() {
        this.checkCalculatePercentageDiscountForNoDiscount("product.medication");
        this.checkCalculatePercentageDiscountForNoDiscount("product.merchandise");
        this.checkCalculatePercentageDiscountForNoDiscount("product.service");
        this.checkCalculateCostRateDiscountForNoDiscount("product.medication");
        this.checkCalculateCostRateDiscountForNoDiscount("product.merchandise");
        this.checkCalculateCostRateDiscountForNoDiscount("product.service");
    }

    @Test
    public void testCalculateDiscountForProductDiscount() {
        this.checkCalculatePercentageDiscountForProductDiscount("product.medication");
        this.checkCalculatePercentageDiscountForProductDiscount("product.merchandise");
        this.checkCalculatePercentageDiscountForProductDiscount("product.service");
        this.checkCalculateCostDiscountForProductDiscount("product.medication");
        this.checkCalculateCostDiscountForProductDiscount("product.merchandise");
        this.checkCalculateCostDiscountForProductDiscount("product.service");
        this.checkCalculateFixedDiscountForProductDiscount("product.medication");
        this.checkCalculateFixedDiscountForProductDiscount("product.merchandise");
        this.checkCalculateFixedDiscountForProductDiscount("product.service");
    }

    @Test
    public void testCalculateDiscountForProductTypeDiscount() {
        this.checkCalculatePercentageDiscountForProductTypeDiscount("product.medication");
        this.checkCalculatePercentageDiscountForProductTypeDiscount("product.merchandise");
        this.checkCalculatePercentageDiscountForProductTypeDiscount("product.service");
        this.checkCalculateCostDiscountForProductTypeDiscount("product.medication");
        this.checkCalculateCostDiscountForProductTypeDiscount("product.merchandise");
        this.checkCalculateCostDiscountForProductTypeDiscount("product.service");
    }

    @Test
    public void testCalculateDiscountForProductProductTypeDiscount() {
        this.checkCalculatePercentageDiscountForProductProductTypeDiscount("product.medication");
        this.checkCalculatePercentageDiscountForProductProductTypeDiscount("product.merchandise");
        this.checkCalculatePercentageDiscountForProductProductTypeDiscount("product.service");
        this.checkCalculateCostDiscountForProductProductTypeDiscount("product.medication");
        this.checkCalculateCostDiscountForProductProductTypeDiscount("product.merchandise");
        this.checkCalculateCostDiscountForProductProductTypeDiscount("product.service");
    }

    @Test
    public void testCalculateDiscountForProductWithNoFixedDiscount() {
        this.checkCalculatePercentageDiscountForProductWithNoFixedDiscount("product.medication");
        this.checkCalculatePercentageDiscountForProductWithNoFixedDiscount("product.merchandise");
        this.checkCalculatePercentageDiscountForProductWithNoFixedDiscount("product.service");
        this.checkCalculateCostDiscountForProductWithNoFixedDiscount("product.medication");
        this.checkCalculateCostDiscountForProductWithNoFixedDiscount("product.merchandise");
        this.checkCalculateCostDiscountForProductWithNoFixedDiscount("product.service");
    }

    @Test
    public void testCalculateDiscountForPercentageDiscountWithMaxDiscount() {
        this.checkCalculateDiscountForPercentageWithMaxDiscount("product.medication");
        this.checkCalculateDiscountForPercentageWithMaxDiscount("product.merchandise");
        this.checkCalculateDiscountForPercentageWithMaxDiscount("product.service");
    }

    @Test
    public void testCalculateDiscountForFixedDiscount() {
        this.checkCalculateDiscountForFixedDiscount("product.medication");
        this.checkCalculateDiscountForFixedDiscount("product.merchandise");
        this.checkCalculateDiscountForFixedDiscount("product.service");
    }

    @Test
    public void testCalculateDiscountForFixedDiscountWithMaxDiscount() {
        this.checkCalculateDiscountForFixedDiscountWithMaxDiscount("product.medication");
        this.checkCalculateDiscountForFixedDiscountWithMaxDiscount("product.merchandise");
        this.checkCalculateDiscountForFixedDiscountWithMaxDiscount("product.service");
    }

    @Test
    public void testGetDiscounts() {
        this.checkGetDiscounts("product.medication");
        this.checkGetDiscounts("product.merchandise");
        this.checkGetDiscounts("product.service");
    }

    @Test
    public void testGetDiscountsForDummyProduct() {
        this.checkGetDiscountsForDummyProduct("product.priceTemplate");
        this.checkGetDiscountsForDummyProduct("product.template");
    }

    @Test
    public void testCalculateDiscountForDummyProduct() {
        this.checkCalculateDiscountForDummyProduct("product.priceTemplate");
        this.checkCalculateDiscountForDummyProduct("product.template");
    }

    @Test
    public void testMultipleCostDiscountsWithSameRateSelectsNoDiscountFixed() {
        Entity discount1 = DiscountTestHelper.createDiscount(BigDecimal.ZERO, true, "COST_RATE");
        Entity discount2 = DiscountTestHelper.createDiscount(BigDecimal.ZERO, false, "COST_RATE");
        Party customer = this.createCustomerWithDiscount(discount1, discount2);
        Party patient = this.createPatient();
        Product product = this.createProductWithDiscounts("product.medication", discount1, discount2);
        Date now = new Date();
        this.checkCalculateCostDiscount(now, customer, patient, product, new BigDecimal("1.20"));
    }

    @Test
    public void testCalculatePercentageDiscountForCustomerWithTaxExclusions() {
        Party customer1 = this.createCustomerWithDiscount(this.discount10);
        Party customer2 = this.createCustomerWithDiscount(this.discount10);
        customer1.addClassification(this.taxType);
        Product product = this.createProductWithDiscounts("product.medication", this.discount10);
        Party patient = this.createPatient();
        Date now = new Date();
        this.checkCalculatePercentageDiscount(now, customer1, patient, product, new BigDecimal("0.10"));
        this.checkCalculatePercentageDiscount(now, customer2, patient, product, new BigDecimal("0.10"));
    }

    @Test
    public void testAtCostDiscountForCustomerWithTaxExclusions() {
        Party customer1 = this.createCustomerWithDiscount(this.costDiscount10);
        Party customer2 = this.createCustomerWithDiscount(this.costDiscount10);
        customer1.addClassification(this.taxType);
        Product product = this.createProductWithDiscounts("product.medication", this.costDiscount10);
        Party patient = this.createPatient();
        Date now = new Date();
        this.checkCalculateCostDiscount(now, customer1, patient, product, new BigDecimal("4.60"));
        this.checkCalculateCostDiscount(now, customer2, patient, product, new BigDecimal("3.06"));
    }

    @Test
    public void testDeactivateDiscountForCustomer() {
        Party customer = this.createCustomerWithDiscount(this.discount5, this.discount10);
        Party patient = this.createPatient();
        Product product = this.createProductWithDiscounts("product.medication", this.discount5, this.discount10);
        Date now = new Date();
        this.checkCalculatePercentageDiscount(now, customer, patient, product, new BigDecimal("0.15"));
        this.discount5.setActive(false);
        this.save((IMObject)this.discount5);
        this.checkCalculatePercentageDiscount(now, customer, patient, product, new BigDecimal("0.10"));
        this.discount10.setActive(false);
        this.save((IMObject)this.discount10);
        this.checkCalculatePercentageDiscount(now, customer, patient, product, BigDecimal.ZERO);
    }

    @Test
    public void testDeactivateDiscountForPatient() {
        Party customer = this.createCustomer();
        Party patient = this.createPatientWithDiscounts(this.discount5, this.discount10);
        Product product = this.createProductWithDiscounts("product.medication", this.discount5, this.discount10);
        Date now = new Date();
        this.checkCalculatePercentageDiscount(now, customer, patient, product, new BigDecimal("0.15"));
        this.discount5.setActive(false);
        this.save((IMObject)this.discount5);
        this.checkCalculatePercentageDiscount(now, customer, patient, product, new BigDecimal("0.10"));
        this.discount10.setActive(false);
        this.save((IMObject)this.discount10);
        this.checkCalculatePercentageDiscount(now, customer, patient, product, BigDecimal.ZERO);
    }

    @Test
    public void testDeactivateDiscountForProductType() {
        Party customer = this.createCustomer();
        Party patient = this.createPatientWithDiscounts(this.discount5, this.discount10);
        Product product = this.createProductWithProductTypeDiscounts("product.medication", this.discount5, this.discount10);
        Date now = new Date();
        this.checkCalculatePercentageDiscount(now, customer, patient, product, new BigDecimal("0.15"));
        this.discount5.setActive(false);
        this.save((IMObject)this.discount5);
        this.checkCalculatePercentageDiscount(now, customer, patient, product, new BigDecimal("0.10"));
        this.discount10.setActive(false);
        this.save((IMObject)this.discount10);
        this.checkCalculatePercentageDiscount(now, customer, patient, product, BigDecimal.ZERO);
    }

    @Test
    public void testDeactivateDiscountGroupForCustomer() {
        BigDecimal cents15 = new BigDecimal("0.15");
        Party customer = this.createCustomerWithDiscount(this.discountGroup);
        Party patient = this.createPatient();
        Product product = this.createProductWithProductTypeDiscounts("product.medication", this.discount5);
        this.addDiscount((Entity)product, this.discount10, null);
        Date now = new Date();
        this.checkCalculatePercentageDiscount(now, customer, patient, product, cents15);
        this.discountGroup.setActive(false);
        this.save((IMObject)this.discountGroup);
        this.checkCalculatePercentageDiscount(now, customer, patient, product, BigDecimal.ZERO);
    }

    @Test
    public void testDeactivateDiscountGroupForPatient() {
        BigDecimal cents15 = new BigDecimal("0.15");
        Party customer = this.createCustomerWithDiscount(new Entity[0]);
        Party patient = this.createPatientWithDiscounts(this.discountGroup);
        Product product = this.createProductWithProductTypeDiscounts("product.medication", this.discount5);
        this.addDiscount((Entity)product, this.discount10, null);
        Date now = new Date();
        this.checkCalculatePercentageDiscount(now, customer, patient, product, cents15);
        this.discountGroup.setActive(false);
        this.save((IMObject)this.discountGroup);
        this.checkCalculatePercentageDiscount(now, customer, patient, product, BigDecimal.ZERO);
    }

    private void checkCalculatePercentageDiscountForNoDiscount(String shortName) {
        Party custNoDisc = this.createCustomer();
        Party custWithDisc = this.createCustomerWithDiscount(this.discount10);
        Party patientNoDisc = this.createPatient();
        Party patientWithDisc = this.createPatientWithDiscounts(this.discount10);
        Product productNoDisc = this.createProduct(shortName);
        Product productWith10Disc = this.createProductWithDiscounts(shortName, this.discount10);
        Product productWith5Disc = this.createProductWithDiscounts(shortName, this.discount5);
        Date now = new Date();
        this.checkCalculatePercentageDiscount(now, custNoDisc, patientNoDisc, productNoDisc, BigDecimal.ZERO);
        this.checkCalculatePercentageDiscount(now, custWithDisc, patientNoDisc, productNoDisc, BigDecimal.ZERO);
        this.checkCalculatePercentageDiscount(now, custWithDisc, patientWithDisc, productNoDisc, BigDecimal.ZERO);
        this.checkCalculatePercentageDiscount(now, custNoDisc, patientNoDisc, productWith10Disc, BigDecimal.ZERO);
        this.checkCalculatePercentageDiscount(now, custWithDisc, patientWithDisc, productWith5Disc, BigDecimal.ZERO);
    }

    private void checkCalculateCostRateDiscountForNoDiscount(String shortName) {
        Party custNoDisc = this.createCustomer();
        Party custWithDisc = this.createCustomerWithDiscount(this.costDiscount0);
        Party patientNoDisc = this.createPatient();
        Party patientWithDisc = this.createPatientWithDiscounts(this.costDiscount0);
        Product productNoDisc = this.createProduct(shortName);
        Product productWith0Disc = this.createProductWithDiscounts(shortName, this.costDiscount0);
        Product productWith10Disc = this.createProductWithDiscounts(shortName, this.costDiscount10);
        Date now = new Date();
        this.checkCalculatePercentageDiscount(now, custNoDisc, patientNoDisc, productNoDisc, BigDecimal.ZERO);
        this.checkCalculatePercentageDiscount(now, custWithDisc, patientNoDisc, productNoDisc, BigDecimal.ZERO);
        this.checkCalculatePercentageDiscount(now, custWithDisc, patientWithDisc, productNoDisc, BigDecimal.ZERO);
        this.checkCalculatePercentageDiscount(now, custNoDisc, patientNoDisc, productWith0Disc, BigDecimal.ZERO);
        this.checkCalculatePercentageDiscount(now, custWithDisc, patientWithDisc, productWith10Disc, BigDecimal.ZERO);
    }

    private void checkCalculatePercentageDiscountForProductDiscount(String shortName) {
        BigDecimal cents10 = new BigDecimal("0.10");
        BigDecimal cents5 = new BigDecimal("0.05");
        Party custNoDisc = this.createCustomer();
        Party custWithDisc = this.createCustomerWithDiscount(this.discount10);
        Party patientNoDisc = this.createPatient();
        Party patientWithDisc = this.createPatientWithDiscounts(this.discount10);
        Product product = this.createProductWithDiscounts(shortName, this.discount10);
        Date now = new Date();
        this.checkCalculatePercentageDiscount(now, custNoDisc, patientNoDisc, product, BigDecimal.ZERO);
        this.checkCalculatePercentageDiscount(now, custWithDisc, patientNoDisc, product, cents10);
        this.checkCalculatePercentageDiscount(now, custNoDisc, patientWithDisc, product, cents10);
        this.checkCalculatePercentageDiscount(now, custWithDisc, patientWithDisc, product, cents10);
        this.expireDiscount((Entity)product, this.discount10, now);
        this.checkCalculatePercentageDiscount(now, custNoDisc, patientNoDisc, product, BigDecimal.ZERO);
        this.checkCalculatePercentageDiscount(now, custWithDisc, patientNoDisc, product, BigDecimal.ZERO);
        this.checkCalculatePercentageDiscount(now, custNoDisc, patientWithDisc, product, BigDecimal.ZERO);
        this.checkCalculatePercentageDiscount(now, custWithDisc, patientWithDisc, product, BigDecimal.ZERO);
        this.addDiscount((Entity)product, this.discount5, null);
        this.addDiscount((Entity)patientWithDisc, this.discount5, null);
        this.addDiscount((Entity)custWithDisc, this.discount5, null);
        now = new Date();
        this.checkCalculatePercentageDiscount(now, custNoDisc, patientNoDisc, product, BigDecimal.ZERO);
        this.checkCalculatePercentageDiscount(now, custWithDisc, patientNoDisc, product, cents5);
        this.checkCalculatePercentageDiscount(now, custNoDisc, patientWithDisc, product, cents5);
        this.checkCalculatePercentageDiscount(now, custWithDisc, patientWithDisc, product, cents5);
    }

    private void expireDiscount(Entity entity, Entity discount, Date time) {
        IMObjectBean bean = this.getBean((IMObject)entity);
        EntityLink result = (EntityLink)bean.getValue("discounts", EntityLink.class, Predicates.targetEquals((IMObject)discount));
        Assert.assertNotNull((Object)result);
        result.setActiveEndTime(new Date(time.getTime() - 1000L));
        this.save((IMObject)entity);
    }

    private void checkCalculateCostDiscountForProductDiscount(String shortName) {
        BigDecimal four60 = new BigDecimal("4.60");
        BigDecimal three06 = new BigDecimal("3.06");
        Party custNoDisc = this.createCustomer();
        Party custWithDisc = this.createCustomerWithDiscount(this.costDiscount0);
        Party patientNoDisc = this.createPatient();
        Party patientWithDisc = this.createPatientWithDiscounts(this.costDiscount0);
        Product product = this.createProductWithDiscounts(shortName, this.costDiscount0);
        Date now = new Date();
        this.checkCalculateCostDiscount(now, custNoDisc, patientNoDisc, product, BigDecimal.ZERO);
        this.checkCalculateCostDiscount(now, custWithDisc, patientNoDisc, product, four60);
        this.checkCalculateCostDiscount(now, custNoDisc, patientWithDisc, product, four60);
        this.checkCalculateCostDiscount(now, custWithDisc, patientWithDisc, product, four60);
        this.expireDiscount((Entity)product, this.costDiscount0, now);
        this.checkCalculateCostDiscount(now, custNoDisc, patientNoDisc, product, BigDecimal.ZERO);
        this.checkCalculateCostDiscount(now, custWithDisc, patientNoDisc, product, BigDecimal.ZERO);
        this.checkCalculateCostDiscount(now, custNoDisc, patientWithDisc, product, BigDecimal.ZERO);
        this.checkCalculateCostDiscount(now, custWithDisc, patientWithDisc, product, BigDecimal.ZERO);
        this.addDiscount((Entity)product, this.costDiscount10, null);
        this.addDiscount((Entity)patientWithDisc, this.costDiscount10, null);
        this.addDiscount((Entity)custWithDisc, this.costDiscount10, null);
        now = new Date();
        this.checkCalculateCostDiscount(now, custNoDisc, patientNoDisc, product, BigDecimal.ZERO);
        this.checkCalculateCostDiscount(now, custWithDisc, patientNoDisc, product, three06);
        this.checkCalculateCostDiscount(now, custNoDisc, patientWithDisc, product, three06);
        this.checkCalculateCostDiscount(now, custWithDisc, patientWithDisc, product, three06);
    }

    private void checkCalculateFixedDiscountForProductDiscount(String archetype) {
        BigDecimal five = BigDecimal.valueOf(5L);
        Party custNoDisc = this.createCustomer();
        Party custWithDisc = this.createCustomerWithDiscount(this.fixedDiscount10);
        Party patientNoDisc = this.createPatient();
        Party patientWithDisc = this.createPatientWithDiscounts(this.fixedDiscount10);
        Product product = this.createProductWithDiscounts(archetype, this.fixedDiscount10);
        Date now = new Date();
        this.checkCalculateFixedDiscount(now, custNoDisc, patientNoDisc, product, BigDecimal.ZERO);
        this.checkCalculateFixedDiscount(now, custWithDisc, patientNoDisc, product, BigDecimal.TEN);
        this.checkCalculateFixedDiscount(now, custNoDisc, patientWithDisc, product, BigDecimal.TEN);
        this.checkCalculateFixedDiscount(now, custWithDisc, patientWithDisc, product, BigDecimal.TEN);
        this.expireDiscount((Entity)product, this.fixedDiscount10, now);
        this.checkCalculateFixedDiscount(now, custNoDisc, patientNoDisc, product, BigDecimal.ZERO);
        this.checkCalculateFixedDiscount(now, custWithDisc, patientNoDisc, product, BigDecimal.ZERO);
        this.checkCalculateFixedDiscount(now, custNoDisc, patientWithDisc, product, BigDecimal.ZERO);
        this.checkCalculateFixedDiscount(now, custWithDisc, patientWithDisc, product, BigDecimal.ZERO);
        this.addDiscount((Entity)product, this.fixedDiscount5, null);
        this.addDiscount((Entity)patientWithDisc, this.fixedDiscount5, null);
        this.addDiscount((Entity)custWithDisc, this.fixedDiscount5, null);
        now = new Date();
        this.checkCalculateFixedDiscount(now, custNoDisc, patientNoDisc, product, BigDecimal.ZERO);
        this.checkCalculateFixedDiscount(now, custWithDisc, patientNoDisc, product, five);
        this.checkCalculateFixedDiscount(now, custNoDisc, patientWithDisc, product, five);
        this.checkCalculateFixedDiscount(now, custWithDisc, patientWithDisc, product, five);
    }

    private void checkCalculatePercentageDiscountForProductTypeDiscount(String shortName) {
        BigDecimal cents10 = new BigDecimal("0.10");
        BigDecimal cents5 = new BigDecimal("0.05");
        Party custNoDisc = this.createCustomer();
        Party custWithDisc = this.createCustomerWithDiscount(this.discount10);
        Party patientNoDisc = this.createPatient();
        Party patientWithDisc = this.createPatientWithDiscounts(this.discount10);
        Product product = this.createProductWithProductTypeDiscounts(shortName, this.discount10);
        Date now = new Date();
        this.checkCalculatePercentageDiscount(now, custNoDisc, patientNoDisc, product, BigDecimal.ZERO);
        this.checkCalculatePercentageDiscount(now, custWithDisc, patientNoDisc, product, cents10);
        this.checkCalculatePercentageDiscount(now, custNoDisc, patientWithDisc, product, cents10);
        this.checkCalculatePercentageDiscount(now, custWithDisc, patientWithDisc, product, cents10);
        IMObjectBean bean = this.getBean((IMObject)product);
        Entity productType = (Entity)bean.getTarget("type", Entity.class);
        this.expireDiscount(productType, this.discount10, now);
        this.checkCalculatePercentageDiscount(now, custNoDisc, patientNoDisc, product, BigDecimal.ZERO);
        this.checkCalculatePercentageDiscount(now, custWithDisc, patientNoDisc, product, BigDecimal.ZERO);
        this.checkCalculatePercentageDiscount(now, custNoDisc, patientWithDisc, product, BigDecimal.ZERO);
        this.checkCalculatePercentageDiscount(now, custWithDisc, patientWithDisc, product, BigDecimal.ZERO);
        this.addDiscount(productType, this.discount5, null);
        this.addDiscount((Entity)patientWithDisc, this.discount5, null);
        this.addDiscount((Entity)custWithDisc, this.discount5, null);
        now = new Date();
        this.checkCalculatePercentageDiscount(now, custNoDisc, patientNoDisc, product, BigDecimal.ZERO);
        this.checkCalculatePercentageDiscount(now, custWithDisc, patientNoDisc, product, cents5);
        this.checkCalculatePercentageDiscount(now, custNoDisc, patientWithDisc, product, cents5);
        this.checkCalculatePercentageDiscount(now, custWithDisc, patientWithDisc, product, cents5);
    }

    private void checkCalculateCostDiscountForProductTypeDiscount(String shortName) {
        BigDecimal four60 = new BigDecimal("4.60");
        BigDecimal three06 = new BigDecimal("3.06");
        Party custNoDisc = this.createCustomer();
        Party custWithDisc = this.createCustomerWithDiscount(this.costDiscount0);
        Party patientNoDisc = this.createPatient();
        Party patientWithDisc = this.createPatientWithDiscounts(this.costDiscount0);
        Product product = this.createProductWithProductTypeDiscounts(shortName, this.costDiscount0);
        Date now = new Date();
        this.checkCalculateCostDiscount(now, custNoDisc, patientNoDisc, product, BigDecimal.ZERO);
        this.checkCalculateCostDiscount(now, custWithDisc, patientNoDisc, product, four60);
        this.checkCalculateCostDiscount(now, custNoDisc, patientWithDisc, product, four60);
        this.checkCalculateCostDiscount(now, custWithDisc, patientWithDisc, product, four60);
        IMObjectBean bean = this.getBean((IMObject)product);
        Entity productType = (Entity)bean.getTarget("type", Entity.class);
        this.expireDiscount(productType, this.costDiscount0, now);
        this.checkCalculateCostDiscount(now, custNoDisc, patientNoDisc, product, BigDecimal.ZERO);
        this.checkCalculateCostDiscount(now, custWithDisc, patientNoDisc, product, BigDecimal.ZERO);
        this.checkCalculateCostDiscount(now, custNoDisc, patientWithDisc, product, BigDecimal.ZERO);
        this.checkCalculateCostDiscount(now, custWithDisc, patientWithDisc, product, BigDecimal.ZERO);
        this.addDiscount(productType, this.costDiscount10, null);
        this.addDiscount((Entity)patientWithDisc, this.costDiscount10, null);
        this.addDiscount((Entity)custWithDisc, this.costDiscount10, null);
        now = new Date();
        this.checkCalculateCostDiscount(now, custNoDisc, patientNoDisc, product, BigDecimal.ZERO);
        this.checkCalculateCostDiscount(now, custWithDisc, patientNoDisc, product, three06);
        this.checkCalculateCostDiscount(now, custNoDisc, patientWithDisc, product, three06);
        this.checkCalculateCostDiscount(now, custWithDisc, patientWithDisc, product, three06);
    }

    private void checkCalculatePercentageDiscountForProductProductTypeDiscount(String shortName) {
        BigDecimal cents10 = new BigDecimal("0.10");
        BigDecimal cents15 = new BigDecimal("0.15");
        Party custNoDisc = this.createCustomer();
        Party custWithDisc = this.createCustomerWithDiscount(this.discountGroup);
        Party patientNoDisc = this.createPatient();
        Party patientWithDisc = this.createPatientWithDiscounts(this.discount10);
        Product product = this.createProductWithProductTypeDiscounts(shortName, this.discount5);
        this.addDiscount((Entity)product, this.discount10, null);
        Date now = new Date();
        this.checkCalculatePercentageDiscount(now, custNoDisc, patientNoDisc, product, BigDecimal.ZERO);
        this.checkCalculatePercentageDiscount(now, custWithDisc, patientNoDisc, product, cents15);
        this.checkCalculatePercentageDiscount(now, custNoDisc, patientWithDisc, product, cents10);
        this.checkCalculatePercentageDiscount(now, custWithDisc, patientWithDisc, product, cents15);
    }

    private void checkCalculateCostDiscountForProductProductTypeDiscount(String shortName) {
        BigDecimal four60 = new BigDecimal("4.60");
        BigDecimal three06 = new BigDecimal("3.06");
        Party custNoDisc = this.createCustomer();
        Party custWithDisc = this.createCustomerWithDiscount(this.costDiscountGroup);
        Party patientNoDisc = this.createPatient();
        Party patientWithDisc = this.createPatientWithDiscounts(this.costDiscount10);
        Product product = this.createProductWithProductTypeDiscounts(shortName, this.costDiscount0);
        this.addDiscount((Entity)product, this.costDiscount10, null);
        Date now = new Date();
        this.checkCalculateCostDiscount(now, custNoDisc, patientNoDisc, product, BigDecimal.ZERO);
        this.checkCalculateCostDiscount(now, custWithDisc, patientNoDisc, product, four60);
        this.checkCalculateCostDiscount(now, custNoDisc, patientWithDisc, product, three06);
        this.checkCalculateCostDiscount(now, custWithDisc, patientWithDisc, product, four60);
    }

    private void checkCalculatePercentageDiscountForProductWithNoFixedDiscount(String shortName) {
        Entity discount = DiscountTestHelper.createDiscount(BigDecimal.TEN, false, "PERCENTAGE");
        BigDecimal cents5 = new BigDecimal("0.05");
        Party custNoDisc = this.createCustomer();
        Party custWithDisc = this.createCustomerWithDiscount(discount);
        Party patientNoDisc = this.createPatient();
        Party patientWithDisc = this.createPatientWithDiscounts(discount);
        Product product = this.createProductWithDiscounts(shortName, discount, this.discount10);
        Date now = new Date();
        this.checkCalculatePercentageDiscount(now, custNoDisc, patientNoDisc, product, BigDecimal.ZERO);
        this.checkCalculatePercentageDiscount(now, custWithDisc, patientNoDisc, product, cents5);
        this.checkCalculatePercentageDiscount(now, custNoDisc, patientWithDisc, product, cents5);
        this.checkCalculatePercentageDiscount(now, custWithDisc, patientWithDisc, product, cents5);
    }

    private void checkCalculateCostDiscountForProductWithNoFixedDiscount(String shortName) {
        Entity discount = DiscountTestHelper.createDiscount(BigDecimal.ZERO, false, "COST_RATE");
        BigDecimal one20 = new BigDecimal("1.20");
        Party custNoDisc = this.createCustomer();
        Party custWithDisc = this.createCustomerWithDiscount(discount);
        Party patientNoDisc = this.createPatient();
        Party patientWithDisc = this.createPatientWithDiscounts(discount);
        Product product = this.createProductWithDiscounts(shortName, discount, this.discount10);
        Date now = new Date();
        this.checkCalculateCostDiscount(now, custNoDisc, patientNoDisc, product, BigDecimal.ZERO);
        this.checkCalculateCostDiscount(now, custWithDisc, patientNoDisc, product, one20);
        this.checkCalculateCostDiscount(now, custNoDisc, patientWithDisc, product, one20);
        this.checkCalculateCostDiscount(now, custWithDisc, patientWithDisc, product, one20);
    }

    private void checkCalculateDiscountForPercentageWithMaxDiscount(String shortName) {
        BigDecimal cents10 = new BigDecimal("0.10");
        BigDecimal percent10 = new BigDecimal("10.00");
        Party custNoDisc = this.createCustomer();
        Party custWithDisc = this.createCustomerWithDiscount(this.discountGroup);
        Party patientNoDisc = this.createPatient();
        Party patientWithDisc = this.createPatientWithDiscounts(this.discount10);
        Product product = this.createProductWithProductTypeDiscounts(shortName, this.discount5);
        this.addDiscount((Entity)product, this.discount10, null);
        Date now = new Date();
        this.checkCalculatePercentageDiscount(now, custNoDisc, patientNoDisc, product, percent10, percent10, BigDecimal.ZERO);
        this.checkCalculatePercentageDiscount(now, custWithDisc, patientNoDisc, product, percent10, percent10, cents10);
        this.checkCalculatePercentageDiscount(now, custNoDisc, patientWithDisc, product, percent10, percent10, cents10);
        this.checkCalculatePercentageDiscount(now, custWithDisc, patientWithDisc, product, percent10, percent10, cents10);
    }

    private void checkCalculateDiscountForFixedDiscount(String archetype) {
        Party custNoDisc = this.createCustomer();
        Party custWithDisc = this.createCustomerWithDiscount(this.fixedDiscountGroup);
        Party patientNoDisc = this.createPatient();
        Party patientWithDisc = this.createPatientWithDiscounts(this.fixedDiscount10);
        Product product = this.createProductWithProductTypeDiscounts(archetype, this.fixedDiscount5);
        this.addDiscount((Entity)product, this.fixedDiscount10, null);
        Date now = new Date();
        this.checkCalculateFixedDiscount(now, custNoDisc, patientNoDisc, product, MathRules.ONE_HUNDRED, MathRules.ONE_HUNDRED, BigDecimal.ZERO);
        this.checkCalculateFixedDiscount(now, custWithDisc, patientNoDisc, product, MathRules.ONE_HUNDRED, MathRules.ONE_HUNDRED, BigDecimal.valueOf(15L));
        this.checkCalculateFixedDiscount(now, custNoDisc, patientWithDisc, product, MathRules.ONE_HUNDRED, MathRules.ONE_HUNDRED, BigDecimal.TEN);
        this.checkCalculateFixedDiscount(now, custWithDisc, patientWithDisc, product, MathRules.ONE_HUNDRED, MathRules.ONE_HUNDRED, BigDecimal.valueOf(15L));
    }

    private void checkCalculateDiscountForFixedDiscountWithMaxDiscount(String archetype) {
        Party custNoDisc = this.createCustomer();
        Party custWithDisc = this.createCustomerWithDiscount(this.fixedDiscountGroup);
        Party patientNoDisc = this.createPatient();
        Party patientWithDisc = this.createPatientWithDiscounts(this.fixedDiscount10);
        Product product = this.createProductWithProductTypeDiscounts(archetype, this.fixedDiscount5);
        this.addDiscount((Entity)product, this.fixedDiscount10, null);
        Date now = new Date();
        this.checkCalculateFixedDiscount(now, custNoDisc, patientNoDisc, product, BigDecimal.TEN, BigDecimal.TEN, BigDecimal.ZERO);
        this.checkCalculateFixedDiscount(now, custWithDisc, patientNoDisc, product, BigDecimal.TEN, BigDecimal.TEN, BigDecimal.valueOf(2L));
        this.checkCalculateFixedDiscount(now, custNoDisc, patientWithDisc, product, BigDecimal.TEN, BigDecimal.TEN, BigDecimal.valueOf(2L));
        this.checkCalculateFixedDiscount(now, custWithDisc, patientWithDisc, product, BigDecimal.TEN, BigDecimal.TEN, BigDecimal.valueOf(2L));
    }

    private void checkGetDiscounts(String shortName) {
        Party custNoDisc = this.createCustomer();
        Party custWithDisc = this.createCustomerWithDiscount(this.discount5, this.discountGroup);
        Party patientNoDisc = this.createPatient();
        Party patientWithDisc = this.createPatientWithDiscounts(this.discount10);
        Product product = this.createProductWithProductTypeDiscounts(shortName, this.discount5);
        this.addDiscount((Entity)product, this.discount10, null);
        Date now = new Date();
        this.checkDiscounts(now, custNoDisc, patientNoDisc, product, new Entity[0]);
        this.checkDiscounts(now, custWithDisc, patientNoDisc, product, this.discount5, this.discount10);
        this.checkDiscounts(now, custNoDisc, patientWithDisc, product, this.discount10);
        this.checkDiscounts(now, custWithDisc, patientWithDisc, product, this.discount5, this.discount10);
    }

    private void checkGetDiscountsForDummyProduct(String shortName) {
        Party customer = this.createCustomer();
        Party patient = this.createPatient();
        Product product = this.createProduct(shortName);
        List discounts = this.rules.getDiscounts(new Date(), customer, patient, product);
        Assert.assertEquals((long)0L, (long)discounts.size());
    }

    private void checkCalculateDiscountForDummyProduct(String shortName) {
        Party customer = this.createCustomer();
        Party patient = this.createPatient();
        Product product = this.createProduct(shortName);
        this.checkCalculatePercentageDiscount(new Date(), customer, patient, product, BigDecimal.ZERO);
    }

    private void checkCalculatePercentageDiscount(Date date, Party customer, Party patient, Product product, BigDecimal expectedDiscount) {
        this.checkCalculatePercentageDiscount(date, customer, patient, product, MathRules.ONE_HUNDRED, MathRules.ONE_HUNDRED, expectedDiscount);
    }

    private void checkCalculatePercentageDiscount(Date date, Party customer, Party patient, Product product, BigDecimal maxFixedDiscount, BigDecimal maxUnitDiscount, BigDecimal expectedDiscount) {
        BigDecimal fixedCost = BigDecimal.ZERO;
        BigDecimal unitCost = BigDecimal.ZERO;
        BigDecimal fixedPrice = new BigDecimal("0.50");
        BigDecimal unitPrice = new BigDecimal("0.50");
        BigDecimal quantity = BigDecimal.ONE;
        BigDecimal discount = this.rules.calculateDiscount(date, this.practice, customer, patient, product, fixedCost, unitCost, fixedPrice, unitPrice, quantity, maxFixedDiscount, maxUnitDiscount);
        this.checkEquals(expectedDiscount, discount);
    }

    private void checkCalculateCostDiscount(Date date, Party customer, Party patient, Product product, BigDecimal expectedDiscount) {
        this.checkCalculateCostDiscount(date, customer, patient, product, MathRules.ONE_HUNDRED, MathRules.ONE_HUNDRED, expectedDiscount);
    }

    private void checkCalculateCostDiscount(Date date, Party customer, Party patient, Product product, BigDecimal maxFixedDiscount, BigDecimal maxUnitDiscount, BigDecimal expectedDiscount) {
        BigDecimal fixedCost = new BigDecimal("6.00");
        BigDecimal unitCost = new BigDecimal("4.00");
        BigDecimal fixedPrice = new BigDecimal("10.00");
        BigDecimal unitPrice = new BigDecimal("5.00");
        BigDecimal quantity = BigDecimal.valueOf(2L);
        BigDecimal discount = this.rules.calculateDiscount(date, this.practice, customer, patient, product, fixedCost, unitCost, fixedPrice, unitPrice, quantity, maxFixedDiscount, maxUnitDiscount);
        this.checkEquals(expectedDiscount, discount);
    }

    private void checkCalculateFixedDiscount(Date date, Party customer, Party patient, Product product, BigDecimal expectedDiscount) {
        this.checkCalculateFixedDiscount(date, customer, patient, product, MathRules.ONE_HUNDRED, MathRules.ONE_HUNDRED, expectedDiscount);
    }

    private void checkCalculateFixedDiscount(Date date, Party customer, Party patient, Product product, BigDecimal maxFixedDiscount, BigDecimal maxUnitDiscount, BigDecimal expectedDiscount) {
        BigDecimal fixedCost = new BigDecimal("6.00");
        BigDecimal unitCost = new BigDecimal("4.00");
        BigDecimal fixedPrice = new BigDecimal("10.00");
        BigDecimal unitPrice = new BigDecimal("5.00");
        BigDecimal quantity = BigDecimal.valueOf(2L);
        BigDecimal discount = this.rules.calculateDiscount(date, this.practice, customer, patient, product, fixedCost, unitCost, fixedPrice, unitPrice, quantity, maxFixedDiscount, maxUnitDiscount);
        this.checkEquals(expectedDiscount, discount);
        BigDecimal discount2 = this.rules.calculateDiscount(date, this.practice, customer, patient, product, fixedCost, unitCost, fixedPrice, unitPrice, quantity.negate(), maxFixedDiscount, maxUnitDiscount);
        this.checkEquals(expectedDiscount, discount2);
    }

    private void checkDiscounts(Date date, Party customer, Party patient, Product product, Entity ... expected) {
        List discounts = this.rules.getDiscounts(date, customer, patient, product);
        Assert.assertEquals((long)expected.length, (long)discounts.size());
        for (Entity discount : expected) {
            Assert.assertTrue((boolean)discounts.contains(discount));
        }
    }

    private Party createCustomer() {
        return TestHelper.createCustomer();
    }

    private Party createCustomerWithDiscount(Entity ... discounts) {
        Party customer = this.createCustomer();
        for (Entity discount : discounts) {
            this.addDiscount((Entity)customer, discount, null);
        }
        return customer;
    }

    private Party createPatient() {
        Party patient = this.create("party.patientpet", Party.class);
        IMObjectBean bean = this.getBean((IMObject)patient);
        bean.setValue("name", (Object)TestHelper.randomName("XDiscountRulesTestCasse-pet"));
        bean.setValue("species", (Object)"CANINE");
        bean.save();
        return patient;
    }

    private Party createPatientWithDiscounts(Entity ... discounts) {
        Party patient = this.createPatient();
        for (Entity discount : discounts) {
            this.addDiscount((Entity)patient, discount, null);
        }
        return patient;
    }

    private Product createProduct(String shortName) {
        Product product = this.create(shortName, Product.class);
        product.setName(TestHelper.randomName("XProduct-"));
        this.save((IMObject)product);
        return product;
    }

    private Product createProductWithDiscounts(String shortName, Entity ... discounts) {
        return this.createProductWithDiscounts(shortName, (Date)null, discounts);
    }

    private Product createProductWithDiscounts(String shortName, Date endTime, Entity ... discounts) {
        Product product = this.createProduct(shortName);
        for (Entity discount : discounts) {
            this.addDiscount((Entity)product, discount, endTime);
        }
        this.save((IMObject)product);
        return product;
    }

    private Product createProductWithProductTypeDiscounts(String shortName, Entity ... discounts) {
        Product product = this.createProduct(shortName);
        Entity type = this.create("entity.productType", Entity.class);
        type.setName(TestHelper.randomName("DiscountRulesTestCase-entity"));
        for (Entity discount : discounts) {
            this.addDiscount(type, discount, null);
        }
        IMObjectBean bean = this.getBean((IMObject)product);
        bean.setTarget("type", (IMObject)type);
        this.save((IMObject)product);
        return product;
    }

    private void addDiscount(Entity entity, Entity discount, Date endTime) {
        IMObjectBean bean = this.getBean((IMObject)entity);
        Relationship relationship = bean.addTarget("discounts", (IMObject)discount);
        if (relationship instanceof PeriodRelationship) {
            ((PeriodRelationship)relationship).setActiveEndTime(endTime);
        }
        bean.save();
    }

    private Entity createDiscountGroup(Entity ... discounts) {
        Entity result = this.create("entity.discountGroupType", Entity.class);
        IMObjectBean bean = this.getBean((IMObject)result);
        bean.setValue("name", (Object)TestHelper.randomName("XDISCOUNT_RULES_TESTCASE_"));
        for (Entity discount : discounts) {
            bean.addTarget("discounts", (IMObject)discount);
        }
        this.save((IMObject)result);
        return result;
    }
}

