/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.credit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.BalanceCalculator;
import org.openvpms.archetype.rules.finance.credit.CreditActAllocator;
import org.openvpms.archetype.rules.finance.credit.CreditAllocation;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentBuilder;
import org.openvpms.archetype.test.builder.insurance.TestInsuranceFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public class CreditActAllocatorTestCase
extends ArchetypeServiceTest {
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestInsuranceFactory insuranceFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestUserFactory userFactory;
    private BalanceCalculator calculator;
    private Party customer;
    private Party patient;
    private Product product;
    private Entity till;
    private Party location;
    private CreditActAllocator allocator;

    @Before
    public void setUp() {
        InsuranceRules insuranceRules = new InsuranceRules(this.getArchetypeService(), this.transactionManager);
        this.calculator = new BalanceCalculator(this.getArchetypeService());
        this.customer = this.customerFactory.createCustomer();
        this.patient = this.patientFactory.createPatient(this.customer);
        this.product = this.productFactory.createMedication();
        this.till = this.practiceFactory.createTill();
        this.location = this.practiceFactory.createLocation();
        this.allocator = new CreditActAllocator(this.getArchetypeService(), insuranceRules);
    }

    @Test
    public void testAllocatePaymentToEmptyAccount() {
        List<FinancialAct> paymentActs = this.createPayment(BigDecimal.TEN);
        FinancialAct payment = paymentActs.get(0);
        Assert.assertFalse((boolean)this.calculator.isAllocated(payment));
        CreditAllocation allocation = this.allocator.allocate(payment);
        Assert.assertEquals((Object)payment, (Object)allocation.getCredit());
        Assert.assertTrue((boolean)allocation.getDebits().isEmpty());
        Assert.assertTrue((boolean)allocation.getBlocked().isEmpty());
        Assert.assertFalse((boolean)allocation.isModified());
        Assert.assertFalse((boolean)allocation.overrideDefaultAllocation());
        Assert.assertFalse((boolean)this.calculator.isAllocated(payment));
        this.save(paymentActs);
        Assert.assertFalse((boolean)this.calculator.isAllocated(this.get(payment)));
    }

    @Test
    public void testDefaultAllocation() {
        this.checkDefaultAllocation(BigDecimal.TEN, BigDecimal.TEN);
        this.checkDefaultAllocation(BigDecimal.TEN, BigDecimal.valueOf(20L));
        this.checkDefaultAllocation(BigDecimal.valueOf(20L), BigDecimal.TEN);
    }

    @Test
    public void testAllocateWithGapClaim() {
        List<FinancialAct> acts = this.createInvoice(BigDecimal.TEN);
        FinancialAct invoice = acts.get(0);
        FinancialAct item = acts.get(1);
        Assert.assertFalse((boolean)this.calculator.isAllocated(invoice));
        Party insurer = this.insuranceFactory.createInsurer();
        User clinician = this.userFactory.createClinician();
        Act policy = this.insuranceFactory.createPolicy(this.customer, this.patient, insurer, "12345");
        this.insuranceFactory.newClaim().policy(policy).location(this.location).clinician(clinician).claimHandler(clinician).gapClaim(true).item(item).build();
        List<FinancialAct> paymentActs = this.createPayment(BigDecimal.TEN);
        FinancialAct payment = paymentActs.get(0);
        Assert.assertFalse((boolean)this.calculator.isAllocated(payment));
        CreditAllocation allocation = this.allocator.allocate(payment);
        Assert.assertEquals((long)1L, (long)allocation.getDebits().size());
        Assert.assertEquals((Object)invoice, allocation.getDebits().get(0));
        Assert.assertEquals((long)1L, (long)allocation.getBlocked().size());
        Assert.assertEquals((Object)invoice, allocation.getBlocked().keySet().iterator().next());
        Assert.assertFalse((boolean)allocation.isModified());
        Assert.assertTrue((boolean)allocation.overrideDefaultAllocation());
    }

    @Test
    public void testAllocateWithGapClaimAndMultipleInvoices() {
        List<FinancialAct> invoice1Acts = this.createInvoice(BigDecimal.TEN);
        FinancialAct invoice1 = invoice1Acts.get(0);
        FinancialAct item1 = invoice1Acts.get(1);
        List<FinancialAct> invoice2Acts = this.createInvoice(BigDecimal.TEN);
        FinancialAct invoice2 = invoice2Acts.get(0);
        Assert.assertFalse((boolean)this.calculator.isAllocated(invoice1));
        Assert.assertFalse((boolean)this.calculator.isAllocated(invoice2));
        Party insurer = this.insuranceFactory.createInsurer();
        User clinician = this.userFactory.createClinician();
        Act policy = this.insuranceFactory.createPolicy(this.customer, this.patient, insurer, "12345");
        this.insuranceFactory.newClaim().policy(policy).location(this.location).clinician(clinician).claimHandler(clinician).gapClaim(true).item(item1).build();
        List<FinancialAct> paymentActs = this.createPayment(BigDecimal.TEN);
        FinancialAct payment = paymentActs.get(0);
        Assert.assertFalse((boolean)this.calculator.isAllocated(payment));
        CreditAllocation allocation = this.allocator.allocate(payment);
        Assert.assertEquals((long)1L, (long)allocation.getDebits().size());
        Assert.assertEquals((Object)invoice2, allocation.getDebits().get(0));
        Assert.assertEquals((long)1L, (long)allocation.getBlocked().size());
        Assert.assertEquals((Object)invoice1, allocation.getBlocked().keySet().iterator().next());
        Assert.assertTrue((boolean)allocation.isModified());
        Assert.assertEquals((long)2L, (long)allocation.getModified().size());
        Assert.assertTrue((boolean)allocation.getModified().contains(payment));
        Assert.assertTrue((boolean)allocation.getModified().contains(invoice2));
        Assert.assertFalse((boolean)allocation.overrideDefaultAllocation());
        HashSet<FinancialAct> acts = new HashSet<FinancialAct>(paymentActs);
        acts.addAll(allocation.getModified());
        this.save(acts);
        Assert.assertFalse((boolean)this.calculator.isAllocated(this.get(invoice1)));
        Assert.assertTrue((boolean)this.calculator.isAllocated(this.get(invoice2)));
        Assert.assertTrue((boolean)this.calculator.isAllocated(this.get(payment)));
    }

    @Test
    public void testAllocateAgainstSpecifiedInvoices() {
        FinancialAct invoice1 = this.createInvoice(BigDecimal.TEN).get(0);
        FinancialAct invoice2 = this.createInvoice(BigDecimal.TEN).get(0);
        FinancialAct invoice3 = this.createInvoice(BigDecimal.TEN).get(0);
        FinancialAct invoice4 = this.createInvoice(BigDecimal.TEN).get(0);
        Assert.assertFalse((boolean)this.calculator.isAllocated(invoice1));
        Assert.assertFalse((boolean)this.calculator.isAllocated(invoice2));
        Assert.assertFalse((boolean)this.calculator.isAllocated(invoice3));
        Assert.assertFalse((boolean)this.calculator.isAllocated(invoice3));
        BigDecimal twenty1 = BigDecimal.valueOf(21L);
        List<FinancialAct> paymentActs = this.createPayment(twenty1);
        FinancialAct payment = paymentActs.get(0);
        Assert.assertFalse((boolean)this.calculator.isAllocated(payment));
        List acts = this.allocator.allocate(payment, Arrays.asList(invoice2, invoice3, invoice4));
        Assert.assertEquals((long)4L, (long)acts.size());
        Assert.assertEquals((Object)invoice2, acts.get(0));
        Assert.assertEquals((Object)invoice3, acts.get(1));
        Assert.assertEquals((Object)invoice4, acts.get(2));
        Assert.assertEquals((Object)payment, acts.get(3));
        this.checkAllocation(invoice1, BigDecimal.ZERO);
        this.checkAllocation(invoice2, BigDecimal.TEN);
        this.checkAllocation(invoice3, BigDecimal.TEN);
        this.checkAllocation(invoice4, BigDecimal.ONE);
        this.checkAllocation(payment, twenty1);
        this.checkEquals(twenty1, payment.getAllocatedAmount());
        acts.add(paymentActs.get(1));
        this.save(acts);
        this.checkAllocation(this.get(invoice1), BigDecimal.ZERO);
        this.checkAllocation(this.get(invoice2), BigDecimal.TEN);
        this.checkAllocation(this.get(invoice3), BigDecimal.TEN);
        this.checkAllocation(this.get(invoice4), BigDecimal.ONE);
        this.checkAllocation(this.get(payment), twenty1);
    }

    private void checkAllocation(FinancialAct act, BigDecimal amount) {
        this.checkEquals(amount, act.getAllocatedAmount());
    }

    private void checkDefaultAllocation(BigDecimal invoiceAmount, BigDecimal paymentAmount) {
        FinancialAct invoice = this.createInvoice(invoiceAmount).get(0);
        Assert.assertFalse((boolean)this.calculator.isAllocated(invoice));
        List<FinancialAct> paymentActs = this.createPayment(paymentAmount);
        FinancialAct payment = paymentActs.get(0);
        Assert.assertFalse((boolean)this.calculator.isAllocated(payment));
        CreditAllocation allocation = this.allocator.allocate(payment);
        Assert.assertEquals((Object)payment, (Object)allocation.getCredit());
        Assert.assertEquals((long)1L, (long)allocation.getDebits().size());
        Assert.assertTrue((boolean)allocation.getDebits().contains(invoice));
        Assert.assertTrue((boolean)allocation.getBlocked().isEmpty());
        Assert.assertFalse((boolean)allocation.isModified());
        Assert.assertFalse((boolean)allocation.overrideDefaultAllocation());
        Assert.assertFalse((boolean)this.calculator.isAllocated(payment));
        Assert.assertFalse((boolean)this.calculator.isAllocated(invoice));
        this.save(paymentActs);
        boolean allocated = paymentAmount.compareTo(invoiceAmount) <= 0;
        Assert.assertEquals((Object)allocated, (Object)this.calculator.isAllocated(this.get(payment)));
    }

    private List<FinancialAct> createInvoice(BigDecimal amount) {
        TestInvoiceBuilder builder = this.accountFactory.newInvoice();
        FinancialAct invoice = (FinancialAct)((TestInvoiceBuilder)((TestInvoiceBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceBuilder)builder.customer(this.customer)).item().patient(this.patient)).product(this.product)).unitPrice(amount)).add()).status("POSTED")).build();
        ArrayList<FinancialAct> result = new ArrayList<FinancialAct>();
        result.add(invoice);
        result.addAll(builder.getItems());
        return result;
    }

    private List<FinancialAct> createPayment(BigDecimal amount) {
        TestPaymentBuilder builder = this.accountFactory.newPayment();
        FinancialAct payment = ((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)builder.customer(this.customer)).till(this.till)).status("POSTED")).cash(amount).build(false);
        ArrayList<FinancialAct> result = new ArrayList<FinancialAct>();
        result.add(payment);
        result.addAll(builder.getItems());
        return result;
    }
}

