/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.AbstractCustomerAccountTest;
import org.openvpms.archetype.rules.finance.account.OutstandingBalanceQuery;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;

public class OutstandingBalanceQueryTestCase
extends AbstractCustomerAccountTest {
    @Test
    public void testQuery() {
        Party customer = this.getCustomer();
        List<Party> before = this.getCustomersWithOutstandingBalances();
        customer.addClassification(this.createAccountType(30, DateUnits.DAYS));
        this.save((IMObject)customer);
        Money amount = new Money(100);
        Date startTime = TestHelper.getDate("2007-01-01");
        List<FinancialAct> invoice = this.createChargesInvoice((BigDecimal)amount, startTime);
        this.save(invoice);
        List<Party> after = this.getCustomersWithOutstandingBalances();
        Assert.assertEquals((long)(before.size() + 1), (long)after.size());
        Assert.assertTrue((boolean)after.contains(customer));
        FinancialAct payment = this.createPayment((BigDecimal)amount);
        this.save((IMObject)payment);
        List<Party> now = this.getCustomersWithOutstandingBalances();
        Assert.assertEquals((long)before.size(), (long)now.size());
        Assert.assertFalse((boolean)now.contains(customer));
    }

    @Test
    public void testQueryWithAccountType() {
        Lookup accountType1 = this.createAccountType(30, DateUnits.DAYS);
        Lookup accountType2 = this.createAccountType(60, DateUnits.DAYS);
        OutstandingBalanceQuery query = new OutstandingBalanceQuery(this.getArchetypeService());
        query.setAccountType(accountType1);
        Assert.assertFalse((boolean)query.query().hasNext());
        Party customer = this.getCustomer();
        customer.addClassification(accountType1);
        this.save((IMObject)customer);
        Assert.assertFalse((boolean)query.query().hasNext());
        Money amount = new Money(100);
        Date startTime = TestHelper.getDate("2007-01-01");
        List<FinancialAct> invoice = this.createChargesInvoice((BigDecimal)amount, startTime);
        this.save(invoice);
        Iterator iter = query.query();
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)customer, iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
        query.setAccountType(accountType2);
        Assert.assertFalse((boolean)query.query().hasNext());
    }

    private List<Party> getCustomersWithOutstandingBalances() {
        ArrayList<Party> result = new ArrayList<Party>();
        OutstandingBalanceQuery query = new OutstandingBalanceQuery(this.getArchetypeService());
        Iterator iterator = query.query();
        while (iterator.hasNext()) {
            result.add((Party)iterator.next());
        }
        return result;
    }
}

