/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.junit.Assert;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.helper.IMObjectBean;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;

public class FinancialTestHelper
extends TestHelper {
    public static List<FinancialAct> createChargesInvoice(BigDecimal amount, Party customer, Party patient, Product product, String status) {
        return FinancialTestHelper.createChargesInvoice(customer, patient, product, BigDecimal.ONE, BigDecimal.ZERO, amount, BigDecimal.ZERO, status);
    }

    public static List<FinancialAct> createChargesInvoice(Party customer, Party patient, Product product, BigDecimal quantity, BigDecimal fixedPrice, BigDecimal unitPrice, BigDecimal tax, String status) {
        return FinancialTestHelper.createChargesInvoice(customer, patient, null, product, quantity, fixedPrice, unitPrice, tax, status);
    }

    public static List<FinancialAct> createChargesInvoice(Party customer, Party patient, User clinician, Product product, BigDecimal quantity, BigDecimal fixedPrice, BigDecimal unitPrice, BigDecimal tax, String status) {
        return FinancialTestHelper.createCharges("act.customerAccountChargesInvoice", "act.customerAccountInvoiceItem", customer, patient, clinician, product, quantity, fixedPrice, unitPrice, BigDecimal.ZERO, tax, status);
    }

    public static List<FinancialAct> createChargesInvoice(Party customer, User clinician, String status, FinancialAct ... items) {
        return FinancialTestHelper.createCharges("act.customerAccountChargesInvoice", customer, clinician, status, items);
    }

    public static List<FinancialAct> createChargesCredit(Party customer, User clinician, String status, FinancialAct ... items) {
        return FinancialTestHelper.createCharges("act.customerAccountChargesCredit", customer, clinician, status, items);
    }

    public static List<FinancialAct> createChargesCounter(BigDecimal amount, Party customer, Product product, String status) {
        return FinancialTestHelper.createCharges("act.customerAccountChargesCounter", "act.customerAccountCounterItem", amount, customer, null, product, status);
    }

    public static List<FinancialAct> createChargesCredit(BigDecimal amount, Party customer, Party patient, Product product, String status) {
        List<FinancialAct> result = FinancialTestHelper.createCharges("act.customerAccountChargesCredit", "act.customerAccountCreditItem", amount, customer, patient, product, status);
        IMObjectBean bean = new IMObjectBean((IMObject)result.get(0));
        bean.setValue("notes", (Object)"Dummy notes");
        return result;
    }

    public static FinancialAct createPayment(BigDecimal amount, Party customer, Entity till, String status) {
        return FinancialTestHelper.createPaymentRefund("act.customerAccountPayment", amount, customer, till, status);
    }

    public static List<FinancialAct> createPayment(Party customer, Entity till, String status, FinancialAct ... items) {
        ArrayList<FinancialAct> result = new ArrayList<FinancialAct>();
        BigDecimal amount = BigDecimal.ZERO;
        FinancialAct act = FinancialTestHelper.createAct("act.customerAccountPayment", BigDecimal.ZERO, customer, null, status);
        result.add(act);
        IMObjectBean bean = new IMObjectBean((IMObject)act);
        for (FinancialAct item : items) {
            amount = amount.add(item.getTotal());
            Relationship relationship = bean.addTarget("items", (IMObject)item);
            item.addActRelationship((ActRelationship)relationship);
            result.add(item);
        }
        act.setTotal(amount);
        bean.setTarget("till", (IMObject)till);
        return result;
    }

    public static FinancialAct createPaymentCash(BigDecimal amount) {
        return FinancialTestHelper.createPaymentRefundItem("act.customerAccountPaymentCash", amount);
    }

    public static FinancialAct createPaymentCheque(BigDecimal amount) {
        return FinancialTestHelper.createPaymentRefundItem("act.customerAccountPaymentCheque", amount);
    }

    public static FinancialAct createPaymentCredit(BigDecimal amount) {
        return FinancialTestHelper.createPaymentRefundItem("act.customerAccountPaymentCredit", amount);
    }

    public static FinancialAct createPaymentDiscount(BigDecimal amount) {
        return FinancialTestHelper.createPaymentRefundItem("act.customerAccountPaymentDiscount", amount);
    }

    public static FinancialAct createPaymentEFT(BigDecimal amount) {
        return FinancialTestHelper.createPaymentRefundItem("act.customerAccountPaymentEFT", amount);
    }

    public static FinancialAct createPaymentOther(BigDecimal amount) {
        return FinancialTestHelper.createPaymentRefundItem("act.customerAccountPaymentOther", amount);
    }

    public static List<FinancialAct> createPaymentCash(BigDecimal amount, Party customer, Entity till, String status) {
        return FinancialTestHelper.createPaymentRefund("act.customerAccountPayment", "act.customerAccountPaymentCash", amount, customer, till, status, false);
    }

    public static List<FinancialAct> createRefundCash(BigDecimal amount, Party customer, Entity till, String status) {
        List<FinancialAct> result = FinancialTestHelper.createPaymentRefund("act.customerAccountRefund", "act.customerAccountRefundCash", amount, customer, till, status, false);
        IMObjectBean bean = new IMObjectBean((IMObject)result.get(0));
        bean.setValue("notes", (Object)"Dummy notes");
        return result;
    }

    public static FinancialAct createPaymentCash(BigDecimal amount, Party customer, Entity till) {
        return FinancialTestHelper.createPaymentRefund("act.customerAccountPayment", "act.customerAccountPaymentCash", amount, customer, till);
    }

    public static FinancialAct createPaymentCheque(BigDecimal amount, Party customer, Entity till) {
        return FinancialTestHelper.createPaymentRefund("act.customerAccountPayment", "act.customerAccountPaymentCheque", amount, customer, till);
    }

    public static FinancialAct createPaymentCredit(BigDecimal amount, Party customer, Entity till) {
        return FinancialTestHelper.createPaymentRefund("act.customerAccountPayment", "act.customerAccountPaymentCredit", amount, customer, till);
    }

    public static FinancialAct createPaymentDiscount(BigDecimal amount, Party customer, Entity till) {
        return FinancialTestHelper.createPaymentRefund("act.customerAccountPayment", "act.customerAccountPaymentDiscount", amount, customer, till);
    }

    public static FinancialAct createPaymentEFT(BigDecimal amount, Party customer, Entity till) {
        return FinancialTestHelper.createPaymentRefund("act.customerAccountPayment", "act.customerAccountPaymentEFT", amount, customer, till);
    }

    public static FinancialAct createPaymentOther(BigDecimal amount, Party customer, Entity till) {
        return FinancialTestHelper.createPaymentRefund("act.customerAccountPayment", "act.customerAccountPaymentOther", amount, customer, till);
    }

    public static FinancialAct createPaymentPaymentProcessor(BigDecimal amount, Party customer, Entity till) {
        return FinancialTestHelper.createPaymentRefund("act.customerAccountPayment", "act.customerAccountPaymentPP", amount, customer, till);
    }

    public static FinancialAct createRefund(BigDecimal amount, Party customer, Entity till, String status) {
        return FinancialTestHelper.createPaymentRefund("act.customerAccountRefund", amount, customer, till, status);
    }

    public static FinancialAct createRefundCash(BigDecimal amount, Party customer, Entity till) {
        FinancialAct result = FinancialTestHelper.createPaymentRefund("act.customerAccountRefund", "act.customerAccountRefundCash", amount, customer, till);
        IMObjectBean bean = new IMObjectBean((IMObject)result);
        bean.setValue("notes", (Object)"Dummy notes");
        return result;
    }

    public static FinancialAct createRefundCheque(BigDecimal amount, Party customer, Entity till) {
        FinancialAct result = FinancialTestHelper.createPaymentRefund("act.customerAccountRefund", "act.customerAccountRefundCheque", amount, customer, till);
        IMObjectBean bean = new IMObjectBean((IMObject)result);
        bean.setValue("notes", (Object)"Dummy notes");
        return result;
    }

    public static FinancialAct createRefundCredit(BigDecimal amount, Party customer, Entity till) {
        FinancialAct result = FinancialTestHelper.createPaymentRefund("act.customerAccountRefund", "act.customerAccountRefundCredit", amount, customer, till);
        IMObjectBean bean = new IMObjectBean((IMObject)result);
        bean.setValue("notes", (Object)"Dummy notes");
        return result;
    }

    public static FinancialAct createRefundDiscount(BigDecimal amount, Party customer, Entity till) {
        FinancialAct result = FinancialTestHelper.createPaymentRefund("act.customerAccountRefund", "act.customerAccountRefundDiscount", amount, customer, till);
        IMObjectBean bean = new IMObjectBean((IMObject)result);
        bean.setValue("notes", (Object)"Dummy notes");
        return result;
    }

    public static FinancialAct createRefundEFT(BigDecimal amount, Party customer, Entity till) {
        FinancialAct result = FinancialTestHelper.createPaymentRefund("act.customerAccountRefund", "act.customerAccountRefundEFT", amount, customer, till);
        IMObjectBean bean = new IMObjectBean((IMObject)result);
        bean.setValue("notes", (Object)"Dummy notes");
        return result;
    }

    public static FinancialAct createRefundOther(BigDecimal amount, Party customer, Entity till) {
        FinancialAct result = FinancialTestHelper.createPaymentRefund("act.customerAccountRefund", "act.customerAccountRefundOther", amount, customer, till);
        IMObjectBean bean = new IMObjectBean((IMObject)result);
        bean.setValue("notes", (Object)"Dummy notes");
        return result;
    }

    public static FinancialAct createRefundPaymentProcessor(BigDecimal amount, Party customer, Entity till) {
        FinancialAct result = FinancialTestHelper.createPaymentRefund("act.customerAccountRefund", "act.customerAccountRefundPP", amount, customer, till);
        IMObjectBean bean = new IMObjectBean((IMObject)result);
        bean.setValue("notes", (Object)"Dummy notes");
        return result;
    }

    public static FinancialAct createInvoiceItem(Date date, Party patient, User clinician, Product product, BigDecimal quantity, BigDecimal fixedPrice, BigDecimal unitPrice, BigDecimal discount, BigDecimal tax) {
        FinancialAct act = FinancialTestHelper.createChargeItem("act.customerAccountInvoiceItem", patient, clinician, product, quantity, fixedPrice, unitPrice, discount, tax);
        act.setActivityStartTime(date);
        return act;
    }

    public static FinancialAct createChargeItem(String itemShortName, Party patient, Product product, BigDecimal unitPrice) {
        return FinancialTestHelper.createChargeItem(itemShortName, patient, null, product, BigDecimal.ONE, unitPrice, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    public static FinancialAct createChargeItem(String itemShortName, Party patient, User clinician, Product product, BigDecimal quantity, BigDecimal fixedPrice, BigDecimal unitPrice, BigDecimal discount, BigDecimal tax) {
        FinancialAct item = FinancialTestHelper.create(itemShortName, FinancialAct.class);
        IMObjectBean bean = new IMObjectBean((IMObject)item);
        if (patient != null) {
            bean.setTarget("patient", (IMObject)patient);
        }
        if (clinician != null) {
            bean.setTarget("clinician", (IMObject)clinician);
        }
        if (product != null) {
            bean.setTarget("product", (IMObject)product);
        }
        bean.setValue("quantity", (Object)quantity);
        bean.setValue("fixedPrice", (Object)fixedPrice);
        bean.setValue("unitPrice", (Object)unitPrice);
        bean.setValue("discount", (Object)discount);
        bean.setValue("tax", (Object)tax);
        bean.setValue("total", (Object)MathRules.calculateTotal((BigDecimal)fixedPrice, (BigDecimal)unitPrice, (BigDecimal)quantity, (BigDecimal)discount, (int)2));
        bean.deriveValues();
        return item;
    }

    public static Entity createTill() {
        Entity till = FinancialTestHelper.create("party.organisationTill", Entity.class);
        till.setName("XTill-" + System.currentTimeMillis());
        FinancialTestHelper.save((IMObject)till);
        return till;
    }

    public static FinancialAct createTillBalance(Entity till) {
        FinancialAct act = FinancialTestHelper.create("act.tillBalance", FinancialAct.class);
        IMObjectBean bean = new IMObjectBean((IMObject)act);
        bean.setTarget("till", (IMObject)till);
        return act;
    }

    public static FinancialAct createPaymentRefundItem(String itemShortName, BigDecimal amount) {
        FinancialAct item = FinancialTestHelper.create(itemShortName, FinancialAct.class);
        IMObjectBean itemBean = new IMObjectBean((IMObject)item);
        itemBean.setValue("amount", (Object)amount);
        if (itemBean.isA(new String[]{"act.customerAccountPaymentCash", "act.customerAccountRefundCash"})) {
            itemBean.setValue("roundedAmount", (Object)amount);
            if (itemBean.isA(new String[]{"act.customerAccountPaymentCash"})) {
                itemBean.setValue("tendered", (Object)amount);
            }
        }
        return item;
    }

    public static <T extends Act> T find(List<T> items, Product product) {
        return FinancialTestHelper.find(items, null, product, null);
    }

    public static <T extends Act> T find(List<T> items, Party patient, Product product) {
        return FinancialTestHelper.find(items, patient, product, null);
    }

    public static <T extends Act> T find(List<T> items, Party patient, Product product, BigDecimal quantity) {
        return FinancialTestHelper.find(items, patient != null ? patient.getObjectReference() : null, product.getObjectReference(), quantity);
    }

    public static <T extends Act> T find(List<T> items, Reference patient, Reference product, BigDecimal quantity) {
        Act result = null;
        for (Act item : items) {
            IMObjectBean bean = new IMObjectBean((IMObject)item);
            if (!Objects.equals(bean.getTargetRef("product"), product)) continue;
            if (bean.hasNode("patient")) {
                if (!Objects.equals(bean.getTargetRef("patient"), patient) || quantity != null && quantity.compareTo(bean.getBigDecimal("quantity", BigDecimal.ZERO)) != 0) continue;
                result = item;
                break;
            }
            if (quantity != null && quantity.compareTo(bean.getBigDecimal("quantity", BigDecimal.ZERO)) != 0) continue;
            result = item;
            break;
        }
        return (T)result;
    }

    public static void checkItem(FinancialAct item, String archetype, Party patient, Product product, Product template, int group, User author, User clinician, BigDecimal minimumQuantity, BigDecimal quantity, BigDecimal unitCost, BigDecimal unitPrice, BigDecimal fixedCost, BigDecimal fixedPrice, BigDecimal discount, BigDecimal tax, BigDecimal total, boolean print) {
        Assert.assertTrue((boolean)item.isA(archetype));
        IMObjectBean bean = new IMObjectBean((IMObject)item);
        if (bean.hasNode("patient")) {
            Reference patientRef = patient != null ? patient.getObjectReference() : null;
            Assert.assertEquals((Object)patientRef, (Object)bean.getTargetRef("patient"));
        }
        Assert.assertEquals((Object)product.getObjectReference(), (Object)bean.getTargetRef("product"));
        if (template == null) {
            Assert.assertNull((Object)bean.getTargetRef("template"));
        } else {
            Assert.assertEquals((Object)template.getObjectReference(), (Object)bean.getTargetRef("template"));
            Participation participation = (Participation)bean.getObject("template", Participation.class);
            IMObjectBean participationBean = new IMObjectBean((IMObject)participation);
            Assert.assertEquals((long)group, (long)participationBean.getInt("group"));
        }
        if (author != null) {
            Assert.assertEquals((Object)author.getObjectReference(), (Object)item.getCreatedBy());
        } else {
            Assert.assertNull((Object)item.getCreatedBy());
        }
        if (bean.hasNode("clinician")) {
            if (clinician != null) {
                Assert.assertEquals((Object)clinician.getObjectReference(), (Object)bean.getTargetRef("clinician"));
            } else {
                Assert.assertNull((Object)bean.getTarget("clinician"));
            }
        }
        FinancialTestHelper.checkEquals(minimumQuantity, bean.getBigDecimal("minQuantity"));
        FinancialTestHelper.checkEquals(quantity, bean.getBigDecimal("quantity"));
        FinancialTestHelper.checkEquals(fixedCost, bean.getBigDecimal("fixedCost"));
        FinancialTestHelper.checkEquals(fixedPrice, bean.getBigDecimal("fixedPrice"));
        FinancialTestHelper.checkEquals(unitPrice, bean.getBigDecimal("unitPrice"));
        FinancialTestHelper.checkEquals(unitCost, bean.getBigDecimal("unitCost"));
        FinancialTestHelper.checkEquals(discount, bean.getBigDecimal("discount"));
        FinancialTestHelper.checkEquals(tax, bean.getBigDecimal("tax"));
        FinancialTestHelper.checkEquals(total, bean.getBigDecimal("total"));
        Assert.assertEquals((Object)print, (Object)bean.getBoolean("print"));
    }

    public static List<FinancialAct> createCharges(String shortName, Party customer, User clinician, String status, FinancialAct ... items) {
        ArrayList<FinancialAct> result = new ArrayList<FinancialAct>();
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        FinancialAct act = FinancialTestHelper.createAct(shortName, amount, customer, clinician, status);
        result.add(act);
        IMObjectBean chargeBean = new IMObjectBean((IMObject)act);
        for (FinancialAct item : items) {
            IMObjectBean itemBean = new IMObjectBean((IMObject)item);
            tax = tax.add(itemBean.getBigDecimal("tax", BigDecimal.ZERO));
            amount = amount.add(itemBean.getBigDecimal("total", BigDecimal.ZERO));
            result.add(item);
            Relationship relationship = chargeBean.addTarget("items", (IMObject)item);
            item.addActRelationship((ActRelationship)relationship);
        }
        chargeBean.setValue("amount", (Object)amount);
        chargeBean.setValue("tax", (Object)tax);
        return result;
    }

    private static List<FinancialAct> createCharges(String shortName, String itemShortName, BigDecimal amount, Party customer, Party patient, Product product, String status) {
        return FinancialTestHelper.createCharges(shortName, itemShortName, customer, patient, null, product, BigDecimal.ONE, BigDecimal.ZERO, amount, BigDecimal.ZERO, BigDecimal.ZERO, status);
    }

    private static List<FinancialAct> createCharges(String shortName, String itemShortName, Party customer, Party patient, User clinician, Product product, BigDecimal quantity, BigDecimal fixedPrice, BigDecimal unitPrice, BigDecimal discount, BigDecimal tax, String status) {
        FinancialAct item = FinancialTestHelper.createChargeItem(itemShortName, patient, clinician, product, quantity, fixedPrice, unitPrice, discount, tax);
        return FinancialTestHelper.createCharges(shortName, customer, clinician, status, item);
    }

    private static FinancialAct createPaymentRefund(String shortName, String itemShortName, BigDecimal amount, Party customer, Entity till) {
        List<FinancialAct> acts = FinancialTestHelper.createPaymentRefund(shortName, itemShortName, amount, customer, till, "POSTED", true);
        return acts.get(0);
    }

    private static FinancialAct createPaymentRefund(String shortName, BigDecimal amount, Party customer, Entity till, String status) {
        FinancialAct act = FinancialTestHelper.createAct(shortName, amount, customer, null, status);
        IMObjectBean bean = new IMObjectBean((IMObject)act);
        bean.setValue("amount", (Object)amount);
        bean.setTarget("till", (IMObject)till);
        return act;
    }

    private static List<FinancialAct> createPaymentRefund(String shortName, String itemShortName, BigDecimal amount, Party customer, Entity till, String status, boolean saveItem) {
        FinancialAct act = FinancialTestHelper.createPaymentRefund(shortName, amount, customer, till, status);
        IMObjectBean bean = new IMObjectBean((IMObject)act);
        FinancialAct item = FinancialTestHelper.createPaymentRefundItem(itemShortName, amount);
        if (saveItem) {
            IMObjectBean itemBean = new IMObjectBean((IMObject)item);
            itemBean.save();
        }
        ActRelationship relationship = (ActRelationship)bean.addTarget("items", (IMObject)item);
        item.addActRelationship(relationship);
        return Arrays.asList(act, item);
    }

    private static FinancialAct createAct(String shortName, BigDecimal amount, Party customer, User clinician, String status) {
        FinancialAct act = FinancialTestHelper.create(shortName, FinancialAct.class);
        act.setStatus(status);
        IMObjectBean bean = new IMObjectBean((IMObject)act);
        bean.setValue("amount", (Object)amount);
        bean.setTarget("customer", (IMObject)customer);
        if (clinician != null) {
            bean.setTarget("clinician", (IMObject)clinician);
        }
        return act;
    }
}

