/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.AbstractCustomerAccountTest;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.account.CustomerBalanceSummaryQuery;
import org.openvpms.archetype.rules.practice.Location;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.query.ObjectSet;

public class CustomerBalanceSummaryQueryTestCase
extends AbstractCustomerAccountTest {
    @Test
    public void testQuery() {
        Party customer = this.getCustomer();
        Lookup accountType = this.createAccountType(30, DateUnits.DAYS);
        customer.addClassification(accountType);
        this.save((IMObject)customer);
        Date startTime = TestHelper.getDate("2007-01-01");
        Date now = DateRules.getDate((Date)startTime, (int)60, (DateUnits)DateUnits.DAYS);
        BigDecimal hundred = new BigDecimal(100);
        List<FinancialAct> invoice = this.createChargesInvoice(hundred, startTime);
        this.save(invoice);
        Date paymentStartTime = DateRules.getDate((Date)startTime, (int)1, (DateUnits)DateUnits.DAYS);
        BigDecimal fifty = new BigDecimal(50);
        FinancialAct payment = this.createPayment(fifty);
        payment.setActivityStartTime(paymentStartTime);
        payment.setStatus("POSTED");
        this.save((IMObject)payment);
        CustomerBalanceSummaryQuery query = new CustomerBalanceSummaryQuery(now, this.getArchetypeService(), this.getLookupService(), this.getRules());
        Assert.assertTrue((boolean)query.hasNext());
        ObjectSet set = null;
        while (query.hasNext()) {
            ObjectSet tmp = query.next();
            IMObjectReference ref = tmp.getReference("customer.objectReference");
            if (!customer.getObjectReference().equals((Object)ref)) continue;
            set = tmp;
            break;
        }
        Assert.assertNotNull(set);
        BigDecimal balance = set.getBigDecimal("balance");
        BigDecimal overdue = set.getBigDecimal("overdueBalance");
        BigDecimal credit = set.getBigDecimal("creditBalance");
        Date paymentDate = set.getDate("lastPaymentDate");
        BigDecimal paymentAmount = set.getBigDecimal("lastPaymentAmount");
        Date invoiceDate = set.getDate("lastInvoiceDate");
        BigDecimal invoiceAmount = set.getBigDecimal("lastInvoiceAmount");
        this.checkEquals(fifty, balance);
        this.checkEquals(fifty, overdue);
        this.checkEquals(BigDecimal.ZERO, credit);
        Assert.assertEquals((Object)paymentStartTime, (Object)paymentDate);
        this.checkEquals(fifty, paymentAmount);
        Assert.assertEquals((Object)startTime, (Object)invoiceDate);
        this.checkEquals(hundred, invoiceAmount);
    }

    @Test
    public void testQueryByAccountType() {
        IArchetypeService service = this.getArchetypeService();
        LookupService lookups = this.getLookupService();
        CustomerAccountRules rules = this.getRules();
        Party customer = this.getCustomer();
        Lookup accountType1 = this.createAccountType(30, DateUnits.DAYS);
        Lookup accountType2 = this.createAccountType(30, DateUnits.DAYS);
        customer.addClassification(accountType1);
        this.save((IMObject)customer);
        Date startTime = TestHelper.getDate("2007-01-01");
        BigDecimal hundred = new BigDecimal(100);
        List<FinancialAct> invoice = this.createChargesInvoice(hundred, startTime);
        this.save(invoice);
        CustomerBalanceSummaryQuery query = new CustomerBalanceSummaryQuery(new Date(), accountType1, service, lookups, rules);
        this.checkSummaries(1, query);
        CustomerBalanceSummaryQuery query2 = new CustomerBalanceSummaryQuery(new Date(), accountType2, service, lookups, rules);
        this.checkSummaries(0, query2);
    }

    @Test
    public void testQueryByLocation() {
        Party location1 = TestHelper.createLocation();
        Party location2 = TestHelper.createLocation();
        Party customer1 = TestHelper.createCustomer(location1);
        Party customer2 = TestHelper.createCustomer(location2);
        Party customer3 = TestHelper.createCustomer();
        HashSet<Party> customers = new HashSet<Party>();
        customers.add(customer1);
        customers.add(customer2);
        customers.add(customer3);
        List<FinancialAct> invoice1 = this.createChargesInvoice(new BigDecimal(100), customer1);
        List<FinancialAct> invoice2 = this.createChargesInvoice(new BigDecimal(100), customer2);
        List<FinancialAct> invoice3 = this.createChargesInvoice(new BigDecimal(100), customer3);
        this.save(invoice1);
        this.save(invoice2);
        this.save(invoice3);
        Date date = new Date();
        this.checkLocation(date, Location.ALL, customers, customer1, customer2, customer3);
        this.checkLocation(date, Location.NONE, customers, customer3);
        this.checkLocation(date, new Location(location1), customers, customer1);
        this.checkLocation(date, new Location(location2), customers, customer2);
    }

    @Test
    public void testOverdueQuery() {
        Party customer = this.getCustomer();
        Reference custRef = customer.getObjectReference();
        customer.addClassification(this.createAccountType(30, DateUnits.DAYS));
        this.save((IMObject)customer);
        Date startTime = TestHelper.getDate("2007-01-01");
        Date now = DateRules.getDate((Date)startTime, (int)60, (DateUnits)DateUnits.DAYS);
        List<Reference> beforeAll = this.getCustomersWithOverdueBalances(now, 0, 0);
        List<Reference> before30 = this.getCustomersWithOverdueBalances(now, 30, 0);
        List<Reference> before15 = this.getCustomersWithOverdueBalances(now, 15, 0);
        List<Reference> before15btw30 = this.getCustomersWithOverdueBalances(now, 15, 30);
        List<Reference> before15btw45 = this.getCustomersWithOverdueBalances(now, 15, 45);
        BigDecimal amount = new BigDecimal(100);
        List<FinancialAct> invoice = this.createChargesInvoice(amount, startTime);
        this.save(invoice);
        List<Reference> after = this.getCustomersWithOverdueBalances(now, 0, 0);
        Assert.assertEquals((long)(beforeAll.size() + 1), (long)after.size());
        Assert.assertTrue((boolean)after.contains(custRef));
        after = this.getCustomersWithOverdueBalances(now, 30, 0);
        Assert.assertEquals((long)before30.size(), (long)after.size());
        Assert.assertFalse((boolean)after.contains(custRef));
        after = this.getCustomersWithOverdueBalances(now, 15, 0);
        Assert.assertEquals((long)(before15.size() + 1), (long)after.size());
        Assert.assertTrue((boolean)after.contains(custRef));
        after = this.getCustomersWithOverdueBalances(now, 15, 30);
        Assert.assertEquals((long)before15btw30.size(), (long)after.size());
        Assert.assertFalse((boolean)after.contains(custRef));
        after = this.getCustomersWithOverdueBalances(now, 15, 45);
        Assert.assertEquals((long)(before15btw45.size() + 1), (long)after.size());
        Assert.assertTrue((boolean)after.contains(custRef));
        FinancialAct payment = this.createPayment(amount);
        this.save((IMObject)payment);
        after = this.getCustomersWithOverdueBalances(now, 0, 0);
        Assert.assertEquals((long)beforeAll.size(), (long)after.size());
        Assert.assertFalse((boolean)after.contains(custRef));
    }

    @Test
    public void testQueryByCustomerRange() {
        IArchetypeService service = this.getArchetypeService();
        LookupService lookups = this.getLookupService();
        CustomerAccountRules rules = this.getRules();
        Party customerA = TestHelper.createCustomer("Foo", "A" + System.currentTimeMillis(), true);
        Lookup accountType = this.createAccountType(30, DateUnits.DAYS);
        customerA.addClassification(accountType);
        this.save((IMObject)customerA);
        Party customerB = TestHelper.createCustomer("Foo", "B" + System.currentTimeMillis(), true);
        Party customerZ = TestHelper.createCustomer("Foo", "Z" + System.currentTimeMillis(), true);
        HashSet<Party> customers = new HashSet<Party>();
        customers.add(customerA);
        customers.add(customerB);
        customers.add(customerZ);
        List<FinancialAct> invoice1 = this.createChargesInvoice(new BigDecimal(100), customerA);
        List<FinancialAct> invoice2 = this.createChargesInvoice(new BigDecimal(100), customerB);
        List<FinancialAct> invoice3 = this.createChargesInvoice(new BigDecimal(100), customerZ);
        this.save(invoice1);
        this.save(invoice2);
        this.save(invoice3);
        CustomerBalanceSummaryQuery query1 = new CustomerBalanceSummaryQuery(new Date(), null, customerA.getName(), null, service, lookups, rules);
        CustomerBalanceSummaryQuery query2 = new CustomerBalanceSummaryQuery(new Date(), null, customerA.getName(), customerZ.getName(), service, lookups, rules);
        CustomerBalanceSummaryQuery query3 = new CustomerBalanceSummaryQuery(new Date(), null, customerB.getName(), customerZ.getName(), service, lookups, rules);
        CustomerBalanceSummaryQuery query4 = new CustomerBalanceSummaryQuery(new Date(), accountType, customerA.getName(), null, service, lookups, rules);
        CustomerBalanceSummaryQuery query5 = new CustomerBalanceSummaryQuery(new Date(), accountType, customerA.getName(), customerZ.getName(), service, lookups, rules);
        CustomerBalanceSummaryQuery query6 = new CustomerBalanceSummaryQuery(new Date(), accountType, customerB.getName(), customerZ.getName(), service, lookups, rules);
        this.checkCustomers(query1, customers, customerA, customerB, customerZ);
        this.checkCustomers(query2, customers, customerA, customerB, customerZ);
        this.checkCustomers(query3, customers, customerB, customerZ);
        this.checkCustomers(query4, customers, customerA);
        this.checkCustomers(query5, customers, customerA);
        this.checkCustomers(query6, customers, new Party[0]);
        CustomerBalanceSummaryQuery wildcard1 = new CustomerBalanceSummaryQuery(new Date(), null, "A*", null, service, lookups, rules);
        CustomerBalanceSummaryQuery wildcard2 = new CustomerBalanceSummaryQuery(new Date(), null, "A*", "Z*", service, lookups, rules);
        CustomerBalanceSummaryQuery wildcard3 = new CustomerBalanceSummaryQuery(new Date(), null, "B*", "Z*", service, lookups, rules);
        CustomerBalanceSummaryQuery wildcard4 = new CustomerBalanceSummaryQuery(new Date(), accountType, "A*", null, service, lookups, rules);
        CustomerBalanceSummaryQuery wildcard5 = new CustomerBalanceSummaryQuery(new Date(), accountType, "A*", "Z*", service, lookups, rules);
        CustomerBalanceSummaryQuery wildcard6 = new CustomerBalanceSummaryQuery(new Date(), accountType, "B*", "Z*", service, lookups, rules);
        this.checkCustomers(wildcard1, customers, customerA, customerB, customerZ);
        this.checkCustomers(wildcard2, customers, customerA, customerB);
        this.checkCustomers(wildcard3, customers, customerB);
        this.checkCustomers(wildcard4, customers, customerA);
        this.checkCustomers(wildcard5, customers, customerA);
        this.checkCustomers(wildcard6, customers, new Party[0]);
    }

    @Test
    public void testExcludeCreditBalance() {
        CustomerAccountRules rules = this.getRules();
        LookupService lookups = this.getLookupService();
        Party customer1 = this.getCustomer();
        Party customer2 = TestHelper.createCustomer();
        Date startTime = TestHelper.getDate("2007-01-01");
        BigDecimal hundred = new BigDecimal(100);
        List<FinancialAct> invoice = this.createChargesInvoice(hundred, customer1, startTime);
        this.save(invoice);
        FinancialAct payment = this.createPayment(hundred, customer2);
        payment.setActivityStartTime(startTime);
        this.save((IMObject)payment);
        Date now = new Date();
        IArchetypeService service = this.getArchetypeService();
        CustomerBalanceSummaryQuery includeBalanceQuery = new CustomerBalanceSummaryQuery(now, true, 0, 0, false, null, null, null, Location.ALL, service, lookups, rules);
        Map<Reference, ObjectSet> sets = this.getSets(includeBalanceQuery);
        Set<Reference> customers = sets.keySet();
        Assert.assertTrue((boolean)customers.contains(customer1.getObjectReference()));
        Assert.assertTrue((boolean)customers.contains(customer2.getObjectReference()));
        CustomerBalanceSummaryQuery excludeBalanceQuery = new CustomerBalanceSummaryQuery(now, true, 0, 0, true, null, null, null, Location.ALL, service, lookups, rules);
        sets = this.getSets(excludeBalanceQuery);
        customers = sets.keySet();
        Assert.assertTrue((boolean)customers.contains(customer1.getObjectReference()));
        Assert.assertFalse((boolean)customers.contains(customer2.getObjectReference()));
    }

    @Test
    public void testForSameName() {
        int i;
        IArchetypeService service = this.getArchetypeService();
        LookupService lookups = this.getLookupService();
        CustomerAccountRules rules = this.getRules();
        Party customer1 = this.getCustomer();
        long id = System.currentTimeMillis();
        Party customer2 = TestHelper.createCustomer();
        this.setName(customer1, id);
        this.setName(customer2, id);
        BigDecimal cust1Balance = BigDecimal.ZERO;
        BigDecimal cust2Balance = BigDecimal.ZERO;
        Date startTime = TestHelper.getDate("2007-01-01");
        BigDecimal hundred = new BigDecimal(100);
        for (i = 0; i < 10; ++i) {
            List<FinancialAct> invoice1 = this.createChargesInvoice(hundred, customer1, startTime);
            this.save(invoice1);
            cust1Balance = cust1Balance.add(hundred);
        }
        for (i = 0; i < 12; ++i) {
            List<FinancialAct> invoice2 = this.createChargesInvoice(hundred, customer2, startTime);
            this.save(invoice2);
            cust2Balance = cust2Balance.add(hundred);
        }
        Date now = new Date();
        CustomerBalanceSummaryQuery query = new CustomerBalanceSummaryQuery(now, null, customer1.getName(), customer1.getName(), service, lookups, rules);
        Map<Reference, ObjectSet> sets = this.getSets(query);
        Assert.assertEquals((long)2L, (long)sets.size());
        ObjectSet cust1Set = sets.get(customer1.getObjectReference());
        ObjectSet cust2Set = sets.get(customer2.getObjectReference());
        Assert.assertNotNull((Object)cust1Set);
        Assert.assertNotNull((Object)cust2Set);
        this.checkEquals(cust1Balance, cust1Set.getBigDecimal("balance"));
        this.checkEquals(cust2Balance, cust2Set.getBigDecimal("balance"));
    }

    @Test
    public void testQueryForDatetime() {
        Party customer = this.getCustomer();
        BigDecimal hundred = new BigDecimal(100);
        Date startTime = TestHelper.getDatetime("2017-09-10 10:00:00");
        List<FinancialAct> invoice = this.createChargesInvoice(hundred, startTime);
        this.save(invoice);
        Date date = TestHelper.getDate("2017-09-10");
        CustomerBalanceSummaryQuery query = new CustomerBalanceSummaryQuery(date, this.getArchetypeService(), this.getLookupService(), this.getRules());
        Assert.assertTrue((boolean)query.hasNext());
        ObjectSet set = null;
        while (query.hasNext()) {
            ObjectSet tmp = query.next();
            IMObjectReference ref = tmp.getReference("customer.objectReference");
            if (!customer.getObjectReference().equals((Object)ref)) continue;
            set = tmp;
            break;
        }
        Assert.assertNotNull(set);
        BigDecimal balance = set.getBigDecimal("balance");
        BigDecimal overdue = set.getBigDecimal("overdueBalance");
        BigDecimal credit = set.getBigDecimal("creditBalance");
        Date invoiceDate = set.getDate("lastInvoiceDate");
        BigDecimal invoiceAmount = set.getBigDecimal("lastInvoiceAmount");
        this.checkEquals(hundred, balance);
        this.checkEquals(hundred, overdue);
        this.checkEquals(BigDecimal.ZERO, credit);
        Assert.assertEquals((Object)startTime, (Object)invoiceDate);
        this.checkEquals(hundred, invoiceAmount);
    }

    @Test
    public void testNegativeInvoice() {
        CustomerAccountRules rules = this.getRules();
        LookupService lookups = this.getLookupService();
        Party customer = this.getCustomer();
        Date startTime = TestHelper.getDate("2007-01-01");
        BigDecimal amount = new BigDecimal(-100);
        List<FinancialAct> invoice = this.createChargesInvoice(amount, customer, startTime);
        this.save(invoice);
        IArchetypeService service = this.getArchetypeService();
        CustomerBalanceSummaryQuery query = new CustomerBalanceSummaryQuery(new Date(), true, 0, 0, false, null, customer.getName(), customer.getName(), Location.ALL, service, lookups, rules);
        ObjectSet set = this.getSet(query, customer);
        BigDecimal balance = set.getBigDecimal("balance");
        BigDecimal overdue = set.getBigDecimal("overdueBalance");
        BigDecimal credit = set.getBigDecimal("creditBalance");
        Date invoiceDate = set.getDate("lastInvoiceDate");
        BigDecimal invoiceAmount = set.getBigDecimal("lastInvoiceAmount");
        this.checkEquals(amount, balance);
        this.checkEquals(BigDecimal.ZERO, overdue);
        this.checkEquals(amount, credit);
        Assert.assertEquals((Object)startTime, (Object)invoiceDate);
        this.checkEquals(amount, invoiceAmount);
    }

    @Test
    public void testNegativeCredit() {
        CustomerAccountRules rules = this.getRules();
        LookupService lookups = this.getLookupService();
        Party customer = this.getCustomer();
        Date startTime = TestHelper.getDate("2007-01-01");
        BigDecimal amount = new BigDecimal(-100);
        List<FinancialAct> creditActs = this.createChargesCredit(amount);
        creditActs.get(0).setActivityStartTime(startTime);
        this.save(creditActs);
        IArchetypeService service = this.getArchetypeService();
        CustomerBalanceSummaryQuery query = new CustomerBalanceSummaryQuery(new Date(), true, 0, 0, false, null, customer.getName(), customer.getName(), Location.ALL, service, lookups, rules);
        ObjectSet set = this.getSet(query, customer);
        BigDecimal balance = set.getBigDecimal("balance");
        BigDecimal overdue = set.getBigDecimal("overdueBalance");
        BigDecimal credit = set.getBigDecimal("creditBalance");
        Date invoiceDate = set.getDate("lastInvoiceDate");
        BigDecimal invoiceAmount = set.getBigDecimal("lastInvoiceAmount");
        this.checkEquals(amount.negate(), balance);
        this.checkEquals(amount.negate(), overdue);
        this.checkEquals(BigDecimal.ZERO, credit);
        Assert.assertNull((Object)invoiceDate);
        Assert.assertNull((Object)invoiceAmount);
    }

    private void checkSummaries(int expected, CustomerBalanceSummaryQuery query) {
        int count = 0;
        while (query.hasNext()) {
            ++count;
            query.next();
        }
        Assert.assertEquals((long)expected, (long)count);
    }

    private void checkLocation(Date date, Location location, Set<Party> customers, Party ... expected) {
        CustomerBalanceSummaryQuery query = new CustomerBalanceSummaryQuery(date, null, null, null, location, this.getArchetypeService(), this.getLookupService(), this.getRules());
        this.checkCustomers(query, customers, expected);
    }

    private List<Reference> getCustomersWithOverdueBalances(Date date, int from, int to) {
        ArrayList<Reference> result = new ArrayList<Reference>();
        CustomerAccountRules rules = this.getRules();
        CustomerBalanceSummaryQuery query = new CustomerBalanceSummaryQuery(date, from, to, null, this.getArchetypeService(), this.getLookupService(), rules);
        while (query.hasNext()) {
            ObjectSet set = query.next();
            IMObjectReference ref = set.getReference("customer.objectReference");
            result.add((Reference)ref);
        }
        return result;
    }

    private void checkCustomers(CustomerBalanceSummaryQuery query, Set<Party> customers, Party ... expected) {
        HashSet<Reference> customerSet = new HashSet<Reference>();
        HashSet<Reference> expectedSet = new HashSet<Reference>();
        HashSet<Reference> found = new HashSet<Reference>();
        for (Party customer : customers) {
            customerSet.add(customer.getObjectReference());
        }
        for (Party customer : expected) {
            expectedSet.add(customer.getObjectReference());
        }
        Map<Reference, ObjectSet> sets = this.getSets(query);
        for (Reference ref : sets.keySet()) {
            if (expectedSet.contains(ref)) {
                found.add(ref);
                continue;
            }
            if (!customerSet.contains(ref)) continue;
            Assert.fail((String)"Found customer not expected in balance results");
        }
        Assert.assertEquals((long)expected.length, (long)found.size());
    }

    private ObjectSet getSet(CustomerBalanceSummaryQuery query, Party customer) {
        Map<Reference, ObjectSet> sets = this.getSets(query);
        ObjectSet set = sets.get(customer.getObjectReference());
        Assert.assertNotNull((Object)set);
        return set;
    }

    private Map<Reference, ObjectSet> getSets(CustomerBalanceSummaryQuery query) {
        HashMap<Reference, ObjectSet> result = new HashMap<Reference, ObjectSet>();
        while (query.hasNext()) {
            ObjectSet set = query.next();
            IMObjectReference ref = set.getReference("customer.objectReference");
            if (result.containsKey(ref)) {
                Assert.fail((String)("Duplicate customer " + ref));
            }
            result.put((Reference)ref, set);
        }
        return result;
    }

    private void setName(Party customer, long id) {
        IMObjectBean bean = this.getBean((IMObject)customer);
        bean.setValue("firstName", (Object)"Foo");
        bean.setValue("lastName", (Object)("Bar-" + id));
        bean.save();
    }
}

