/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.account;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.finance.account.AccountType;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.AbstractTestCustomerActBuilder;
import org.openvpms.archetype.test.builder.customer.account.AbstractTestSingleAccountActBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestOtherPaymentItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestOtherRefundItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestRefundBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractCustomerAccountTest
extends ArchetypeServiceTest {
    @Autowired
    protected CustomerAccountRules accountRules;
    @Autowired
    protected TestCustomerAccountFactory accountFactory;
    @Autowired
    protected TestCustomerFactory customerFactory;
    @Autowired
    protected TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    protected TestProductFactory productFactory;
    private Party customer;
    private Party patient;
    private Product product;
    private Party stockLocation;
    private Entity till;

    protected Party getCustomer() {
        if (this.customer == null) {
            this.customer = this.customerFactory.createCustomer();
        }
        return this.customer;
    }

    protected void setCustomer(Party customer) {
        this.customer = customer;
    }

    protected Party getPatient() {
        if (this.patient == null) {
            this.patient = this.patientFactory.createPatient(this.getCustomer());
        }
        return this.patient;
    }

    protected Product getProduct() {
        if (this.product == null) {
            this.product = this.productFactory.createMedication();
        }
        return this.product;
    }

    protected CustomerAccountRules getRules() {
        return this.accountRules;
    }

    protected Entity getTill() {
        if (this.till == null) {
            this.till = this.practiceFactory.createTill();
        }
        return this.till;
    }

    protected Party getStockLocation() {
        if (this.stockLocation == null) {
            this.stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        }
        return this.stockLocation;
    }

    protected List<FinancialAct> createChargesInvoice(BigDecimal amount) {
        return this.createChargesInvoice(amount, this.getCustomer());
    }

    protected List<FinancialAct> createChargesInvoice(BigDecimal amount, Party customer) {
        return this.createChargesInvoice(amount, customer, this.getProduct());
    }

    protected List<FinancialAct> createChargesInvoice(BigDecimal amount, Party customer, Product product) {
        List<FinancialAct> result = FinancialTestHelper.createChargesInvoice(amount, customer, this.getPatient(), product, "POSTED");
        IMObjectBean item = this.getBean((IMObject)result.get(1));
        item.setTarget("stockLocation", (IMObject)this.getStockLocation());
        return result;
    }

    protected List<FinancialAct> createChargesInvoice(BigDecimal amount, Party customer, Date startTime) {
        List<FinancialAct> acts = this.createChargesInvoice(amount, customer);
        acts.get(0).setActivityStartTime(startTime);
        return acts;
    }

    protected List<FinancialAct> createChargesInvoice(BigDecimal amount, Date startTime) {
        List<FinancialAct> acts = this.createChargesInvoice(amount);
        acts.get(0).setActivityStartTime(startTime);
        return acts;
    }

    protected List<FinancialAct> createChargesInvoice(BigDecimal amount, Party customer, Date startTime, String status) {
        List<FinancialAct> acts = FinancialTestHelper.createChargesInvoice(amount, customer, this.getPatient(), this.getProduct(), status);
        acts.get(0).setActivityStartTime(startTime);
        return acts;
    }

    protected List<FinancialAct> createChargesInvoice(BigDecimal amount, Date startTime, String status) {
        return this.createChargesInvoice(amount, this.getCustomer(), startTime, status);
    }

    protected List<FinancialAct> createChargesCounter(BigDecimal amount) {
        List<FinancialAct> result = FinancialTestHelper.createChargesCounter(amount, this.getCustomer(), this.getProduct(), "POSTED");
        IMObjectBean item = this.getBean((IMObject)result.get(1));
        item.setTarget("stockLocation", (IMObject)this.getStockLocation());
        return result;
    }

    protected List<FinancialAct> createChargesCredit(BigDecimal amount) {
        List<FinancialAct> result = FinancialTestHelper.createChargesCredit(amount, this.getCustomer(), this.getPatient(), this.getProduct(), "POSTED");
        IMObjectBean item = this.getBean((IMObject)result.get(1));
        item.setTarget("stockLocation", (IMObject)this.getStockLocation());
        return result;
    }

    protected FinancialAct createPayment(int amount) {
        return this.createPayment(BigDecimal.valueOf(amount), this.getCustomer());
    }

    protected FinancialAct createPayment(BigDecimal amount) {
        return this.createPayment(amount, this.getCustomer());
    }

    protected FinancialAct createPayment(BigDecimal amount, Party customer) {
        return FinancialTestHelper.createPaymentCash(amount, customer, this.getTill());
    }

    protected FinancialAct createPayment(BigDecimal amount, Date startTime) {
        FinancialAct payment = this.createPayment(amount);
        payment.setActivityStartTime(startTime);
        return payment;
    }

    protected FinancialAct createPaymentCash(BigDecimal amount) {
        return FinancialTestHelper.createPaymentCash(amount, this.getCustomer(), this.getTill());
    }

    protected FinancialAct createPaymentCheque(BigDecimal amount) {
        return FinancialTestHelper.createPaymentCheque(amount, this.getCustomer(), this.getTill());
    }

    protected FinancialAct createPaymentCredit(BigDecimal amount) {
        return FinancialTestHelper.createPaymentCredit(amount, this.getCustomer(), this.getTill());
    }

    protected FinancialAct createPaymentDiscount(BigDecimal amount) {
        return FinancialTestHelper.createPaymentDiscount(amount, this.getCustomer(), this.getTill());
    }

    protected FinancialAct createPaymentEFT(BigDecimal amount) {
        return FinancialTestHelper.createPaymentEFT(amount, this.getCustomer(), this.getTill());
    }

    protected FinancialAct createPaymentOther(BigDecimal amount) {
        return this.createPaymentOther(amount, null);
    }

    protected FinancialAct createPaymentOther(BigDecimal amount, String paymentType) {
        FinancialAct item = (FinancialAct)((TestOtherPaymentItemBuilder)this.accountFactory.newOtherPaymentItem().amount(amount)).paymentType(paymentType).build();
        return ((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(this.getCustomer())).till(this.getTill())).add(item)).status("POSTED")).build(false);
    }

    protected FinancialAct createRefund(BigDecimal amount) {
        return FinancialTestHelper.createRefundCash(amount, this.getCustomer(), this.getTill());
    }

    protected FinancialAct createRefundCash(BigDecimal amount) {
        return FinancialTestHelper.createRefundCash(amount, this.getCustomer(), this.getTill());
    }

    protected FinancialAct createRefundCheque(BigDecimal amount) {
        return FinancialTestHelper.createRefundCheque(amount, this.getCustomer(), this.getTill());
    }

    protected FinancialAct createRefundCredit(BigDecimal amount) {
        return FinancialTestHelper.createRefundCredit(amount, this.getCustomer(), this.getTill());
    }

    protected FinancialAct createRefundDiscount(BigDecimal amount) {
        return FinancialTestHelper.createRefundDiscount(amount, this.getCustomer(), this.getTill());
    }

    protected FinancialAct createRefundEFT(BigDecimal amount) {
        return FinancialTestHelper.createRefundEFT(amount, this.getCustomer(), this.getTill());
    }

    protected FinancialAct createRefundOther(BigDecimal amount) {
        return this.createRefundOther(amount, null);
    }

    public FinancialAct createRefundOther(BigDecimal amount, String paymentType) {
        FinancialAct item = (FinancialAct)((TestOtherRefundItemBuilder)this.accountFactory.newOtherRefundItem().amount(amount)).paymentType(paymentType).build();
        return ((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)((TestRefundBuilder)this.accountFactory.newRefund().customer(this.getCustomer())).till(this.getTill())).add(item)).status("POSTED")).build(false);
    }

    protected FinancialAct createCreditAdjust(BigDecimal amount) {
        return this.createSingleAccountAct(this.accountFactory.newCreditAdjust(), amount);
    }

    protected FinancialAct createDebitAdjust(BigDecimal amount) {
        return this.createSingleAccountAct(this.accountFactory.newDebitAdjust(), amount);
    }

    protected FinancialAct createInitialBalance(BigDecimal amount) {
        return this.createSingleAccountAct(this.accountFactory.newInitialBalance(), amount);
    }

    protected FinancialAct createBadDebt(BigDecimal amount) {
        return this.createSingleAccountAct(this.accountFactory.newBadDebt(), amount);
    }

    protected FinancialAct createSingleAccountAct(AbstractTestSingleAccountActBuilder<?> builder, BigDecimal amount) {
        return (FinancialAct)((AbstractTestSingleAccountActBuilder)((AbstractTestSingleAccountActBuilder)((AbstractTestCustomerActBuilder)builder.amount(amount)).customer(this.getCustomer())).status("POSTED")).build(false);
    }

    protected Lookup createAccountType(int paymentTerms, DateUnits paymentUom) {
        return this.createAccountType(paymentTerms, paymentUom, BigDecimal.ZERO);
    }

    protected Lookup createAccountType(int paymentTerms, DateUnits paymentUom, BigDecimal accountFeeAmount) {
        return (Lookup)this.customerFactory.newAccountType().paymentTerms(paymentTerms, paymentUom).accountFee(accountFeeAmount, AccountType.FeeType.FIXED).build();
    }
}

