/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.TemplateHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.beans.factory.annotation.Autowired;

public class TemplateHelperTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestLookupFactory lookupFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    private TemplateHelper helper;

    @Before
    public void setUp() {
        this.helper = new TemplateHelper((ArchetypeService)this.getArchetypeService());
    }

    @Test
    public void testGetDocument() {
        String filename = UUID.randomUUID() + ".jrxml";
        Assert.assertNull((Object)this.helper.getDocument(filename));
        Document document1 = this.documentFactory.createJRXML(filename);
        Assert.assertNull((Object)this.helper.getDocument(filename));
        Entity template1 = (Entity)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().name("A")).type("act.patientDocumentForm").document(document1)).active(true)).build();
        Assert.assertEquals((Object)document1, (Object)this.helper.getDocument(filename));
        Document document2 = this.documentFactory.createJRXML(filename);
        Entity template2 = (Entity)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().name("B")).type("act.patientDocumentForm").document(document2)).active(true)).build();
        Assert.assertEquals((Object)document1, (Object)this.helper.getDocument(filename));
        template1.setActive(false);
        this.save((IMObject)template1);
        Assert.assertEquals((Object)document2, (Object)this.helper.getDocument(filename));
        template2.setActive(false);
        this.save((IMObject)template2);
        Assert.assertNull((Object)this.helper.getDocument(filename));
    }

    @Test
    public void testGetDocumentAct() {
        String filename = UUID.randomUUID() + ".jrxml";
        Assert.assertNull((Object)this.helper.getDocumentAct(filename));
        Document document1 = this.documentFactory.createJRXML(filename);
        Assert.assertNull((Object)this.helper.getDocumentAct(filename));
        Entity template1 = (Entity)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().name("A")).type("act.patientDocumentForm").document(document1)).active(true)).build();
        DocumentAct act1 = this.helper.getDocumentAct(template1);
        Assert.assertNotNull((Object)act1);
        Assert.assertEquals((Object)document1.getObjectReference(), (Object)act1.getDocument());
        Document document2 = this.documentFactory.createJRXML(filename);
        Entity template2 = (Entity)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().name("B")).type("act.patientDocumentForm").document(document2)).active(true)).build();
        DocumentAct act2 = this.helper.getDocumentAct(template2);
        Assert.assertNotNull((Object)act2);
        Assert.assertEquals((Object)document2.getObjectReference(), (Object)act2.getDocument());
        Assert.assertEquals((Object)act1, (Object)this.helper.getDocumentAct(filename));
        template1.setActive(false);
        this.save((IMObject)template1);
        Assert.assertEquals((Object)act2, (Object)this.helper.getDocumentAct(filename));
        template2.setActive(false);
        this.save((IMObject)template2);
        Assert.assertNull((Object)this.helper.getDocumentAct(filename));
    }

    @Test
    public void testGetTemplateForType() {
        String type = ((Lookup)((TestLookupBuilder)this.lookupFactory.newLookup("lookup.documentTemplateType").uniqueCode()).build()).getCode();
        Assert.assertNull((Object)this.helper.getTemplateForType(type));
        Entity template1 = (Entity)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().name("A")).type(type).blankDocument()).active(true)).build();
        Assert.assertEquals((Object)template1, (Object)this.helper.getTemplateForType(type));
        Entity template2 = (Entity)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().name("B")).type(type).blankDocument()).active(true)).build();
        Assert.assertEquals((Object)template1, (Object)this.helper.getTemplateForType(type));
        template1.setActive(false);
        this.save((IMObject)template1);
        Assert.assertEquals((Object)template2, (Object)this.helper.getTemplateForType(type));
        template2.setActive(false);
        this.save((IMObject)template2);
        Assert.assertNull((Object)this.helper.getTemplateForType(type));
    }

    @Test
    public void testGetOrganisationTemplateForType() {
        Party location = this.practiceFactory.createLocation();
        String typeA = ((Lookup)((TestLookupBuilder)this.lookupFactory.newLookup("lookup.documentTemplateType").uniqueCode()).build()).getCode();
        String typeB = ((Lookup)((TestLookupBuilder)this.lookupFactory.newLookup("lookup.documentTemplateType").uniqueCode()).build()).getCode();
        Assert.assertNull((Object)this.helper.getTemplateForType(typeA, location));
        Assert.assertNull((Object)this.helper.getTemplateForType(typeB, location));
        Entity template1 = (Entity)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().name("template1")).type(typeA).blankDocument()).active(true)).build();
        Assert.assertNull((Object)this.helper.getTemplateForType(typeA, location));
        this.documentFactory.updateTemplate(template1).printer().printer("printer1").location(location).add().build();
        Assert.assertEquals((Object)template1, (Object)this.helper.getTemplateForType(typeA, location));
        Entity template2 = (Entity)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().name("template2")).type(typeB).blankDocument()).active(true)).printer().printer("printer1").location(location).add().build();
        Assert.assertEquals((Object)template2, (Object)this.helper.getTemplateForType(typeB, location));
        Entity template3 = (Entity)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().name("template3")).type(typeA).blankDocument()).active(true)).printer().printer("printer2").location(location).add().build();
        Assert.assertEquals((Object)template1, (Object)this.helper.getTemplateForType(typeA, location));
        template1.setActive(false);
        this.save((IMObject)template1);
        Assert.assertEquals((Object)template3, (Object)this.helper.getTemplateForType(typeA, location));
        template3.setActive(false);
        this.save((IMObject)template3);
        Assert.assertNull((Object)this.helper.getTemplateForType(typeA, location));
    }
}

