/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.PrinterReference;
import org.openvpms.archetype.test.ArchetypeServiceTest;

public class PrinterReferenceTestCase
extends ArchetypeServiceTest {
    @Test
    public void testToString() {
        Assert.assertEquals((Object)"::printer:", (Object)new PrinterReference(null, "printer").toString());
        Assert.assertEquals((Object)"entity.printerService1::printer:", (Object)new PrinterReference("entity.printerService1", "printer").toString());
        Assert.assertEquals((Object)"entity.printerService1:PrinterService:printer:", (Object)new PrinterReference("entity.printerService1", "PrinterService", "printer", null).toString());
        Assert.assertEquals((Object)"entity.printerService1:PrinterService:printer:Printer", (Object)new PrinterReference("entity.printerService1", "PrinterService", "printer", "Printer").toString());
        Assert.assertEquals((Object)"entity.printerService1:PrinterService\\:1:printer\\:a:Printer\\:A", (Object)new PrinterReference("entity.printerService1", "PrinterService:1", "printer:a", "Printer:A").toString());
    }

    @Test
    public void testFromString() {
        Assert.assertNull((Object)PrinterReference.fromString(null));
        Assert.assertNull((Object)PrinterReference.fromString((String)""));
        Assert.assertNull((Object)PrinterReference.fromString((String)":"));
        Assert.assertNull((Object)PrinterReference.fromString((String)"::"));
        Assert.assertNull((Object)PrinterReference.fromString((String)":::"));
        this.checkFromString("printer", null, null, "printer", "printer");
        this.checkFromString(":printer", null, null, "printer", "printer");
        this.checkFromString("entity.printerService1:printer", "entity.printerService1", null, "printer", "printer");
        this.checkFromString("entity.printerService1:PrinterService:printer", "entity.printerService1", "PrinterService", "printer", "printer");
        this.checkFromString("entity.printerService1:PrinterService:printer:", "entity.printerService1", "PrinterService", "printer", "printer");
        this.checkFromString("entity.printerService1:PrinterService:printer:PrinterA", "entity.printerService1", "PrinterService", "printer", "PrinterA");
        this.checkFromString("entity.printerService1::printer:PrinterA", "entity.printerService1", null, "printer", "PrinterA");
        this.checkFromString("entity.printerService1:PrinterService:printer\\:B:Printer\\:B", "entity.printerService1", "PrinterService", "printer:B", "Printer:B");
    }

    @Test
    public void testFromToString() {
        this.checkFromToString("printer", null, null, "printer", "printer", "::printer:");
        this.checkFromToString(":printer", null, null, "printer", "printer", "::printer:");
        this.checkFromToString("entity.printerService1:PrinterService:printer", "entity.printerService1", "PrinterService", "printer", "printer", "entity.printerService1:PrinterService:printer:");
        this.checkFromToString("entity.printerService1:PrinterService:printer\\:B:Printer\\:B", "entity.printerService1", "PrinterService", "printer:B", "Printer:B", "entity.printerService1:PrinterService:printer\\:B:Printer\\:B");
    }

    private PrinterReference checkFromString(String value, String archetype, String serviceName, String id, String name) {
        PrinterReference reference = PrinterReference.fromString((String)value);
        Assert.assertNotNull((Object)reference);
        Assert.assertEquals((Object)archetype, (Object)reference.getArchetype());
        Assert.assertEquals((Object)serviceName, (Object)reference.getServiceName());
        Assert.assertEquals((Object)id, (Object)reference.getId());
        Assert.assertEquals((Object)name, (Object)reference.getName());
        return reference;
    }

    private void checkFromToString(String value, String archetype, String serviceName, String id, String name, String toString) {
        PrinterReference reference1 = this.checkFromString(value, archetype, serviceName, id, name);
        Assert.assertEquals((Object)toString, (Object)reference1.toString());
        PrinterReference reference2 = PrinterReference.fromString((String)reference1.toString());
        Assert.assertEquals((Object)reference1, (Object)reference2);
    }
}

