/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.DefaultDocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentException;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

public class DefaultDocumentHandlerTestCase
extends ArchetypeServiceTest {
    @Test
    public void testCanHandle() {
        DefaultDocumentHandler handler = new DefaultDocumentHandler((ArchetypeService)this.getArchetypeService());
        Assert.assertTrue((boolean)handler.canHandle("foo.pdf", "application/pdf"));
        Assert.assertTrue((boolean)handler.canHandle("foo.jpg", "image/jpg"));
        Assert.assertTrue((boolean)handler.canHandle("foo.txt", "text/plain"));
    }

    @Test
    public void testSerialisation() throws Exception {
        DefaultDocumentHandler handler = new DefaultDocumentHandler((ArchetypeService)this.getArchetypeService());
        String name = "foo.txt";
        String content = "some text with unicode \u2202";
        String mimeType = "text/plain";
        Document document = handler.create(name, IOUtils.toInputStream((String)content, (Charset)StandardCharsets.UTF_8), mimeType, -1);
        Assert.assertEquals((Object)name, (Object)document.getName());
        Assert.assertEquals((Object)mimeType, (Object)document.getMimeType());
        Assert.assertEquals((long)content.getBytes(StandardCharsets.UTF_8).length, (long)document.getSize());
        Assert.assertEquals((long)40666662L, (long)document.getChecksum());
        this.save((IMObject)document);
        document = this.get(document);
        Assert.assertTrue((boolean)handler.canHandle((org.openvpms.component.model.document.Document)document));
        String read1 = this.toString(handler, document);
        Assert.assertEquals((Object)content, (Object)read1);
        String newContent = "some new text with unicode \u2202";
        handler.update(document, IOUtils.toInputStream((String)newContent, (Charset)StandardCharsets.UTF_8), mimeType, -1);
        Assert.assertEquals((Object)name, (Object)document.getName());
        Assert.assertEquals((Object)mimeType, (Object)document.getMimeType());
        Assert.assertEquals((long)newContent.getBytes(StandardCharsets.UTF_8).length, (long)document.getSize());
        Assert.assertEquals((long)3675053849L, (long)document.getChecksum());
        String read2 = this.toString(handler, document);
        Assert.assertEquals((Object)newContent, (Object)read2);
    }

    @Test
    public void testCreateWithIncorrectSize() {
        DefaultDocumentHandler handler = new DefaultDocumentHandler((ArchetypeService)this.getArchetypeService());
        String name = "foo.html";
        String content = "<html><body>some text</body></html>";
        String mimeType = "text/html";
        try {
            handler.create(name, IOUtils.toInputStream((String)content, (Charset)StandardCharsets.UTF_8), mimeType, content.length() - 1);
            Assert.fail((String)"Expected DocumentException to be thrown");
        }
        catch (DocumentException expected) {
            Assert.assertEquals((Object)"Failed to read foo.html", (Object)expected.getMessage());
        }
        try {
            handler.create(name, IOUtils.toInputStream((String)content, (Charset)StandardCharsets.UTF_8), mimeType, content.length() + 1);
            Assert.fail((String)"Expected DocumentException to be thrown");
        }
        catch (DocumentException expected) {
            Assert.assertEquals((Object)"Failed to read foo.html", (Object)expected.getMessage());
        }
    }

    private String toString(DefaultDocumentHandler handler, Document document) throws IOException {
        InputStream inputStream = handler.getContent((org.openvpms.component.model.document.Document)document);
        String read = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        inputStream.close();
        return read;
    }
}

