/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.i18n.time;

import java.util.Arrays;
import java.util.UUID;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.helper.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.lookup.LookupRelationship;
import org.openvpms.component.model.object.IMObject;

public class DurationFormatterTestHelper {
    public static Lookup addFormat(Lookup lookup, int interval, DateUnits units, boolean showYears, boolean showMonths, boolean showWeeks, boolean showDays) {
        Lookup format = DurationFormatterTestHelper.createDurationFormat(interval, units, showYears, showMonths, showWeeks, showDays);
        LookupRelationship rel = (LookupRelationship)TestHelper.create("lookupRelationship.durationformats");
        rel.setSource(lookup.getObjectReference());
        rel.setTarget(format.getObjectReference());
        lookup.addLookupRelationship(rel);
        format.addLookupRelationship(rel);
        TestHelper.save(Arrays.asList(lookup, format));
        return format;
    }

    public static Lookup createDurationFormats() {
        String code = "XTESTDURATIONFORMATS_" + UUID.randomUUID().toString().toUpperCase().replace("-", "_");
        return TestHelper.getLookup("lookup.durationformats", code);
    }

    public static Lookup createDurationFormat(int interval, DateUnits units, boolean showYears, boolean showMonths, boolean showWeeks, boolean showDays) {
        String code = "XTESTDURATIONFORMAT-" + UUID.randomUUID();
        Lookup format = (Lookup)TestHelper.create("lookup.durationformat");
        IMObjectBean bean = new IMObjectBean((IMObject)format);
        bean.setValue("code", (Object)code);
        bean.setValue("interval", (Object)interval);
        bean.setValue("units", (Object)units.toString());
        bean.setValue("showYears", (Object)showYears);
        bean.setValue("showMonths", (Object)showMonths);
        bean.setValue("showWeeks", (Object)showWeeks);
        bean.setValue("showDays", (Object)showDays);
        return format;
    }
}

