/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.i18n;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.i18n.ArchetypeMessages;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.i18n.Message;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;

public class ArchetypeMessagesTestCase
extends ArchetypeServiceTest {
    @Test
    public void testCoverage() {
        for (Method method : ArchetypeMessages.class.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers())) continue;
            String test = "test" + StringUtils.capitalize((String)method.getName());
            try {
                ArchetypeMessagesTestCase.class.getDeclaredMethod(test, new Class[0]);
            }
            catch (NoSuchMethodException exception) {
                Assert.fail((String)("Test needs to be expanded to include " + method.getName()));
            }
        }
    }

    @Test
    public void testPriceCreatedByDelivery() {
        Party supplier = this.create("party.supplierorganisation", Party.class);
        supplier.setName("Cenvet");
        Act delivery = this.create("act.supplierDelivery", Act.class);
        TestHelper.setId((IMObject)delivery, 1005L);
        delivery.setActivityStartTime(TestHelper.getDate("2020-02-17"));
        this.check("ARCH-1501: Price created by delivery 1005 from supplier Cenvet on 17/02/2020", ArchetypeMessages.priceCreatedByDelivery((Act)delivery, (Party)supplier));
    }

    @Test
    public void testPasswordCannotContainWhitespace() {
        Assert.assertEquals((Object)"Password cannot contain whitespace", (Object)ArchetypeMessages.passwordCannotContainWhitespace());
    }

    @Test
    public void testPasswordLessThanMinimumLength() {
        Assert.assertEquals((Object)"Password must have at least 8 characters", (Object)ArchetypeMessages.passwordLessThanMinimumLength((int)8));
    }

    @Test
    public void testPasswordGreaterThanMaximumLength() {
        Assert.assertEquals((Object)"Password must not be longer than 10 characters", (Object)ArchetypeMessages.passwordGreaterThanMaximumLength((int)10));
    }

    @Test
    public void testPasswordMustContainLowercaseCharacter() {
        Assert.assertEquals((Object)"Password must have at least one lowercase character", (Object)ArchetypeMessages.passwordMustContainLowercaseCharacter());
    }

    @Test
    public void testPasswordMustContainUppercaseCharacter() {
        Assert.assertEquals((Object)"Password must have at least one uppercase character", (Object)ArchetypeMessages.passwordMustContainUppercaseCharacter());
    }

    @Test
    public void testPasswordMustContainNumber() {
        Assert.assertEquals((Object)"Password must have at least one number", (Object)ArchetypeMessages.passwordMustContainNumber());
    }

    @Test
    public void testPasswordMustContainSpecialCharacter() {
        Assert.assertEquals((Object)"Password must have at least one special character", (Object)ArchetypeMessages.passwordMustContainSpecialCharacter());
    }

    @Test
    public void testPasswordCharacterInvalid() {
        Assert.assertEquals((Object)"' ' is not a valid password character", (Object)ArchetypeMessages.passwordCharacterInvalid((char)' '));
    }

    @Test
    public void testPasswordCharacterInvalidSuffix() {
        Assert.assertEquals((Object)"is not a valid password character", (Object)ArchetypeMessages.passwordCharacterInvalidSuffix());
    }

    @Test
    public void testNewPasswordMustBeDifferentToOldPassword() {
        Assert.assertEquals((Object)"Password must be different to the old password", (Object)ArchetypeMessages.newPasswordMustBeDifferentToOldPassword());
    }

    private void check(String expected, Message actual) {
        Assert.assertEquals((Object)expected, (Object)actual.toString());
    }
}

