/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.supplier;

import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.function.supplier.SupplierFunctions;
import org.openvpms.archetype.rules.supplier.SupplierRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.ArchetypeServiceFunctions;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.openvpms.component.system.common.jxpath.ObjectFunctions;

public class SupplierFunctionsTestCase
extends ArchetypeServiceTest {
    @Test
    public void testAccountId() {
        Party location = TestHelper.createLocation();
        Party supplier = TestHelper.createSupplier();
        JXPathContext ctx = this.createContext((IMObject)supplier);
        ctx.getVariables().declareVariable("OpenVPMS.location", (Object)location);
        Assert.assertNull((Object)ctx.getValue("supplier:accountId(" + supplier.getId() + ", $OpenVPMS.location)"));
        Assert.assertNull((Object)ctx.getValue("supplier:accountId(., $OpenVPMS.location)"));
        Assert.assertNull((Object)ctx.getValue("supplier:accountId(-1, $OpenVPMS.location)"));
        IMObjectBean supplierBean = this.getBean((IMObject)supplier);
        Relationship relationship = supplierBean.addTarget("locations", (IMObject)location);
        IMObjectBean bean = this.getBean((IMObject)relationship);
        String expected = "1234567";
        bean.setValue("accountId", (Object)expected);
        supplierBean.save();
        Assert.assertEquals((Object)expected, (Object)ctx.getValue("supplier:accountId(" + supplier.getId() + ", $OpenVPMS.location)"));
        Assert.assertEquals((Object)expected, (Object)ctx.getValue("supplier:accountId(., $OpenVPMS.location)"));
    }

    private JXPathContext createContext(IMObject object) {
        IArchetypeService service = this.getArchetypeService();
        LookupService lookups = this.getLookupService();
        ArchetypeServiceFunctions functions = new ArchetypeServiceFunctions(service, lookups);
        SupplierFunctions supplierFunctions = new SupplierFunctions(new SupplierRules(service));
        FunctionLibrary library = new FunctionLibrary();
        library.addFunctions((Functions)new ObjectFunctions((Object)functions, "openvpms"));
        library.addFunctions((Functions)new ObjectFunctions((Object)supplierFunctions, "supplier"));
        return JXPathHelper.newContext((Object)object, (Functions)library);
    }
}

