/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.product;

import java.math.BigDecimal;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.function.product.ProductFunctions;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class ProductFunctionsTestCase
extends ArchetypeServiceTest {
    private PracticeService practiceService;
    @Autowired
    private PracticeRules practiceRules;
    private ProductFunctions functions;
    private ThreadPoolTaskExecutor executor;

    @Before
    public void setUp() {
        Party practice = TestHelper.getPractice(BigDecimal.TEN);
        IMObjectBean bean = this.getBean((IMObject)practice);
        bean.setValue("showPricesTaxInclusive", (Object)true);
        bean.save();
        ProductPriceRules rules = new ProductPriceRules((ArchetypeService)this.getArchetypeService());
        this.executor = new ThreadPoolTaskExecutor();
        this.executor.setThreadGroupName("PracticeService");
        this.executor.setCorePoolSize(1);
        this.executor.setMaxPoolSize(1);
        this.executor.afterPropertiesSet();
        this.practiceService = new PracticeService(this.getArchetypeService(), this.practiceRules, this.executor);
        this.functions = new ProductFunctions(rules, this.practiceService, this.getArchetypeService());
    }

    @After
    public void tearDown() {
        this.practiceService.destroy();
        this.executor.destroy();
    }

    @Test
    public void testPrice() {
        Product product = TestHelper.createProduct();
        BigDecimal eleven = new BigDecimal("11");
        this.checkValue(eleven, new Object(), "product:price(" + product.getId() + ", 10)");
        this.checkValue(BigDecimal.TEN, new Object(), "product:price(" + product.getId() + ", 10, false())");
        this.checkValue(eleven, new Object(), "product:price(" + product.getId() + ", 10, true())");
        this.checkValue(eleven, product, "product:price(., 10)");
        this.checkValue(BigDecimal.TEN, product, "product:price(., 10, false())");
        this.checkValue(eleven, product, "product:price(., 10, true())");
    }

    @Test
    public void testRound() {
        this.checkValue(new BigDecimal("10.25"), new Object(), "product:round(10.253)");
        this.checkValue(new BigDecimal("10.25"), new Object(), "product:round(10.245)");
    }

    @Test
    public void testTaxRate() {
        Product product = TestHelper.createProduct();
        this.checkValue(BigDecimal.TEN, new Object(), "product:taxRate(" + product.getId() + ")");
        this.checkValue(BigDecimal.TEN, product, "product:taxRate(.)");
    }

    private void checkValue(BigDecimal expected, Object context, String expression) {
        JXPathContext ctx = JXPathHelper.newContext((Object)context, (Functions)this.functions);
        BigDecimal price = (BigDecimal)ctx.getValue(expression);
        this.checkEquals(expected, price);
    }
}

