/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.list;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.function.expression.ExpressionFunctions;
import org.openvpms.archetype.function.list.ListFunctions;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.util.PropertySet;

public class ListFunctionsTestCase
extends ArchetypeServiceTest {
    private JXPathContext ctx;
    private Party pet1;
    private Party pet2;
    private Party pet3;

    @Before
    public void setUp() {
        this.pet1 = this.createPet("C", "Canine");
        this.pet2 = this.createPet("A", "Feline");
        this.pet3 = this.createPet("B", "Bovine");
        List<Party> objects = Arrays.asList(this.pet1, this.pet2, this.pet3);
        this.ctx = this.createContext(objects);
    }

    @Test
    public void testFirst() {
        Assert.assertEquals((Object)this.pet1, (Object)this.ctx.getValue("list:first(.)"));
        Assert.assertEquals((Object)"C", (Object)this.ctx.getValue("list:first(., 'name')"));
    }

    @Test
    public void testNames() {
        Assert.assertEquals((Object)"C, A, B", (Object)this.ctx.getValue("list:names(.)"));
        Assert.assertEquals((Object)"C;A;B", (Object)this.ctx.getValue("list:names(., ';')"));
        Assert.assertEquals((Object)"C, A & B", (Object)this.ctx.getValue("list:names(., ', ', ' & ')"));
        Assert.assertEquals((Object)"C, A and B are", (Object)this.ctx.getValue("list:names(., ', ', ' and ', ' is', ' are')"));
        Assert.assertEquals((Object)"C is", (Object)this.ctx.getValue("list:names(list:first(.), ', ', ' and ', ' is', ' are')"));
    }

    @Test
    public void testSortNamesOf() {
        Party vet = this.create("party.supplierVeterinarian", Party.class);
        vet.addClassification(this.createVetSpecialty("Surgery"));
        vet.addClassification(this.createVetSpecialty("Large Animals"));
        vet.addClassification(this.createVetSpecialty("Snakes"));
        JXPathContext ctx = this.createContext(vet);
        Assert.assertEquals((Object)"Large Animals, Snakes, Surgery", (Object)ctx.getValue("list:sortNamesOf('classifications')"));
        Assert.assertEquals((Object)"Large Animals, Snakes, Surgery", (Object)ctx.getValue("list:sortNamesOf(., 'classifications')"));
        Assert.assertEquals((Object)"(Large Animals, Snakes, Surgery)", (Object)ctx.getValue("expr:concatIf('(', list:sortNamesOf(., 'classifications'), ')')"));
        Assert.assertEquals((Object)"Large Animals, Snakes, Surgery classifications", (Object)ctx.getValue("list:sortNamesOf(., 'classifications', ', ',', ',' classification',' classifications')"));
    }

    @Test
    public void testSortNames() {
        Assert.assertEquals((Object)"A, B, C", (Object)this.ctx.getValue("list:sortNames(.)"));
        Assert.assertEquals((Object)"A;B;C", (Object)this.ctx.getValue("list:sortNames(., ';')"));
        Assert.assertEquals((Object)"A,B&C are", (Object)this.ctx.getValue("list:sortNames(., ',','&',' is', ' are')"));
        Assert.assertEquals((Object)"C is", (Object)this.ctx.getValue("list:sortNames(list:first(.), ',','&',' is', ' are')"));
    }

    @Test
    public void testJoin() {
        Assert.assertEquals((Object)"CANINE, FELINE, BOVINE", (Object)this.ctx.getValue("list:join(.,'species')"));
        Assert.assertEquals((Object)"CANINE;FELINE;BOVINE", (Object)this.ctx.getValue("list:join(.,'species',';')"));
        Assert.assertEquals((Object)"Canine, Feline and Bovine", (Object)this.ctx.getValue("list:join(.,'species.name',', ',' and ')"));
        Assert.assertEquals((Object)"CANINE, FELINE and BOVINE are", (Object)this.ctx.getValue("list:join(.,'species',', ',' and ',' is',' are')"));
        Assert.assertEquals((Object)"CANINE is", (Object)this.ctx.getValue("list:join(list:first(.),'species',', ',' and ',' is',' are')"));
    }

    @Test
    public void testJoinPropertySet() {
        List<PropertySet> objects = this.createPetSets(this.pet1, this.pet2, this.pet3);
        JXPathContext context = this.createContext(objects);
        Assert.assertEquals((Object)"CANINE, FELINE, BOVINE", (Object)context.getValue("list:join(.,'pet.species')"));
        Assert.assertEquals((Object)"CANINE;FELINE;BOVINE", (Object)context.getValue("list:join(.,'pet.species',';')"));
        Assert.assertEquals((Object)"Canine, Feline and Bovine", (Object)context.getValue("list:join(.,'pet.species.name',', ',' and ')"));
    }

    @Test
    public void testValues() {
        Party customer = TestHelper.createCustomer();
        Party patient1 = TestHelper.createPatient(customer);
        Party patient2 = TestHelper.createPatient(customer);
        Party patient3 = TestHelper.createPatient(customer);
        JXPathContext context = this.createContext(customer);
        List values1 = (List)context.getValue("list:values(., 'patients.target')");
        this.checkValues(values1, patient1, patient2, patient3);
        List values2 = (List)context.getValue("list:values('patients.target')");
        this.checkValues(values2, patient1, patient2, patient3);
        List values3 = (List)context.getValue("list:values(., 'patients.target.id')");
        this.checkValues(values3, patient1.getId(), patient2.getId(), patient3.getId());
        List values4 = (List)context.getValue("list:values('patients.target.id')");
        this.checkValues(values4, patient1.getId(), patient2.getId(), patient3.getId());
    }

    @Test
    public void testValuesCollection() {
        this.pet1.addIdentity(PatientTestHelper.createMicrochip("M1"));
        this.pet1.addIdentity(PatientTestHelper.createPetTag("T1"));
        this.pet2.addIdentity(PatientTestHelper.createMicrochip("M2"));
        this.pet2.addIdentity(PatientTestHelper.createPetTag("T2"));
        this.pet2.addIdentity(PatientTestHelper.createMicrochip("M3"));
        this.pet2.addIdentity(PatientTestHelper.createPetTag("T3"));
        List<Party> pets = Arrays.asList(this.pet1, this.pet2, this.pet3);
        JXPathContext context1 = this.createContext(pets);
        List values1 = (List)context1.getValue("list:values(., 'id')");
        this.checkValues(values1, this.pet1.getId(), this.pet2.getId(), this.pet3.getId());
        List values2 = (List)context1.getValue("list:values('id')");
        this.checkValues(values2, this.pet1.getId(), this.pet2.getId(), this.pet3.getId());
        List values3 = (List)context1.getValue("list:values('identities.name')");
        this.checkValues(values3, "M1", "T1", "M2", "T2", "M3", "T3");
        List<PropertySet> sets = this.createPetSets(this.pet1, this.pet2, this.pet3);
        JXPathContext context2 = this.createContext(sets);
        List values4 = (List)context2.getValue("list:values(., 'pet.id')");
        this.checkValues(values4, this.pet1.getId(), this.pet2.getId(), this.pet3.getId());
        List values5 = (List)context2.getValue("list:values('pet.id')");
        this.checkValues(values5, this.pet1.getId(), this.pet2.getId(), this.pet3.getId());
        List values6 = (List)context2.getValue("list:values('pet.identities.name')");
        this.checkValues(values6, "M1", "T1", "M2", "T2", "M3", "T3");
    }

    @Test
    public void testDistinctSet() {
        Product product = TestHelper.createProduct();
        Party customer = TestHelper.createCustomer();
        Party patient1 = TestHelper.createPatient();
        Party patient2 = TestHelper.createPatient();
        patient1.setName("Fido");
        patient2.setName("Spot");
        this.save((IMObject[])new Party[]{patient1, patient2});
        List<FinancialAct> acts = FinancialTestHelper.createChargesInvoice(BigDecimal.TEN, customer, patient1, product, "IN_PROGRESS");
        FinancialAct invoice = acts.get(0);
        FinancialAct act1 = acts.get(1);
        FinancialAct act2 = FinancialTestHelper.createChargeItem("act.customerAccountInvoiceItem", patient2, product, BigDecimal.ONE);
        FinancialAct act3 = FinancialTestHelper.createChargeItem("act.customerAccountInvoiceItem", patient2, product, BigDecimal.ONE);
        IMObjectBean bean = this.getBean((IMObject)invoice);
        bean.addTarget("items", (IMObject)act2, "invoice");
        bean.addTarget("items", (IMObject)act3, "invoice");
        this.save((IMObject[])new FinancialAct[]{invoice, act1, act2, act3});
        JXPathContext context = this.createContext(invoice);
        List list1 = (List)context.getValue("list:distinct(., 'items.target.patient.entity')");
        this.checkValues(list1, patient1, patient2);
        Set set1 = (Set)context.getValue("list:set(., 'items.target.patient.entity')");
        this.checkValues(set1, patient1, patient2);
        List values2 = (List)context.getValue("list:distinct('items.target.patient.entity')");
        this.checkValues(values2, patient1, patient2);
        Set set2 = (Set)context.getValue("list:set('items.target.patient.entity')");
        this.checkValues(set2, patient1, patient2);
        Number count1 = (Number)context.getValue("count(list:distinct(., 'items.target.patient.entity'))");
        Assert.assertEquals((long)2L, (long)count1.intValue());
        Number count2 = (Number)context.getValue("count(list:set(., 'items.target.patient.entity'))");
        Assert.assertEquals((long)2L, (long)count2.intValue());
        List values3 = (List)context.getValue("list:distinct(., 'items.target.product.entity.id')");
        this.checkValues(values3, product.getId());
        String names1 = (String)context.getValue("list:sortNames(list:distinct('items.target.patient.entity'))");
        Assert.assertEquals((Object)"Fido, Spot", (Object)names1);
        String names2 = (String)context.getValue("list:sortNames(list:set('items.target.patient.entity'))");
        Assert.assertEquals((Object)"Fido, Spot", (Object)names2);
    }

    @SafeVarargs
    private final <T> void checkValues(Collection<T> collection, T ... values) {
        Assert.assertEquals((long)values.length, (long)collection.size());
        for (T value : values) {
            Assert.assertTrue((boolean)collection.contains(value));
        }
    }

    private Party createPet(String name, String species) {
        Party pet = TestHelper.createPatient(false);
        pet.setName(name);
        IMObjectBean bean = this.getBean((IMObject)pet);
        Lookup lookup = TestHelper.getLookup("lookup.species", species.toUpperCase(), species, true);
        bean.setValue("species", (Object)lookup.getCode());
        return pet;
    }

    private Lookup createVetSpecialty(String name) {
        Lookup lookup = this.create("lookup.veterinarySpeciality", Lookup.class);
        lookup.setCode(name);
        lookup.setName(name);
        return lookup;
    }

    private JXPathContext createContext(Object object) {
        FunctionLibrary library = new FunctionLibrary();
        library.addFunctions((Functions)new ListFunctions(this.getArchetypeService(), this.getLookupService()));
        library.addFunctions((Functions)new ExpressionFunctions("expr"));
        return JXPathHelper.newContext((Object)object, (Functions)library);
    }

    private List<PropertySet> createPetSets(Party ... pets) {
        ArrayList<PropertySet> result = new ArrayList<PropertySet>();
        for (Party pet : pets) {
            ObjectSet set = new ObjectSet();
            set.set("pet", (Object)pet);
            result.add((PropertySet)set);
        }
        return result;
    }
}

