/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.investigation;

import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.function.laboratory.InvestigationFunctions;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryFactory;
import org.openvpms.archetype.test.builder.patient.TestInvestigationBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.openvpms.component.system.common.jxpath.ObjectFunctions;
import org.springframework.beans.factory.annotation.Autowired;

public class InvestigationFunctionsTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestLaboratoryFactory laboratoryFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;

    @Test
    public void testAccountId() {
        Party patient = this.patientFactory.createPatient();
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        Entity investigationTypeA = (Entity)this.laboratoryFactory.newInvestigationType().accountId("X", location1).accountId("Y", location2).build();
        Entity investigationTypeB = this.laboratoryFactory.createInvestigationType();
        DocumentAct investigation1 = (DocumentAct)((TestInvestigationBuilder)this.patientFactory.newInvestigation().patient(patient)).investigationType(investigationTypeA).build();
        DocumentAct investigation2 = (DocumentAct)((TestInvestigationBuilder)((TestInvestigationBuilder)this.patientFactory.newInvestigation().patient(patient)).investigationType(investigationTypeA).location(location1)).build();
        DocumentAct investigation3 = (DocumentAct)((TestInvestigationBuilder)((TestInvestigationBuilder)this.patientFactory.newInvestigation().patient(patient)).investigationType(investigationTypeA).location(location2)).build();
        DocumentAct investigation4 = (DocumentAct)((TestInvestigationBuilder)((TestInvestigationBuilder)this.patientFactory.newInvestigation().patient(patient)).investigationType(investigationTypeB).location(location1)).build();
        JXPathContext context1 = this.createContext(investigation1);
        Assert.assertNull((Object)context1.getValue("investigation:accountId()"));
        Assert.assertNull((Object)context1.getValue("investigation:accountId(.)"));
        JXPathContext context2 = this.createContext(investigation2);
        Assert.assertEquals((Object)"X", (Object)context2.getValue("investigation:accountId()"));
        Assert.assertEquals((Object)"X", (Object)context2.getValue("investigation:accountId(.)"));
        JXPathContext context3 = this.createContext(investigation3);
        Assert.assertEquals((Object)"Y", (Object)context3.getValue("investigation:accountId()"));
        Assert.assertEquals((Object)"Y", (Object)context3.getValue("investigation:accountId(.)"));
        JXPathContext context4 = this.createContext(investigation4);
        Assert.assertNull((Object)context4.getValue("investigation:accountId()"));
        Assert.assertNull((Object)context4.getValue("investigation:accountId(.)"));
        JXPathContext context5 = this.createContext(investigation4);
        Assert.assertNull((Object)context5.getValue("investigation:accountId(null)"));
    }

    @Test
    public void testAccountIdForInvestigationTypeAndLocation() {
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        Entity investigationTypeA = (Entity)this.laboratoryFactory.newInvestigationType().accountId("X", location1).accountId("Y", location2).build();
        JXPathContext context1 = this.createContext(new Object());
        context1.getVariables().declareVariable("investigationType", (Object)investigationTypeA);
        context1.getVariables().declareVariable("location", (Object)location1);
        Assert.assertEquals((Object)"X", (Object)context1.getValue("investigation:accountId($investigationType, $location)"));
        JXPathContext context2 = this.createContext(new Object());
        context2.getVariables().declareVariable("investigationType", null);
        context2.getVariables().declareVariable("location", null);
        Assert.assertNull((Object)context2.getValue("investigation:accountId($investigationType, $location)"));
    }

    private JXPathContext createContext(Object object) {
        FunctionLibrary library = new FunctionLibrary();
        library.addFunctions((Functions)new ObjectFunctions((Object)new InvestigationFunctions((ArchetypeService)this.getArchetypeService()), "investigation"));
        return JXPathHelper.newContext((Object)object, (Functions)library);
    }
}

