/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.expression;

import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.function.expression.ExpressionFunctions;
import org.openvpms.component.system.common.jxpath.JXPathHelper;

public class ExpressionFunctionsTestCase {
    private JXPathContext ctx;

    @Before
    public void setUp() {
        this.ctx = JXPathHelper.newContext((Object)new Object(), (Functions)new ExpressionFunctions("expr"));
    }

    @Test
    public void testIfThen() {
        Assert.assertNull((Object)this.ctx.getValue("expr:if('a' = 'b', 'true')"));
        Assert.assertEquals((Object)"true", (Object)this.ctx.getValue("expr:if('a' != 'b', 'true')"));
    }

    @Test
    public void testIfThenElse() {
        Assert.assertEquals((Object)"false", (Object)this.ctx.getValue("expr:if('a' = 'b', 'true', 'false')"));
        Assert.assertEquals((Object)"true", (Object)this.ctx.getValue("expr:if('a' !='b', 'true', 'false')"));
        this.ctx.getVariables().declareVariable("x", null);
        Assert.assertEquals((Object)"false", (Object)this.ctx.getValue("expr:if($x, 'true', 'false')"));
        Assert.assertEquals((Object)"true", (Object)this.ctx.getValue("expr:if(not($x), 'true', 'false')"));
    }

    @Test
    public void testVar() {
        this.ctx.getVariables().declareVariable("foo", (Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)this.ctx.getValue("expr:var('foo')"));
        Assert.assertNull((Object)this.ctx.getValue("expr:var('novar')"));
        Assert.assertEquals((Object)"fail", (Object)this.ctx.getValue("expr:var('novar', 'fail')"));
    }

    @Test
    public void testConcatIf() {
        Assert.assertEquals((Object)"", (Object)this.ctx.getValue("expr:concatIf('x','')"));
        Assert.assertEquals((Object)"", (Object)this.ctx.getValue("expr:concatIf('','x')"));
        Assert.assertEquals((Object)"xy", (Object)this.ctx.getValue("expr:concatIf('x','y')"));
        Assert.assertEquals((Object)"", (Object)this.ctx.getValue("expr:concatIf('','x','x')"));
        Assert.assertEquals((Object)"", (Object)this.ctx.getValue("expr:concatIf('x','','x')"));
        Assert.assertEquals((Object)"", (Object)this.ctx.getValue("expr:concatIf('x','x','')"));
        Assert.assertEquals((Object)"xyx", (Object)this.ctx.getValue("expr:concatIf('x','y','x')"));
        Assert.assertEquals((Object)"", (Object)this.ctx.getValue("expr:concatIf('','x','x','x')"));
        Assert.assertEquals((Object)"abcd", (Object)this.ctx.getValue("expr:concatIf('a','b','c','d')"));
        Assert.assertEquals((Object)"", (Object)this.ctx.getValue("expr:concatIf('','x','x','x', 'x')"));
        Assert.assertEquals((Object)"abcde", (Object)this.ctx.getValue("expr:concatIf('a','b','c','d','e')"));
    }

    @Test
    public void testIfEmpty() {
        Assert.assertEquals((Object)"x", (Object)this.ctx.getValue("expr:ifempty('x','y')"));
        Assert.assertEquals((Object)"y", (Object)this.ctx.getValue("expr:ifempty('','y')"));
    }

    @Test
    public void testTrim() {
        Assert.assertEquals((Object)"abc", (Object)this.ctx.getValue("expr:trim('abc', 4)"));
        Assert.assertEquals((Object)"ab", (Object)this.ctx.getValue("expr:trim('abc', 2)"));
        Assert.assertEquals((Object)"", (Object)this.ctx.getValue("expr:trim('', 255)"));
    }

    @Test
    public void testReplaceIf() {
        Assert.assertEquals((Object)"abc", (Object)this.ctx.getValue("expr:replaceIf('abc', 4, '123')"));
        Assert.assertEquals((Object)"abcd", (Object)this.ctx.getValue("expr:replaceIf('abcd', 4, '123')"));
        Assert.assertEquals((Object)"123", (Object)this.ctx.getValue("expr:replaceIf('abcd', 3, '123')"));
    }

    @Test
    public void testAbbreviate() {
        Assert.assertEquals((Object)"abcd", (Object)this.ctx.getValue("expr:abbreviate('abcd', 4)"));
        Assert.assertEquals((Object)"a...", (Object)this.ctx.getValue("expr:abbreviate('abcde', 4)"));
        Assert.assertEquals((Object)"ab...", (Object)this.ctx.getValue("expr:abbreviate('abcdef', 5)"));
        Assert.assertEquals((Object)"abc", (Object)this.ctx.getValue("expr:abbreviate('abcde', 3)"));
        Assert.assertEquals((Object)"", (Object)this.ctx.getValue("expr:abbreviate('', 5)"));
        Assert.assertNull((Object)this.ctx.getValue("expr:abbreviate('', 0)"));
        Assert.assertNull((Object)this.ctx.getValue("expr:abbreviate('', -1)"));
    }
}

